/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog.hourly;

import java.io.File;
import java.io.FilenameFilter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.common.ParameterMap;

public class HourlyLogFileUtils {
    private static final Logger log = LogManager.getLogger();
    private static String directoryTemplate = "yyyy/yyyy-MM/yyyy-MM-dd";
    private static String directoryTemplate2 = "yyyy/MM/dd";

    public static final List<File> getLogFile(File path, Calendar hour) {
        return HourlyLogFileUtils.getLogFiles(path, hour);
    }

    public static final List<File> getLogFile(ParameterMap setup, String key, int sourceId, Calendar hour) {
        String path = HourlyLogFileUtils.getPath(setup, key, sourceId);
        return HourlyLogFileUtils.getLogFiles(new File(path), hour);
    }

    protected static String getPath(ParameterMap setup, String key, int sourceId) {
        return new StringBuilder(100).append(setup.get(key, null)).append(File.separator + "source_").append(sourceId).append(File.separator).toString();
    }

    private static final List<File> getLogFiles(File path, Calendar hour) {
        File dir = new File(path, new SimpleDateFormat(directoryTemplate).format(hour.getTime()));
        File dir2 = new File(path, new SimpleDateFormat(directoryTemplate2).format(hour.getTime()));
        return HourlyLogFileUtils.getLogFiles(hour, dir, dir2);
    }

    private static List<File> getLogFiles(Calendar hour, File ... dirs) {
        ArrayList<File> result = new ArrayList<File>();
        Date hr = hour.getTime();
        final Pattern pattern = Pattern.compile("(log_" + new SimpleDateFormat("HH").format(hr) + ")|(log_" + new SimpleDateFormat("yyyy-MM-dd-HH").format(hr) + ".*)|(.*" + new SimpleDateFormat("yyyy-MM-dd'\\.'HH").format(hr) + ".*)");
        for (File dir : dirs) {
            try {
                if (!dir.exists() || !dir.isDirectory()) continue;
                FilenameFilter logFileFilter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return !name.startsWith("tmp") && !name.endsWith("data") && pattern.matcher(name).matches();
                    }
                };
                File[] files = dir.listFiles(logFileFilter);
                result.addAll(Arrays.asList(files != null ? files : new File[]{}));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        Collections.sort(result, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }

    public static final int[] getLogExistsForMonth(ParameterMap setup, String key, Date month, int sourceId) {
        log.debug("getLogExistsForMonth: key={}, month={}, sourceId={}", (Object)key, (Object)month, (Object)sourceId);
        int[] result = new int[31];
        File dir = new File(HourlyLogFileUtils.getPath(setup, key, sourceId), new SimpleDateFormat("yyyy/yyyy-MM").format(month.getTime()));
        if (!dir.exists()) {
            log.debug("getLogExistsForMonth: dir={} not exist", (Object)dir);
            return result;
        }
        Pattern patternDay = Pattern.compile(".*" + new SimpleDateFormat("yyyy-MM").format(month) + "-\\d{2}");
        Pattern patternHour = Pattern.compile(".*" + new SimpleDateFormat("yyyy-MM").format(month) + "-(\\d{2})[-|\\.](\\d{2})\\.*");
        for (File dir2 : dir.listFiles()) {
            ArrayList result1 = new ArrayList();
            try {
                if (dir2.exists() && dir2.isDirectory() && patternDay.matcher(dir2.getName()).matches()) {
                    for (String fileName : dir2.list()) {
                        Matcher m = patternHour.matcher(fileName);
                        if (fileName.startsWith("tmp") || fileName.endsWith("data") || !(m = patternHour.matcher(fileName)).find()) continue;
                        int day = Integer.valueOf(m.group(1));
                        int hour = Integer.valueOf(m.group(2));
                        int n = day - 1;
                        result[n] = result[n] | 1 << hour;
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            Collections.sort(result1);
        }
        return result;
    }

    @Deprecated
    public static final synchronized File getNextFileToWrite(ParameterMap setup, int sourceId, Calendar hour, int[] idRef) {
        return HourlyLogFileUtils.getNextFileToWrite(setup, "log.dir", sourceId, hour, idRef);
    }

    public static final synchronized File getNextFileToWrite(ParameterMap setup, String logDirParamName, int sourceId, Calendar hour, int[] idRef) {
        File result = null;
        Date hr = hour.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat(directoryTemplate);
        String hourString = new SimpleDateFormat("yyyy-MM-dd-HH").format(hr);
        StringBuilder path = new StringBuilder();
        path.append(setup.get(logDirParamName, null));
        path.append(File.separator + "source_");
        path.append(sourceId);
        path.append(File.separator);
        path.append(dateFormat.format(hr));
        File dir = new File(path.toString());
        DecimalFormat df = new DecimalFormat("000");
        try {
            int i;
            dir.mkdirs();
            for (i = 0; (result = new File(dir, "log_" + hourString + "." + df.format(i) + ".bgdl")).exists() && i < 10000; ++i) {
            }
            result.createNewFile();
            idRef[0] = i;
            if (log.isDebugEnabled()) {
                log.debug("Next log file: " + result.getAbsolutePath());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String key = "error.create.datalog.file";
            String message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043b\u043e\u0433\u0430 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c: " + sourceId + " \u0437\u0430 " + hourString;
            AlarmSender.sendAlarm(key, 0L, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043b\u043e\u0433\u0430", message, e);
        }
        return result;
    }
}

