/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.field.BGMaskTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class CalendarPanel_v2
extends JPanel {
    private static final String[] weekDays = new String[]{"\u041f\u043d.", "\u0412\u0442.", "\u0421\u0440.", "\u0427\u0442.", "\u041f\u0442.", "\u0421\u0431.", "\u0412\u0441."};
    private static final Font fontBold = new Font("Dialog", 1, 12);
    private static final Font fontPlain = new Font("Dialog", 0, 10);
    private static final Font fontLabel = new Font("Dialog", 0, 9);
    private Calendar calendarOld = null;
    private Calendar calendarCurrent = null;
    private Calendar firstDate = null;
    private JButton buttonYearDec = new JButton();
    private JButton buttonMonthDec = new JButton();
    private JButton buttonClear = new JButton();
    private JButton buttonMonthInc = new JButton();
    private JButton buttonYearInc = new JButton();
    private JPanel jPanel1 = new JPanel(new GridBagLayout());
    private JPanel panelDays = new JPanel(new GridLayout(7, 7));
    private JLabel labelDate = new JLabel();
    private DateField dateField = new DateField();
    private KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if ((e.getModifiersEx() & 0x80) > 0) {
                switch (e.getKeyCode()) {
                    case 37: {
                        CalendarPanel_v2.this.buttonMonthDec_actionPerformed();
                        break;
                    }
                    case 39: {
                        CalendarPanel_v2.this.buttonMonthInc_actionPerformed();
                        break;
                    }
                    case 38: {
                        CalendarPanel_v2.this.buttonYearInc_actionPerformed();
                        break;
                    }
                    case 40: {
                        CalendarPanel_v2.this.buttonYearDec_actionPerformed();
                    }
                }
            } else {
                switch (e.getKeyCode()) {
                    case 27: {
                        CalendarPanel_v2.this.buttonClear_actionPerformed();
                    }
                }
            }
        }
    };

    public CalendarPanel_v2() {
        try {
            this.jbInit();
            this.buildButtons();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.updateDate();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.buttonYearDec.setFont(fontBold);
        this.buttonYearDec.setMargin(new Insets(2, 2, 2, 2));
        this.buttonYearDec.setText("<<");
        this.buttonYearDec.addActionListener(e -> this.buttonYearDec_actionPerformed());
        this.buttonMonthDec.setFont(fontBold);
        this.buttonMonthDec.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMonthDec.setText(" < ");
        this.buttonMonthDec.addActionListener(e -> this.buttonMonthDec_actionPerformed());
        this.buttonClear.setFont(fontBold);
        this.buttonClear.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClear.setText(" X ");
        this.buttonClear.addActionListener(e -> this.buttonClear_actionPerformed());
        this.buttonMonthInc.setFont(fontBold);
        this.buttonMonthInc.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMonthInc.setText(" > ");
        this.buttonMonthInc.addActionListener(e -> this.buttonMonthInc_actionPerformed());
        this.buttonYearInc.setFont(fontBold);
        this.buttonYearInc.setMargin(new Insets(2, 2, 2, 2));
        this.buttonYearInc.setText(">>");
        this.buttonYearInc.addActionListener(e -> this.buttonYearInc_actionPerformed());
        this.labelDate.setFont(fontBold);
        this.labelDate.setText(" ");
        this.jPanel1.setOpaque(false);
        this.panelDays.setOpaque(false);
        final JButton ok = new JButton();
        ok.setFont(fontBold);
        ok.setMargin(new Insets(2, 2, 2, 2));
        ok.setText("OK");
        KeyAdapter l = new KeyAdapter(this){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        ok.doClick();
                        break;
                    }
                    case 27: {
                        ok.doClick();
                    }
                }
            }
        };
        this.dateField.addKeyListener(l);
        this.dateField.addKeyListener(this.keyListener);
        ok.addKeyListener(l);
        ok.addKeyListener(this.keyListener);
        ok.addActionListener(e -> {
            String date = this.dateField.getText();
            if (date != null) {
                this.calendarCurrent = (Calendar)this.firstDate.clone();
                SimpleDateFormat f = new SimpleDateFormat("dd.MM.yyyy");
                try {
                    this.calendarCurrent.setTime(f.parse(date));
                    this.updateDate();
                    this.firePropertyChange("updateCalendar", true, false);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.dateField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)ok, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)panel, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.jPanel1.add((Component)this.buttonYearDec, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.buttonMonthDec, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.buttonClear, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.buttonMonthInc, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.buttonYearInc, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.labelDate, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this.panelDays, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonMonthInc.addKeyListener(this.keyListener);
        this.buttonMonthDec.addKeyListener(this.keyListener);
        this.buttonYearInc.addKeyListener(this.keyListener);
        this.buttonYearDec.addKeyListener(this.keyListener);
        this.buttonClear.addKeyListener(this.keyListener);
    }

    private void buildButtons() {
        int i;
        Insets insets = new Insets(0, 0, 0, 0);
        ActionListener bal = e -> this.dayClick(e);
        for (i = 0; i < 7; ++i) {
            JLabel label = new JLabel(weekDays[i]);
            label.setFont(fontLabel);
            label.setHorizontalAlignment(0);
            this.panelDays.add((Component)label, null);
        }
        for (i = 0; i < 42; ++i) {
            JButton button = new JButton("  ");
            button.setActionCommand(String.valueOf(i));
            button.setFont(fontPlain);
            button.setMargin(insets);
            this.panelDays.add((Component)button, null);
            button.addActionListener(bal);
            button.addKeyListener(this.keyListener);
        }
    }

    private void buttonYearDec_actionPerformed() {
        if (this.calendarCurrent != null) {
            this.calendarCurrent.add(1, -1);
        }
        this.updateDate();
    }

    private void buttonYearInc_actionPerformed() {
        if (this.calendarCurrent != null) {
            this.calendarCurrent.add(1, 1);
        }
        this.updateDate();
    }

    private void buttonMonthInc_actionPerformed() {
        if (this.calendarCurrent != null) {
            this.calendarCurrent.add(2, 1);
        }
        this.updateDate();
    }

    private void buttonMonthDec_actionPerformed() {
        if (this.calendarCurrent != null) {
            this.calendarCurrent.add(2, -1);
        }
        this.updateDate();
    }

    private void updateDate() {
        int month;
        if (this.calendarCurrent == null) {
            return;
        }
        int year = this.calendarCurrent.get(1);
        GregorianCalendar calendar = new GregorianCalendar(year, month = this.calendarCurrent.get(2), 1);
        int DAY_OF_WEEK = calendar.get(7);
        if (DAY_OF_WEEK == 1) {
            ((Calendar)calendar).add(5, -7);
        } else {
            ((Calendar)calendar).add(5, 1 - DAY_OF_WEEK);
        }
        this.firstDate = (Calendar)((Calendar)calendar).clone();
        for (int i = 7; i < this.panelDays.getComponentCount(); ++i) {
            ((Calendar)calendar).add(5, 1);
            JButton button = (JButton)this.panelDays.getComponent(i);
            button.setText("" + calendar.get(5));
            if (calendar.get(2) == month) {
                button.setFont(fontBold);
                button.setForeground(Color.black);
                continue;
            }
            button.setFont(fontPlain);
            button.setForeground(Color.darkGray);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.calendarCurrent.get(5));
        buf.append(' ');
        buf.append(TimeUtils.monthNames[month]);
        buf.append(' ');
        buf.append(year);
        this.labelDate.setText(buf.toString());
        SimpleDateFormat f = new SimpleDateFormat("dd.MM.yyyy");
        this.dateField.setText(f.format(this.calendarCurrent.getTime()));
        this.firePropertyChange("updateTitle", "", buf.toString());
    }

    private void dayClick(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        this.calendarCurrent = (Calendar)this.firstDate.clone();
        this.calendarCurrent.add(5, Utils.parseInt(actionCommand, 0) + 1);
        this.updateDate();
        this.firePropertyChange("updateCalendar", true, false);
    }

    public void setCalendar(Calendar calendar) {
        this.calendarOld = calendar;
        this.calendarCurrent = calendar == null ? new GregorianCalendar() : (Calendar)calendar.clone();
        this.calendarCurrent.clear(14);
        this.calendarCurrent.clear(13);
        this.calendarCurrent.clear(12);
        this.calendarCurrent.clear(11);
        this.calendarCurrent.clear(0);
        this.updateDate();
    }

    public Calendar getCalendar() {
        return this.calendarCurrent;
    }

    public Calendar getOldCalendar() {
        return this.calendarOld;
    }

    private void buttonClear_actionPerformed() {
        this.calendarCurrent = null;
        this.labelDate.setText(" ");
        this.firePropertyChange("updateCalendar", true, false);
    }

    public void setVisibleLabelDate(boolean value) {
        this.labelDate.setVisible(value);
    }

    private class DateField
    extends BGMaskTextField {
        DateField() {
            super("  .  .    ", ".", new BGMaskTextField.IntegerValidator(1L, 31L, 2), new BGMaskTextField.IntegerValidator(1L, 12L, 2), new BGMaskTextField.IntegerValidator());
            this.setHorizontalAlignment(0);
        }
    }
}

