/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server;

import bitel.billing.server.Action;
import bitel.billing.server.ActionConType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.script.common.bean.Script;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptInstance;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.model.ListItem;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public abstract class ActionBase
extends BGLogger
implements Action {
    protected static final String ELEMENT_NAME_ROW = "row";
    protected static final String ELEMENT_NAME_ITEM = "item";
    protected static final String ELEMENT_NAME_LIST = "list";
    private ThreadContext parentContext;
    protected ServerContext context;
    protected int mid = -1;
    protected int cid = -1;
    protected String module = "";
    protected Setup setup = null;
    protected ModuleSetup moduleSetup = null;
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected ServletContext servletContext = null;
    protected HttpSession session = null;
    protected Element rootNode = null;
    protected Integer userId = null;
    private Preferences userConfig = null;
    protected Connection con;
    protected Connection conSlave;
    protected ConnectionSet connectionSet;
    protected String userName = null;
    protected int outputMode = 0;
    protected Map<String, Object> dataMap = new HashMap<String, Object>();
    protected Date closedDate;

    @Override
    public void init(Setup setup, Element rootNode, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws SQLException {
        Integer clientid;
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
        this.session = request.getSession(false);
        this.userId = (Integer)request.getAttribute("user_id");
        if (this.userId == null) {
            this.userId = -1;
        }
        this.userName = (String)request.getAttribute("userName");
        this.init(setup, rootNode, this.getIntParameter("cid", -1), this.getParameter("module"), this.getIntParameter("mid", -1));
        if (this.session != null && (clientid = (Integer)this.session.getAttribute("clientid")) != null) {
            this.cid = clientid;
        }
        request.setAttribute("dataMap", this.dataMap);
    }

    public final void init(Setup setup, Element rootNode, int contractId, String module, int mid) throws SQLException {
        this.setup = setup;
        this.mid = mid;
        this.rootNode = rootNode;
        this.module = module;
        this.cid = contractId;
        this.context = new ServerContext(setup, mid, this.userId == null ? -1 : this.userId);
        this.context.init();
        this.parentContext = ThreadContext.get();
        ThreadContext.set((ThreadContext)this.context);
        ConnectionSet connectionSet = this.context.getConnectionSet();
        ActionConType type = this.getClass().getAnnotation(ActionConType.class);
        if (type == null || type.value() == 1) {
            this.con = this.conSlave = connectionSet.getConnection();
        } else if (type != null && type.value() == 2) {
            this.con = this.conSlave = connectionSet.getSlaveConnection();
        } else {
            this.con = connectionSet.getConnection();
            this.conSlave = connectionSet.getSlaveConnection();
        }
        this.connectionSet = connectionSet;
        if (mid > 0) {
            this.moduleSetup = setup.getModuleSetup(mid);
        }
    }

    @Override
    public void freeConnection() {
        ThreadContext.set((ThreadContext)this.parentContext);
        this.context.destroy();
    }

    @Override
    public abstract void doAction() throws Exception;

    @Override
    public void commit() {
        try {
            this.context.commit();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    protected final Date getDateParameter(String name) {
        return this.getDateParameter(name, null);
    }

    protected final Date getDateParameter(String name, Date defaultValue) {
        return this.getDateParameter(name, "dd.MM.yyyy", defaultValue);
    }

    protected final Date getDateParameter(String name, String pattern, Date defaultValue) {
        Date outDate = defaultValue;
        String inDate = this.request.getParameter(name);
        if (inDate != null && !"".equals(inDate) && !"00.00.0000".equals(inDate)) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(pattern);
                outDate = new Date(format.parse(inDate).getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return outDate;
    }

    protected int getIntParameter(String name, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.parseInt(this.request.getParameter(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected final Long getLongParameter(String name, Long defaultValue) {
        Long value = defaultValue;
        try {
            value = Long.valueOf(this.request.getParameter(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected final float getFloatParameter(String name, float defaultValue) {
        float value = defaultValue;
        try {
            value = Float.parseFloat(this.request.getParameter(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected final BigDecimal getBigDecimalParameter(String name, BigDecimal defaultValue) {
        BigDecimal value = defaultValue;
        try {
            String requestValue = this.request.getParameter(name);
            if (requestValue != null && requestValue.contains(",")) {
                requestValue = requestValue.replace(",", ".");
            }
            value = new BigDecimal(requestValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected final boolean getBooleanParameter(String name, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            String v = this.request.getParameter(name);
            if (v != null) {
                v = v.toUpperCase();
                if (defaultValue && ("0".equals(v) || "FALSE".equals(v) || "NO".equals(v))) {
                    value = false;
                } else if (!defaultValue && ("1".equals(v) || "TRUE".equals(v) || "YES".equals(v))) {
                    value = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected final Boolean getBooleanParameter(String name) {
        Boolean value = null;
        try {
            String v = this.request.getParameter(name).toUpperCase();
            if ("0".equals(v) || "FALSE".equals(v) || "NO".equals(v)) {
                value = Boolean.FALSE;
            } else if ("1".equals(v) || "TRUE".equals(v) || "YES".equals(v)) {
                value = Boolean.TRUE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    @Deprecated
    protected void setWebErrorMessage(String msg) {
        if (msg == null) {
            msg = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 ...";
        }
        this.rootNode.setAttribute("status", "error");
        XMLUtils.createTextNode((Node)this.rootNode, (String)msg);
        try {
            HttpServletResponse response = this.getResponse();
            if (response != null) {
                response.setHeader("bgbilling-error", Base64.encodeUTF8((String)msg));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final Element createElement(Element element, String name) {
        Element newElement = null;
        if (element == null) {
            newElement = this.rootNode.getOwnerDocument().createElement(name);
        } else {
            newElement = element.getOwnerDocument().createElement(name);
            element.appendChild(newElement);
        }
        return newElement;
    }

    protected final String getParameter(String name) {
        return this.getParameter(name, null);
    }

    protected String getParameter(String name, String defaultValue) {
        String value = this.request.getParameter(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected void setMsg(String msg) {
        XMLUtils.createTextNode((Node)this.rootNode, (String)msg);
        this.rootNode.setAttribute("status", "message");
        try {
            HttpServletResponse response = this.getResponse();
            if (response != null) {
                response.setHeader("bgbilling-message", Base64.encodeUTF8((String)msg));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Element addListItem(Node node, int id, String title) {
        return this.addListItem(node, ELEMENT_NAME_ITEM, String.valueOf(id), title);
    }

    protected Element addListItem(Node node, String id, String title) {
        return this.addListItem(node, ELEMENT_NAME_ITEM, id, title);
    }

    protected Element addListItem(Node node, String nameNode, String id, String title) {
        Element element = this.createElement((Element)node, nameNode);
        element.setAttribute("id", id);
        element.setAttribute("title", title);
        return element;
    }

    protected Element buildList(Element element, Iterable<? extends ListItem> list) {
        Element listElement = this.createElement(element, ELEMENT_NAME_LIST);
        for (ListItem listItem : list) {
            this.addListItem((Node)listElement, listItem.getId(), listItem.getTitle());
        }
        return listElement;
    }

    protected Element buildList(Element element, String query) throws SQLException {
        return this.buildList(element, query, ELEMENT_NAME_LIST);
    }

    protected Element buildList(Element element, String query, String listElementName) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement(query);
        Element list = this.createElement(element, listElementName);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            this.addListItem((Node)list, rs.getString(1), rs.getString(2));
        }
        rs.close();
        ps.close();
        return list;
    }

    protected void createElementServices(Element services, int moduleId, int contractId) throws SQLException {
        String query = "SELECT DISTINCT t1.sid, t2.title FROM contract_service as t1, service as t2 WHERE t1.cid=? AND t1.sid=t2.id AND t2.mid=? ORDER BY t2.title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, moduleId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this.addListItem((Node)services, rs.getString(1), rs.getString(2));
                }
            }
        }
    }

    protected long getLongParameter(String name, long defaultValue) {
        long value = defaultValue;
        try {
            value = Long.parseLong(this.request.getParameter(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected <E extends Enum<E>> E getEnumParameter(String name, E defaultValue) {
        return (E)this.getEnumParameter(name, defaultValue.getClass(), defaultValue);
    }

    protected <E extends Enum<E>> E getEnumParameter(String name, Class<E> clazz, E defaultValue) {
        E value = defaultValue;
        try {
            value = Enum.valueOf(clazz, this.request.getParameter(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected Element buildListItem(String query, String nodeName) throws SQLException {
        Element element = this.createElement(this.rootNode, nodeName);
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            this.addListItem((Node)element, rs.getString(1), rs.getString(2));
        }
        rs.close();
        st.close();
        return element;
    }

    protected Element buildListItem(PreparedStatement ps, String nodeName) throws SQLException {
        Element element = this.createElement(this.rootNode, nodeName);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            this.addListItem((Node)element, rs.getString(1), rs.getString(2));
        }
        rs.close();
        return element;
    }

    protected void buildAddressesLists() throws SQLException {
        Element cities = this.createElement(this.rootNode, "cities");
        this.addListItem((Node)cities, "0", "----------");
        PreparedStatement ps = this.con.prepareStatement("SELECT id, title FROM address_city ORDER BY pos, title");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            this.addListItem((Node)cities, rs.getString(1), rs.getString(2));
        }
        rs.close();
        ps.close();
        Element streets = this.createElement(this.rootNode, "streets");
        this.addListItem((Node)streets, "0", "----------");
        ps = this.con.prepareStatement("SELECT id, title, cityid, p_index FROM address_street ORDER BY title");
        rs = ps.executeQuery();
        while (rs.next()) {
            Element element = this.createElement(streets, ELEMENT_NAME_ITEM);
            element.setAttribute("id", rs.getString(1));
            element.setAttribute("title", rs.getString(2));
            element.setAttribute("cityid", rs.getString(3));
            element.setAttribute("index", rs.getString(4));
        }
        rs.close();
        ps.close();
        Element areas = this.createElement(this.rootNode, "areas");
        String query = "SELECT id, title, cityid FROM address_area WHERE id!=0 ORDER BY title ";
        ps = this.con.prepareStatement(query);
        rs = ps.executeQuery();
        this.addListItem((Node)areas, "0", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d");
        while (rs.next()) {
            Element element = this.createElement(areas, ELEMENT_NAME_ITEM);
            element.setAttribute("id", rs.getString(1));
            element.setAttribute("title", rs.getString(2));
            element.setAttribute("cityid", rs.getString(3));
        }
        rs.close();
        ps.close();
        Element quarters = this.createElement(this.rootNode, "quarters");
        query = "SELECT id, title, cityid FROM address_quarter WHERE id!=0 ORDER BY title ";
        ps = this.con.prepareStatement(query);
        rs = ps.executeQuery();
        this.addListItem((Node)quarters, "0", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d");
        while (rs.next()) {
            Element element = this.createElement(quarters, ELEMENT_NAME_ITEM);
            element.setAttribute("id", rs.getString(1));
            element.setAttribute("title", rs.getString(2));
            element.setAttribute("cityid", rs.getString(3));
        }
        rs.close();
        ps.close();
    }

    protected void getFormatAddressTable(AddressStruct addressStruct, int pid, String selectedKey, boolean isObject) {
        Element selectedRadio = this.createElement(this.rootNode, "selected");
        Element addressFormatTable = this.createElement(this.rootNode, "addressFormatTable");
        Element data = this.createElement(addressFormatTable, "data");
        Element defaultFormatRow = this.createElement(data, ELEMENT_NAME_ROW);
        defaultFormatRow.setAttribute("f0", String.valueOf(0));
        defaultFormatRow.setAttribute("f1", "");
        String defaultFormattedAddress = AddressUtils.getAddress(this.setup, addressStruct, "0");
        defaultFormatRow.setAttribute("f2", defaultFormattedAddress);
        selectedRadio.setAttribute("selected_id", selectedKey == null || selectedKey.equals("") ? "0" : selectedKey);
        String sortOrder = this.setup.get("addrs.format.list");
        if (sortOrder != null) {
            String[] sortOrderValues = sortOrder.trim().split(";");
            int index = 1;
            for (String item : sortOrderValues) {
                Element row = this.createElement(data, ELEMENT_NAME_ROW);
                row.setAttribute("f0", String.valueOf(index));
                row.setAttribute("f1", "");
                row.setAttribute("f2", AddressUtils.getAddress(this.setup, addressStruct, item));
                ++index;
            }
        }
    }

    protected Element getYearsElement(int show_years) {
        GregorianCalendar cur_date = new GregorianCalendar();
        Element date = this.createElement(this.rootNode, "date");
        int cur_year = cur_date.get(1);
        for (int i = 0; i < show_years; ++i) {
            Element year = this.createElement(date, "year");
            year.setAttribute("value", "" + (cur_year - i));
        }
        return date;
    }

    protected HttpServletResponse getResponse() {
        return (HttpServletResponse)this.request.getAttribute("response");
    }

    protected OutputStream getResponseOut() {
        ServletOutputStream result = null;
        try {
            HttpServletResponse response = (HttpServletResponse)this.request.getAttribute("response");
            if (response != null) {
                result = response.getOutputStream();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected String getParameterValues(String name) {
        String[] params = this.request.getParameterValues(name);
        return params != null ? Utils.toString(Arrays.asList(params)) : null;
    }

    protected void stringToLines(Element node, String str) {
        if (Utils.isEmptyString((String)str)) {
            return;
        }
        String[] lines = str.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            Element row = this.createElement(node, ELEMENT_NAME_ROW);
            row.setAttribute("text", lines[i]);
        }
    }

    protected Period getPeriodByYearsAndDays() {
        int showYears = this.moduleSetup.getInt("showyears", 6);
        Element date = this.getYearsElement(showYears);
        GregorianCalendar cur_date = new GregorianCalendar();
        int year = this.getIntParameter("year", cur_date.get(1));
        int month = this.getIntParameter("month", cur_date.get(2) + 1);
        int day_from = this.getIntParameter("day_from", 1);
        int day_to = this.getIntParameter("day_to", ((Calendar)cur_date).getActualMaximum(5));
        date.setAttribute("year", "" + year);
        date.setAttribute("month", "" + month);
        date.setAttribute("day_from", "" + day_from);
        date.setAttribute("day_to", "" + day_to);
        return new Period(year, month - 1, day_from, day_to);
    }

    protected Page getPage() {
        Page page = new Page();
        page.setPageIndex(this.getIntParameter("pageIndex", 1));
        page.setPageSize(this.getIntParameter("pageSize", 25));
        return page;
    }

    protected Period getPeriod() {
        return this.getPeriod(null);
    }

    protected Period getPeriod(String pattern) {
        Period result = new Period();
        if (Utils.isBlankString((String)pattern)) {
            pattern = "dd.MM.yyyy";
        }
        result.setDateFrom(this.getDateParameter("date1", pattern, null));
        result.setDateTo(this.getDateParameter("date2", pattern, null));
        return result;
    }

    protected void setPageAttribute(Element element, Page page) {
        XMLUtils.setPageAttribute((Element)element, (Page)page);
    }

    protected Preferences getUserConfig() {
        if (this.userConfig == null) {
            User user = UserMap.getUser(this.userId);
            String user_config = user.getConfig();
            this.userConfig = new Preferences(user_config, "\r\n");
        }
        return this.userConfig;
    }

    protected boolean validateScript(Script scr) {
        try {
            ScriptInstance.validateScript(scr);
            return true;
        }
        catch (ScriptInstance.ValidationException e) {
            this.rootNode.setAttribute("validationError", e.getMessage());
            this.rootNode.setAttribute("validationErrorBeginLine", String.valueOf(e.getBeginLine()));
            this.rootNode.setAttribute("validationErrorBeginColumn", String.valueOf(e.getBeginColumn()));
            this.rootNode.setAttribute("validationErrorEndLine", String.valueOf(e.getEndLine()));
            this.rootNode.setAttribute("validationErrorEndColumn", String.valueOf(e.getEndColumn()));
            return false;
        }
    }

    protected void setDataForXslt() throws Exception {
    }

    protected void setDataToRequest() throws Exception {
    }

    protected void setData() throws Exception {
        switch (this.outputMode) {
            case 1: 
            case 2: {
                this.setDataToRequest();
                break;
            }
            case 0: {
                this.setDataForXslt();
                break;
            }
        }
    }

    @Override
    public void setOutputMode(int outputMode) {
        this.outputMode = outputMode;
    }

    protected List<String> getSortFields(String sortOrder, String[] fieldNames) {
        ArrayList<String> sortFields = new ArrayList<String>();
        if (sortOrder != null) {
            block0: for (String field : sortOrder.split(";")) {
                String[] tokens = field.split(":");
                if (tokens.length != 2) continue;
                for (String fieldName : fieldNames) {
                    if (!fieldName.equals(tokens[0])) continue;
                    sortFields.add(field);
                    continue block0;
                }
            }
        }
        return sortFields;
    }
}

