/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvProductsModifyEvent;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Node;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductPeriod;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecServiceLink;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductUtils;
import ru.bitel.oss.systems.inventory.product.common.event.ProductEntry;
import ru.bitel.oss.systems.inventory.product.common.event.ProductModifiedEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ProductModifyEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ProductPeriodModifiedEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ProductPeriodModifyEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ProductSpecModifiedEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ServiceLinkModifiedEvent;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;
import ru.bitel.oss.systems.inventory.product.server.ProductSpecMap;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductPeriodDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecActivationModeDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecServiceLinkDao;
import ru.bitel.oss.systems.inventory.service.common.bean.Service;
import ru.bitel.oss.systems.inventory.service.common.service.ServiceService;

@WebService(endpointInterface="ru.bitel.oss.systems.inventory.product.common.service.ProductService")
public class ProductServiceImpl
extends AbstractService
implements ProductService {
    private ProductDao productDao;
    private ProductSpecDao productSpecDao;
    private ProductPeriodDao productPeriodDao;
    @Resource
    private ServiceService serviceService;
    private Directory<ProductSpec> productSpecDir;

    private Directory<ProductSpec> getProductSpecDir() throws BGException {
        if (this.productSpecDir == null) {
            this.productSpecDir = this.context.getDirectory(ProductSpec.class, 0);
        }
        return this.productSpecDir;
    }

    private ProductSpecDao getProductSpecDao() {
        if (this.productSpecDao == null) {
            this.productSpecDao = new ProductSpecDao(this.getConnection(), 0, this.userId);
        }
        return this.productSpecDao;
    }

    private ProductDao getProductDao() {
        if (this.productDao == null) {
            this.productDao = new ProductDao(this.getConnection());
        }
        return this.productDao;
    }

    private ProductPeriodDao getProductPeriodDao() {
        if (this.productPeriodDao == null) {
            this.productPeriodDao = new ProductPeriodDao(this.getConnection(), this.userId);
        }
        return this.productPeriodDao;
    }

    @PostConstruct
    protected void init() {
    }

    public ProductSpec productSpecGet(int id) throws BGException {
        return this.getProductSpecDir().get(id);
    }

    public ProductSpec productSpecGetByIdentifier(String identifier) throws BGException {
        return this.getProductSpecDao().getByIdentifier(identifier, this.moduleId);
    }

    public List<ProductSpec> productSpecList(Integer moduleId, Date dateFrom, Date dateTo, String title, List<FilterEntityAttr> entityFilter) throws Exception {
        if (moduleId == null && this.moduleId > 0) {
            moduleId = this.moduleId;
        }
        if (!(moduleId != null && moduleId >= 0 || dateFrom != null || dateTo != null || !Utils.isBlankString((String)title) || entityFilter != null && entityFilter.size() != 0)) {
            return this.getProductSpecDir().list();
        }
        return this.getProductSpecDao().list(moduleId, dateFrom, dateTo, title, entityFilter);
    }

    public ProductSpec productSpecRoot(Integer moduleId, Date dateFrom, Date dateTo, String title, List<FilterEntityAttr> entityFilter) throws Exception {
        List<ProductSpec> list = this.productSpecList(moduleId, dateFrom, dateTo, title, entityFilter);
        return (ProductSpec)TreeUtils.tree(list, (Node)ProductSpec.builder().setTitle("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b").build());
    }

    public int productSpecUpdate(ProductSpec productSpec) throws BGException {
        try {
            this.getProductSpecDir().update(productSpec);
            return productSpec.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void productSpecDelete(int id) throws BGException {
        try {
            this.getProductSpecDir().delete(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<ProductSpecActivationMode> productSpecActivationModeList() throws BGException {
        return new ProductSpecActivationModeDao(this.getConnection(), 0).list();
    }

    public ProductSpecActivationMode productSpecActivationModeGet(int id) throws BGException, BGMessageException {
        return new ProductSpecActivationModeDao(this.getConnection(), 0).get(id);
    }

    public int productSpecActivationModeUpdate(ProductSpecActivationMode productSpecActivationMode) throws BGException, BGMessageException {
        new ProductSpecActivationModeDao(this.getConnection(), 0).update(productSpecActivationMode);
        EventProcessor.getInstance().publish(new ProductSpecModifiedEvent(0, this.userId, null, null));
        return productSpecActivationMode.getId();
    }

    public void productSpecActivationModeDelete(int id) throws Exception {
        List<ProductSpec> productSpecs = this.getProductSpecDir().list();
        if (!productSpecs.isEmpty()) {
            for (ProductSpec productSpec : productSpecs) {
                for (ProductSpecActivationMode activationMode : productSpec.getActivationModeList()) {
                    if (activationMode.getId() != id) continue;
                    throw new BGMessageException("\u0420\u0435\u0436\u0438\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0435 \u0441 ID#" + productSpec.getId());
                }
            }
        }
        new ProductSpecActivationModeDao(this.getConnection(), 0).delete(id);
    }

    public void productSpecMove(int id, Set<Integer> ids) throws BGException {
        this.getProductSpecDao().move(id, ids);
    }

    public List<ProductSpecServiceLink> serviceLinkList(int productSpecId, Date date) throws BGException {
        return new ProductSpecServiceLinkDao(this.getConnection(), 0).list(productSpecId, date);
    }

    public void serviceLinkUpdate(int productSpecId, List<ProductSpecServiceLink> linkList) throws Exception {
        new ProductSpecServiceLinkDao(this.getConnection(), 0).update(productSpecId, linkList);
        this.context.publishAfterCommit(new ServiceLinkModifiedEvent(this.moduleId, this.userId, productSpecId, linkList));
    }

    @Deprecated
    public List<Product> productList(int moduleId, int contractId, int accountId, boolean kernel, Date timeFrom, Date timeTo, Date intersectTimeFrom, Date intersectTimeTo, boolean nonActive) throws Exception {
        return this.productList(moduleId, contractId, accountId, kernel, timeFrom, timeTo, intersectTimeFrom, intersectTimeTo, nonActive, true);
    }

    public List<Product> productList(int moduleId, int contractId, int accountId, boolean kernel, Date timeFrom, Date timeTo, Date intersectTimeFrom, Date intersectTimeTo, boolean nonActive, boolean needProductPeriods) throws Exception {
        List<Product> result = this.getProductDao().list(moduleId, contractId, accountId, kernel, timeFrom, timeTo, intersectTimeFrom, intersectTimeTo, nonActive, true);
        if (!needProductPeriods) {
            return result;
        }
        Date now = new Date();
        HashMap productPeriodMap = new HashMap();
        this.getProductPeriodDao().list(-1, contractId, accountId, true, now, now, true).forEach(a -> productPeriodMap.put(a.getProductId(), a));
        for (Product product : result) {
            ProductPeriod productPeriod;
            if (product.getTimeTo() != null && product.getTimeTo().before(now) || (productPeriod = (ProductPeriod)productPeriodMap.get(product.getId())) == null) continue;
            product.setSubscriptionTimeFrom(productPeriod.getTimeFrom());
            product.setSubscriptionTimeTo(productPeriod.getTimeTo());
        }
        return result;
    }

    public Product productGet(int contractId, int productId) throws BGException {
        return this.getProductDao().get(contractId, productId);
    }

    public int productUpdate(Product product) throws BGException {
        int contractId = product.getContractId();
        ProductDao productDao = this.getProductDao();
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId);
        ProductSpec productSpec = this.getProductSpecDir().get(product.getProductSpecId());
        if (productSpec.getModeId() == 1) {
            try {
                this.getProductDao().update(product);
                int npayModuleId = ModuleCache.getInstance().getModuleIdByServiceId(productSpec.getNPayServiceId());
                EventProcessor.getInstance().doCrossComponentQuery("npay", npayModuleId, "contractServiceUpdate", product.getContractId(), productSpec.getNPayServiceId(), productSpec.getModuleId(), product.getId(), new Period(product.getTimeFrom(), product.getTimeTo()));
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        contractRuntime.lock();
        try {
            HashMap<Integer, Service> oldServiceMap;
            Product oldProduct;
            if (product.getId() > 0) {
                oldProduct = (Product)productDao.get(product.getId());
                List oldServiceList = this.serviceService.serviceList(contractId, product.getId());
                oldServiceMap = new HashMap<Integer, Service>();
                for (Service service : oldServiceList) {
                    oldServiceMap.put(service.getServiceSpecId(), service);
                }
            } else {
                oldProduct = null;
                oldServiceMap = null;
            }
            this.getProductDao().update(product);
            ArrayList<Service> newServiceList = new ArrayList<Service>();
            ProductSpecMap productSpecMap = ProductSpecMap.getInstance();
            ProductSpecMap.ProductSpecItem productSpecItem = productSpecMap.get(product.getProductSpecId());
            GregorianCalendar utilCalendar = new GregorianCalendar();
            for (ProductSpecServiceLink serviceLink : productSpecItem.serviceLinkList) {
                Service oldService;
                if (!TimeUtils.periodInRange((Date)product.getTimeTo(), (Date)product.getTimeFrom(), (Date)serviceLink.getDateFrom(), (Date)serviceLink.getDateTo())) continue;
                Date timeFrom = ProductUtils.timeFrom((Date)product.getTimeFrom(), (Date)serviceLink.getDateFrom(), (Calendar)utilCalendar);
                Date timeTo = ProductUtils.timeTo((Date)product.getTimeTo(), (Date)serviceLink.getDateTo(), (Calendar)utilCalendar);
                if (oldServiceMap != null) {
                    oldService = (Service)oldServiceMap.remove(serviceLink.getServiceSpecId());
                    if (oldService != null && (timeFrom == null && oldService.getTimeFrom() == null || timeFrom != null && timeFrom.equals(oldService.getTimeFrom()) && timeTo == null && oldService.getTimeTo() == null || timeTo != null && timeTo.equals(oldService.getTimeTo()))) {
                        newServiceList.add(oldService);
                        continue;
                    }
                } else {
                    oldService = null;
                }
                Service service = new Service();
                if (oldService != null) {
                    service.setId(oldService.getId());
                }
                service.setContractId(product.getContractId());
                service.setAccountId(product.getAccountId());
                service.setProductId(product.getId());
                service.setServiceSpecId(serviceLink.getServiceSpecId());
                service.setTimeFrom(timeFrom);
                service.setTimeTo(timeTo);
                service.setDeviceState(product.getDeviceState());
                this.serviceService.serviceUpdate(service);
                newServiceList.add(service);
            }
            if (oldServiceMap != null) {
                for (Service oldService : oldServiceMap.values()) {
                    this.serviceService.serviceDelete(contractId, oldService.getId());
                }
            }
            product.setServiceList(newServiceList);
            this.context.publishAfterCommit(new ProductModifiedEvent(productSpec.getModuleId(), product.getContractId(), this.userId, oldProduct, product));
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            contractRuntime.unlock();
        }
        return product.getId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void productDelete(int contractId, int productId) throws BGException {
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId);
        ProductDao productDao = this.getProductDao();
        Product product = (Product)productDao.get(productId);
        ProductSpec productSpec = this.getProductSpecDir().get(product.getProductSpecId());
        if (productSpec != null && productSpec.getModeId() == 1) {
            try {
                this.getProductDao().delete(productId);
                EventProcessor eventProcessor = EventProcessor.getInstance();
                int npayModuleId = ModuleCache.getInstance().getModuleIdByServiceId(productSpec.getNPayServiceId());
                eventProcessor.doCrossComponentQuery("npay", npayModuleId, "contractServiceDelete", product.getContractId(), productSpec.getNPayServiceId(), productSpec.getModuleId(), product.getId());
                Date now = new Date();
                if (product.getTimeFrom() != null && !product.getTimeFrom().before(now) || product.getTimeTo() != null && !product.getTimeTo().after(now)) return;
                TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), productSpec.getModuleId());
                TvAccount tvAccount = (TvAccount)tvAccountDao.get(product.getAccountId());
                List<ProductEntry> productEntries = Arrays.asList(new ProductEntry(product, product, 1, 0));
                eventProcessor.publish((Event)new OmTvProductsModifyEvent(productSpec.getModuleId(), contractRuntime.contractId, 0, tvAccount.getDeviceId(), product.getAccountId(), productEntries, null));
                return;
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        contractRuntime.lock();
        try {
            Product oldProduct = this.getProductDao().getAndDelete(contractId, productId);
            List oldServiceList = this.serviceService.serviceList(contractId, productId);
            oldProduct.setServiceList(oldServiceList);
            this.serviceService.serviceDeleteByProduct(contractId, productId);
            List<ProductPeriod> oldProductPeriodList = this.getProductPeriodDao().list(contractId, productId);
            this.getProductPeriodDao().deleteByProductId(contractId, productId);
            productSpec = this.getProductSpecDir().get(oldProduct.getProductSpecId());
            if (productSpec != null) {
                ProductModifyEvent productModifyEvent = EventProcessor.getInstance().request(new ProductModifyEvent(contractId, this.userId, productSpec, oldProduct, null, true, true));
                if (!productModifyEvent.isProcess()) {
                    throw new BGMessageException(productModifyEvent.getMessage());
                }
                this.context.publishAfterCommit(new ProductModifiedEvent(productSpec.getModuleId(), oldProduct.getContractId(), productId, oldProduct, null));
                for (ProductPeriod oldProductPeriod : oldProductPeriodList) {
                    this.context.publishAfterCommit(new ProductPeriodModifiedEvent(productSpec.getModuleId(), contractId, productId, oldProduct, oldProductPeriod, null));
                }
                return;
            } else {
                this.getLogger().error("productSpec == null for productId={} [productSpecId={}]", (Object)oldProduct.getId(), (Object)oldProduct.getProductSpecId());
            }
            return;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            contractRuntime.unlock();
        }
    }

    public int productPeriodUpdate(int contractId, ProductPeriod productPeriod) throws BGException {
        if (contractId <= 0 || productPeriod.getContractId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        Product product = this.productGet(contractId, productPeriod.getProductId());
        if (product == null) {
            throw new BGIllegalArgumentException("productPeriod.productId");
        }
        productPeriod.setProductSpecId(product.getProductSpecId());
        try {
            ProductPeriod oldProductPeriod = (ProductPeriod)this.getProductPeriodDao().getAndUpdate((Id)productPeriod);
            ProductSpec productSpec = this.getProductSpecDir().get(product.getProductSpecId());
            EventProcessor.getInstance().request(new ProductPeriodModifyEvent(productSpec.getModuleId(), contractId, this.userId, productSpec, product, oldProductPeriod, productPeriod));
            this.context.publishAfterCommit(new ProductPeriodModifiedEvent(productSpec.getModuleId(), contractId, this.userId, product, oldProductPeriod, productPeriod));
            return productPeriod.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void productPeriodDelete(int contractId, int productPeriodId) throws BGException {
        ProductPeriod oldProductPeriod = (ProductPeriod)this.getProductPeriodDao().get(productPeriodId);
        if (oldProductPeriod.getContractId() != contractId) {
            throw new BGIllegalArgumentException("productPeriodId");
        }
        Product product = this.productGet(contractId, oldProductPeriod.getProductId());
        ProductSpec productSpec = this.getProductSpecDir().get(product.getProductSpecId());
        List<ProductPeriod> list = this.getProductPeriodDao().list(contractId, product.getId());
        if (list.size() <= 1) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u043f\u0435\u0440\u0438\u043e\u0434. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0432\u043c\u0435\u0441\u0442\u043e \u044d\u0442\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442.");
        }
        try {
            this.getProductPeriodDao().delete(productPeriodId);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        this.context.publishAfterCommit(new ProductPeriodModifiedEvent(productSpec.getModuleId(), contractId, this.userId, product, oldProductPeriod, null));
    }

    public List<ProductPeriod> productPeriodList(int contractId, int productId) throws BGException {
        return this.getProductPeriodDao().list(contractId, productId);
    }

    public List<String[]> getIncompatibleItems(int moduleId) throws BGException {
        String config = this.getSetup().getModuleSetup(moduleId).get("tv.product.incompatible.items", "true:\u043d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c;false:\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c");
        String[] listItems = config.split(";");
        ArrayList<String[]> items = new ArrayList<String[]>();
        for (String item : listItems) {
            items.add(item.split(":"));
        }
        return items;
    }

    public JSONObject productSpecTree(int moduleId) throws BGException, BGMessageException {
        JSONObject root = new JSONObject();
        root.put("id", 0);
        root.put("title", (Object)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b");
        this.buildTree(0, root, this.getProductSpecDao().list(moduleId));
        return root;
    }

    private void buildTree(int parentId, JSONObject parent, List<ProductSpec> productSpecs) {
        for (ProductSpec productSpec : productSpecs) {
            if (productSpec.getParentId() != parentId) continue;
            JSONObject child = new JSONObject();
            child.put("id", productSpec.getId());
            child.put("parentId", parentId);
            child.put("title", (Object)productSpec.getTitle());
            child.put("comment", (Object)productSpec.getComment());
            this.buildTree(productSpec.getId(), child, productSpecs);
            JSONArray children = parent.optJSONArray("children");
            if (children == null) {
                children = new JSONArray();
                parent.put("children", (Object)children);
            }
            children.put((Object)child);
        }
    }

    public void productTreeReorder(int srcProductId, int parentProductId, int childIndex) throws BGException, BGMessageException {
        this.getProductSpecDao().reorder(srcProductId, parentProductId, childIndex);
    }
}

