/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RequestCounter {
    private List<Integer> vector = Collections.synchronizedList(new ArrayList());
    private int time;
    private AtomicLong lastSecond = new AtomicLong(0L);
    private AtomicInteger lastCount = new AtomicInteger(0);

    public RequestCounter(int time) {
        this.time = time;
    }

    public int getCount() {
        this.addRequestCount(false);
        int cnt_1 = 0;
        for (int count : this.vector) {
            cnt_1 += count;
        }
        return cnt_1;
    }

    public final void addRequestCount() {
        this.addRequestCount(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addRequestCount(boolean add) {
        long currentSecond = System.currentTimeMillis() / 1000L;
        RequestCounter requestCounter = this;
        synchronized (requestCounter) {
            if (currentSecond != this.lastSecond.get()) {
                if (this.lastSecond.get() != 0L) {
                    if (currentSecond - this.lastSecond.get() > (long)(this.time * 1000)) {
                        this.vector.clear();
                        for (int i = 0; i < this.time; ++i) {
                            this.vector.add(0);
                        }
                    } else {
                        this.vector.add(0, this.lastCount.get());
                        for (long i = this.lastSecond.get(); i < currentSecond - 1L; ++i) {
                            this.vector.add(0, 0);
                        }
                        while (this.vector.size() > this.time) {
                            this.vector.remove(this.vector.size() - 1);
                        }
                    }
                }
                this.lastSecond.set(currentSecond);
                this.lastCount.set(0);
                if (add) {
                    this.lastCount.set(1);
                }
            } else if (add) {
                this.lastCount.incrementAndGet();
            }
        }
    }
}

