/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client;

import bitel.billing.module.common.CheckListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.RowSorterEvent;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import org.json.JSONObject;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.event.UpdateContractEmailEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.common.util.CustomerUtils;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractSubPanel;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class ContractSubPanel_Password
extends ContractSubPanel
implements EventSubscriber<UpdateContractEmailEvent> {
    private BGDataSourceTableModel tableModel = new BGDataSourceTableModel("WebPassword");
    private JCheckBox generate = new JCheckBox("\u0430\u0432\u0442\u043e");
    private JPasswordField password = new JPasswordField();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelListSelect emailList = new BGControlPanelListSelect();
    private JTextArea customEmails = new JTextArea(5, 10);
    private JLabel recordCountLabel = new JLabel();

    public ContractSubPanel_Password() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        EventBus.subscribe(UpdateContractEmailEvent.class, (EventSubscriber)this);
    }

    public void onEvent(UpdateContractEmailEvent event) {
        if (event.getContractId() == this.getContractId()) {
            this.setEmailData();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getSendPasswordPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.getLogPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
    }

    private JPanel getSendPasswordPanel() {
        this.customEmails.setMargin(new Insets(3, 3, 3, 3));
        CheckListCellRenderer<BGUListItem> cellRenderer = new CheckListCellRenderer<BGUListItem>(){

            public void setText(String text) {
                StringBuilder str = new StringBuilder("<html><div style='font-size: 15pt; font-style: italic; margin-top: 3px; margin-left: 3px;'>").append(text.startsWith("<") ? "?????" : "").append(text.replaceFirst("<", "</div><div style='font-size: 11pt; color: #a0a0a0;'>&lt;")).append("</div></html>");
                super.setText(str.toString());
            }
        };
        this.emailList.getList().setCellRenderer((ListCellRenderer)cellRenderer);
        BGButton sendButton = new BGButton("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c");
        sendButton.addActionListener(this::sendButton_actionPerformed);
        JPanel customEmailPanel = new JPanel(new GridBagLayout());
        Dimension dimension = customEmailPanel.getPreferredSize();
        dimension.setSize(dimension.width, 200);
        customEmailPanel.setMinimumSize(dimension);
        customEmailPanel.setPreferredSize(dimension);
        customEmailPanel.setBorder((Border)new BGTitleBorder(" \u0414\u0440\u0443\u0433\u0438\u0435 e-mail \u0430\u0434\u0440\u0435\u0441\u0430  "));
        customEmailPanel.add((Component)new JScrollPane(this.customEmails), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        customEmailPanel.add((Component)new CommentLabel("( \u043a\u0430\u0436\u0434\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u043d\u0430 \u043d\u043e\u0432\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u0435 )"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        TitlePanel panel = new TitlePanel(" \u0412\u044b\u0441\u043b\u0430\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0430 e-mail ");
        dimension = panel.getPreferredSize();
        dimension.setSize(350, dimension.height);
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.add((Component)this.emailList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)customEmailPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)sendButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getLogPanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.setSelectionMode(0);
        table.getRowSorter().addRowSorterListener(e -> {
            if (e.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                this.pagePanel.setPageIndex(1);
                this.setData(table.getSort());
            }
        });
        this.password.setText("");
        this.password.setMinimumSize(new Dimension(110, 24));
        this.password.setPreferredSize(new Dimension(114, 24));
        this.password.setColumns(20);
        this.password.setHorizontalAlignment(0);
        BGButton buttonOK = new BGButton("OK");
        buttonOK.addActionListener(e -> this.saveButton_actionPerformed(e));
        JPanel editPasswordPanel = new JPanel(new GridBagLayout());
        editPasswordPanel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        editPasswordPanel.add((Component)this.password, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        editPasswordPanel.add((Component)this.generate, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        editPasswordPanel.add((Component)buttonOK, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.setData(table.getSort());
            }
        });
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)editPasswordPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.recordCountLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        topPanel.add((Component)this.pagePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        return panel;
    }

    public void setData() {
        this.setData(null);
    }

    protected void setData(String[] sort) {
        this.setEmailData();
        try {
            BGUTableParams tableParams = new BGUTableParams().setContractId(this.getContractId()).setPage(this.pagePanel.getPage()).setSort(sort);
            this.tableModel.loadData(this.getKernelContext(), tableParams, this.pagePanel, this.recordCountLabel);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void setEmailData() {
        try {
            DefaultListModel model = this.emailList.getListModel();
            model.clear();
            JSONObject customer = this.getContext().getCustomer();
            if (customer != null) {
                CustomerUtils.getContactEmails(customer).forEach(c -> model.addElement(new BGUListItem(0, c.toString())));
            }
            ((ContractService)this.getContext().getWebService(ContractService.class, 0)).contractParameterMapByType(this.getContractId(), EntitySpecAttrType.EMAIL.getCode()).getMap().forEach((pid, emailParameter) -> {
                if (emailParameter != null) {
                    ((EntityAttrEmail)emailParameter).getContactList().forEach(c -> model.addElement(new BGUListItem(0, c.toString())));
                }
            });
            this.customEmails.setText("");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void sendButton_actionPerformed(ActionEvent e) {
        StringBuffer list = new StringBuffer();
        DefaultListModel model = this.emailList.getList().getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            BGUListItem item = (BGUListItem)model.elementAt(i);
            if (!item.isSelected()) continue;
            list.append(item.getTitle());
            list.append("\n");
        }
        list.append(this.customEmails.getText());
        if (list.length() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u0435 \u043e\u0434\u0438\u043d \u0430\u0434\u0440\u0435\u0441!");
        } else {
            try {
                ((ContractService)this.getContext().getPort(ContractService.class)).sendWebPasswordOfContractToEmail(list.toString(), this.getContractId());
                ClientUtils.showMessageDialog((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private void saveButton_actionPerformed(ActionEvent e) {
        char[] pswd1 = this.password.getPassword();
        Request request = new Request().setModule(this.module).setAction("UpdateContractPassword").setContractId(this.getContractId()).setAttribute("value", new String(pswd1)).setAttribute("set_pswd", this.generate.isSelected() ? "1" : null);
        if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
            this.setData();
        }
    }

    class CommentLabel
    extends JLabel {
        public CommentLabel(String text) {
            super(text);
            this.setFont(new Font("SansSerif", 2, 10));
            this.setForeground(Color.DARK_GRAY);
        }
    }

    class TitlePanel
    extends JPanel {
        TitlePanel(String borderTitle) {
            this.setLayout(new GridBagLayout());
            this.setBorder((Border)new BGTitleBorder(borderTitle));
        }
    }
}

