/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.load;

import bitel.billing.module.common.BGControlPanelMonth;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.time.LocalDate;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.log.client.LogManagerPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public abstract class ServiceConfigSourceManager
extends ServiceConfigTabbedPanel {
    int[] colors = new int[]{0xF00000, 983040, 61440, 3840, 240};
    private LogManagerPanel sourceManagerPanel = new LogManagerPanel(5, this.colors);
    private JCheckBox jcbLoad = new JCheckBox();
    private JCheckBox jcbInProcess = new JCheckBox();
    private JCheckBox jcbInLoad = new JCheckBox();
    private JCheckBox jcbProcess = new JCheckBox();
    private JCheckBox jcbLabel = new JCheckBox();
    private JCheckBox jcbZero = new JCheckBox();
    private JList<BGUListItem> sourceList = new JList();
    private BGControlPanelMonth bGControlPanel_10 = new BGControlPanelMonth();

    public ServiceConfigSourceManager() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this.sourceManagerPanel);
    }

    protected abstract boolean isNeedLoadMenuItems();

    private void jbInit() throws Exception {
        this.sourceList.addListSelectionListener(e -> this.sourceList_valueChanged(e));
        this.sourceList.setSelectionMode(0);
        this.sourceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ServiceConfigSourceManager.this.sourceList_mouseClicked(e);
            }
        });
        ViewModeChangeListener viewModeChangeListener = new ViewModeChangeListener();
        ViewModeActionListener viewModeActionListener = new ViewModeActionListener();
        this.jcbLoad.setSelected(true);
        this.jcbLoad.setText("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d");
        this.jcbLoad.addChangeListener(viewModeChangeListener);
        this.jcbInProcess.setSelected(true);
        this.jcbInProcess.setText("\u0412 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435");
        this.jcbInProcess.addChangeListener(viewModeChangeListener);
        this.jcbInLoad.setSelected(true);
        this.jcbInLoad.setText("\u0412 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435");
        this.jcbInLoad.addChangeListener(viewModeChangeListener);
        this.jcbProcess.setSelected(true);
        this.jcbProcess.setText("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d");
        this.jcbProcess.addActionListener(viewModeActionListener);
        this.jcbLabel.setSelected(true);
        this.jcbLabel.setText("\u041f\u043e\u043c\u0435\u0447\u0435\u043d");
        this.jcbLabel.addActionListener(viewModeActionListener);
        this.jcbZero.setSelected(true);
        this.jcbZero.setText("\u041d\u0443\u043b\u0435\u0432\u043e\u0439 \u043e\u0431\u044a\u0435\u043c");
        this.jcbZero.addActionListener(viewModeActionListener);
        JPanel jPanel14 = new JPanel();
        jPanel14.add((Component)this.jcbLoad, null);
        jPanel14.add((Component)this.jcbInLoad, null);
        jPanel14.add((Component)this.jcbProcess, null);
        jPanel14.add((Component)this.jcbInProcess, null);
        jPanel14.add((Component)this.jcbLabel, null);
        jPanel14.add((Component)this.jcbZero, null);
        this.sourceManagerPanel.setLayout(new GridBagLayout());
        this.sourceManagerPanel.setBackground(Color.gray);
        this.sourceManagerPanel.addPropertyChangeListener(e -> this.sourceManagerPanel_propertyChange(e));
        this.bGControlPanel_10.setBorder(new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        this.bGControlPanel_10.addPropertyChangeListener(e -> this.bGControlPanel_10_propertyChange(e));
        JPanel jPanel13 = new JPanel(new GridBagLayout());
        jPanel13.setAlignmentX(0.5f);
        jPanel13.add((Component)jPanel14, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        jPanel8.add((Component)jPanel13, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel8.add((Component)this.sourceManagerPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane jScrollPane2 = new JScrollPane(jPanel8);
        jScrollPane2.setBorder(null);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(new BGTitleBorder(" \u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438 "));
        jPanel4.add((Component)BGSwingUtilites.wrapScrollPane(this.sourceList, 200, 200), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.bGControlPanel_10, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel4, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add((Component)jScrollPane2, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public void setData() throws Exception {
        if (this.module != null && this.getModuleId() > 0) {
            Request request = new Request().setModule("load").setModuleId(this.getModuleId()).setAction("SourceManagerInfo");
            BGUListItem listItem = this.sourceList.getSelectedValue();
            int sourceType = -1;
            if (listItem != null) {
                request.setAttribute("source_id", (String)listItem.getAttribute("id"));
                String str = String.valueOf(listItem.getAttribute("sourceType"));
                sourceType = Integer.valueOf(str);
            }
            LocalDate date = this.bGControlPanel_10.getLocalDate();
            request.setAttribute("month", String.valueOf(date.getMonthValue()));
            request.setAttribute("year", String.valueOf(date.getYear()));
            this.setDocument(this.getDocument(request), sourceType);
        }
    }

    @Override
    public void setDocument(Document doc) {
        throw new UnsupportedOperationException();
    }

    public void setDocument(Document doc, int sourceType) throws Exception {
        if (ClientUtils.checkStatus(doc)) {
            Element info;
            Node sources = XMLUtils.selectNode(doc, "//list");
            if (sources != null && sources.hasChildNodes()) {
                ClientUtils.buildList(this.sourceList, sources);
            }
            if ((info = XMLUtils.selectElement(doc, "//info")) != null) {
                this.reloadPopupMenuItems(Utils.parseInt(info.getAttribute("use.load")) > 0, sourceType);
                this.setDataToSourceManagerPanel(info);
            }
        }
    }

    protected void setDataToSourceManagerPanel(Element info) {
        int valueCount = 5;
        int[][] values = new int[valueCount][31];
        int[] quads = new int[31];
        for (int i = 0; i < 31; ++i) {
            for (int j = 0; j < valueCount; ++j) {
                values[j][i] = 0;
            }
            quads[i] = 0;
        }
        if (info != null && info.hasChildNodes()) {
            for (Element node : XMLUtils.elements(info.getChildNodes())) {
                String id = XMLUtils.getAttribute(node, "id", "0");
                int day = Utils.parseInt(id, 0);
                for (int j = 0; j < valueCount; ++j) {
                    String value = XMLUtils.getAttribute(node, "v" + (j + 1), "0");
                    values[j][day - 1] = Utils.parseInt(value, 0);
                }
                String value = XMLUtils.getAttribute(node, "v6", "0");
                quads[day - 1] = Utils.parseInt(value, 0);
            }
        }
        this.sourceManagerPanel.setData(values, quads, this.bGControlPanel_10.getLocalDate().lengthOfMonth());
    }

    void sourceList_valueChanged(ListSelectionEvent e) {
        this.trySetData();
    }

    void sourceManagerPanel_propertyChange(PropertyChangeEvent e) {
        int i;
        LocalDate date = this.bGControlPanel_10.getLocalDate();
        String mm = String.valueOf(date.getMonthValue());
        String yy = String.valueOf(date.getYear());
        Object hours = "";
        Rectangle rect = this.sourceManagerPanel.getSelectArea();
        for (i = rect.y; i < rect.y + rect.height; ++i) {
            String hh = i < 10 ? "0" + i : "" + i;
            hours = (String)hours + hh + ",";
        }
        if ("load".equals(e.getPropertyName())) {
            for (i = rect.x; i < rect.x + rect.width; ++i) {
                dd = i < 10 ? "0" + i : "" + i;
                Request request = new Request();
                request.setModule("load");
                request.setModuleId(this.getModuleId());
                request.setAction("AddLoadTasks");
                BGUListItem item = this.sourceList.getSelectedValue();
                if (item != null) {
                    request.setAttribute("source", item.getAttribute("id"));
                }
                request.setAttribute("date", dd + "." + mm + "." + yy);
                request.setAttribute("hour", (String)hours);
                ClientUtils.checkStatus(this.getDocument(request));
            }
        } else if ("deleteLoad".equals(e.getPropertyName())) {
            for (i = rect.x; i < rect.x + rect.width; ++i) {
                dd = i < 10 ? "0" + i : "" + i;
                Request request = new Request();
                request.setModule("load");
                request.setModuleId(this.getModuleId());
                request.setAction("DeleteLoadTasks");
                BGUListItem item = this.sourceList.getSelectedValue();
                if (item != null) {
                    request.setAttribute("source", item.getAttribute("id"));
                }
                request.setAttribute("date", dd + "." + mm + "." + yy);
                request.setAttribute("hour", (String)hours);
                ClientUtils.checkStatus(this.getDocument(request));
            }
        } else if ("deleteLoadAll".equals(e.getPropertyName())) {
            for (i = rect.x; i < rect.x + rect.width; ++i) {
                dd = i < 10 ? "0" + i : "" + i;
                Request request = new Request();
                request.setModule("load");
                request.setModuleId(this.getModuleId());
                request.setAction("DeleteLoadTasksAll");
                request.setAttribute("date", dd + "." + mm + "." + yy);
                request.setAttribute("hour", (String)hours);
                ClientUtils.checkStatus(this.getDocument(request));
            }
        } else if ("proccess".equals(e.getPropertyName())) {
            for (i = rect.x; i < rect.x + rect.width; ++i) {
                dd = i < 10 ? "0" + i : "" + i;
                Request request = new Request();
                request.setModule("load");
                request.setModuleId(this.getModuleId());
                request.setAction("AddProcessTasks");
                BGUListItem item = this.sourceList.getSelectedValue();
                if (item != null) {
                    request.setAttribute("source", item.getAttribute("id"));
                }
                request.setAttribute("date", dd + "." + mm + "." + yy);
                request.setAttribute("hour", (String)hours);
                ClientUtils.checkStatus(this.getDocument(request));
            }
        } else if ("proccessAll".equals(e.getPropertyName())) {
            for (i = rect.x; i < rect.x + rect.width; ++i) {
                dd = i < 10 ? "0" + i : "" + i;
                Request request = new Request();
                request.setModule("load");
                request.setModuleId(this.getModuleId());
                request.setAction("AddProcessTasksAll");
                request.setAttribute("date", dd + "." + mm + "." + yy);
                request.setAttribute("hour", (String)hours);
                ClientUtils.checkStatus(this.getDocument(request));
            }
        } else if ("deleteProccess".equals(e.getPropertyName())) {
            for (i = rect.x; i < rect.x + rect.width; ++i) {
                dd = i < 10 ? "0" + i : "" + i;
                Request request = new Request();
                request.setModule("load");
                request.setModuleId(this.getModuleId());
                request.setAction("DeleteProccessTasks");
                BGUListItem item = this.sourceList.getSelectedValue();
                if (item != null) {
                    request.setAttribute("source", item.getAttribute("id"));
                }
                request.setAttribute("date", dd + "." + mm + "." + yy);
                request.setAttribute("hour", (String)hours);
                ClientUtils.checkStatus(this.getDocument(request));
            }
        } else if ("deleteProccessAll".equals(e.getPropertyName())) {
            for (i = rect.x; i < rect.x + rect.width; ++i) {
                dd = i < 10 ? "0" + i : "" + i;
                Request request = new Request();
                request.setModule("load");
                request.setModuleId(this.getModuleId());
                request.setAction("DeleteProccessTasksAll");
                request.setAttribute("date", dd + "." + mm + "." + yy);
                request.setAttribute("hour", (String)hours);
                ClientUtils.checkStatus(this.getDocument(request));
            }
        } else if ("label".equals(e.getPropertyName())) {
            for (i = rect.x; i < rect.x + rect.width; ++i) {
                dd = i < 10 ? "0" + i : "" + i;
                Request request = new Request();
                request.setModule("load");
                request.setModuleId(this.getModuleId());
                request.setAction("AddLabel");
                BGUListItem item = this.sourceList.getSelectedValue();
                if (item != null) {
                    request.setAttribute("source", item.getAttribute("id"));
                }
                request.setAttribute("date", dd + "." + mm + "." + yy);
                request.setAttribute("hour", (String)hours);
                ClientUtils.checkStatus(this.getDocument(request));
            }
        } else if ("labelAll".equals(e.getPropertyName())) {
            for (i = rect.x; i < rect.x + rect.width; ++i) {
                dd = i < 10 ? "0" + i : "" + i;
                Request request = new Request();
                request.setModule("load");
                request.setModuleId(this.getModuleId());
                request.setAction("AddLabel");
                Object source = "";
                if (this.sourceList.getModel().getSize() > 0) {
                    source = this.sourceList.getModel().getElementAt(0).getAttribute("id").toString();
                }
                for (int j = 1; j < this.sourceList.getModel().getSize(); ++j) {
                    source = (String)source + "," + String.valueOf(this.sourceList.getModel().getElementAt(j).getAttribute("id"));
                }
                request.setAttribute("date", dd + "." + mm + "." + yy);
                request.setAttribute("hour", (String)hours);
                request.setAttribute("source", (String)source);
                ClientUtils.checkStatus(this.getDocument(request));
            }
        } else if ("deleteLabel".equals(e.getPropertyName())) {
            for (i = rect.x; i < rect.x + rect.width; ++i) {
                dd = i < 10 ? "0" + i : "" + i;
                Request request = new Request();
                request.setModule("load");
                request.setModuleId(this.getModuleId());
                request.setAction("DeleteLabel");
                BGUListItem item = this.sourceList.getSelectedValue();
                if (item != null) {
                    request.setAttribute("source", item.getAttribute("id"));
                }
                request.setAttribute("date", dd + "." + mm + "." + yy);
                request.setAttribute("hour", (String)hours);
                ClientUtils.checkStatus(this.getDocument(request));
            }
        } else if ("deleteLabelAll".equals(e.getPropertyName())) {
            for (i = rect.x; i < rect.x + rect.width; ++i) {
                dd = i < 10 ? "0" + i : "" + i;
                Request request = new Request();
                request.setModule("load");
                request.setModuleId(this.getModuleId());
                request.setAction("DeleteLabel");
                Object source = "";
                if (this.sourceList.getModel().getSize() > 0) {
                    source = this.sourceList.getModel().getElementAt(0).getAttribute("id").toString();
                }
                for (int j = 1; j < this.sourceList.getModel().getSize(); ++j) {
                    source = (String)source + "," + String.valueOf(this.sourceList.getModel().getElementAt(j).getAttribute("id"));
                }
                request.setAttribute("source", (String)source);
                request.setAttribute("date", dd + "." + mm + "." + yy);
                request.setAttribute("hour", (String)hours);
                ClientUtils.checkStatus(this.getDocument(request));
            }
        }
        this.trySetData();
    }

    void setViewMode() {
        boolean[] checked = new boolean[]{this.jcbLoad.isSelected(), this.jcbProcess.isSelected(), this.jcbInProcess.isSelected(), this.jcbInLoad.isSelected(), this.jcbLabel.isSelected(), this.jcbZero.isSelected()};
        this.sourceManagerPanel.setViewMode(checked);
    }

    void bGControlPanel_10_propertyChange(PropertyChangeEvent e) {
        if ("date".equals(e.getPropertyName())) {
            this.trySetData();
        }
    }

    void sourceList_mouseClicked(MouseEvent e) {
        this.trySetData();
    }

    public void reloadPopupMenuItems(boolean needLoadMenuItems, int sourceType) {
        this.sourceManagerPanel.clearPopups();
        if (sourceType == 1 || sourceType == 2 || needLoadMenuItems) {
            this.sourceManagerPanel.addMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443 (\u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a)", "load");
            this.sourceManagerPanel.addMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 (\u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a)", "deleteLoad");
            this.sourceManagerPanel.addPopupSeparator();
        }
        this.sourceManagerPanel.addMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 (\u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a)", "proccess");
        this.sourceManagerPanel.addMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 (\u0432\u0441\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438)", "proccessAll");
        this.sourceManagerPanel.addMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 (\u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a)", "deleteProccess");
        this.sourceManagerPanel.addMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 (\u0432\u0441\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438)", "deleteProccessAll");
        this.sourceManagerPanel.addPopupSeparator();
        this.sourceManagerPanel.addMenuItem("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043c\u0435\u0442\u043a\u0443 (\u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a)", "label");
        this.sourceManagerPanel.addMenuItem("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043c\u0435\u0442\u043a\u0443 (\u0432\u0441\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438)", "labelAll");
        this.sourceManagerPanel.addMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u0435\u0442\u043a\u0443 (\u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a)", "deleteLabel");
        this.sourceManagerPanel.addMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u0435\u0442\u043a\u0443 (\u0432\u0441\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438)", "deleteLabelAll");
    }

    private class ViewModeChangeListener
    implements ChangeListener {
        private ViewModeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            ServiceConfigSourceManager.this.setViewMode();
        }
    }

    private class ViewModeActionListener
    implements ActionListener {
        private ViewModeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ServiceConfigSourceManager.this.setViewMode();
        }
    }
}

