/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.apps.server.bean;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import ru.bitel.bgbilling.kernel.admin.apps.common.bean.AppInfo;
import ru.bitel.bgbilling.kernel.event.events.system.AppNotificationEvent;

public class AppsCache {
    private static AppsCache instanse = null;
    private List<AppInfo> appInfos = new ArrayList<AppInfo>();

    private AppsCache() {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                AppsCache.this.appInfos = new ArrayList<AppInfo>(AppsCache.this.appInfos.stream().filter(a -> System.currentTimeMillis() - a.getPublishLastTime() < (long)(2 * a.getPublishPeriod() * 1000)).toList());
            }
        }, 60000L);
    }

    public static AppsCache getInstanse() {
        if (instanse == null) {
            instanse = new AppsCache();
        }
        return instanse;
    }

    public void update(AppNotificationEvent event) {
        int appId = event.getAppId();
        AppInfo appInfo = this.appInfos.stream().filter(a -> a.getAppId() == appId).findFirst().orElse(null);
        if (appInfo == null) {
            appInfo = new AppInfo().setAppId(appId);
            this.appInfos.add(appInfo);
        }
        appInfo.setAppName(event.getAppName()).setUptime(event.getUptime()).setPublishPeriod(event.getPublishPeriod()).setPublishLastTime(System.currentTimeMillis()).setData(event.getData());
    }

    public List<AppInfo> getAppInfos() {
        return this.appInfos;
    }
}

