/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.bean;

import bitel.billing.server.tariff.TimeLimits;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TimeLimitSet {
    private List<Period> periodList = new ArrayList<Period>();

    public TimeLimitSet(String data) {
        StringTokenizer st = new StringTokenizer(data, "#");
        while (st.hasMoreTokens()) {
            Period period = new Period(this, st.nextToken());
            this.periodList.add(period);
        }
    }

    public boolean checkTime(Calendar time) {
        boolean result = false;
        if (this.periodList.size() == 0) {
            result = true;
        } else {
            Period period;
            Iterator<Period> iterator = this.periodList.iterator();
            while (iterator.hasNext() && !(result = (period = iterator.next()).checkDate(time))) {
            }
        }
        return result;
    }

    private class Period {
        private Date date1 = null;
        private Date date2 = null;
        private List<TimeLimits> limitsList = new ArrayList<TimeLimits>();

        public Period(TimeLimitSet timeLimitSet, String data) {
            String period;
            String[] s;
            StringTokenizer st = new StringTokenizer(data, ">");
            if (st.countTokens() > 1 && (s = (period = st.nextToken()).split("-")).length > 1) {
                if (Utils.isEmptyString((String)s[0]) || s[0].equals("any")) {
                    s[0] = null;
                }
                if (Utils.isEmptyString((String)s[1]) || s[1].equals("any")) {
                    s[1] = null;
                }
                this.date1 = TimeUtils.parseDate((String)s[0], (String)"dd.MM.yyyy");
                this.date2 = TimeUtils.parseDate((String)s[1], (String)"dd.MM.yyyy");
            }
            this.loadTimeLimits(st.nextToken());
        }

        public boolean checkDate(Calendar calendar) {
            boolean result;
            block3: {
                Date date = calendar.getTime();
                result = false;
                if (date == null || this.date1 != null && !TimeUtils.dateBeforeOrEq((Date)this.date1, (Date)date) || this.date2 != null && !TimeUtils.dateBeforeOrEq((Date)date, (Date)this.date2)) break block3;
                if (this.limitsList.size() == 0) {
                    result = true;
                } else {
                    TimeLimits tl;
                    Iterator<TimeLimits> iterator = this.limitsList.iterator();
                    while (iterator.hasNext() && !(result = (tl = iterator.next()).checkDate(calendar))) {
                    }
                }
            }
            return result;
        }

        public void loadTimeLimits(String data) {
            StringTokenizer st = new StringTokenizer(data, "%");
            while (st.hasMoreTokens()) {
                this.limitsList.add(new TimeLimits(st.nextToken()));
            }
        }
    }
}

