/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelDate;
import bitel.billing.module.common.FloatTextField;
import bitel.billing.module.contract.PaymentDistributePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.math.BigDecimal;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGDialog;

public class BalanceTransferPanel
extends BGDialog {
    private int cid = -1;
    private int id = -1;
    private BGControlPanelDate date = new BGControlPanelDate();
    private FloatTextField summa = new FloatTextField();
    private PaymentDistributePanel paymentDictributePanel;
    private boolean doTransfer = true;

    public BalanceTransferPanel(int id, int cid) {
        this.id = id;
        this.cid = cid;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.pack();
        this.setSize(500, 500);
        this.moveWindowToCenterScreen();
    }

    private void jbInit() throws Exception {
        this.date.setButtonMove(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        JPanel summaPanel = new JPanel(new GridBagLayout());
        summaPanel.setBorder(new BGTitleBorder(" \u0421\u0443\u043c\u043c\u0430 "));
        summaPanel.setOpaque(false);
        JPanel datePanel = new JPanel(new GridBagLayout());
        this.summa.setMinimumSize(new Dimension(110, 24));
        this.summa.setPreferredSize(new Dimension(110, 24));
        this.summa.setColumns(10);
        this.summa.setEnabled(false);
        BGButtonPanelRestoreOkCancelHelp okPanel = new BGButtonPanelRestoreOkCancelHelp();
        okPanel.addActionListener(e -> this.okPanelActionPerformed(e));
        summaPanel.add((Component)this.summa, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        datePanel.add((Component)summaPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        datePanel.add((Component)this.date, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)datePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)okPanel, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                BalanceTransferPanel.this.summa.requestFocusInWindow();
            }
        });
        this.summa.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updated();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updated();
            }

            private void updated() {
                if (BalanceTransferPanel.this.paymentDictributePanel != null) {
                    BalanceTransferPanel.this.paymentDictributePanel.summaChanged(BalanceTransferPanel.this.summa.getText());
                }
            }
        });
    }

    public boolean isDoTransfer() {
        return this.doTransfer;
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setContractId(this.cid);
        request.setModule("contract");
        request.setAction("GetContractFreeSumma");
        try {
            Document doc = TransferManager.getDocument(request);
            ClientUtils.checkStatus(doc);
            Element free = XMLUtils.selectElement(doc, "//free");
            this.summa.setText(free.getAttribute("amount"));
            if (Utils.parseBigDecimal(free.getAttribute("amount"), BigDecimal.ZERO).signum() <= 0) {
                ClientUtils.showErrorMessageDialog("\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0435\u0442!");
                this.doTransfer = false;
            }
            if (this.id <= 0) {
                this.paymentDictributePanel = new PaymentDistributePanel(0, this);
                this.paymentDictributePanel.init("contract", 0);
                this.paymentDictributePanel.setContractId(this.cid);
                this.paymentDictributePanel.setData();
                if (this.paymentDictributePanel.getRowCount() > 0) {
                    this.add((Component)this.paymentDictributePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
                    this.paymentDictributePanel.summaChanged(this.summa.getText());
                } else {
                    this.paymentDictributePanel = null;
                    ClientUtils.showErrorMessageDialog("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u043e\u0436\u043d\u043e \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u044f\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0441 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432!");
                    this.doTransfer = false;
                }
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void okPanelActionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.setData();
        } else if ("ok".equals(actionCommand)) {
            if (this.date.getDateCalendar() == null) {
                ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
                return;
            }
            Request request = new Request();
            request.setModule("contract");
            request.setAction("ContractBalanceTransfer");
            request.setContractId(this.cid);
            request.setAttribute("date", this.date.getDateString());
            String check = this.paymentDictributePanel.checkValidDistribution(this.summa.getText().trim());
            if (!"ok".equals(check)) {
                ClientUtils.showErrorMessageDialog(check);
                return;
            }
            if (this.paymentDictributePanel != null) {
                request.setAttribute("distribution", this.paymentDictributePanel.getDistribution());
            }
            Document doc = TransferManager.getDocument(request);
            ClientUtils.checkStatus(doc);
            this.dispose();
        } else if ("cancel".equals(actionCommand)) {
            this.dispose();
        } else if ("help".equals(actionCommand)) {
            this.openHelp(this.getClass().getName());
        }
    }
}

