/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioButtonTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGDialog;
import ru.bitel.common.client.table.BGTableModel;

public class BGContractTitleDialog
extends BGDialog {
    private String selectedTitle = null;
    private ContractTitleTableModel tableModel = new ContractTitleTableModel(BGContractTitleDialog.class.getName());
    private BGUTable table = new BGUTable(this.tableModel);
    private BGButtonPanelOkCancel buttonPanelOkCancel = new BGButtonPanelOkCancel();

    public BGContractTitleDialog(List<String> contractTitles) {
        this.buttonPanelOkCancel.addActionListener(e -> {
            if (e.getActionCommand().equals("cancel")) {
                this.selectedTitle = null;
                this.setVisible(false);
            } else if (this.selectedTitle != null) {
                this.setVisible(false);
            } else {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        this.setTitle("\u0412\u044b\u0431\u043e\u0440 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        this.setMinimumSize(new Dimension(500, 250));
        this.moveWindowToCenterScreen();
        this.setDefaultCloseOperation(2);
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.buttonPanelOkCancel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        ArrayList data = new ArrayList();
        contractTitles.forEach(e -> data.add(new ContractTitleRow(this, (String)e)));
        this.tableModel.setData(data);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int col;
                super.mouseClicked(mouseEvent);
                if (BGContractTitleDialog.this.table.isEnabled() && mouseEvent.getClickCount() > 1 && (col = BGContractTitleDialog.this.table.getSelectedColumn()) == 0) {
                    BGContractTitleDialog.this.selectedTitle = BGContractTitleDialog.this.tableModel.optSelectedRow().map(a -> a.getTitle()).orElse("");
                    BGContractTitleDialog.this.setSelected();
                }
            }
        });
    }

    public boolean setSelected(String selectedTitle) {
        this.selectedTitle = selectedTitle;
        return this.setSelected();
    }

    public boolean setSelected() {
        boolean result = true;
        if (this.tableModel != null) {
            result = false;
            for (ContractTitleRow item : this.tableModel.getRows()) {
                item.setSelected(this.selectedTitle.equals(item.getTitle()));
                if (!item.isSelected()) continue;
                this.tableModel.setSelectedRow(item);
                result = true;
            }
            this.table.repaint();
        }
        return result;
    }

    public String getSelectedTitle() {
        return this.selectedTitle;
    }

    class ContractTitleTableModel
    extends BGTableModel<ContractTitleRow> {
        public ContractTitleTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("V", 50, 50, 50, "selected", false, new RadioButtonTableCellRenderer());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 150, 200, -1, "title", false, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class ContractTitleRow {
        boolean selected = false;
        String title = "";

        ContractTitleRow(BGContractTitleDialog this$0, String title) {
            this.title = title;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

