/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.server.bean;

import bitel.billing.server.ApplicationModule;
import java.io.File;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.enums.ComponentType;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.installer.InstallerModule;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class ModuleManager
extends BGLogger {
    private static final String IMC = "id, enabled, type, name, title, version, pack_client, pack_server";
    private Connection con;
    private static long lastUpdateTime = 0L;
    private static Map<String, int[]> moduleIds = new HashMap<String, int[]>();

    public ModuleManager(Connection con) {
        this.con = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getModuleIdByName(String moduleName) {
        int[] ids;
        int moduleId = 0;
        if (System.currentTimeMillis() > lastUpdateTime + 1000L * Setup.getSetup().getLong("module.ids.update.period", 300L)) {
            Connection con = Setup.getSetup().getDBConnectionFromPool();
            try {
                HashMap<String, int[]> newModuleIds = new HashMap<String, int[]>();
                String query = "SELECT id, name FROM module";
                Statement st = con.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    String module = rs.getString(2);
                    int[] ids2 = (int[])newModuleIds.get(module);
                    ids2 = ids2 == null ? new int[1] : Arrays.copyOf(ids2, ids2.length + 1);
                    newModuleIds.put(module, ids2);
                    ids2[ids2.length - 1] = rs.getInt(1);
                }
                rs.close();
                st.close();
                moduleIds = newModuleIds;
                lastUpdateTime = System.currentTimeMillis();
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(ModuleManager.class).error("error get moduleId by name", (Throwable)ex);
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Exception exception) {}
                }
                con = null;
            }
        }
        if ((ids = moduleIds.get(moduleName)) != null && ids.length == 1) {
            moduleId = ids[0];
        }
        return moduleId;
    }

    public List<BGModule> getModules(String name) throws Exception {
        ArrayList<BGModule> result = new ArrayList<BGModule>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ");
        query.append("module");
        if (name != null) {
            query.append(" WHERE name=?");
        }
        query.append(" ORDER BY title");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (name != null) {
                ps.setString(1, name);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getModuleFromRs(rs));
                }
            }
        }
        return result;
    }

    public List<BGModule> getModules() throws Exception {
        ArrayList<BGModule> result = new ArrayList<BGModule>();
        String query = "SELECT * FROM module ORDER BY name";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getModuleFromRs(rs));
            }
        }
        ArrayList<BGModule> resultSort = new ArrayList<BGModule>(result.stream().filter(a -> !a.getName().equals("npay")).toList());
        resultSort.addAll(result.stream().filter(a -> a.getName().equals("npay")).toList());
        return resultSort;
    }

    public BGModule getModule(int id) throws Exception {
        BGModule module = null;
        StringBuilder query = new StringBuilder().append("SELECT * FROM ").append("module").append(" WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            ps.setInt(index++, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    module = this.getModuleFromRs(rs);
                }
            }
        }
        return module;
    }

    public Map<Integer, BGModule> getModulesMap() throws Exception {
        HashMap<Integer, BGModule> result = new HashMap<Integer, BGModule>();
        String query = "SELECT * FROM module";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                BGModule module = this.getModuleFromRs(rs);
                result.put(module.getId(), module);
            }
        }
        return result;
    }

    public int addModule(BGInstalledModule module, String title, int userId) throws BGException {
        try {
            PreparedStatement ps = null;
            if (ServerUtils.getSetupValue(this.con, "20") != null) {
                throw new BGMessageException("\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0431\u044b\u043b \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0449\u0435\u043d \u043f\u043e\u0441\u043b\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043c\u043e\u0434\u0443\u043b\u044f!");
            }
            ps = this.con.prepareStatement("INSERT INTO module SET title=?, name=?", 1);
            ps.setString(1, title);
            ps.setString(2, module.getName());
            ps.executeUpdate();
            int moduleId = ServerUtils.lastInsertId(ps);
            InstallerModule.initModule(this.con, module.getName(), moduleId);
            ModuleCache.getInstance().reloadModules(this.con);
            BGModule bgModule = ModuleCache.getInstance().getModule(moduleId);
            ApplicationModule am = ModuleCache.getInstance().getApplicationModule(module.getName());
            if (am != null && bgModule != null) {
                try {
                    am.start(this.con, bgModule);
                }
                catch (BGException e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
            }
            return moduleId;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateModule(BGModule bgModule) throws Exception {
        String query = "UPDATE module SET title=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, bgModule.getTitle());
            ps.setInt(2, bgModule.getId());
            ps.executeUpdate();
        }
    }

    public void deleteModule(BGInstalledModule module, int id) throws BGException {
        try {
            String query = "SELECT cid FROM contract_module WHERE mid=? LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ps.close();
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u043e\u0434\u0443\u043b\u044c, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c \u0438\u0437 \u0432\u0441\u0435\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0447\u0435\u0440\u0435\u0437 \u0413\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438.");
            }
            rs.close();
            ps.close();
            InstallerModule.uninstallModuleInstance(this.con, module.getName(), id);
            query = "DELETE FROM module WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            this.deleteModuleEventTypes(id);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<String> getInstalledModules() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        String query = "SELECT name FROM installed_modules WHERE type IN ('module', 'plugin')";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        return result;
    }

    public List<BGInstalledModule> getInstalledModules(ComponentType ... types) throws Exception {
        ArrayList<BGInstalledModule> result = new ArrayList<BGInstalledModule>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT ").append(IMC).append(" FROM ").append("installed_modules");
        if (types != null && types.length > 0) {
            query.append(" WHERE type IN ( ");
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    query.append(", ");
                }
                query.append("?");
            }
            query.append(" )");
        }
        query.append(" ORDER BY title");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            if (types != null && types.length > 0) {
                for (ComponentType type : types) {
                    ps.setString(index++, type.name().toLowerCase());
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getInstalledModuleFromRs(rs));
                }
            }
        }
        return result;
    }

    private BGModule getModuleFromRs(ResultSet rs) throws SQLException {
        BGModule result = new BGModule();
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        result.setTitle(rs.getString("title"));
        return result;
    }

    private BGInstalledModule getInstalledModuleFromRs(ResultSet rs) throws SQLException {
        BGInstalledModule result = new BGInstalledModule();
        result.setId(rs.getInt("id"));
        result.setEnabled(rs.getBoolean("enabled"));
        result.setType(ComponentType.valueOf(rs.getString("type").toUpperCase()));
        result.setName(rs.getString("name"));
        result.setTitle(rs.getString("title"));
        result.setVersion(rs.getString("version"));
        result.setPackageClient(rs.getString("pack_client"));
        result.setPackageServer(rs.getString("pack_server"));
        return result;
    }

    private void deleteModuleEventTypes(int id) throws SQLException {
        String query = "DELETE FROM script_event_type WHERE mid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    public void deleteInstalledComponent(String name) throws Exception {
        URL filesDat;
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM installed_modules WHERE name=?");){
            ps.setString(1, name);
            ps.executeUpdate();
        }
        URL componentDirURL = ModuleManager.class.getResource("/components" + File.separatorChar + name);
        if (componentDirURL != null) {
            Files.walk(Paths.get(componentDirURL.toURI()), new FileVisitOption[0]).map(Path::toFile).sorted((o1, o2) -> -o1.compareTo((File)o2)).forEach(File::delete);
        }
        if ((filesDat = ModuleManager.class.getResource("/data/files.dat")) != null) {
            ArrayList toSave = new ArrayList();
            Path path = Paths.get(filesDat.toURI());
            Files.lines(path).forEach(e -> {
                if (!e.contains("name:" + name + "\t") && !e.contains("name:ru.bitel.bgbilling.plugins." + name + "\t")) {
                    toSave.add(e);
                }
            });
            Files.write(path, toSave, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        for (String dir : new String[]{"client", "common", "server"}) {
            URL libJar = ModuleManager.class.getResource("/lib/" + dir + "/" + name + "-" + dir + ".jar");
            if (libJar == null) continue;
            Files.deleteIfExists(Paths.get(libJar.toURI()));
        }
    }
}

