/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import ru.bitel.bgbilling.client.common.BGTimePanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.LookAndFeelUtils;

public class BGTimeButton
extends JToggleButton
implements PropertyChangeListener,
PopupMenuListener {
    private LocalTime oldTime = null;
    private LocalTime newTime = null;
    private int columns = 0;
    private int columnWidth = 0;
    private Popup popup = null;

    public BGTimeButton() {
        try {
            this.setMargin(new Insets(2, 5, 2, 5));
            this.setColumns(6);
            this.jbInit();
            this.setFocusPainted(true);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void jbInit() {
        this.setActionCommand("popup");
        this.addActionListener(e -> this.setPopupVisible(true));
    }

    public void setPopupVisible(boolean visible) {
        if (visible) {
            LocalTime time;
            LocalTime localTime = time = this.newTime != null ? this.newTime : LocalTime.now();
            if (this.getPopup().getTime() == null || !time.equals(this.getPopup().getTime())) {
                this.getPopup().setTime(time);
            }
            this.getPopup().timePanel.addPropertyChangeListener(this);
            this.getPopup().addPopupMenuListener(this);
            this.getPopup().show(this, 0, this.getHeight() + 1);
            Component comp = this.getPopup().timePanel.getTimeField().getComponent(1);
            if (comp != null) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().downFocusCycle();
                comp.requestFocus();
            }
        } else {
            this.getPopup().setVisible(false);
        }
    }

    public void setTime(LocalTime localTime) {
        this.oldTime = this.newTime == null ? null : this.newTime;
        this.setOnlyTime(localTime);
    }

    public LocalTime getTime() {
        return this.newTime;
    }

    @Override
    public void setText(String text) {
        try {
            this.setTime(LocalTime.from(DateTimeFormatter.ofPattern("HH:mm:ss").parse(text)));
        }
        catch (Exception e) {
            this.setTime(null);
        }
    }

    private void setOnlyTime(LocalTime localTime) {
        this.newTime = localTime;
        if (this.newTime != null) {
            BGTimeButton.super.setText(DateTimeFormatter.ofPattern("HH:mm:ss").format(this.newTime));
        } else {
            BGTimeButton.super.setText("");
        }
    }

    private Popup getPopup() {
        if (this.popup == null) {
            this.popup = new Popup();
        }
        return this.popup;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        int oldVal = this.columns;
        if (columns != oldVal) {
            this.columns = columns;
            this.invalidate();
        }
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.columns != 0) {
            Insets insets = this.getInsets();
            size.width = this.columns * this.getColumnWidth() + insets.left + insets.right;
        }
        size.height = LookAndFeelUtils.BUTTON_HEIGHT.get();
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.getModel().setSelected(false);
        this.getModel().setPressed(false);
        this.getPopup().timePanel.removePropertyChangeListener(this);
        this.getPopup().removePopupMenuListener(this);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String propertyName = propertyChangeEvent.getPropertyName();
        if ("updateTime".equals(propertyName)) {
            this.setPopupVisible(false);
            LocalTime newTime = null;
            if (this.getPopup().getTime() != null) {
                newTime = this.getPopup().getTime();
            }
            this.setTime(newTime);
            this.firePropertyChange("popupVisible", true, false);
            this.firePropertyChange("updateTime", this.oldTime, newTime);
        }
    }

    class Popup
    extends JPopupMenu {
        private BGTimePanel timePanel = new BGTimePanel();

        public Popup() {
            try {
                this.timePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                this.add("Center", this.timePanel);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }

        public LocalTime getTime() {
            return this.timePanel.getTime();
        }

        public void setTime(LocalTime localTime) {
            this.timePanel.setTime(localTime);
        }
    }
}

