/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGToggleButton;
import jakarta.xml.ws.Holder;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.BGClientInit;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractIdTitleComment;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractSearchParam;
import ru.bitel.bgbilling.kernel.contract.api.common.dto.ContractSearchDto;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelType;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.contract.search.client.ContracHistoryTableModel;
import ru.bitel.bgbilling.kernel.contract.search.client.ContracTabsTableModel;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractFilter_Address;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractFilter_Date;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractFilter_Default;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractFilter_Email;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractFilter_Id;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractFilter_List;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractFilter_Memo;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractFilter_MultiList;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractFilter_Phone;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractFilter_Text;
import ru.bitel.bgbilling.kernel.contract.search.client.ObjectFilter_Date;
import ru.bitel.bgbilling.kernel.contract.search.client.ObjectFilter_Id;
import ru.bitel.bgbilling.kernel.contract.search.client.ObjectFilter_List;
import ru.bitel.bgbilling.kernel.contract.search.client.SearchPopup;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractHistoryRecord;
import ru.bitel.bgbilling.kernel.contract.search.common.SearchImplementation;
import ru.bitel.bgbilling.kernel.contract.search.common.service.ContractSearchService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.LookAndFeelUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;

public class ContractOpen
extends BGTabPanel
implements SearchPopup.CustomSearch {
    private static final String VIEW_MODE_KEY = "contractOpenViewMode";
    private static final String VIEW_MODE_LIST = "list";
    private static final String VIEW_MODE_TABS = "tabs";
    private static final String VIEW_MODE_TABLE = "table";
    private static final String VIEW_MODE_HISTORY = "history";
    public static final String TAB_ID = "findContract";
    private static final String TAB_OBJECT = "object";
    private static final String TAB_CONTRACT = "contract";
    final String prefix = "\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432/\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432";
    private TitleComment titleComment = new TitleComment();
    private Set<Integer> selectedLabels = new HashSet<Integer>();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JTabbedPane tabPane = new JTabbedPane();
    private final JTextField contractTitleField = new JTextField();
    private SearchPopup searchPopup;
    private final SearchCheckBox showHidden = new SearchCheckBox("\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u0441\u043a\u0440\u044b\u0442\u044b\u0435", "2");
    private final SearchCheckBox showSub = new SearchCheckBox("\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b", "3");
    private final SearchCheckBox showClosed = new SearchCheckBox("\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0435", "4");
    private final SearchCheckBox searchAll = new SearchCheckBox("\u041f\u043e\u0438\u0441\u043a \u043f\u043e \u0432\u0441\u0435\u043c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c", "1");
    private final JLabel labelCount = new JLabel();
    private final ButtonGroup group = new ButtonGroup();
    private final ButtonGroup viewMode = new ButtonGroup();
    private final ButtonGroup typeContractButton = new ButtonGroup();
    private final ContractLabelTree contractLabelTree = new ContractLabelTree();
    private final JRadioButton inAll = new JRadioButton("\u0418");
    private final JRadioButton inSelected = new JRadioButton("\u0418\u041b\u0418");
    private JTabbedPane contractFiltersTab = new JTabbedPane();
    private JTabbedPane objectFiltersTab = new JTabbedPane();
    private ArrayList<ContractFilter_Default> contractFilters = new ArrayList();
    private ContractSearchParam lastRequestData = new ContractSearchParam();
    private final SearchData searchData = new SearchData();
    private ContractSearchService contractSearchService = null;
    private List<ContractSearchDto> findedContracts = new ArrayList<ContractSearchDto>();
    private CardLayout contractListCardLayout = new CardLayout();
    private JPanel contractListPanel = new JPanel(this.contractListCardLayout);
    private JScrollPane tableScroll = new JScrollPane();
    private final JList<JSONObject> contractList = new JList();
    private ContracTabsTableModel contracTabsTableModel = new ContracTabsTableModel();
    private ContracHistoryTableModel contracHistoryTableModel = new ContracHistoryTableModel();
    private ContracTableModel contracTableModel = new ContracTableModel("contractTableModel", this.searchData);

    public ContractOpen() {
        super(TAB_ID, "\u041f\u043e\u0438\u0441\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        try {
            this.jbInit();
            this.switchViewMode();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.pagePanel.setKey(this.getClass().getName());
        this.contractLabelTree.setCtrlDown(false);
        this.contractLabelTree.setEditable(false);
        this.contractLabelTree.onNodeSelectionListener();
        this.contractLabelTree.addPropertyChangeListener(event -> {
            if ("changeSelected".equals(event.getPropertyName())) {
                this.groups_valueChanged();
            }
        });
        this.addFilter(new ContractFilter_Text("c1"), this.contractFiltersTab, "\u0422\u0435\u043a\u0441\u0442");
        this.addFilter(new ContractFilter_Address("c8"), this.contractFiltersTab, "\u0410\u0434\u0440\u0435\u0441");
        this.addFilter(new ContractFilter_Email(), this.contractFiltersTab, "E-Mail");
        this.addFilter(new ContractFilter_Date(), this.contractFiltersTab, "\u0414\u0430\u0442\u0430");
        this.addFilter(new ContractFilter_List(), this.contractFiltersTab, "\u0421\u043f\u0438\u0441\u043a\u0438");
        this.addFilter(new ContractFilter_Phone(), this.contractFiltersTab, "\u0422\u0435\u043b\u0435\u0444\u043e\u043d");
        this.addFilter(new ContractFilter_Id("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"), this.contractFiltersTab, "ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        this.addFilter(new ContractFilter_Memo(), this.contractFiltersTab, "\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435");
        this.addFilter(new ContractFilter_MultiList(), this.contractFiltersTab, "\u041c\u0443\u043b\u044c\u0442\u0438\u0441\u043f\u0438\u0441\u043a\u0438");
        this.addFilter(new ContractFilter_Text("o1"), this.objectFiltersTab, "\u0422\u0435\u043a\u0441\u0442");
        this.addFilter(new ContractFilter_Address("o8"), this.objectFiltersTab, "\u0410\u0434\u0440\u0435\u0441");
        this.addFilter(new ObjectFilter_Date(), this.objectFiltersTab, "\u0414\u0430\u0442\u0430");
        this.addFilter(new ObjectFilter_List(), this.objectFiltersTab, "\u0421\u043f\u0438\u0441\u043a\u0438");
        this.addFilter(new ObjectFilter_Id("ID \u043e\u0431\u044a\u0435\u043a\u0442\u0430"), this.objectFiltersTab, "ID \u043e\u0431\u044a\u0435\u043a\u0442\u0430");
        this.initRadioButtons();
        LookAndFeelUtils.updateOnChangeLookAndFeel((Container)((Object)this));
        this.trySetData();
    }

    private void initRadioButtons() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.inAll);
        buttonGroup.add(this.inSelected);
        ActionListener radioButtonsListener = e -> {
            this.setup.getUserConfig().set("inAll", this.inAll.isSelected() ? "true" : "false");
            this.setup.saveUserConfig();
            this.groups_valueChanged();
        };
        this.inAll.addActionListener(radioButtonsListener);
        this.inSelected.addActionListener(radioButtonsListener);
        if (this.setup.getUserConfig().getBoolean("inAll", true)) {
            this.inAll.setSelected(true);
        } else {
            this.inSelected.setSelected(true);
        }
    }

    private void addFilter(ContractFilter_Default filter, JTabbedPane tab, String title) {
        filter.setOpenPanel(this);
        tab.add((Component)((Object)filter), title);
        this.contractFilters.add(filter);
        filter.init(this.module, this.getModuleId());
    }

    private void jbInit() throws Exception {
        CardLayout cardLayoutParam = new CardLayout();
        JPanel bottomPanel = new JPanel(cardLayoutParam);
        this.labelCount.setText("");
        this.contractTitleField.setHorizontalAlignment(0);
        this.pagePanel.init();
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                if (this.tabPane.getSelectedIndex() == 0) {
                    this.simpleFind(false);
                } else {
                    this.doFilter(null, "-1", false);
                }
            }
        });
        this.contractTitleField.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ContractOpen.this.contractTitleField.requestFocus();
            }
        });
        this.searchPopup = new SearchPopup(this.getContext(), this, true);
        JPanel contractsPanel = new JPanel(new GridBagLayout());
        contractsPanel.setRequestFocusEnabled(false);
        contractsPanel.add((Component)this.getContractPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        contractsPanel.add((Component)this.getFaceTypeFilterPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        contractsPanel.add((Component)this.getContractFilterPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel paramFindTab = new JPanel(new GridBagLayout());
        this.tabPane.setMinimumSize(new Dimension(280, 61));
        this.tabPane.setPreferredSize(new Dimension(280, 170));
        this.tabPane.setRequestFocusEnabled(false);
        this.tabPane.add((Component)contractsPanel, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        this.tabPane.add((Component)paramFindTab, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        JToggleButton contractParamButton = new JToggleButton("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        contractParamButton.setActionCommand(TAB_CONTRACT);
        contractParamButton.setSelected(true);
        JToggleButton objectParamButton = new JToggleButton("\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
        objectParamButton.setActionCommand(TAB_OBJECT);
        this.group.add(contractParamButton);
        this.group.add(objectParamButton);
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)contractParamButton, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)objectParamButton, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        paramFindTab.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        paramFindTab.add((Component)bottomPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        bottomPanel.add((Component)this.contractFiltersTab, TAB_CONTRACT);
        bottomPanel.add((Component)this.objectFiltersTab, TAB_OBJECT);
        cardLayoutParam.show(bottomPanel, TAB_CONTRACT);
        ChangeListener changeListener = e -> {
            ContractFilter_Default fil = this.getSelectFilter();
            if (this.tabPane.getSelectedComponent() == paramFindTab && (objectParamButton.isSelected() || fil instanceof ContractFilter_Phone || fil instanceof ContractFilter_Id)) {
                this.searchAll.setEnabled(false);
                return;
            }
            this.searchAll.setEnabled(true);
        };
        this.tabPane.addChangeListener(changeListener);
        this.contractFiltersTab.addChangeListener(changeListener);
        ActionListener listener = e -> this.searchAll.setEnabled(!objectParamButton.isSelected());
        objectParamButton.addActionListener(listener);
        contractParamButton.addActionListener(listener);
        ActionListener actionListener = event -> cardLayoutParam.show(bottomPanel, event.getActionCommand());
        contractParamButton.addActionListener(actionListener);
        objectParamButton.addActionListener(actionListener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ContractOpen.this.contractTitleField.requestFocusInWindow();
            }
        });
        this.contractList.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.contractList.setSelectionMode(2);
        this.contractList.setCellRenderer(new SearchRowListRendered(this.searchData));
        AWTEventListener openContractEventListener = e -> this.openContract();
        ClientUtils.addOpenAction(this.contractList, (AWTEventListener)openContractEventListener);
        BGUTable contractHistoryTable = new BGUTable((TableModel)((Object)this.contracHistoryTableModel));
        ClientUtils.addOpenAction((Component)contractHistoryTable, (AWTEventListener)openContractEventListener);
        BGUTable contractTabsTable = new BGUTable((TableModel)((Object)this.contracTabsTableModel));
        contractTabsTable.setSelectionMode(0);
        ClientUtils.addOpenAction((Component)contractTabsTable, (AWTEventListener)openContractEventListener);
        this.contractListPanel.add((Component)new JScrollPane(this.contractList), VIEW_MODE_LIST);
        this.contractListPanel.add((Component)this.tableScroll, VIEW_MODE_TABLE);
        this.contractListPanel.add((Component)new JScrollPane((Component)contractTabsTable), VIEW_MODE_TABS);
        this.contractListPanel.add((Component)new JScrollPane((Component)contractHistoryTable), VIEW_MODE_HISTORY);
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)this.getViewModePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        rightPanel.add((Component)this.contractListPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 10, 5), 0, 0));
        rightPanel.add((Component)this.getBottomPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.tabPane, (Component)rightPanel, 200L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getContractFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 "));
        panel.add((Component)this.getContractLabelFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getFaceTypeFilterPanel() {
        JToggleButton aFaceTypeButton = new JToggleButton("\u041b\u044e\u0431\u043e\u0435", true);
        aFaceTypeButton.setActionCommand("-1");
        this.typeContractButton.add(aFaceTypeButton);
        JToggleButton fFaceTypeButton = new JToggleButton("\u0424\u0438\u0437\u0438\u0447.");
        fFaceTypeButton.setActionCommand("0");
        this.typeContractButton.add(fFaceTypeButton);
        JToggleButton uFaceTypeButton = new JToggleButton("\u042e\u0440\u0438\u0434.");
        uFaceTypeButton.setActionCommand("1");
        this.typeContractButton.add(uFaceTypeButton);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041b\u0438\u0446\u043e "));
        panel.add((Component)aFaceTypeButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)fFaceTypeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)uFaceTypeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getViewModePanel() {
        ActionListener viewModeActionListener = event -> {
            String actionCommand = event.getActionCommand();
            if (!VIEW_MODE_HISTORY.equals(actionCommand) && !VIEW_MODE_TABS.equals(actionCommand)) {
                ClientSetup.getInstance().getUserConfig().set(VIEW_MODE_KEY, event.getActionCommand());
            }
            this.switchViewMode();
        };
        String contractOpenViewMode = ClientSetup.getInstance().getUserConfig().get(VIEW_MODE_KEY, VIEW_MODE_LIST);
        ViewModeButton viewListButton = new ViewModeButton(VIEW_MODE_LIST, "list.png", "\u0441\u043f\u0438\u0441\u043e\u043a", this.viewMode, viewModeActionListener, VIEW_MODE_LIST.equals(contractOpenViewMode));
        ViewModeButton viewTableButton = new ViewModeButton(VIEW_MODE_TABLE, "table.png", "\u0442\u0430\u0431\u043b\u0438\u0446\u0430", this.viewMode, viewModeActionListener, VIEW_MODE_TABLE.equals(contractOpenViewMode));
        ViewModeButton viewHistoryButton = new ViewModeButton(VIEW_MODE_HISTORY, "fugue/clock", "\u0438\u0441\u0442\u043e\u0440\u0438\u044f", this.viewMode, viewModeActionListener, VIEW_MODE_HISTORY.equals(contractOpenViewMode));
        ViewModeButton viewTabsButton = new ViewModeButton(VIEW_MODE_TABS, "opened.png", "\u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0435 \u0432\u043a\u043b\u0430\u0434\u043a\u0438", this.viewMode, viewModeActionListener, VIEW_MODE_TABS.equals(contractOpenViewMode));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)((Object)viewListButton), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)((Object)viewTableButton), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)((Object)viewHistoryButton), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)((Object)viewTabsButton), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)this.labelCount, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 20), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getContractPanel() {
        NoteLabel hintLabel = new NoteLabel("Enter - \u0438\u0441\u043a\u0430\u0442\u044c \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443", false);
        NoteLabel secondHintLabel = new NoteLabel("Ctrl+Enter - \u0438\u0441\u043a\u0430\u0442\u044c \u043f\u043e \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044e", false);
        BGButton contractMaskClearButton = new BGButton("X");
        contractMaskClearButton.setColumns(1);
        contractMaskClearButton.setMargin(new Insets(2, 2, 2, 2));
        contractMaskClearButton.addActionListener(e -> {
            this.contractTitleField.setText("");
            this.contractLabelTreeClearSelection();
            if (this.searchAll.isSelected()) {
                for (Component comObject : this.contractFiltersTab.getComponents()) {
                    if (!(comObject instanceof ContractFilter_Default)) continue;
                    ((ContractFilter_Default)((Object)((Object)comObject))).resetAction();
                }
            }
        });
        this.contractTitleField.setFont(new Font("Dialog", 1, 25));
        this.contractTitleField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (ContractOpen.this.searchPopup.isVisible() && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
                    ContractOpen.this.searchPopup.dispatchEvent(keyEvent);
                } else if (keyEvent.getKeyCode() == 10) {
                    if (ContractOpen.this.searchPopup.isVisible() && ContractOpen.this.searchPopup.getSelectionModel().getSelectedIndex() >= 0) {
                        ContractOpen.this.searchPopup.getSearchImplementationByIndex(ContractOpen.this.searchPopup.getSelectionModel().getSelectedIndex()).ifPresent(selectedImpl -> {
                            ContractOpen.this.searchPopup.setVisible(false);
                            ContractOpen.this.customSearchImpl((SearchImplementation)((Object)selectedImpl));
                        });
                    } else {
                        ContractOpen.this.titleComment.setValue(keyEvent.isControlDown());
                        ContractOpen.this.simpleFind(true);
                    }
                    ContractOpen.this.searchPopup.setVisible(false);
                }
            }
        });
        if (BGClientInit.isMacOs()) {
            AbstractAction commandAndEnter = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContractOpen.this.titleComment.setValue(true);
                    ContractOpen.this.simpleFind(true);
                }
            };
            int modif = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
            this.contractTitleField.getInputMap().put(KeyStroke.getKeyStroke(10, modif), "commandAndEnter");
            this.contractTitleField.getActionMap().put("commandAndEnter", commandAndEnter);
            secondHintLabel.setText("\u2318 + Enter - \u0438\u0441\u043a\u0430\u0442\u044c \u043f\u043e \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044e");
        }
        hintLabel.setVisible(true);
        secondHintLabel.setVisible(true);
        JPanel panel = new JPanel(new GridBagLayout());
        this.contractTitleField.getDocument().addDocumentListener(SearchPopup.getDocumentListenerBySearchField(panel, this.contractTitleField, this.searchPopup));
        panel.setBorder((Border)new BGTitleBorder(" \u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430(\u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439) "));
        panel.add((Component)this.contractTitleField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 3, 0), 0, 0));
        panel.add((Component)contractMaskClearButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 3, 5), 0, 0));
        panel.add((Component)hintLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 1, 5), 0, 0));
        panel.add((Component)secondHintLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 3, 5), 0, 0));
        return panel;
    }

    private JPanel getBottomPanel() {
        this.searchAll.setToolTipText("\u041f\u043e\u0438\u0441\u043a \u043f\u043e \u0432\u0441\u0435\u043c \u0432\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u043c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c");
        ActionListener al = e -> {
            String configurationString = this.setup.getUserConfig().get("searchFilters", this.setup.get("dbinfo.contract.searchDefaultFilters")).replace(e.getActionCommand(), "") + (((JCheckBox)e.getSource()).isSelected() ? e.getActionCommand() : "");
            this.setup.getUserConfig().set("searchFilters", configurationString);
            this.setup.saveUserConfig();
        };
        String configurationString = this.setup.getUserConfig().get("searchFilters", this.setup.get("dbinfo.contract.searchDefaultFilters"));
        if (configurationString != null) {
            Arrays.asList(this.searchAll, this.showHidden, this.showSub, this.showClosed).forEach(e -> {
                e.addActionListener(al);
                e.setSelected(configurationString.contains(e.getActionCommand()));
            });
        }
        BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.GLUE, BGButtonPanel.OK});
        buttonPanel.addActionListener(e -> {
            ((JComponent)e.getSource()).requestFocus();
            String actionCommand = e.getActionCommand();
            if (BGButtonPanel.OK.getActionCommand().equals(actionCommand)) {
                this.openContract();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.searchAll, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.showHidden, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.showSub, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.showClosed, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 10), 0, 0));
        return panel;
    }

    public void setData() throws Exception {
        this.contractTitleField.setText("");
        Request request = new Request();
        request.setModule(TAB_CONTRACT);
        request.setAction("OpenContract");
        this.setDocument(TransferManager.getDocument((Request)request));
        this.loadContractHistoryRecordData();
    }

    public void setDocument(Document doc) throws Exception {
        if (ClientUtils.checkStatus((Document)doc)) {
            for (ContractFilter_Default filter : this.contractFilters) {
                filter.setParametersList(doc.getDocumentElement());
                filter.setDocument(doc);
            }
            this.pagePanel.init();
        }
        try {
            ((ContractLabelService)this.getContext().getPort(ContractLabelService.class)).syncLabelAndGroupDirectory();
            this.contractLabelTree.setData(((ContractLabelService)this.getContext().getPort(ContractLabelService.class)).getContractLabelTreeItemListForUser(this.getSetup().getUserId()));
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void setViewMode() {
        String viewModeValue = this.viewMode.getSelection().getActionCommand();
        if (VIEW_MODE_HISTORY.equals(viewModeValue) || VIEW_MODE_TABS.equals(viewModeValue)) {
            String contractOpenViewMode = ClientSetup.getInstance().getUserConfig().get(VIEW_MODE_KEY, VIEW_MODE_LIST);
            Enumeration<AbstractButton> enumeration = this.viewMode.getElements();
            while (enumeration.hasMoreElements()) {
                AbstractButton abstractButton = enumeration.nextElement();
                if (!contractOpenViewMode.equals(abstractButton.getActionCommand())) continue;
                this.viewMode.setSelected(abstractButton.getModel(), true);
                break;
            }
        }
    }

    private ContractSearchService getContractSearchService() {
        if (this.contractSearchService == null) {
            this.contractSearchService = (ContractSearchService)this.getContext().getPort(ContractSearchService.class, 0);
        }
        return this.contractSearchService;
    }

    @Override
    public void customSearchImpl(SearchImplementation searchImplementation) {
        try {
            int typeContract = Utils.parseInt((String)this.typeContractButton.getSelection().getActionCommand(), (int)-1);
            boolean showSubContracts = this.showSub.isSelected();
            boolean showClosed = !this.showClosed.isSelected();
            boolean showHidden = this.showHidden.isSelected();
            Holder pageHolder = new Holder((Object)this.pagePanel.getPage());
            this.searchData.isOldMode = false;
            List<JSONObject> searchResult = this.getContractSearchService().search(searchImplementation, this.contractTitleField.getText(), typeContract, showSubContracts, showClosed, showHidden, (Holder<Page>)pageHolder);
            if (Utils.notEmptyCollection(searchResult)) {
                JSONObject metadata = this.getContractSearchService().getTitles(searchImplementation);
                if (metadata != null) {
                    if (metadata.has("titles")) {
                        this.searchData.titlesOfNewMode = metadata.getJSONArray("titles");
                    }
                    this.searchData.listLayout = metadata.has("listLayout") ? metadata.getJSONObject("listLayout") : null;
                }
                this.searchData.dataForUI = new ArrayList<JSONObject>(searchResult);
            } else if (Utils.notEmptyCollection(this.searchData.dataForUI)) {
                this.searchData.dataForUI.clear();
            }
            if (((Page)pageHolder.value).getRecordCount() <= 0 && searchResult.size() > 0) {
                ((Page)pageHolder.value).setRecordCount(searchResult.size());
            }
            this.updatePage((Page)pageHolder.value);
            this.switchViewMode();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void groups_valueChanged() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.contractLabelTree.getModel();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
        this.selectedLabels.clear();
        this.getSelectedLabels(rootNode);
        this.titleComment.setValue(false);
        this.simpleFind(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simpleFind(boolean new_find) {
        if (new_find) {
            this.setViewMode();
            this.pagePanel.init();
        }
        if (this.searchAll.isSelected()) {
            this.doFilter(null, "-10", false);
            return;
        }
        int fc = Utils.parseInt((String)this.typeContractButton.getSelection().getActionCommand(), (int)-1);
        ArrayList<FilterEntityAttr> entityFilter = new ArrayList<FilterEntityAttr>();
        boolean subContracts = this.showSub.isSelected();
        boolean closed = !this.showClosed.isSelected();
        boolean hidden = this.showHidden.isSelected();
        Page page = this.pagePanel.getPage();
        try {
            this.lastRequestData = null;
            this.searchData.isOldMode = true;
            this.searchData.listLayout = null;
            ContractSearchParam contractSearchParam = new ContractSearchParam().setContractId(0).setContractTitle(this.titleComment.title).setContractComment(this.titleComment.comment).setFaceType(fc).setContractLabelsIds(this.selectedLabels).setEntityFilter(entityFilter).setShowSubContracts(subContracts).setShowClosed(closed).setShowHidden(hidden).setPage(page);
            SearchResult<ContractSearchDto> searchResult = this.getContractList(contractSearchParam);
            this.findedContracts = searchResult.getList();
            this.searchData.setContractList(this.findedContracts);
            this.updatePage(searchResult.getPage());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        finally {
            this.switchViewMode();
        }
    }

    private void updatePage(Page page) {
        this.labelCount.setText("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432/\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: 0");
        if (page != null) {
            if (page.getPageIndex() > 0) {
                this.pagePanel.setPageIndex(page.getPageIndex());
            }
            if (page.getPageCount() > 0) {
                this.pagePanel.setPageCount(page.getPageCount());
            }
        }
        this.labelCount.setText("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432/\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + page.getRecordCount());
    }

    private void switchViewMode() {
        String viewModeValue;
        switch (viewModeValue = this.viewMode.getSelection().getActionCommand()) {
            case "table": {
                this.contracTableModel = new ContracTableModel("contracTableModel", this.searchData);
                ContractTable contractTable = new ContractTable((TableModel)((Object)this.contracTableModel));
                ClientUtils.addOpenAction((Component)((Object)contractTable), e -> this.openContract());
                this.tableScroll.setViewportView((Component)((Object)contractTable));
                if (!Utils.notEmptyCollection(this.searchData.dataForUI)) break;
                this.contracTableModel.setData(new ArrayList<JSONObject>(this.searchData.dataForUI));
                break;
            }
            case "list": {
                this.contractList.setModel(this.getListModelOfResult(this.searchData));
                break;
            }
            case "history": {
                this.loadContractHistoryRecordData();
                break;
            }
            case "tabs": {
                this.loadContractTabsRecordData();
            }
        }
        this.contractListCardLayout.show(this.contractListPanel, viewModeValue);
    }

    private DefaultListModel<JSONObject> getListModelOfResult(SearchData searchData) {
        DefaultListModel<JSONObject> listModel;
        block3: {
            block2: {
                listModel = new DefaultListModel<JSONObject>();
                if (!searchData.isOldMode || !Utils.notEmptyCollection(searchData.contractList)) break block2;
                for (int i = 0; i < searchData.dataForUI.size(); ++i) {
                    listModel.add(i, searchData.dataForUI.get(i));
                }
                break block3;
            }
            if (!Utils.notEmptyCollection(searchData.dataForUI)) break block3;
            for (int i = 0; i < searchData.dataForUI.size(); ++i) {
                listModel.add(i, searchData.dataForUI.get(i));
            }
        }
        return listModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(int id) {
        this.labelCount.setText("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432/\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: 0");
        this.pagePanel.setPageCount(1);
        this.pagePanel.setPageIndex(1);
        this.searchData.isOldMode = true;
        this.contractList.setModel(this.getListModelOfResult(this.searchData));
        this.lastRequestData = null;
        try {
            ContractSearchParam contractSearchParam = new ContractSearchParam().setContractId(id).setFaceType(Utils.parseInt((String)this.typeContractButton.getSelection().getActionCommand(), (int)-1)).setContractLabelsIds(this.selectedLabels).setEntityFilter(new ArrayList<FilterEntityAttr>()).setShowSubContracts(this.showSub.isSelected()).setShowClosed(!this.showClosed.isSelected()).setShowHidden(this.showHidden.isSelected()).setPage(this.pagePanel.getPage());
            SearchResult<ContractSearchDto> searchResult = this.getContractList(contractSearchParam);
            this.findedContracts = searchResult.getList();
            this.searchData.setContractList(this.findedContracts);
            Page page = searchResult.getPage();
            if (page != null) {
                this.pagePanel.setPage(page);
                this.labelCount.setText("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432/\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + page.getRecordCount());
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        finally {
            this.switchViewMode();
        }
    }

    public void doFilter(String searchString) {
        this.labelCount.setText("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432/\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 [ \u043d\u0430\u0439\u0434\u0435\u043d\u043e: 0 ]");
        this.pagePanel.setPageCount(1);
        this.pagePanel.setPageIndex(1);
        this.searchData.isOldMode = true;
        this.contractList.setModel(this.getListModelOfResult(this.searchData));
        if (!searchString.isEmpty()) {
            Request request = new Request();
            request.setModule(TAB_CONTRACT);
            request.setAction("FindContractByMemo");
            request.setAttribute("searchString", searchString);
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.tryCall(() -> {
                    Element contracts = XMLUtils.selectElement((Node)doc, (String)"//contracts");
                    this.buildContractList(contracts);
                    this.labelCount.setText("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432/\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 [ \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + contracts.getAttribute("allRecord") + " ]");
                    this.pagePanel.setPageInfo(contracts);
                });
            }
        }
    }

    private void buildContractList(Element contracts) {
        this.findedContracts = new ArrayList<ContractSearchDto>();
        this.searchData.setContractList(this.findedContracts);
        if (contracts != null && contracts.hasChildNodes()) {
            for (Element contractElement : XMLUtils.elements((NodeList)contracts.getChildNodes())) {
                this.findedContracts.add(new ContractSearchDto().setContractId(Utils.parseInt((String)contractElement.getAttribute("id"), (int)0)).setContractTitle(contractElement.getAttribute("title")).setContractComment(contractElement.getAttribute("comment")));
            }
            this.searchData.setContractList(this.findedContracts);
        }
        this.setViewMode();
        this.switchViewMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(Map<String, Object> params, String type, boolean new_find) {
        boolean isSearchAll;
        if (new_find) {
            this.pagePanel.init();
        }
        this.searchData.isOldMode = true;
        this.searchData.listLayout = null;
        this.labelCount.setText("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432/\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: 0");
        this.contractList.setModel(this.getListModelOfResult(this.searchData));
        boolean bl = isSearchAll = this.searchAll.isEnabled() && this.searchAll.isSelected();
        if (type != null && params != null || type.equals("-10")) {
            if (!type.equals("-10") && !TAB_CONTRACT.equals(this.group.getSelection().getActionCommand())) {
                Request request = new Request();
                request.setModule(TAB_CONTRACT);
                request.setAction("FindContract");
                request.setPageIndex(this.pagePanel.getPageIndex());
                request.setPageSize(this.pagePanel.getPageSize());
                request.setAttribute("del", this.showHidden.isSelected() ? "1" : "0");
                request.setAttribute("show_sub", this.showSub.isSelected() ? "1" : "0");
                request.setAttribute("show_closed", this.showClosed.isSelected() ? "1" : "0");
                request.setAttribute("type", type);
                for (String key : params.keySet()) {
                    request.setAttribute(key, params.get(key));
                }
                Document doc = TransferManager.getDocument((Request)request);
                if (!ClientUtils.checkStatus((Document)doc)) return;
                this.tryCall(() -> {
                    Element contracts = XMLUtils.selectElement((Node)doc, (String)"//contracts");
                    this.buildContractList(contracts);
                    this.labelCount.setText("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432/\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + contracts.getAttribute("allRecord"));
                    this.pagePanel.setPageInfo(contracts);
                });
                return;
            }
            int fc = Utils.parseInt((String)this.typeContractButton.getSelection().getActionCommand(), (int)-1);
            ArrayList<FilterEntityAttr> entityFilter = new ArrayList<FilterEntityAttr>();
            if (isSearchAll) {
                for (ContractFilter_Default contract_filter : this.contractFilters) {
                    FilterEntityAttr filter;
                    if (((Object)((Object)contract_filter)).getClass().getSimpleName().contains("ObjectFilter") || (filter = contract_filter.getFilter()) == null) continue;
                    entityFilter.add(filter);
                }
            } else {
                FilterEntityAttr filter = this.getSelectFilter().getFilter();
                if (filter != null) {
                    entityFilter.add(filter);
                }
            }
            if (!type.equals("-10")) {
                this.titleComment.title = null;
                this.titleComment.comment = null;
                if (entityFilter.size() == 0) {
                    this.labelCount.setText("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432/\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: 0");
                    this.pagePanel.setPageIndex(1);
                    this.pagePanel.setPageCount(1);
                    this.findedContracts = new ArrayList<ContractSearchDto>();
                    this.searchData.setContractList(this.findedContracts);
                    this.switchViewMode();
                    return;
                }
            }
            try {
                Page page = this.pagePanel.getPage();
                ContractSearchParam contractSearchParam = new ContractSearchParam().setContractId(0).setContractTitle(this.titleComment.title).setContractComment(this.titleComment.comment).setFaceType(fc).setContractLabelsIds(this.selectedLabels).setEntityFilter(entityFilter).setShowSubContracts(this.showSub.isSelected()).setShowClosed(!this.showClosed.isSelected()).setShowHidden(this.showHidden.isSelected()).setPage(page);
                SearchResult<ContractSearchDto> searchResult = this.getContractList(contractSearchParam);
                this.findedContracts = searchResult.getList();
                this.searchData.setContractList(this.findedContracts);
                page = searchResult.getPage();
                if (page == null) return;
                this.pagePanel.setPage(page);
                this.labelCount.setText("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432/\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + page.getRecordCount());
                return;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return;
            }
            finally {
                this.switchViewMode();
            }
        } else {
            ContractFilter_Default filter = this.getSelectFilter();
            if (filter == null) return;
            filter.doFilter(false);
        }
    }

    private void loadContractHistoryRecordData() {
        try {
            this.contracHistoryTableModel.setData(((ContractService)this.getContext().getPort(ContractService.class)).searchContractHistoryRecord(new Page(1, 50)).getList());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void loadContractTabsRecordData() {
        this.contracTabsTableModel.deleteRows();
        this.contracTabsTableModel.setData(BGClientBase.getFrame().getTabbedPane().getContracts());
    }

    private ContractFilter_Default getSelectFilter() {
        Component component = null;
        component = TAB_CONTRACT.equals(this.group.getSelection().getActionCommand()) ? this.contractFiltersTab.getSelectedComponent() : this.objectFiltersTab.getSelectedComponent();
        if (component instanceof ContractFilter_Default) {
            ContractFilter_Default filter = (ContractFilter_Default)((Object)component);
            return filter;
        }
        return null;
    }

    public SearchData getSearchData() {
        if (this.lastRequestData != null) {
            try {
                this.lastRequestData.getPage().setPageSize(0);
                this.lastRequestData.getPage().setPageIndex(1);
                SearchResult<ContractSearchDto> searchResult = ((ContractService)this.getContext().getPort(ContractService.class)).searchContractList(this.lastRequestData);
                this.searchData.setContractList(searchResult.getList());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        return this.searchData;
    }

    private SearchResult<ContractSearchDto> getContractList(ContractSearchParam contractSearchParam) throws Exception {
        contractSearchParam.setInAllLabels(this.inAll.isSelected());
        this.lastRequestData = contractSearchParam;
        return ((ContractService)this.getContext().getPort(ContractService.class)).searchContractList(contractSearchParam);
    }

    private void openContract() {
        String viewMode;
        switch (viewMode = this.viewMode.getSelection().getActionCommand()) {
            case "list": {
                List<JSONObject> contracts = this.contractList.getSelectedValuesList();
                if (Utils.isEmptyCollection(contracts)) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
                    return;
                }
                for (JSONObject listItem : contracts) {
                    int contractId = listItem.optInt("cid", -1);
                    if (contractId <= 0) continue;
                    this.addContractEditorTab(contractId);
                }
                break;
            }
            case "table": {
                List contracts = this.contracTableModel.getSelectedRows();
                if (Utils.isEmptyCollection((Collection)contracts)) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
                    return;
                }
                for (JSONObject contract : contracts) {
                    this.addContractEditorTab(contract.getInt("cid"));
                }
                break;
            }
            case "history": {
                List contracts = this.contracHistoryTableModel.getSelectedRows();
                if (Utils.isEmptyCollection((Collection)contracts)) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
                    return;
                }
                for (ContractHistoryRecord contract : contracts) {
                    this.addContractEditorTab(contract.getContractId());
                }
                break;
            }
            case "tabs": {
                ContractIdTitleComment contract = (ContractIdTitleComment)((Object)this.contracTabsTableModel.getSelectedRow());
                if (contract == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
                    return;
                }
                this.addContractEditorTab(contract.getId());
            }
        }
    }

    private void addContractEditorTab(int contractId) {
        BGClientBase.getFrame().getTabbedPane().addContractEditorTab(contractId);
    }

    private void getSelectedLabels(DefaultMutableTreeNode node) {
        ContractLabelItem contractLabelItem = (ContractLabelItem)node.getUserObject();
        ContractLabelType labelType = contractLabelItem.getContractLabelType();
        if ((labelType == ContractLabelType.GROUP_ITEM || labelType == ContractLabelType.LABEL || labelType == ContractLabelType.LABEL_ITEM) && contractLabelItem.isSelected()) {
            this.selectedLabels.add(contractLabelItem.getId());
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            this.getSelectedLabels((DefaultMutableTreeNode)enumeration.nextElement());
        }
    }

    private void contractLabelTreeClearSelection() {
        this.contractLabelTreeClearSelection((DefaultMutableTreeNode)this.contractLabelTree.getModel().getRoot());
        this.selectedLabels.clear();
        this.contractLabelTree.invalidate();
        this.contractLabelTree.repaint();
    }

    private void contractLabelTreeClearSelection(DefaultMutableTreeNode treeNode) {
        ContractLabelItem contractLabelItem = (ContractLabelItem)treeNode.getUserObject();
        contractLabelItem.setSelected(false);
        Enumeration<TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            this.contractLabelTreeClearSelection((DefaultMutableTreeNode)enumeration.nextElement());
        }
    }

    private JPanel getContractLabelFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.contractLabelTree), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.inAll, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.inSelected, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private static Color getColorOfSearchRow(JSONObject searchItem) {
        Color result = null;
        String colorStr = searchItem.optString("color");
        if (Utils.notBlankString((String)colorStr)) {
            result = switch (colorStr) {
                case "blue" -> Color.BLUE;
                case "red" -> Color.RED;
                case "green" -> Color.GREEN;
                default -> Color.BLACK;
            };
        }
        return result == null ? Color.BLACK : result;
    }

    class TitleComment {
        String title = null;
        String comment = null;

        TitleComment() {
        }

        void setValue(boolean ctrlEnter) {
            String text = ContractOpen.this.contractTitleField.getText().trim().length() > 0 ? ContractOpen.this.contractTitleField.getText().trim() : null;
            this.title = ctrlEnter ? null : text;
            this.comment = ctrlEnter ? text : null;
        }
    }

    class SearchCheckBox
    extends JCheckBox {
        public SearchCheckBox(String text, String actionCommand) {
            super(text);
            this.setActionCommand(actionCommand);
        }
    }

    public static class SearchData {
        public static final String CONTRACT_ID_KEY = "cid";
        public static final String CONTRACT_TITLE_KEY = "contractTitle";
        public static final String CONTRACT_COMMENT_KEY = "comment";
        private boolean isOldMode = true;
        private List<ContractSearchDto> contractList;
        private List<JSONObject> dataForUI;
        static JSONArray titlesOfOldMode = new JSONArray().put((Object)new JSONObject().put("cid", (Object)"ID")).put((Object)new JSONObject().put("contractTitle", (Object)"\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")).put((Object)new JSONObject().put("comment", (Object)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"));
        private JSONArray titlesOfNewMode;
        private JSONObject listLayout;

        void setContractList(List<ContractSearchDto> contracts) {
            this.contractList = contracts;
            this.dataForUI = new ArrayList<JSONObject>();
            contracts.forEach(c -> this.dataForUI.add(this.transformContractToJSON((ContractSearchDto)c)));
        }

        JSONObject transformContractToJSON(ContractSearchDto contract) {
            JSONObject jsonContract = new JSONObject().put(CONTRACT_ID_KEY, contract.getContractId()).put(CONTRACT_TITLE_KEY, (Object)contract.getContractTitle()).put(CONTRACT_COMMENT_KEY, (Object)contract.getContractComment());
            return jsonContract;
        }

        public JSONArray getTitlesOfNewMode() {
            return this.titlesOfNewMode == null ? new JSONArray() : this.titlesOfNewMode;
        }

        public JSONObject getListLayout() {
            return this.listLayout == null ? new JSONObject() : this.listLayout;
        }

        public List<JSONObject> getDataForUI() {
            return this.dataForUI;
        }
    }

    static class ContracTableModel
    extends BGTableModel<JSONObject> {
        private SearchData searchData;

        public ContracTableModel(String name, SearchData searchData) {
            super(name);
            this.searchData = searchData;
            this.initColumns();
        }

        protected void initColumns() {
            if (this.searchData != null && Utils.notEmptyCollection(this.searchData.dataForUI)) {
                if (this.searchData.isOldMode) {
                    this.addColumn("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 100, 300, 500, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                    this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                    this.addColumnId();
                } else {
                    JSONObject row = this.searchData.dataForUI.get(0);
                    JSONArray titles = this.searchData.getTitlesOfNewMode();
                    ArrayList<String> keys = new ArrayList<String>(row.keySet().size());
                    if (titles.length() > 0) {
                        for (int x = 0; x < titles.length(); ++x) {
                            JSONObject title = titles.getJSONObject(x);
                            for (String key2 : row.keySet()) {
                                if (!title.has(key2)) continue;
                                keys.add(key2);
                            }
                        }
                        if (row.keySet().size() != titles.length()) {
                            for (String key3 : row.keySet()) {
                                if (keys.contains(key3)) continue;
                                keys.add(key3);
                            }
                        }
                    } else {
                        keys.addAll(row.keySet());
                    }
                    keys.forEach(key -> {
                        if (key.equals("color")) {
                            return;
                        }
                        int width = -1;
                        String title = null;
                        for (Object o : titles) {
                            JSONObject titleJson = (JSONObject)o;
                            if (!titleJson.has(key)) continue;
                            title = titleJson.optString(key);
                            if (!titleJson.has("width")) break;
                            width = titleJson.optInt("width", -1);
                            break;
                        }
                        if (Utils.isBlankString(title)) {
                            title = key;
                        }
                        if (width < 0) {
                            width = switch (key) {
                                case "cid" -> 100;
                                case "contractTitle" -> 300;
                                default -> -1;
                            };
                        }
                        this.addColumn(title, width, width, width, (String)key, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                    });
                }
            }
        }

        public Object getValue(JSONObject val, int column) throws Exception {
            if (this.searchData != null && this.searchData.isOldMode) {
                switch (column) {
                    case 0: {
                        return val.get("contractTitle");
                    }
                    case 1: {
                        return val.get("comment");
                    }
                    case 2: {
                        return val.get("cid");
                    }
                }
            } else if (this.searchData != null) {
                String columnName = this.getColumnName(column);
                JSONArray titles = this.searchData.getTitlesOfNewMode();
                if (titles.length() > 0) {
                    for (int x = 0; x < titles.length(); ++x) {
                        JSONObject titleJson = titles.optJSONObject(x);
                        if (titleJson == null) continue;
                        for (String s : titleJson.keySet()) {
                            if (!titleJson.optString(s).equals(columnName)) continue;
                            for (String key : titleJson.keySet()) {
                                if (!val.has(key)) continue;
                                return String.valueOf(val.get(key));
                            }
                        }
                    }
                } else {
                    for (String key : val.keySet()) {
                        if (!key.equals(this.getColumnName(column)) || !val.has(key)) continue;
                        return String.valueOf(val.optString(key));
                    }
                }
                int keySetSize = val.keySet().size();
                if (val.has("color")) {
                    --keySetSize;
                }
                if (titles.length() > 0 && titles.length() != keySetSize && val.has(columnName)) {
                    return String.valueOf(val.get(columnName));
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    public static class SearchRowListRendered
    implements ListCellRenderer<JSONObject> {
        private SearchData searchData;

        public SearchRowListRendered(SearchData searchData) {
            this.searchData = searchData;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JSONObject> list, JSONObject searchValue, int index, boolean isSelected, boolean cellHasFocus) {
            JSONArray titles = this.searchData.isOldMode ? SearchData.titlesOfOldMode : this.searchData.titlesOfNewMode;
            ArrayList<String> keys = new ArrayList<String>(searchValue.keySet().size());
            if (!this.searchData.isOldMode && titles.length() > 0) {
                for (int x = 0; x < titles.length(); ++x) {
                    JSONObject title = titles.getJSONObject(x);
                    for (String key : searchValue.keySet()) {
                        if (!title.has(key) || x >= keys.size()) continue;
                        keys.add(x, key);
                    }
                }
                if (searchValue.keySet().size() != titles.length()) {
                    for (String key : searchValue.keySet()) {
                        if (keys.contains(key)) continue;
                        keys.add(key);
                    }
                }
            } else {
                keys.addAll(searchValue.keySet());
            }
            JPanel resultCell = new JPanel(new GridBagLayout());
            JSONArray listLayout = this.searchData.getListLayout().optJSONArray("grid");
            if (listLayout == null) {
                String defaultListLayout = "[{text:\"${contractTitle}\",width:200,font:{name:\"Monospaced\",size:16,style:1},anchor:10,hAlign:0,insets:{l:5,b:2,r:5,t:2}},{text:\"${comment}\",fill:2,weightx:1.0,fColor:6316128,font:{size:14,style:2},insets:{l:20,b:0,r:20,t:0}},{text:\"ID# ${cid}\",fColor:10526880,width:100,anchor:17}]";
                listLayout = new JSONArray(ClientSetup.getInstance().get("dbinfo.contract.search.list.layout", "[{text:\"${contractTitle}\",width:200,font:{name:\"Monospaced\",size:16,style:1},anchor:10,hAlign:0,insets:{l:5,b:2,r:5,t:2}},{text:\"${comment}\",fill:2,weightx:1.0,fColor:6316128,font:{size:14,style:2},insets:{l:20,b:0,r:20,t:0}},{text:\"ID# ${cid}\",fColor:10526880,width:100,anchor:17}]"));
            }
            listLayout.forEach(i -> {
                if (i instanceof JSONObject) {
                    JSONObject insets;
                    JSONObject font;
                    JSONObject json = (JSONObject)i;
                    String text = json.optString("text");
                    if (text.isEmpty()) {
                        return;
                    }
                    Object labelText = text;
                    Matcher matcher = Pattern.compile("\\$\\{([^\\}]+)\\}").matcher(text);
                    while (matcher.find()) {
                        String str = "${" + matcher.group(1) + "}";
                        int pos = ((String)labelText).indexOf(str);
                        String value = searchValue.optString(matcher.group(1));
                        if ("${cid}".equals(str)) {
                            value = Utils.formatInteger((int)Utils.parseInt((String)value));
                        }
                        labelText = ((String)labelText).substring(0, pos) + value + ((String)labelText).substring(pos + str.length());
                    }
                    JLabel label = new JLabel((String)labelText);
                    if (json.has("font") && (font = json.optJSONObject("font")) != null) {
                        label.setFont(new Font(font.optString("name", "Dialog"), font.optInt("style", 0), font.optInt("size", 12)));
                    }
                    if (json.has("fColor")) {
                        label.setForeground(new Color(json.optInt("fColor", 0)));
                    }
                    if (json.has("width")) {
                        Dimension dimension = label.getPreferredSize();
                        dimension.width = json.optInt("width");
                        label.setMinimumSize(dimension);
                        label.setPreferredSize(dimension);
                    }
                    if (json.has("hAlign")) {
                        label.setHorizontalAlignment(json.optInt("hAlign", 0));
                    }
                    GridBagConstraints constraints = new GridBagConstraints();
                    constraints.gridx = json.optInt("gridx", -1);
                    constraints.gridy = json.optInt("gridy", -1);
                    constraints.gridwidth = json.optInt("gridwidth", 1);
                    constraints.gridheight = json.optInt("gridheight", 1);
                    constraints.weightx = json.optDouble("weightx", 0.0);
                    constraints.weighty = json.optDouble("weighty", 0.0);
                    constraints.anchor = json.optInt("anchor", 17);
                    constraints.fill = json.optInt("fill", 0);
                    if (json.has("insets") && (insets = json.optJSONObject("insets")) != null) {
                        constraints.insets = new Insets(insets.optInt("t", 0), insets.optInt("l", 0), insets.optInt("b", 0), insets.optInt("r", 0));
                    }
                    resultCell.add((Component)label, constraints);
                }
            });
            if (cellHasFocus) {
                resultCell.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Table.focusCellHighlightBorder")));
            }
            if (cellHasFocus || isSelected) {
                Color selectedRowColor = UIManager.getColor("Table.selectionBackground");
                resultCell.setBackground(selectedRowColor != null ? selectedRowColor : Color.PINK);
            } else {
                resultCell.setBackground(UIManager.getColor("List.background"));
            }
            return resultCell;
        }
    }

    static class ViewModeButton
    extends BGToggleButton {
        public ViewModeButton(String actionCommand, String iconName, String toolTipText, ButtonGroup buttonGroup, ActionListener actionListener, boolean selected) {
            super("", (Icon)ClientUtils.getIcon((String)iconName), selected);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.setActionCommand(actionCommand);
            this.setToolTipText(toolTipText);
            this.addActionListener(actionListener);
            buttonGroup.add((AbstractButton)((Object)this));
        }
    }

    static class NoteLabel
    extends JLabel {
        public NoteLabel(String text, boolean visible) {
            super(text);
            this.setFont(new Font("SansSerif", 2, 11));
            this.setForeground(Color.DARK_GRAY);
            this.setVisible(visible);
        }
    }

    static class ContractTable
    extends BGUTable {
        public ContractTable(TableModel model) {
            super(model);
            this.setSelectionMode(2);
        }

        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component component = super.prepareRenderer(renderer, row, column);
            TableModel tableModel = this.getModel();
            if (tableModel != null) {
                JSONObject tableRow = (JSONObject)((BGTableModel)this.getModel()).getRows().get(row);
                component.setForeground(ContractOpen.getColorOfSearchRow(tableRow));
            }
            return component;
        }
    }
}

