/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import bitel.billing.server.contract.ContractRemover;
import bitel.billing.server.contract.bean.CommentPatternManager;
import jakarta.xml.ws.Holder;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCreateData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class LoaderImportContractUtil
extends LoaderBase {
    private char fieldSeparator = (char)44;
    private int contractPatternId = -1;
    private String contractTitleField = null;
    private String contractDateField = null;
    private String contractPasswordField = null;
    private String contractPatternDateField = null;

    @Override
    public String execute(String data, String config) throws Exception {
        JSONObject contractPatternJsonObject;
        data = data.replace("_x000D_\n", "\\n");
        JSONObject configJsonObject = new JSONObject(config);
        JSONObject contractClearJsonObject = configJsonObject.optJSONObject("contractClear");
        if (contractClearJsonObject != null && contractClearJsonObject.optBoolean("value", false)) {
            this.doClean();
        }
        if ((contractPatternJsonObject = configJsonObject.optJSONObject("contractPattern")) != null) {
            this.contractPatternId = contractPatternJsonObject.optInt("contractPatternId");
            if (this.contractPatternId < 1 && contractPatternJsonObject.optBoolean("fieldContractPatternId")) {
                this.contractPatternId = -1;
            }
        }
        this.fieldSeparator = configJsonObject.optString("fieldSeparator", ",").charAt(0);
        this.contractTitleField = (String)configJsonObject.optQuery("/contractTitle/field");
        this.contractDateField = (String)configJsonObject.optQuery("/contractDate/field");
        this.contractPasswordField = (String)configJsonObject.optQuery("/contractPassword/field");
        this.contractPatternDateField = (String)configJsonObject.optQuery("/contractDate/fieldPattern");
        JSONArray contractParamsJsonArray = configJsonObject.optJSONArray("contractParams");
        this.createContractParameters(contractParamsJsonArray);
        configJsonObject.put("contractParams", (Object)contractParamsJsonArray);
        int importCounter = 0;
        if (Utils.notBlankString((String)data)) {
            boolean header = true;
            ArrayList<String> headers = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (String line : data.split("\n")) {
                if (header) {
                    this.parse(line.toCharArray(), headers);
                    header = false;
                    continue;
                }
                values.clear();
                this.parse(line.toCharArray(), values);
                if (headers.size() == values.size()) {
                    HashMap<String, String> valuesMap = new HashMap<String, String>();
                    for (int index = 0; index < headers.size(); ++index) {
                        valuesMap.put((String)headers.get(index), (String)values.get(index));
                    }
                    this.doImport(valuesMap, configJsonObject, this.con, this.setup);
                    ++importCounter;
                    continue;
                }
                throw new BGException("\u041d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0442\u043e\u043b\u0431\u0446\u043e\u0432 \u0432 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0435 \u0438 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438\n[" + line + "]");
            }
        }
        return "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e  \u0437\u0430\u043f\u0438\u0441\u0435\u0439 -> " + importCounter;
    }

    private void doClean() {
        try (ContractRemover contractRemover = new ContractRemover(this.con, "/");){
            Set contractLabelIds = Utils.toIntegerSet((String)Setup.getSetup().get("loader.import.contract.clean.label.ids", "-1"));
            for (Contract contract : this.getContractService().contractList0(0, null, null, -1, contractLabelIds, null, false, false, false, (Holder<Page>)new Holder((Object)new Page(1, -1)), false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 #" + contract.getId() + " [" + contract.getTitle() + "]");
                }
                ArrayList<Integer> contractIds = new ArrayList<Integer>();
                contractIds.add(contract.getId());
                String error = contractRemover.removeContracts(contractIds, false);
                if (error == null || error.length() <= 0) continue;
                this.getLogger().error(error);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void doImport(Map<String, String> values, JSONObject configJsonObject, Connection con, Setup setup) {
        try (ContractParameterGroupAttrDao contractParameterGroupAttrDao = new ContractParameterGroupAttrDao(con);
             ContractDao contractDao = new ContractDao(con, 0);){
            String title = this.contractTitleField != null ? values.get(this.contractTitleField) : null;
            String pattern = this.contractPatternDateField != null ? this.contractPatternDateField : "dd.MM.yyyy";
            GregorianCalendar date = this.contractDateField != null ? TimeUtils.parseCalendar((String)values.get(this.contractDateField), (String)pattern) : new GregorianCalendar();
            String passwd = this.contractPasswordField != null ? values.get(this.contractPasswordField) : PswdGen.generatePassword((ParameterMap)setup);
            int patternId = this.contractPatternId > 0 ? this.contractPatternId : Utils.parseInt((String)values.get("contractPatternId"), (int)this.contractPatternId);
            int contractId = 0;
            try {
                ContractCreateData data = ContractCreateData.builder().setPatternId(patternId).setTitle(title).setDateFrom(date.getTime()).setPassword(passwd).build();
                Contract contract = contractDao.createFromPattern(data, true);
                if (contract != null) {
                    contractId = contract.getId();
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            if (contractId < 1 && Utils.notBlankString((String)title)) {
                try {
                    Contract contract2 = contractDao.getByTitle(title);
                    if (contract2 != null) {
                        contractId = contract2.getId();
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
            if (contractId > 0) {
                JSONArray contractParamsJsonArray = configJsonObject.optJSONArray("contractParams");
                for (int index = 0; index < contractParamsJsonArray.length(); ++index) {
                    JSONObject paramJsonObject = contractParamsJsonArray.getJSONObject(index);
                    int paramId = paramJsonObject.getInt("value");
                    if (paramId <= 0) continue;
                    EntityAttrEmail entityAttr = null;
                    String name = paramJsonObject.getString("name");
                    ContractParameterGroupAttr attr = (ContractParameterGroupAttr)contractParameterGroupAttrDao.get(paramId);
                    if (attr == null) continue;
                    switch (attr.getTypeName()) {
                        case "text": {
                            entityAttr = new EntityAttrText(contractId, paramId, values.get(name));
                            break;
                        }
                        case "date": {
                            entityAttr = new EntityAttrDate(contractId, paramId, TimeUtils.parseDate((String)values.get(name), (String)"dd.MM.yyyy"));
                            break;
                        }
                        case "boolean": {
                            entityAttr = new EntityAttrBoolean(contractId, paramId, Boolean.valueOf(values.get(name)).booleanValue());
                            break;
                        }
                        case "email": {
                            entityAttr = EntityAttrEmail.parse((int)contractId, (int)paramId, (String)values.get(name));
                            break;
                        }
                        case "address": {
                            entityAttr = new EntityAttrAddress(contractId, paramId, values.get(name));
                            break;
                        }
                    }
                    try {
                        contractDao.updateContractParameter(contractId, (EntityAttr)entityAttr);
                        continue;
                    }
                    catch (BGException ex) {
                        this.logError(ex);
                    }
                }
            }
            new CommentPatternManager(con).updateContractComment(contractId);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void parse(char[] data, List<String> values) {
        int pos1 = 0;
        int pos2 = 0;
        while (pos2 < data.length) {
            char c = data[pos2];
            if (c == '\"') {
                ++pos2;
                while (pos2 < data.length) {
                    c = data[pos2];
                    if (c != '\"') {
                        ++pos2;
                        continue;
                    }
                    if (pos2 != data.length - 1) {
                        c = data[pos2 + 1];
                        if (c != '\"') {
                            ++pos2;
                            break;
                        }
                        pos2 += 2;
                        continue;
                    }
                    ++pos2;
                }
            } else {
                while (pos2 < data.length && (c = data[pos2]) != this.fieldSeparator) {
                    ++pos2;
                }
            }
            if (pos1 == pos2) {
                values.add("");
            } else {
                values.add(new String(Arrays.copyOfRange(data, data[pos1] == '\"' ? pos1 + 1 : pos1, data[pos2 - 1] == '\"' ? pos2 - 1 : pos2)).replace("\"\"", "\""));
            }
            pos1 = ++pos2;
        }
    }

    private void createContractParameters(JSONArray contractParamsJsonArray) throws Exception {
        if (contractParamsJsonArray != null) {
            for (int index = 0; index < contractParamsJsonArray.length(); ++index) {
                JSONObject paramJsonObject = contractParamsJsonArray.getJSONObject(index);
                int value = paramJsonObject.getInt("value");
                if (value != -1) continue;
                String name = paramJsonObject.getString("name").substring(9);
                for (ContractParameterGroupAttr attr : this.getContractParameterService().contractParameterGroupAttrList()) {
                    if (attr.getType() == EntitySpecAttrType.TEXT.getCode() && attr.getTitle().equals(name)) break;
                }
                try (ContractParameterGroupAttrDao contractParameterGroupAttrDao = new ContractParameterGroupAttrDao(this.con);){
                    ContractParameterGroupAttr contractParameterGroupAttr = new ContractParameterGroupAttr();
                    contractParameterGroupAttr.setTitle(name);
                    contractParameterGroupAttr.setType(EntitySpecAttrType.TEXT.getCode());
                    contractParameterGroupAttrDao.update((Object)contractParameterGroupAttr);
                    this.context.getDirectory(ContractParameterGroupAttr.class, 0).update(contractParameterGroupAttr);
                    paramJsonObject.put("value", contractParameterGroupAttr.getId());
                    continue;
                }
            }
        }
    }
}

