/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.web.client;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.admin.web.client.WebMenuTransferHandler;
import ru.bitel.bgbilling.kernel.admin.web.client.WebMenuUserObject;
import ru.bitel.bgbilling.kernel.admin.web.common.bean.WebMenuModuleItem;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class WebMenuTree
extends JTree
implements Autoscroll {
    private int margin = 12;
    private String inData = null;
    private String outData = null;
    private JPopupMenu popupMenu = null;
    Map<String, WebMenuModuleItem> webMenuItemMap = null;

    public WebMenuTree() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setRootVisible(true);
        this.setShowsRootHandles(true);
        this.getSelectionModel().setSelectionMode(1);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.setTransferHandler(new WebMenuTransferHandler());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                TreePath treePath;
                if (event.getButton() == 3 && (treePath = WebMenuTree.this.getSelectionPath()) != null) {
                    Point p = event.getPoint();
                    Rectangle b = WebMenuTree.this.getPathBounds(treePath);
                    if (b.contains(p)) {
                        WebMenuTree.this.popupMenu.show(event.getComponent(), p.x, b.y + b.height + 1);
                    }
                }
            }
        });
    }

    public void reset() {
        this.setData(this.inData);
    }

    public void setData(String doc) {
        try {
            this.inData = this.outData = doc;
            Document webMenuItemDoc = null;
            webMenuItemDoc = !Utils.isBlankString(doc) ? XMLUtils.parseDocument(new InputSource(new StringReader(doc))) : XMLUtils.newDocument();
            Element rootElement = webMenuItemDoc.getDocumentElement();
            if (rootElement == null) {
                rootElement = webMenuItemDoc.createElement("group");
                webMenuItemDoc.appendChild(rootElement);
                rootElement.setAttribute("title", "\u041a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442");
            }
            DefaultMutableTreeNode rootTreeNode = new DefaultMutableTreeNode(new WebMenuUserObject(rootElement));
            DefaultTreeModel model = new DefaultTreeModel(rootTreeNode);
            this.cc(model, rootElement, rootTreeNode);
            this.setModel(model);
            for (DefaultMutableTreeNode node = rootTreeNode.getNextNode(); node != null; node = node.getNextNode()) {
                this.expandPath(new TreePath(node.getPath()));
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void cc(DefaultTreeModel model, Element parentElement, DefaultMutableTreeNode parentTreeNode) throws Exception {
        int index = 0;
        for (Element element : XMLUtils.selectElements(parentElement, "*")) {
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(new WebMenuUserObject(element));
            model.insertNodeInto(treeNode, parentTreeNode, index++);
            this.cc(model, element, treeNode);
        }
    }

    public void initPopupMenu(WebMenuModuleItem[] kernelItems, WebMenuModuleItem[] moduleItems, WebMenuModuleItem[] pluginItems) throws Exception {
        this.webMenuItemMap = new HashMap<String, WebMenuModuleItem>();
        ActionListener actionListener = e -> this.addMenuItem(e.getActionCommand());
        ActionListener addAllActionListener = e -> this.addAllMenuItem(e.getActionCommand());
        JMenu addMenu = new JMenu("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
        this.buildPopupMenu(addMenu, kernelItems, "\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u043c\u0435\u043d\u044e (\u044f\u0434\u0440\u043e)", actionListener, addAllActionListener, true);
        this.buildPopupMenu(addMenu, moduleItems, "\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u043c\u0435\u043d\u044e (\u043c\u043e\u0434\u0443\u043b\u0438)", actionListener, addAllActionListener, false);
        this.buildPopupMenu(addMenu, pluginItems, "\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u043c\u0435\u043d\u044e (\u043f\u043b\u0430\u0433\u0438\u043d\u044b)", actionListener, addAllActionListener, false);
        addMenu.add("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u043c\u0435\u043d\u044e - \u0413\u0440\u0443\u043f\u043f\u0430").addActionListener(e -> this.addGroupMenuItem());
        addMenu.add("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u043c\u0435\u043d\u044e - \u0421\u0441\u044b\u043b\u043a\u0430 (URL)").addActionListener(e -> this.addLinkMenuItem());
        addMenu.add("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u043c\u0435\u043d\u044e - \u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a (\u043c\u0430\u0441\u0442\u0435\u0440)").addActionListener(e -> this.addAssistantMasterMenuItem());
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(addMenu);
        this.popupMenu.add("\u0423\u0434\u0430\u043b\u0438\u0442\u044c").addActionListener(e -> {
            TreePath treePath = this.getSelectionPath();
            if (treePath != null) {
                Object selectedObject = treePath.getLastPathComponent();
                if (selectedObject instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode menuItemTreeNode = (DefaultMutableTreeNode)selectedObject;
                    if (menuItemTreeNode.isRoot()) {
                        ClientUtils.showErrorMessageDialog("\u041a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f.");
                    } else if (!menuItemTreeNode.isLeaf()) {
                        ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f, \u0442.\u043a. \u0443\u0437\u0435\u043b \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435 \u0443\u0437\u043b\u044b, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445.");
                    } else {
                        ((DefaultTreeModel)this.getModel()).removeNodeFromParent(menuItemTreeNode);
                    }
                }
                this.aa("deleteData");
            }
        });
    }

    private void buildPopupMenu(JMenu parentMenu, WebMenuModuleItem[] items, String menuItemTitle, ActionListener listener, ActionListener allListener, boolean itemsInGroupPopupMenu) {
        HashMap<String, JMenu> popups = new HashMap<String, JMenu>();
        JMenu groupPopupMenu = new JMenu(menuItemTitle);
        for (WebMenuModuleItem item : items) {
            String moduleTitle = item.getModuleTitle();
            JMenu menu = (JMenu)popups.get(moduleTitle);
            if (menu == null) {
                menu = itemsInGroupPopupMenu ? groupPopupMenu : new JMenu(moduleTitle);
                menu.addSeparator();
                JMenuItem addAllJMenuItem = new JMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u0441\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b");
                addAllJMenuItem.setActionCommand(item.getModuleName() + "_" + item.getModuleId());
                addAllJMenuItem.addActionListener(allListener);
                menu.add(addAllJMenuItem);
                if (!itemsInGroupPopupMenu) {
                    groupPopupMenu.add(menu);
                }
                popups.put(moduleTitle, menu);
            }
            String key = item.getModuleName() + "_" + item.getModuleId() + "_" + item.getAction();
            JMenuItem menuItem = new JMenuItem(item.getTitle());
            menuItem.setActionCommand(key);
            menuItem.addActionListener(listener);
            menu.insert(menuItem, menu.getItemCount() - 2);
            this.webMenuItemMap.put(key, item);
        }
        parentMenu.add(groupPopupMenu);
    }

    private void addMenuItem(String key) {
        try {
            TreePath treePath = this.getSelectionPath();
            if (treePath != null) {
                Object selectedObject = treePath.getLastPathComponent();
                if (selectedObject instanceof DefaultMutableTreeNode) {
                    WebMenuModuleItem webMenuModuleItem = this.webMenuItemMap.get(key);
                    Element itemElement = XMLUtils.newDocument().createElement("item");
                    itemElement.setAttribute("title", webMenuModuleItem.getTitle());
                    itemElement.setAttribute("action", webMenuModuleItem.getAction());
                    itemElement.setAttribute("moduleName", webMenuModuleItem.getModuleName());
                    itemElement.setAttribute("moduleTitle", webMenuModuleItem.getModuleTitle());
                    itemElement.setAttribute("moduleId", String.valueOf(webMenuModuleItem.getModuleId()));
                    itemElement.setAttribute("cssClass", (String)(Utils.isEmptyString(webMenuModuleItem.getCssClass()) ? webMenuModuleItem.getModuleName() + webMenuModuleItem.getModuleId() : webMenuModuleItem.getCssClass()));
                    itemElement.setAttribute("icon", webMenuModuleItem.getIcon());
                    DefaultMutableTreeNode newMenuItemTreeNode = new DefaultMutableTreeNode(new WebMenuUserObject(itemElement));
                    DefaultMutableTreeNode menuItemTreeNode = (DefaultMutableTreeNode)selectedObject;
                    Object userObject = menuItemTreeNode.getUserObject();
                    if (userObject instanceof WebMenuUserObject) {
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
                        if (((WebMenuUserObject)userObject).getElement().getNodeName().equals("item")) {
                            defaultTreeModel.insertNodeInto(newMenuItemTreeNode, (DefaultMutableTreeNode)menuItemTreeNode.getParent(), menuItemTreeNode.getParent().getIndex(menuItemTreeNode) + 1);
                        } else {
                            defaultTreeModel.insertNodeInto(newMenuItemTreeNode, menuItemTreeNode, 0);
                        }
                        this.expandPath(new TreePath(menuItemTreeNode.getPath()));
                        this.scrollPathToVisible(new TreePath(menuItemTreeNode.getPath()));
                    }
                }
                this.aa("changeData");
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void addAllMenuItem(String prefix) {
        try {
            TreePath treePath = this.getSelectionPath();
            if (treePath != null) {
                Object selectedObject = treePath.getLastPathComponent();
                if (selectedObject instanceof DefaultMutableTreeNode) {
                    for (String key : this.webMenuItemMap.keySet()) {
                        if (!key.startsWith(prefix)) continue;
                        WebMenuModuleItem webMenuModuleItem = this.webMenuItemMap.get(key);
                        Element itemElement = XMLUtils.newDocument().createElement("item");
                        itemElement.setAttribute("title", webMenuModuleItem.getTitle());
                        itemElement.setAttribute("action", webMenuModuleItem.getAction());
                        itemElement.setAttribute("moduleName", webMenuModuleItem.getModuleName());
                        itemElement.setAttribute("moduleTitle", webMenuModuleItem.getModuleTitle());
                        itemElement.setAttribute("moduleId", String.valueOf(webMenuModuleItem.getModuleId()));
                        DefaultMutableTreeNode newMenuItemTreeNode = new DefaultMutableTreeNode(new WebMenuUserObject(itemElement));
                        DefaultMutableTreeNode menuItemTreeNode = (DefaultMutableTreeNode)selectedObject;
                        Object userObject = menuItemTreeNode.getUserObject();
                        if (!(userObject instanceof WebMenuUserObject)) continue;
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
                        if (((WebMenuUserObject)userObject).getElement().getNodeName().equals("item")) {
                            defaultTreeModel.insertNodeInto(newMenuItemTreeNode, (DefaultMutableTreeNode)menuItemTreeNode.getParent(), menuItemTreeNode.getParent().getIndex(menuItemTreeNode) + 1);
                        } else {
                            defaultTreeModel.insertNodeInto(newMenuItemTreeNode, menuItemTreeNode, 0);
                        }
                        this.expandPath(new TreePath(menuItemTreeNode.getPath()));
                        this.scrollPathToVisible(new TreePath(menuItemTreeNode.getPath()));
                    }
                }
                this.aa("changeData");
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void addMenuItem(Element itemElement) throws Exception {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            Object selectedObject = treePath.getLastPathComponent();
            if (selectedObject instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode newMenuItemTreeNode = new DefaultMutableTreeNode(new WebMenuUserObject(itemElement));
                DefaultMutableTreeNode menuItemTreeNode = (DefaultMutableTreeNode)selectedObject;
                Object userObject = menuItemTreeNode.getUserObject();
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
                if (userObject instanceof WebMenuUserObject) {
                    if (((WebMenuUserObject)userObject).getElement().getNodeName().equals("item")) {
                        defaultTreeModel.insertNodeInto(newMenuItemTreeNode, (DefaultMutableTreeNode)menuItemTreeNode.getParent(), menuItemTreeNode.getParent().getIndex(menuItemTreeNode) + 1);
                    } else {
                        defaultTreeModel.insertNodeInto(newMenuItemTreeNode, menuItemTreeNode, 0);
                    }
                    this.expandPath(new TreePath(menuItemTreeNode.getPath()));
                    this.scrollPathToVisible(new TreePath(menuItemTreeNode.getPath()));
                }
            }
            this.aa("changeData");
        }
    }

    private void addAssistantMasterMenuItem() {
        try {
            Element itemElement = XMLUtils.newDocument().createElement("item");
            itemElement.setAttribute("title", "\u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a (\u043c\u0430\u0441\u0442\u0435\u0440)");
            itemElement.setAttribute("type", "assistantMaster");
            itemElement.setAttribute("assistantMasterId", "0");
            itemElement.setAttribute("moduleName", "ru.bitel.bgbilling.plugins.assistant");
            this.addMenuItem(itemElement);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void addLinkMenuItem() {
        try {
            Element itemElement = XMLUtils.newDocument().createElement("item");
            itemElement.setAttribute("title", "\u0421\u0441\u044b\u043b\u043a\u0430");
            itemElement.setAttribute("type", "link");
            itemElement.setAttribute("url", "");
            this.addMenuItem(itemElement);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void addGroupMenuItem() {
        try {
            TreePath treePath = this.getSelectionPath();
            if (treePath != null) {
                Object selectedObject = treePath.getLastPathComponent();
                if (selectedObject instanceof DefaultMutableTreeNode) {
                    Element itemElement = XMLUtils.newDocument().createElement("group");
                    itemElement.setAttribute("title", "\u041d\u043e\u0432\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430");
                    DefaultMutableTreeNode newMenuItemTreeNode = new DefaultMutableTreeNode(new WebMenuUserObject(itemElement));
                    DefaultMutableTreeNode menuItemTreeNode = (DefaultMutableTreeNode)selectedObject;
                    Object userObject = menuItemTreeNode.getUserObject();
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
                    if (userObject instanceof WebMenuUserObject) {
                        if (((WebMenuUserObject)userObject).getElement().getNodeName().equals("item")) {
                            defaultTreeModel.insertNodeInto(newMenuItemTreeNode, (DefaultMutableTreeNode)menuItemTreeNode.getParent(), menuItemTreeNode.getParent().getIndex(menuItemTreeNode) + 1);
                        } else {
                            defaultTreeModel.insertNodeInto(newMenuItemTreeNode, menuItemTreeNode, 0);
                        }
                        this.expandPath(new TreePath(menuItemTreeNode.getPath()));
                        this.scrollPathToVisible(new TreePath(menuItemTreeNode.getPath()));
                    }
                    this.setKey(itemElement);
                }
                this.aa("changeData");
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void setKey(Element itemElement) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        int keyGroupId = 0;
        while (this.bb(defaultTreeModel, defaultTreeModel.getRoot(), "group" + ++keyGroupId)) {
        }
        itemElement.setAttribute("key", "group" + keyGroupId);
        this.aa("changeData");
    }

    private boolean bb(DefaultTreeModel defaultTreeModel, Object parent, String groupKey) {
        for (int index = 0; index < defaultTreeModel.getChildCount(parent); ++index) {
            WebMenuUserObject webMenuUserObject;
            DefaultMutableTreeNode menuItemTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getChild(parent, index);
            Object userObject = menuItemTreeNode.getUserObject();
            if (!(userObject instanceof WebMenuUserObject) || !(webMenuUserObject = (WebMenuUserObject)userObject).getElement().getNodeName().equals("group")) continue;
            if (groupKey.equals(webMenuUserObject.getElement().getAttribute("key"))) {
                return true;
            }
            if (!this.bb(defaultTreeModel, menuItemTreeNode, groupKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle outer = this.getBounds();
        Rectangle inner = this.getParent().getBounds();
        return new Insets(inner.y - outer.y + this.margin, inner.x - outer.x + this.margin, outer.height - inner.height - inner.y + outer.y + this.margin, outer.width - inner.width - inner.x + outer.x + this.margin);
    }

    @Override
    public void autoscroll(Point p) {
        int realrow = this.getRowForLocation(p.x, p.y);
        Rectangle outer = this.getBounds();
        realrow = p.y + outer.y <= this.margin ? (realrow < 1 ? 0 : realrow - 1) : (realrow < this.getRowCount() - 1 ? realrow + 1 : realrow);
        this.scrollRowToVisible(realrow);
    }

    public void aa(String propertyName) {
        try {
            Document doc = XMLUtils.newDocument();
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            DefaultMutableTreeNode rootTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
            Node rootNode = doc.importNode(((WebMenuUserObject)rootTreeNode.getUserObject()).getElement(), false);
            doc.appendChild(rootNode);
            this.bb(rootNode, rootTreeNode);
            this.outData = XMLUtils.serializeToString(doc.getDocumentElement(), false);
            this.firePropertyChange(propertyName, this.inData, this.outData);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void bb(Node parentNode, DefaultMutableTreeNode parentTreeNode) {
        for (int index = 0; index < parentTreeNode.getChildCount(); ++index) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)parentTreeNode.getChildAt(index);
            Node node = parentNode.getOwnerDocument().importNode(((WebMenuUserObject)treeNode.getUserObject()).getElement(), false);
            parentNode.appendChild(node);
            this.bb(node, treeNode);
        }
    }

    public String getData() {
        return this.outData;
    }
}

