/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.bean;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.enums.TrafficRangeMode;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficMaxDetail;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficMaxDetailReport;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeDetail;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeDetailReport;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeDetailValue;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.reports.Series;
import ru.bitel.common.reports.TimeSeriesCollection;

public class InetReportUtils {
    private static void addToRangeChart(String title, TimeSeriesCollection<LocalDate, Double> timeSeriesCollection, Map<String, Series<LocalDate, Double>> timeSeriesMap, long treeNodeId, long rangeKey, boolean group, LocalDate timePeriod, long amount, long unit, String suffix) {
        Object key = group ? String.valueOf(treeNodeId) : treeNodeId + ":" + rangeKey;
        Series timeSeries = timeSeriesMap.get(key);
        if (timeSeries == null) {
            timeSeries = timeSeriesCollection.newSeries(title, title + suffix);
            timeSeriesMap.put((String)key, (Series<LocalDate, Double>)timeSeries);
        }
        timeSeries.add((Object)timePeriod, (Object)((double)amount / (double)unit));
    }

    protected static String getUnitTitle(long unit) {
        if (unit == 1L) {
            return "\u0431\u0430\u0439\u0442";
        }
        if (unit == 1024L) {
            return "\u041a\u0411";
        }
        if (unit == 0x100000L) {
            return "\u041c\u0411";
        }
        if (unit == 0x40000000L) {
            return "\u0413\u0411";
        }
        return "";
    }

    public static TimeSeriesCollection<LocalDate, Double> rangeChart(Date dateFrom, List<TrafficRangeDetailReport> trafficRangeList, long unit) throws BGException {
        if (trafficRangeList == null) {
            return null;
        }
        String unitTitle = InetReportUtils.getUnitTitle(unit);
        TimeSeriesCollection timeSeriesList = new TimeSeriesCollection(ChronoUnit.DAYS, (a, b) -> a + b);
        HashMap<String, Series<LocalDate, Double>> timeSeriesMapRange = new HashMap<String, Series<LocalDate, Double>>();
        GregorianCalendar utilCalendar = new GregorianCalendar();
        utilCalendar.setTime(dateFrom);
        for (TrafficRangeDetailReport trafficRange : trafficRangeList) {
            int mode = trafficRange.getMode();
            boolean groupChart = switch (TrafficRangeMode.getTrafficRangeModeByCode((int)mode)) {
                case TrafficRangeMode.ACCOUNTING_PERIOD, TrafficRangeMode.TARIFF_OPTION -> false;
                default -> true;
            };
            if (trafficRange.getDetailValueList() == null) continue;
            for (TrafficRangeDetailValue detailValue : trafficRange.getDetailValueList()) {
                long rangeKey = detailValue.getRangeKey();
                utilCalendar.setTime(dateFrom);
                TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
                block11: for (TrafficRangeDetail detail : detailValue.getDetailList()) {
                    LocalDate timePeriod;
                    TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
                    utilCalendar.set(5, detail.getDay());
                    Object suffix = "";
                    switch (TrafficRangeMode.getTrafficRangeModeByCode((int)mode)) {
                        case ACCOUNTING_PERIOD: {
                            timePeriod = LocalDate.of(utilCalendar.get(1), Month.of(utilCalendar.get(2) + 1), utilCalendar.get(5));
                            suffix = " (" + unitTitle + "/\u0437\u0430 \u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u0435\u043d\u044c)";
                            break;
                        }
                        case MONTH: {
                            timePeriod = LocalDate.of(utilCalendar.get(1), Month.of(utilCalendar.get(2) + 1), utilCalendar.get(5));
                            suffix = " (" + unitTitle + "/\u0437\u0430 \u043c\u0435\u0441\u044f\u0446 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u0435\u043d\u044c)";
                            break;
                        }
                        case DAY: {
                            timePeriod = LocalDate.of(utilCalendar.get(1), Month.of(utilCalendar.get(2) + 1), utilCalendar.get(5));
                            suffix = " (" + unitTitle + "/\u0434\u0435\u043d\u044c)";
                            break;
                        }
                        case TARIFF_OPTION: {
                            timePeriod = LocalDate.of(utilCalendar.get(1), Month.of(utilCalendar.get(2) + 1), utilCalendar.get(5));
                            suffix = " (" + unitTitle + "/\u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u0435\u043d\u044c)";
                            break;
                        }
                        default: {
                            continue block11;
                        }
                    }
                    if (Utils.isBlankString((String)unitTitle)) {
                        suffix = "";
                    }
                    InetReportUtils.addToRangeChart(trafficRange.getTitle(), (TimeSeriesCollection<LocalDate, Double>)timeSeriesList, timeSeriesMapRange, trafficRange.getTreeNodeId(), rangeKey, groupChart, timePeriod, detail.getAmount(), unit, (String)suffix);
                }
            }
        }
        timeSeriesMapRange.clear();
        return timeSeriesList;
    }

    private static void addToMaxChart(String title, TimeSeriesCollection<Temporal, Double> timeSeriesCollection, Map<String, Series<Temporal, Double>> timeSeriesMap, long treeNodeId, int maxKey, boolean group, Temporal timePeriod, long amount, long unit, String suffix) {
        Object key;
        Series timeSeries;
        if (maxKey < 0) {
            maxKey = maxKey * -1 - 1;
        }
        if ((timeSeries = timeSeriesMap.get(key = group ? String.valueOf(treeNodeId) : treeNodeId + ":" + maxKey)) == null) {
            timeSeries = timeSeriesCollection.newSeries(title, title + suffix);
            timeSeriesMap.put((String)key, (Series<Temporal, Double>)timeSeries);
        }
        timeSeries.add((Object)timePeriod, (Object)((double)amount / (double)unit));
    }

    public static TimeSeriesCollection<Temporal, Double> maxChart(Date dateFrom, Date dateTo, List<TrafficMaxDetailReport> trafficMaxList, long unit, Map<Integer, TrafficType> trafficTypeMap) throws BGException {
        if (trafficMaxList == null) {
            return null;
        }
        boolean oneDay = false;
        if (TimeUtils.convertDateToLocalDate((Date)dateFrom).equals(TimeUtils.convertDateToLocalDate((Date)dateTo))) {
            oneDay = true;
        }
        String unitTitle = InetReportUtils.getUnitTitle(unit);
        TimeSeriesCollection timeSeriesList = oneDay ? new TimeSeriesCollection(ChronoUnit.HOURS, (a, b) -> a + b) : new TimeSeriesCollection(ChronoUnit.DAYS, (a, b) -> a + b);
        HashMap<String, Series<Temporal, Double>> timeSeriesMapRange = new HashMap<String, Series<Temporal, Double>>();
        GregorianCalendar utilCalendar = new GregorianCalendar();
        utilCalendar.setTime(dateFrom);
        for (TrafficMaxDetailReport trafficMax : trafficMaxList) {
            int mode = trafficMax.getMode();
            int typeId1 = trafficMax.getTrafficTypeId1() * -1 - 1;
            int typeId2 = trafficMax.getTrafficTypeId2() * -1 - 1;
            TrafficType type1 = trafficTypeMap.get(typeId1);
            TrafficType type2 = trafficTypeMap.get(typeId2);
            String typeTitle1 = type1 != null ? type1.getTitle() : "";
            String typeTitle2 = type2 != null ? type2.getTitle() : "";
            block7: for (TrafficMaxDetail detail : trafficMax.getTrafficMaxDetailList()) {
                Comparable<ChronoLocalDate> timePeriod;
                TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
                utilCalendar.set(5, detail.getDay());
                utilCalendar.set(11, detail.getHour());
                Object suffix = "";
                switch (mode) {
                    case 1: {
                        timePeriod = LocalDate.of(utilCalendar.get(1), Month.of(utilCalendar.get(2) + 1), utilCalendar.get(5));
                        suffix = " (" + unitTitle + "/\u0437\u0430 \u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u0435\u043d\u044c)";
                        break;
                    }
                    case 2: {
                        timePeriod = LocalDate.of(utilCalendar.get(1), Month.of(utilCalendar.get(2) + 1), utilCalendar.get(5));
                        suffix = " (" + unitTitle + "/\u0437\u0430 \u043c\u0435\u0441\u044f\u0446 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u0435\u043d\u044c)";
                        break;
                    }
                    case 3: {
                        timePeriod = LocalDate.of(utilCalendar.get(1), Month.of(utilCalendar.get(2) + 1), utilCalendar.get(5));
                        suffix = " (" + unitTitle + "/\u0434\u0435\u043d\u044c)";
                        break;
                    }
                    case 4: {
                        if (oneDay) {
                            timePeriod = LocalDateTime.of(utilCalendar.get(1), Month.of(utilCalendar.get(2) + 1), utilCalendar.get(5), utilCalendar.get(11), 0, 0);
                            suffix = " (" + unitTitle + "/\u0447\u0430\u0441)";
                            break;
                        }
                        timePeriod = LocalDate.of(utilCalendar.get(1), Month.of(utilCalendar.get(2) + 1), utilCalendar.get(5));
                        suffix = " (" + unitTitle + "/\u0434\u0435\u043d\u044c)";
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                if (Utils.isBlankString((String)unitTitle)) {
                    suffix = "";
                }
                InetReportUtils.addToMaxChart(typeTitle1, (TimeSeriesCollection<Temporal, Double>)timeSeriesList, timeSeriesMapRange, trafficMax.getTreeNodeId(), trafficMax.getTrafficTypeId1(), false, timePeriod, detail.getAmount1(), unit, (String)suffix);
                InetReportUtils.addToMaxChart(typeTitle2, (TimeSeriesCollection<Temporal, Double>)timeSeriesList, timeSeriesMapRange, trafficMax.getTreeNodeId(), trafficMax.getTrafficTypeId2(), false, timePeriod, detail.getAmount2(), unit, (String)suffix);
                InetReportUtils.addToMaxChart(trafficMax.getTitle(), (TimeSeriesCollection<Temporal, Double>)timeSeriesList, timeSeriesMapRange, trafficMax.getTreeNodeId(), -1, false, timePeriod, detail.getAmountMax(), unit, (String)suffix);
            }
        }
        return timeSeriesList;
    }
}

