package ru.bitel.bgbilling.modules.inet.dyn.device.skat;

import java.util.List;

import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProtocolHandler;
import ru.bitel.bgbilling.modules.inet.dyn.device.radius.CoAProtocolHandler;
import ru.bitel.common.sql.ConnectionSet;

/**
 * Конвертирует атрибуты трафика в строковое представление с префиксом (как в MPD), для которого можно задать правила в привязке трафика.<br>
 * Можно также использовать статический метод этого класса в другом обработчике.
 * 
 * @author amir
 *
 */
public class SkatTrafficClassProtocolHandler
    extends CoAProtocolHandler
    implements RadiusProtocolHandler
{
    @Override
    public void preprocessAccountingRequest( RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet )
        throws Exception
    {
        super.preprocessAccountingRequest( request, response, connectionSet );

        convertTrafficAttributesToMPDAttributes( request );
    }

    public static void convertTrafficAttributesToMPDAttributes( RadiusPacket request )
    {
        convertTrafficAttributesToPrefixedAttributes( request, 12341, 8, 10 );
    }

    public static void convertTrafficAttributesToPrefixedAttributes( RadiusPacket request, int newVendor, int newInputType, int newOutputType )
    {
        final List<RadiusAttribute<?>> classes = request.getAttributes( 43823, 16 );

        if ( classes == null || classes.size() == 0 )
        {
            return;
        }

        final List<RadiusAttribute<?>> inputs = request.getAttributes( 43823, 17 );
        final List<RadiusAttribute<?>> outputs = request.getAttributes( 43823, 18 );

        if ( inputs != null && outputs != null
            && classes.size() == inputs.size() && classes.size() == outputs.size() )
        {
            for ( int i = 0; i < classes.size(); i++ )
            {
                String clazz = (String)classes.get( i ).getValue();
                Long input = (Long)inputs.get( i ).getValue();
                Long output = (Long)inputs.get( i ).getValue();

                request.addAttribute( new RadiusAttribute<String>( newVendor, newInputType, 0, clazz + ":" + input ) );
                request.addAttribute( new RadiusAttribute<String>( newVendor, newOutputType, 0, clazz + ":" + output ) );
            }
        }
    }
}
