/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAmountDelta;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAmountKey;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetConnectionStatus;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetConnectionDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServTypeDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNasConnection;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.common.model.Id;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.CopyOnWriteListMap;
import ru.bitel.common.util.SetCache;

public class ConnectionMapCall
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private static final SetCache<Integer> DEVICE_OPTIONS_SET_CACHE = InetServRuntime.DEVICE_OPTIONS_SET_CACHE;
    protected final Accounting accounting;
    private final ConcurrentMap<Long, InetConnectionCallRuntime> callSessionMap = new ConcurrentHashMap<Long, InetConnectionCallRuntime>(512);
    private final CopyOnWriteListMap<Integer, InetConnectionCallRuntime> servMap = new CopyOnWriteListMap(512, 2);
    private final CopyOnWriteListMap<Integer, InetConnectionCallRuntime> contractMap = new CopyOnWriteListMap(512, 4);
    private boolean realtimeInited = false;

    public ConnectionMapCall(Accounting accounting) throws BGException {
        this.accounting = accounting;
    }

    public InetConnectionCallRuntime get(Long connectionId) {
        return (InetConnectionCallRuntime)((Object)this.callSessionMap.get(connectionId));
    }

    public List<InetConnectionCallRuntime> getByServId(Integer inetServId) {
        return this.servMap.get((Object)inetServId);
    }

    public Map<Long, InetConnectionCallRuntime> getSessionMap() {
        return this.callSessionMap;
    }

    public InetConnectionCallRuntime putIfAbsent(Long connectionId, InetConnectionCallRuntime value) {
        InetConnectionCallRuntime connectionRuntime = this.callSessionMap.putIfAbsent(connectionId, value);
        if (connectionRuntime == null) {
            connectionRuntime = value;
            this.servMap.add((Object)connectionRuntime.inetServId, (Object)connectionRuntime);
            this.contractMap.add((Object)connectionRuntime.contractId, (Object)connectionRuntime);
        }
        return connectionRuntime;
    }

    public void put(Long key, InetConnectionCallRuntime connectionRuntime) {
        this.callSessionMap.put(key, connectionRuntime);
        this.servMap.add((Object)connectionRuntime.inetServId, (Object)connectionRuntime);
        this.contractMap.add((Object)connectionRuntime.contractId, (Object)connectionRuntime);
    }

    public boolean remove(Long key, InetConnectionCallRuntime connectionRuntime) {
        boolean result = this.callSessionMap.remove(key, (Object)connectionRuntime);
        this.servMap.remove((Object)connectionRuntime.inetServId, (Object)connectionRuntime);
        this.contractMap.remove((Object)connectionRuntime.contractId, (Object)connectionRuntime);
        return result;
    }

    public Collection<InetConnectionCallRuntime> values() {
        return this.callSessionMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Event _e, EventListenerContext ctx) throws BGException {
        if (_e instanceof InetConnectionDeviceStateAndOptionsModifiedEvent) {
            InetConnectionDeviceStateAndOptionsModifiedEvent e = (InetConnectionDeviceStateAndOptionsModifiedEvent)_e;
            Long connectionId = e.getConnectionId();
            InetConnectionCallRuntime connectionRuntime = (InetConnectionCallRuntime)((Object)this.callSessionMap.get(connectionId));
            if (connectionRuntime == null) {
                return;
            }
            connectionRuntime.inetServRuntime.lock();
            try {
                InetConnection connection = connectionRuntime.connection;
                if (e.getDeviceState() != InetServState.STATE_NULL.getCode()) {
                    connection.setDeviceState(e.getDeviceState());
                    InetConnection.setType((InetConnection)connection, (int)8, (boolean)true);
                }
                if (e.getDeviceOptions() != null) {
                    connection.setDeviceOptions(e.getDeviceOptions());
                }
            }
            finally {
                connectionRuntime.inetServRuntime.unlock();
            }
        }
    }

    private void initRealtime() throws BGException {
        EventProcessor.getInstance().addListener((EventListener)this, InetConnectionDeviceStateAndOptionsModifiedEvent.class, null);
    }

    public void init(ConnectionSet connectionSet, NasList<InetNasConnection, InetNas> nasList) throws BGException {
        if (this.accounting.realtime && !this.realtimeInited) {
            this.realtimeInited = true;
            this.initRealtime();
        }
        logger.info("Init call sessions");
        Connection con = connectionSet.getConnection();
        InetDevice device = new InetDeviceDao(con, this.accounting.moduleId).node(null, this.accounting.rootDeviceId, false);
        Set servTypeIds = Id.newIdSet(new InetServTypeDao(con, this.accounting.moduleId).list(0));
        if (servTypeIds.size() > 0) {
            InetSessionDao inetSessionDao = new InetSessionDao(con, this.accounting.moduleId);
            TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(con);
            this.loadConnections(connectionSet, con, nasList, device, servTypeIds, inetSessionDao, tariffModuleTreeSetDao);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConnections(ConnectionSet connectionSet, Connection con, NasList<InetNasConnection, InetNas> nasList, InetDevice device, Set<Integer> servTypeIds, InetSessionDao inetSessionDao, TariffModuleTreeSetDao tariffTreeSetDao) throws BGException {
        long start = System.currentTimeMillis();
        InetNas nas = nasList != null ? (InetNas)nasList.get(device.getId()) : null;
        List<Object[]> sessionList = inetSessionDao.listCall(device.getId(), servTypeIds);
        for (Object[] object : sessionList) {
            InetConnection connection = (InetConnection)object[0];
            InetSession session = (InetSession)object[1];
            try {
                InetConnectionCallRuntime newConnectionRuntime;
                String realm;
                InetConnectionCallRuntime parentConnectionCallRuntime;
                boolean serviceSession;
                InetServRuntime inetServRuntime = this.accounting.inetServRuntimeMap.get(connection.getServId());
                if (inetServRuntime == null) {
                    logger.warn("InetServRuntime not found for id=" + connection.getServId());
                    continue;
                }
                if (session.getSessionStart() == null) {
                    logger.warn("InetSession is null or sessionStart is null for connection:" + connection.getId());
                    continue;
                }
                boolean needFinish = false;
                boolean needClose = false;
                if (connection.getParentConnectionId() > 0L) {
                    serviceSession = true;
                    parentConnectionCallRuntime = (InetConnectionCallRuntime)((Object)this.callSessionMap.get(connection.getParentConnectionId()));
                    if (parentConnectionCallRuntime == null && connection.getConnectionStatus().getCode() >= InetConnectionStatus.STATUS_ALIVE.getCode()) {
                        realm = null;
                        needFinish = true;
                        needClose = connection.getConnectionStatus().getCode() < InetConnectionStatus.STATUS_CLOSED.getCode();
                    } else {
                        realm = parentConnectionCallRuntime.realm;
                    }
                } else {
                    serviceSession = false;
                    parentConnectionCallRuntime = null;
                    realm = InetUtils.getRealm(connection.getUsername());
                }
                inetServRuntime.lock();
                try {
                    newConnectionRuntime = new InetConnectionCallRuntime(this.accounting, inetServRuntime, connection, session, realm, (NasList<InetNasConnection, InetNas>)(nas != null ? nasList : null), device.getId(), connection.getDevicePort(), serviceSession, parentConnectionCallRuntime);
                    if (nas != null) {
                        if (newConnectionRuntime.connection.getConnectionStatus().getCode() >= InetConnectionStatus.STATUS_CLOSED.getCode()) {
                            newConnectionRuntime.nasConnection.setStatus(NasConnection.Status.stopped);
                        }
                        nas.setConnection(newConnectionRuntime.nasConnection, con, con);
                    }
                    if (newConnectionRuntime.connection.getParentConnectionId() <= 0L && newConnectionRuntime.connection.getInetAddressBytes() != null) {
                        this.accounting.registerInetAddress(newConnectionRuntime.connection.getDeviceId(), newConnectionRuntime);
                    }
                    newConnectionRuntime.setAccountingPeriod(this.accounting, connectionSet, newConnectionRuntime.sessionStartTime, false);
                    Set inetOptions = connection.getDeviceOptions();
                    if (inetOptions != null) {
                        inetOptions = DEVICE_OPTIONS_SET_CACHE.intern(inetOptions);
                        connection.setDeviceOptions(inetOptions);
                        newConnectionRuntime.setInetOptions(inetOptions);
                    } else {
                        newConnectionRuntime.setInetOptions(Collections.emptySet());
                    }
                }
                finally {
                    inetServRuntime.unlock();
                }
                InetServTypeRuntime servType = newConnectionRuntime.inetServRuntime.inetServTypeRef.get();
                if (servType.trafficTypeLinkRuntimeRef.get().counterTrafficTypes.size() == 0 && !InetConnection.isType((InetConnection)connection, (int)1)) {
                    if (connection.getConnectionStart().equals(session.getSessionStart())) {
                        newConnectionRuntime.initCounterTraffic(TrafficType.TIME_ID, session.getSessionTime());
                    } else {
                        long connectionTime = session.getSessionStart().getTime() / 1000L - connection.getConnectionStart().getTime() / 1000L + session.getSessionTime();
                        newConnectionRuntime.initCounterTraffic(TrafficType.TIME_ID, connectionTime);
                    }
                } else {
                    Map<Integer, AccountingTrafficAmount> counterMap = InetSessionDao.getCountersFromDB(con, this.accounting.moduleId, servType, session.getId());
                    for (Map.Entry<Integer, AccountingTrafficAmount> entry : counterMap.entrySet()) {
                        int trafficTypeId = entry.getKey();
                        long amount = entry.getValue().amount;
                        newConnectionRuntime.initCounterTraffic(trafficTypeId, amount);
                    }
                }
                this.putIfAbsent(session.getConnectionId(), newConnectionRuntime);
                if (!needFinish) continue;
                try (BalanceDao balanceDao = new BalanceDao(con);){
                    newConnectionRuntime.inetServRuntime.lock();
                    try {
                        newConnectionRuntime.forceFinish(this.accounting, connectionSet, balanceDao, needClose, System.currentTimeMillis());
                    }
                    finally {
                        newConnectionRuntime.inetServRuntime.unlock();
                    }
                }
                catch (Exception ex) {
                    logger.error("Problem with connectionId: " + session.getConnectionId() + ", sessionId: " + session.getId() + " restore, " + ex.getMessage(), (Throwable)ex);
                    this.callSessionMap.remove(session.getConnectionId(), (Object)newConnectionRuntime);
                }
            }
            catch (Exception ex) {
                logger.error("Problem with connectionId: " + session.getConnectionId() + ", sessionId: " + session.getId() + " restore, " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (device.getChildren() != null) {
            for (InetDevice child : device.getChildren()) {
                this.loadConnections(connectionSet, con, nasList, child, servTypeIds, inetSessionDao, tariffTreeSetDao);
            }
        }
        logger.info("Call connections loaded for " + (System.currentTimeMillis() - start) + " ms");
    }

    public void loadCounters(ConnectionSet connectionSet) {
        logger.info("Loading counters for call connections");
        long start = System.currentTimeMillis();
        try {
            for (Map.Entry entry : this.callSessionMap.entrySet()) {
                long connectionId = (Long)entry.getKey();
                InetConnectionCallRuntime connection = (InetConnectionCallRuntime)((Object)entry.getValue());
                InetServTypeRuntime servType = connection.inetServRuntime.inetServTypeRef.get();
                InetConnectionCallRuntime inetCon = (InetConnectionCallRuntime)((Object)this.callSessionMap.get(connectionId));
                Connection con = connectionSet.getConnection();
                Map<Integer, AccountingTrafficAmount> counterMap = InetSessionDao.getCountersFromDB(con, this.accounting.moduleId, servType, connection.sessionId);
                if (inetCon == null) continue;
                for (Map.Entry entry2 : inetCon.trafficsDelta.entrySet()) {
                    Map value = (Map)entry2.getValue();
                    for (Map.Entry deltaAmount : value.entrySet()) {
                        int traffTypeId = ((TrafficAmountKey)deltaAmount.getKey()).trafficTypeId;
                        AccountingTrafficAmount amount = counterMap.get(traffTypeId);
                        if (amount == null) {
                            amount = new AccountingTrafficAmount();
                            counterMap.put(traffTypeId, amount);
                        }
                        amount.amount += ((TrafficAmountDelta)deltaAmount.getValue()).flushAmountDelta;
                    }
                }
                for (Map.Entry<Object, Object> entry3 : counterMap.entrySet()) {
                    int trafficTypeId = (Integer)entry3.getKey();
                    AccountingTrafficAmount amount = (AccountingTrafficAmount)entry3.getValue();
                    inetCon.initCounterTraffic(trafficTypeId, amount.amount);
                }
            }
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("Counter loading completed for " + (System.currentTimeMillis() - start) + " ms");
    }
}

