/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.event;

import javax.jms.JMSException;
import javax.jms.Message;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.PoolEvent;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;

@EventType(noLocal=true)
public class InetConnectionAliveEvent
extends PoolEvent {
    private static final long serialVersionUID = -5259123422207692661L;
    private final InetConnection connection;

    protected InetConnectionAliveEvent() {
        this.connection = null;
    }

    public InetConnectionAliveEvent(PoolEventPublisher<?> publisher, int contractId, InetConnection connection) {
        super(publisher, contractId, 0);
        this.connection = connection;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.connection.getDeviceId());
    }

    public InetConnection getConnection() {
        return this.connection;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.connection.getDeviceId());
        sb.append("; connectionId: ");
        sb.append(this.connection.getId());
    }
}

