/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.detail;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.detail.InetFlowSelector;
import ru.bitel.bgbilling.apps.inet.accounting.detail.InetMonthFlowSelector;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLogger;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogUtils;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowSelector;
import ru.bitel.bgbilling.modules.inet.common.event.accounting.InetDetailCreateEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.concurrent.CompositeFuture;
import ru.bitel.common.sql.ConnectionSet;

public abstract class FlowDetailMaker {
    private static final Logger logger = LogManager.getLogger();
    private long nextFlushMillis = 0L;

    protected void sendAlarm(String subject, String text) {
        String key = "inet.accounting.detailmaker";
        AlarmSender.sendAlarm((String)"inet.accounting.detailmaker", (long)0L, (String)subject, (String)text);
    }

    protected File getTempDirectory(ParameterMap setup, String name) {
        StringBuilder fileName = new StringBuilder();
        File dir = new File(new File("temp", "detail"), name);
        if (!dir.exists() && !dir.mkdirs()) {
            this.sendAlarm("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438", fileName.toString());
        }
        return dir.exists() ? dir : null;
    }

    protected SortedSet<Calendar> getLogHours(Date timeFrom, Date timeTo) {
        TreeSet<Calendar> result = new TreeSet<Calendar>();
        Calendar hour = new GregorianCalendar();
        hour.setTime(timeFrom);
        TimeUtils.clear_MIN_MIL_SEC((Calendar)hour);
        GregorianCalendar end = new GregorianCalendar();
        end.setTime(timeTo);
        while (TimeUtils.hourDelta((Calendar)hour, (Calendar)end) >= 0) {
            result.add(hour);
            hour = (Calendar)hour.clone();
            hour.add(11, 1);
        }
        return result;
    }

    protected SortedSet<Calendar> getLogHours(List<InetDetailCreateEvent.SessionInfo> sessionList) {
        TreeSet<Calendar> result = new TreeSet<Calendar>();
        for (InetDetailCreateEvent.SessionInfo session : sessionList) {
            Calendar hour = new GregorianCalendar();
            hour.setTime(session.getTimeFrom());
            TimeUtils.clear_MIN_MIL_SEC((Calendar)hour);
            GregorianCalendar end = new GregorianCalendar();
            end.setTime(session.getTimeTo());
            while (TimeUtils.hourDelta((Calendar)hour, (Calendar)end) >= 0) {
                result.add(hour);
                hour = (Calendar)hour.clone();
                hour.add(11, 1);
            }
        }
        return result;
    }

    protected Map<Integer, SortedSet<Calendar>> getLogHours2(List<InetDetailCreateEvent.SessionInfo> sessionList) {
        HashMap<Integer, SortedSet<Calendar>> result = new HashMap<Integer, SortedSet<Calendar>>();
        for (InetDetailCreateEvent.SessionInfo session : sessionList) {
            TreeSet<GregorianCalendar> set = (TreeSet<GregorianCalendar>)result.get(session.getAgentDeviceId());
            if (set == null) {
                set = new TreeSet<GregorianCalendar>();
                result.put(session.getAgentDeviceId(), set);
            }
            Calendar hour = new GregorianCalendar();
            hour.setTime(session.getTimeFrom());
            TimeUtils.clear_MIN_MIL_SEC((Calendar)hour);
            GregorianCalendar end = new GregorianCalendar();
            end.setTime(session.getTimeTo());
            while (TimeUtils.hourDelta((Calendar)hour, (Calendar)end) >= 0) {
                set.add((GregorianCalendar)hour);
                hour = (Calendar)hour.clone();
                hour.add(11, 1);
            }
        }
        return result;
    }

    protected Map<Integer, List<InetDetailCreateEvent.SessionInfo>> getAgentSessionMap(List<InetDetailCreateEvent.SessionInfo> sessionList) {
        HashMap<Integer, List<InetDetailCreateEvent.SessionInfo>> result = new HashMap<Integer, List<InetDetailCreateEvent.SessionInfo>>();
        for (InetDetailCreateEvent.SessionInfo session : sessionList) {
            ArrayList<InetDetailCreateEvent.SessionInfo> list = (ArrayList<InetDetailCreateEvent.SessionInfo>)result.get(session.getAgentDeviceId());
            if (list == null) {
                list = new ArrayList<InetDetailCreateEvent.SessionInfo>();
                result.put(session.getAgentDeviceId(), list);
            }
            list.add(session);
        }
        return result;
    }

    public void createDetail(DefaultServerSetup setup, ConnectionSet connectionSet, InetDetailCreateEvent task) throws Exception {
        String subject = "Traffic detail";
        long startTime = System.currentTimeMillis();
        TreeSet<Calendar> hoursToFlush = new TreeSet<Calendar>();
        ArrayList<FlowDetailEntry> entries = new ArrayList<FlowDetailEntry>();
        int moduleId = SetupParam.getModuleId((ParameterMap)Setup.getSetup());
        InetDeviceMap.InetDeviceMapItem device = InetDeviceMap.getInstance(moduleId).get(task.getDeviceId());
        long connectionfinishTimeoutMillis = (device != null ? device.getConfig().getLong("connection.finish.timeout", 5L) : 5L) * 1000L;
        if (task.getSessionList().size() == 1) {
            InetDetailCreateEvent.SessionInfo session = (InetDetailCreateEvent.SessionInfo)task.getSessionList().get(0);
            InetFlowSelector selector = new InetFlowSelector(session.getTimeFrom().getTime(), (session.getTimeTo().getTime() + connectionfinishTimeoutMillis) / 1000L * 1000L + 999L, session.getIfaces(), session.getAddressFrom().address, session.getAddressTo().address, session.getPrefix().address, session.getPrefixLength(), session.getRouteNetList(), 0);
            ArrayList<Calendar> hours = new ArrayList<Calendar>(this.getLogHours(task.getTimeFrom(), task.getTimeTo()));
            entries.add(new FlowDetailEntry(this, setup, session.getAgentDeviceId(), selector, hours));
            hoursToFlush.addAll(hours);
        } else {
            Map<Integer, List<InetDetailCreateEvent.SessionInfo>> map = this.getAgentSessionMap(task.getSessionList());
            for (Map.Entry<Integer, List<InetDetailCreateEvent.SessionInfo>> e : map.entrySet()) {
                List<InetDetailCreateEvent.SessionInfo> sessionList = e.getValue();
                InetMonthFlowSelector selector = new InetMonthFlowSelector(sessionList, connectionfinishTimeoutMillis);
                ArrayList<Calendar> hours = new ArrayList<Calendar>(this.getLogHours(sessionList));
                entries.add(new FlowDetailEntry(this, setup, e.getKey(), selector, hours));
                hoursToFlush.addAll(hours);
            }
        }
        logger.info(Utils.memoryStatus());
        try {
            long now = System.currentTimeMillis();
            ArrayList<Future> futures = new ArrayList<Future>();
            for (Calendar hour : hoursToFlush) {
                Long hourLong = InetUtils.getHour(hour.getTimeInMillis());
                if (InetUtils.getHour(now).equals(hourLong)) {
                    if (now < this.nextFlushMillis) continue;
                    this.nextFlushMillis = now + TimeUnit.MINUTES.toMillis(1L);
                }
                HourlyDataLogger dataLogger = (HourlyDataLogger)DefaultServerSetup.getEnvironment().lookup("flowDataLogger");
                futures.add(dataLogger.flush(hourLong));
            }
            CompositeFuture.get(futures, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (Exception now) {
            // empty catch block
        }
        this.sendDetail(setup, connectionSet, task, entries, subject);
        logger.info(Utils.memoryStatus());
        long endCreateTime = System.currentTimeMillis();
        logger.info("Detail created and sended by " + (endCreateTime - startTime) + ", sending to " + task.getEmail());
    }

    protected StringBuilder getMessageBody(InetDetailCreateEvent task) {
        StringBuilder messageBody = new StringBuilder();
        if (task.getSessionList().size() == 1) {
            messageBody.append("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0441\u0435\u0441\u0441\u0438\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 ");
            messageBody.append(task.getInetServTitle());
        } else {
            messageBody.append("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0441\u0435\u0441\u0441\u0438\u0439 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 ");
            messageBody.append(task.getInetServTitle());
            messageBody.append(" \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434");
        }
        messageBody.append(" \u0441 ");
        messageBody.append(TimeUtils.format((Date)task.getTimeFrom(), (String)"dd.MM.yyyy HH:mm:ss"));
        messageBody.append(" \u043f\u043e ");
        messageBody.append(TimeUtils.format((Date)task.getTimeTo(), (String)"dd.MM.yyyy HH:mm:ss"));
        messageBody.append(".\n");
        messageBody.append("\u0424\u0430\u0439\u043b\u044b \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043d\u0430\u0445\u043e\u0434\u044f\u0442\u0441\u044f \u0432\u043e \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0438.");
        return messageBody;
    }

    protected void sendDetail(DefaultServerSetup setup, ConnectionSet connectionSet, InetDetailCreateEvent task, List<FlowDetailEntry> entries, String subject) throws Exception {
        logger.info("Creating session detail for inetServ:" + task.getInetServId() + ":" + task.getInetServTitle() + " from " + TimeUtils.format((Date)task.getTimeFrom(), (String)"dd.MM.yyyy HH:mm:ss"));
        this.sendDetailImpl(setup, connectionSet, task, entries, this.getMessageBody(task), subject);
    }

    protected void sendDetailMail(DefaultServerSetup setup, InetDetailCreateEvent task, String subject, StringBuilder messageBody, MimeBodyPart attach) throws BGException {
        MimeMultipart multipart = new MimeMultipart();
        try {
            if (attach != null) {
                multipart.addBodyPart((BodyPart)attach);
            }
            MimeBodyPart text = new MimeBodyPart();
            text.setText(messageBody.toString(), "utf-8");
            multipart.addBodyPart((BodyPart)text);
        }
        catch (MessagingException e) {
            throw new BGException((Throwable)e);
        }
        logger.info("Detail sending to " + task.getEmail() + "; subject " + subject);
        new MailMsg((Preferences)setup).sendMessage(task.getEmail(), subject, (Multipart)multipart);
    }

    public void init(ParameterMap setup) {
    }

    protected final void printToCsv(PrintStream csvReport, Data flow, DateFormat dateFormat) {
        csvReport.append(TimeUtils.format((Date)new Date(flow.getMilliseconds()), (DateFormat)dateFormat));
        csvReport.append(";");
        csvReport.append(String.valueOf(flow.getSrcIpAddress()));
        csvReport.append(";");
        csvReport.print(flow.getSrcPort());
        csvReport.append(";");
        csvReport.append(String.valueOf(flow.getDstIpAddress()));
        csvReport.append(";");
        csvReport.print(flow.getDstPort());
        csvReport.append(";");
        csvReport.print(flow.getOctets());
        csvReport.append(";");
        csvReport.print(flow.getInputInterface());
        csvReport.append(";");
        csvReport.print(flow.getOutputInterface());
        csvReport.append(";");
        csvReport.print(flow.getProtocol());
        csvReport.append("\n");
    }

    protected abstract void sendDetailImpl(DefaultServerSetup var1, ConnectionSet var2, InetDetailCreateEvent var3, List<FlowDetailEntry> var4, StringBuilder var5, String var6) throws Exception;

    public class FlowDetailEntry {
        private final DefaultServerSetup setup;
        public final int agentDeviceId;
        public final FlowSelector selector;
        public final List<Calendar> hours;

        public FlowDetailEntry(FlowDetailMaker this$0, DefaultServerSetup setup, int agentDeviceId, FlowSelector selector, List<Calendar> hours) {
            this.setup = setup;
            this.agentDeviceId = agentDeviceId;
            this.selector = selector;
            this.hours = hours;
        }

        public Iterable<FlowArray<IPDataLogUtils.FlowDetail>> newFlowDetailIterable() {
            Iterable logs = IPDataLogUtils.newIPHourlyDataLogIterable((ParameterMap)this.setup, (String)"datalog.flow.dir", (int)this.agentDeviceId, this.hours);
            return IPDataLogUtils.newFlowDetailIterable((Iterable)logs, (FlowSelector)this.selector, (int)10000);
        }
    }
}

