/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterface;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Idable;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceInterfaceIndexDao;

public class FlowAgent
extends IdTitle
implements Idable {
    public final int agentType;
    public final ParameterMap config;
    private final Map<Integer, FlowAgentInterface> ifaceMap;
    private final ConcurrentMap<Long, Hour> ifaceIndexHourMap;
    private volatile Hour ifaceIndexHourCurrent;
    public final FlowAgentInterface defaultIface;
    public final boolean process;

    public FlowAgent(int id, String title, int agentType, ParameterMap config, Map<Integer, FlowAgentInterface> ifaceMap) throws BGException {
        this.id = id;
        this.title = title;
        this.agentType = agentType;
        this.config = config;
        this.ifaceMap = ifaceMap;
        this.defaultIface = ifaceMap.get(-1);
        this.ifaceIndexHourMap = new ConcurrentHashMap<Long, Hour>();
        int applicationId = SetupParam.getApplicationId((ParameterMap)Setup.getSetup());
        Set applicationIds = Utils.toIntegerSet((String)config.get("flow.process.applicationIds", null));
        this.process = applicationIds == null || applicationIds.size() == 0 || applicationIds.contains(applicationId);
    }

    private Map<Integer, HourEntry> buildIfaceIndexMap(Long hour) {
        HashMap<Integer, ArrayList<Entry>> ifaceIndexListMap = new HashMap<Integer, ArrayList<Entry>>();
        long hourEnd = hour + 3600000L - 1L;
        long[] intersection = new long[2];
        for (Map.Entry<Integer, FlowAgentInterface> e : this.ifaceMap.entrySet()) {
            FlowAgentInterface iface = e.getValue();
            List<DeviceInterfaceIndexDao.DeviceInterfaceIndexItem> ifaceIndexList = iface.ifaceIndexList;
            if (ifaceIndexList == null || ifaceIndexList.size() == 0) {
                List<Entry> hourEntry = (List)ifaceIndexListMap.get(iface.iface);
                if (hourEntry == null) {
                    hourEntry = new ArrayList<Entry>(4);
                    ifaceIndexListMap.put(iface.iface, (ArrayList<Entry>)hourEntry);
                }
                hourEntry.add(new Entry(0L, 0L, iface));
                continue;
            }
            for (DeviceInterfaceIndexDao.DeviceInterfaceIndexItem index : ifaceIndexList) {
                if (RangeUtils.intersectionAnd((long[])intersection, (long)index.millisFrom, (long)index.millisTo, (long)hour, (long)hourEnd) == null) continue;
                ArrayList<Entry> hourEntry = (ArrayList<Entry>)ifaceIndexListMap.get(index.index);
                if (hourEntry == null) {
                    hourEntry = new ArrayList<Entry>(4);
                    ifaceIndexListMap.put(index.index, hourEntry);
                }
                hourEntry.add(new Entry(index.millisFrom, index.millisTo, iface));
            }
        }
        HashMap<Integer, HourEntry> ifaceIndexMap = new HashMap<Integer, HourEntry>(ifaceIndexListMap.size());
        for (Map.Entry e : ifaceIndexListMap.entrySet()) {
            List entryList = (List)e.getValue();
            if (entryList.size() == 1) {
                Entry entry = (Entry)entryList.get(0);
                if (RangeUtils.inRange((long)hour, (long)hourEnd, (long)entry.millisFrom, (long)entry.millisTo)) {
                    ifaceIndexMap.put((Integer)e.getKey(), new HourEntry(entry.iface, null));
                    continue;
                }
            }
            ifaceIndexMap.put((Integer)e.getKey(), new HourEntry(null, entryList.toArray(new Entry[entryList.size()])));
        }
        return ifaceIndexMap;
    }

    private Hour getHour(Long hour) {
        Hour currentHour = this.ifaceIndexHourCurrent;
        if (currentHour != null && currentHour.hour == hour) {
            return currentHour;
        }
        currentHour = (Hour)this.ifaceIndexHourMap.get(hour);
        if (currentHour != null) {
            this.ifaceIndexHourCurrent = currentHour;
            return currentHour;
        }
        Map<Integer, HourEntry> ifaceIndexMap = this.buildIfaceIndexMap(hour);
        Hour newHour = new Hour(hour, ifaceIndexMap);
        currentHour = this.ifaceIndexHourMap.putIfAbsent(hour, newHour);
        if (currentHour == null) {
            currentHour = newHour;
        } else {
            long minHour = hour - 86400000L;
            Iterator iter = this.ifaceIndexHourMap.keySet().iterator();
            while (iter.hasNext()) {
                if ((Long)iter.next() >= minHour) continue;
                iter.remove();
            }
        }
        this.ifaceIndexHourCurrent = currentHour;
        return currentHour;
    }

    public FlowAgentInterface getInterface(Long hour, long millis, int ifIndex) {
        Hour hourItem = this.getHour(hour);
        HourEntry hourEntry = hourItem.ifaceMap.get(ifIndex);
        if (hourEntry == null) {
            return null;
        }
        if (hourEntry.iface != null) {
            return hourEntry.iface;
        }
        for (Entry entry : hourEntry.ifaceList) {
            if (!RangeUtils.inRange((long)millis, (long)millis, (long)entry.millisFrom, (long)entry.millisTo)) continue;
            return entry.iface;
        }
        return null;
    }

    public Set<Integer> ifIndexSet(long millis) {
        Long hour = InetUtils.getHour(millis);
        Hour hourItem = this.getHour(hour);
        return hourItem.ifaceMap.keySet();
    }

    public Map<Integer, FlowAgentInterface> getIfaceMap() {
        return this.ifaceMap;
    }

    static class Entry {
        final long millisFrom;
        final long millisTo;
        final FlowAgentInterface iface;

        public Entry(long millisFrom, long millisTo, FlowAgentInterface iface) {
            this.millisFrom = millisFrom;
            this.millisTo = millisTo;
            this.iface = iface;
        }
    }

    static class HourEntry {
        final FlowAgentInterface iface;
        final Entry[] ifaceList;

        public HourEntry(FlowAgentInterface iface, Entry[] ifaceList) {
            this.iface = iface;
            this.ifaceList = ifaceList;
        }
    }

    static class Hour {
        final long hour;
        final Map<Integer, HourEntry> ifaceMap;

        public Hour(long hour, Map<Integer, HourEntry> ifaceMap) {
            this.hour = hour;
            this.ifaceMap = ifaceMap;
        }
    }
}

