/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate.day;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RecalculateDAO;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.SessionRecalculateTarifficationManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class RecalculateDayDAO
extends RecalculateDAO {
    protected static final String DELETE_INVALID_SESSION_ACCOUNT_LOG_FOR_CONTRACT_TEMPLATE = "DELETE FROM  account USING sessionAccountTableName as account LEFT JOIN sessionTableName  AS session  ON account.sessionId = session.id WHERE  account.contractId = ? AND account.sessionId  NOT IN (sessionSet) AND ( session.id IS NULL OR (sessionStart >= ? AND sessionStart < ?) ) ";
    private static final String INSERT_CONTRACT_ACCOUNT_FROM_SESSION_LOG_TEMPLATE = " INSERT INTO contract_account( yy, mm, cid, sid, summa )  SELECT ?, ?, contractId, serviceId,  SUM(account) from sessionAccountTableName WHERE contractId = ?  GROUP BY serviceId";
    private PreparedStatement insertContractAccountFromSessionLogPS;

    public RecalculateDayDAO(Date dateFrom, Date dateTo, int moduleId, Connection con) throws SQLException {
        super(dateFrom, dateTo, moduleId, con);
    }

    @Override
    public void flushContract(int contractId, int superContractId, int yy, int mm, Set<Long> affectedSessionsForContract, Map<Integer, BigDecimal> accountMapForContract, Set<Integer> allSids) throws BGException, SQLException {
        this.deleteInvalidSessionAccountLogForContract(this.con, contractId, affectedSessionsForContract);
        this.updateContractAccount(contractId, yy, mm, allSids);
    }

    protected void deleteInvalidSessionAccountLogForContract(Connection con, int contractId, Set<Long> affectedSessionsForContract) throws SQLException {
        int idx = 1;
        PreparedStatement deleteInvalidSessionAccountLogForContractPS = con.prepareStatement(DELETE_INVALID_SESSION_ACCOUNT_LOG_FOR_CONTRACT_TEMPLATE.replaceAll("sessionAccountTableName", this.sessionAccountLogTableName).replaceAll("sessionTableName", this.sessionLogTableName).replace("sessionSet", Utils.toString(affectedSessionsForContract)));
        deleteInvalidSessionAccountLogForContractPS.setInt(idx++, contractId);
        deleteInvalidSessionAccountLogForContractPS.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.dateFrom));
        deleteInvalidSessionAccountLogForContractPS.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.dateTo));
        deleteInvalidSessionAccountLogForContractPS.executeUpdate();
        deleteInvalidSessionAccountLogForContractPS.close();
    }

    @Override
    public void init() throws SQLException {
        super.init();
        this.insertContractAccountFromSessionLogPS = this.con.prepareStatement(INSERT_CONTRACT_ACCOUNT_FROM_SESSION_LOG_TEMPLATE.replaceAll("sessionAccountTableName", this.sessionAccountLogTableName));
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.insertContractAccountFromSessionLogPS.close();
    }

    protected void updateContractAccount(int contractId, int yy, int mm, Set<Integer> allSids) throws SQLException {
        this.deleteAllInetAccountFromContract(contractId, allSids);
        int idx = 1;
        this.insertContractAccountFromSessionLogPS.setInt(idx++, yy);
        this.insertContractAccountFromSessionLogPS.setInt(idx++, mm);
        this.insertContractAccountFromSessionLogPS.setInt(idx++, contractId);
        this.insertContractAccountFromSessionLogPS.executeUpdate();
    }

    public void deleteAllInetAccountFromContract(int contractId, Set<Integer> allSids) throws SQLException {
        int yy = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(2) + 1;
        HashSet<Integer> sids = new HashSet<Integer>(allSids);
        if (sids.size() == 0) {
            sids.add(-1);
        }
        String query = " DELETE from contract_account  WHERE cid = ? AND sid IN ( " + Utils.toString(sids) + ")  AND yy = ? AND mm = ? ";
        PreparedStatement deleteContractAccountPS = this.con.prepareStatement(query);
        int idx = 1;
        deleteContractAccountPS.setInt(idx++, contractId);
        deleteContractAccountPS.setInt(idx++, yy);
        deleteContractAccountPS.setInt(idx++, mm);
        deleteContractAccountPS.executeUpdate();
        deleteContractAccountPS.close();
    }

    @Override
    public void removeAllExtraData(Set<Integer> allSids, Set<Integer> cids, int idDivizor, int idRemainder, Set<Integer> affectedContracts) throws BGException, SQLException {
        String andCidPartWithAffected = SessionRecalculateTarifficationManager.getSqlAndcidPartWithAffected(cids, affectedContracts);
        String query = "SELECT account.contractId, account.serviceId,  contract.scid as superContractId  FROM  " + this.sessionAccountLogTableName + " as account LEFT JOIN " + this.sessionLogTableName + " AS session  ON account.sessionId = session.id LEFT JOIN contract on account.contractId = contract.id  WHERE   session.sessionStart >= ? AND session.sessionStart < ? " + andCidPartWithAffected.replace("cid", "account.contractId");
        PreparedStatement ps = this.con.prepareStatement(query);
        int idx = 1;
        ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.dateFrom));
        ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.dateTo));
        SessionRecalculateTarifficationManager.setDivizorAndRemainder(ps, idx, cids, idDivizor, idRemainder);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Integer contractId = rs.getInt("contractId");
            Integer superContractId = rs.getInt("superContractId");
            Pair pair = new Pair((Object)contractId, (Object)superContractId);
            this.contractsForUpdateBalance.add(pair);
        }
        rs.close();
        ps.close();
        String delQuery = "DELETE FROM account  USING " + this.sessionAccountLogTableName + " AS account  LEFT JOIN " + this.sessionLogTableName + " AS session  ON account.sessionId = session.id WHERE   session.sessionStart >= ? AND session.sessionStart < ?  AND  account.contractId = ? ";
        PreparedStatement deleteSessionAccoutPS = this.con.prepareStatement(delQuery);
        deleteSessionAccoutPS.setDate(1, TimeUtils.convertDateToSqlDate((Date)this.dateFrom));
        deleteSessionAccoutPS.setDate(2, TimeUtils.convertDateToSqlDate((Date)this.dateTo));
        for (Pair pair : this.contractsForUpdateBalance) {
            Integer contractId = (Integer)pair.getFirst();
            deleteSessionAccoutPS.setInt(3, contractId);
            deleteSessionAccoutPS.executeUpdate();
        }
    }
}

