/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.common.ParameterMap;

public class MultCostTariffTreeNode
extends DefaultTariffTreeNode<AbstractTariffRequest<ServiceCost>, TariffContext> {
    private static final Logger logger = LogManager.getLogger();
    private final BigDecimal multiplicand;

    public MultCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.multiplicand = parameterMap.getBigDecimal("value", BigDecimal.ONE);
        if (logger.isDebugEnabled()) {
            logger.debug("multiplicand = " + String.valueOf(this.multiplicand));
        }
    }

    public int executeImpl(Long treeNodeId, AbstractTariffRequest<ServiceCost> tariffRequest, TariffContext tariffContext) {
        int result;
        if (tariffRequest.serviceCost != null) {
            if (tariffRequest.serviceCost.getCost() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("tariffRequest.serviceCost.cost(before) = " + String.valueOf(tariffRequest.serviceCost.getCost()));
                }
                tariffRequest.serviceCost.setCost(tariffRequest.serviceCost.getCost().multiply(this.multiplicand, tariffContext.mc));
                if (logger.isDebugEnabled()) {
                    logger.debug("tariffRequest.serviceCost.cost(after) = " + String.valueOf(tariffRequest.serviceCost.getCost()));
                }
                result = 1;
            } else {
                result = 0;
            }
        } else {
            result = 0;
            for (Map.Entry e : tariffRequest.getServiceCost().entrySet()) {
                List serviceCostList = (List)e.getValue();
                if (serviceCostList == null) continue;
                int size = serviceCostList.size();
                for (int j = 0; j < size; ++j) {
                    ServiceCost serviceCost = (ServiceCost)serviceCostList.get(j);
                    if (serviceCost.getCost() == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("tariffRequest.serviceCost.cost(before) = " + String.valueOf(serviceCost.getCost()));
                    }
                    if (BigDecimal.ZERO.compareTo(serviceCost.getCost()) != 0) {
                        serviceCost.setCost(serviceCost.getCost().multiply(this.multiplicand, tariffContext.mc));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("tariffRequest.serviceCost.cost(after) = " + String.valueOf(serviceCost.getCost()));
                    }
                    result = 1;
                }
            }
        }
        return result;
    }
}

