/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server;

import bitel.billing.server.ModuleBase;
import bitel.billing.server.util.MonthForRecalc;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ModuleEntity;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAccountingPeriod;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServOption;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServStatus;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaStateModifyEvent;
import ru.bitel.bgbilling.modules.inet.common.service.AccountingPeriodService;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.bgbilling.modules.inet.server.bean.InetAccountingPeriodDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServMoveManager;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.modules.inet.server.event.InetServStateChangedEvent;
import ru.bitel.bgbilling.modules.inet.server.task.InetRecalculator;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.XMLDatabaseSerializer;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceRange;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceInterfaceService;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public class Module
extends ModuleBase
implements EventListener<Event> {
    private static final String[] PACKAGES = new String[]{Module.class.getPackage().getName()};
    private final Set<Integer> moduleIds = new HashSet<Integer>();

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void lockServiceNow(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.lockService(con, mid, contractRuntime, balance, limit, lightweight, true);
    }

    public void unlockServiceNow(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.unlockService(con, mid, contractRuntime.contractId, lightweight, true);
    }

    public void lockService(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.lockService(con, mid, contractRuntime, balance, limit, lightweight, false);
    }

    private void lockService(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight, boolean balanceInsufficient) throws BGException {
        try (InetServDao inetServDao = new InetServDao(con, moduleId);){
            EventProcessor ep = EventProcessor.getInstance();
            List<InetServ> inetServList = inetServDao.list(contractRuntime.contractId);
            for (InetServ inetServ : inetServList) {
                if (inetServ.getDeviceState() != InetServState.STATE_ENABLE.getCode() || inetServ.getParentId() > 0) continue;
                this.getLogger().info("Sending state disable to inetServ[id: " + inetServ.getId() + "]");
                int accessCode = balanceInsufficient ? AccessCode.BALANCE_INSUFFICIENT.getCode() : AccessCode.CONTRACT_LOCKED.getCode();
                ep.publish((Event)new InetSaStateModifyEvent(moduleId, 0, inetServ, InetServState.STATE_DISABLE.getCode(), accessCode, balanceInsufficient));
                ep.request((QueueEvent)new InetServStateChangedEvent(moduleId, inetServ, InetServState.STATE_ENABLE.getCode(), InetServState.STATE_DISABLE.getCode(), accessCode));
            }
        }
        catch (BGException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public void unlockService(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.unlockService(con, moduleId, contractRuntime.contractId, lightweight, false);
    }

    private void unlockService(Connection con, int moduleId, int contractId, boolean lightweight, boolean now) {
        EventProcessor ep = EventProcessor.getInstance();
        try (InetServDao inetServDao = new InetServDao(con, moduleId);){
            List<InetServ> inetServList = inetServDao.list(contractId);
            for (InetServ inetServ : inetServList) {
                if (inetServ.getDeviceState() != InetServState.STATE_DISABLE.getCode() || inetServ.getParentId() > 0) continue;
                this.getLogger().info("Sending (try) state enable to inetServ[id: " + inetServ.getId() + "]");
                ep.publish((Event)new InetSaStateModifyEvent(moduleId, 0, inetServ, InetServState.STATE_ENABLE.getCode(), AccessCode.AUTHORIZATION_SUCCEEDED.getCode(), true));
                ep.request((QueueEvent)new InetServStateChangedEvent(moduleId, inetServ, InetServState.STATE_DISABLE.getCode(), InetServState.STATE_ENABLE.getCode(), AccessCode.AUTHORIZATION_SUCCEEDED.getCode()));
            }
            if (!lightweight && !now) {
                ep.publish((Event)new ContractModifiedEvent(0, contractId));
            }
        }
        catch (BGException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        if (event instanceof ContractCreateEvent) {
            this.contractCreate(serverContext, moduleId, (ContractCreateEvent)event);
        } else if (event instanceof ContractDeleteEvent) {
            this.contractDelete(serverContext, moduleId, (ContractDeleteEvent)event);
        } else if (event instanceof ContractCloseEvent) {
            this.contractClose(serverContext, moduleId, (ContractCloseEvent)event);
        } else if (event instanceof ContractWrapEvent) {
            this.contractWrap(serverContext, moduleId, (ContractWrapEvent)event);
        } else if (event instanceof ObjectMoveEvent) {
            this.objectMove(serverContext, moduleId, (ObjectMoveEvent)event);
        }
    }

    private void objectMove(ServerContext ctx, int moduleId, ObjectMoveEvent e) throws Exception {
        InetServService servService = (InetServService)ctx.getService(InetServService.class, moduleId);
        for (InetServ serv : servService.inetServList(e.getContractId(), null)) {
            if (serv.getContractObjectId() != e.getObjectId()) continue;
            serv.setContractObjectId(0);
            List optionList = servService.inetServOptionList(serv.getId());
            servService.inetServUpdate(serv, optionList, false, false, 0L);
        }
    }

    private void contractWrap(ServerContext serverContext, int moduleId, ContractWrapEvent event) throws Exception {
        InetServService servService = (InetServService)serverContext.getService(InetServService.class, moduleId);
        AccountingPeriodService periodService = (AccountingPeriodService)serverContext.getService(AccountingPeriodService.class, moduleId);
        InetSessionService sessionService = (InetSessionService)serverContext.getService(InetSessionService.class, moduleId);
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        boolean isFinishCurrentSessions = moduleSetup.getBoolean("wrap.contract.finish.current.sessions", false);
        if (event.isCheck()) {
            for (InetServ serv : servService.inetServList(event.getContractId(), null)) {
                if (serv.getDateFrom() == null) {
                    event.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u0438\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440, \u0441\u0435\u0440\u0432\u0438\u0441 " + serv.getTitle() + " \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f.");
                    return;
                }
                if (!isFinishCurrentSessions) {
                    InetServMoveManager inetServMoveManager = new InetServMoveManager(serverContext.getConnection(), moduleId);
                    try {
                        Date now = new Date();
                        if (!TimeUtils.dateBeforeOrEq((Date)event.getDateOpen(), (Date)now)) continue;
                        inetServMoveManager.checkForCurrentSessions(serv);
                        continue;
                    }
                    finally {
                        inetServMoveManager.close();
                        continue;
                    }
                }
                Date now = new Date();
                if (!TimeUtils.dateBeforeOrEq((Date)event.getDateOpen(), (Date)now)) continue;
                HashSet<Integer> servIds = new HashSet<Integer>();
                servIds.add(serv.getId());
                HashSet<Integer> contracts = new HashSet<Integer>();
                contracts.add(event.getContractId());
                InetSessionDao sessionDao = new InetSessionDao(serverContext.getConnection(), moduleId);
                List<InetSessionLog> sessionLogList = sessionDao.listAsLog(serverContext.getDirectory(InetServType.class, moduleId).list(), null, null, contracts, servIds, null, null, null, 0, 0, true);
                for (InetSessionLog session : sessionLogList) {
                    sessionService.connectionFinish(session.getContractId(), session.getConnectionId());
                }
            }
        } else {
            MonthForRecalc recalcMonths = new MonthForRecalc();
            for (InetServ serv : servService.inetServList(event.getContractId(), null)) {
                Date dateFrom = event.getDateClose();
                Date dateTo = new Date();
                if (TimeUtils.dateBefore((Date)serv.getDateTo(), (Date)dateTo)) {
                    dateTo = serv.getDateTo();
                }
                recalcMonths.addPeriod(dateFrom, dateTo);
                if (serv.getParentId() > 0) continue;
                servService.inetServWrap(serv, event.getToContractId(), event.getDateOpen());
            }
            for (InetAccountingPeriod period : periodService.periodList(event.getContractId())) {
                periodService.periodWrap(period, event.getToContractId(), event.getDateOpen());
            }
            HashSet<Integer> cids = new HashSet<Integer>();
            cids.add(event.getContractId());
            cids.add(event.getToContractId());
            for (Calendar month : recalcMonths.getMonths()) {
                InetRecalculator task = new InetRecalculator(month.getTime(), null, moduleId, null, cids, "\u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u0430", true);
                new RunTaskDataManager(serverContext.getConnection()).addTask((RunTask)task);
            }
        }
    }

    private void contractCreate(ServerContext ctx, int moduleId, ContractCreateEvent e) throws Exception {
        Integer activateModuleId;
        Document dataDoc = e.getPattern().getData();
        Element addInetServEl = XMLUtils.selectElement((Node)dataDoc, (String)("data/modules/inet[@mid=" + moduleId + "]/addInetServ[@enable=1]"));
        Map params = e.getParams();
        if (params != null && (activateModuleId = (Integer)params.get("moduleId")) != null && activateModuleId == moduleId && addInetServEl == null) {
            e.setError("\u0412 \u0448\u0430\u0431\u043b\u043e\u043d\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u043c\u043e\u0434\u0443\u043b\u044f inet!");
            return;
        }
        if (addInetServEl != null) {
            Integer deviceIdInteger;
            int inetServTypeId = Utils.parseInt((String)addInetServEl.getAttribute("inetServTypeId"), (int)0);
            InetServType servType = (InetServType)ctx.getDirectory(InetServType.class, moduleId).get(inetServTypeId);
            Preferences servTypeConfig = new Preferences(servType.getConfig(), "\n\r");
            int deviceId = servTypeConfig.getInt("const.device.id", -1);
            Card card = null;
            if (params != null && (card = (Card)params.get(Card.class.getName())) != null && deviceId <= 0 && (deviceIdInteger = (Integer)params.get("deviceId")) != null) {
                deviceId = deviceIdInteger;
            }
            InetServService servService = (InetServService)ctx.getService(InetServService.class, moduleId);
            ResourceService resourceService = (ResourceService)ctx.getService(ResourceService.class, moduleId);
            DeviceInterfaceService interfaceService = (DeviceInterfaceService)ctx.getService(DeviceInterfaceService.class, moduleId);
            InetDeviceService inetDeviceService = (InetDeviceService)ctx.getService(InetDeviceService.class, moduleId);
            InetServ serv = new InetServ();
            serv.setTypeId(inetServTypeId);
            serv.setContractId(e.getContractId());
            serv.setDateFrom(e.getDateFrom());
            serv.setDateTo(e.getDateTo());
            serv.setStatus(Optional.ofNullable(InetServStatus.getInetServStatus((int)Utils.parseInt((String)addInetServEl.getAttribute("status")))).orElse(InetServStatus.STATUS_ON));
            if (deviceId <= 0) {
                e.setError("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d const.device.id \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0442\u0438\u043f\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u0430.");
                return;
            }
            serv.setDeviceId(deviceId);
            if (servType.isSessionCountLimitLock()) {
                serv.setSessionCountLimit(servType.getSessionCountLimit());
            } else {
                serv.setSessionCountLimit(Utils.parseInt((String)addInetServEl.getAttribute("sessionCountLimit"), (int)servType.getSessionCountLimit()));
            }
            if (servType.isNeedVlan()) {
                Set vlanResourceCategoryIds = servService.vlanResourceCategoryIds(serv.getDeviceId());
                Integer vlanId = resourceService.freeVlan(vlanResourceCategoryIds, serv.getDateFrom(), serv.getDateTo());
                if (vlanId == null) {
                    e.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c vlan \u0441\u0435\u0440\u0432\u0438\u0441\u0443.");
                    return;
                }
                serv.setVlan(vlanId.intValue());
            }
            if (servType.isNeedInterface()) {
                InetDevice inetDevice = inetDeviceService.inetDeviceGet(serv.getDeviceId());
                Integer ifaceId = interfaceService.nextFreeInterface(inetDevice.getInvDeviceId(), serv.getDateFrom(), serv.getDateTo());
                if (ifaceId == null) {
                    e.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u0441\u0435\u0440\u0432\u0438\u0441\u0443.");
                    return;
                }
                serv.setInterfaceId(ifaceId.intValue());
            }
            switch (servType.getAddressType()) {
                case SINGLE_IPV4: {
                    List ipResourceCategoryIds = servService.ipResourceCategoryIds(serv.getDeviceId(), serv.getInterfaceId(), serv.getTypeId());
                    List rangeList = resourceService.freeIpResourceRangeList((Collection)ipResourceCategoryIds, null, serv.getDateFrom(), serv.getDateTo(), 1, 1, null);
                    this.getLogger().debug("ipResourceCategoryIds = {}", (Object)Utils.toString((Iterable)ipResourceCategoryIds));
                    this.getLogger().debug("rangeList = {}", (Object)(rangeList == null ? "null" : rangeList.get(0)));
                    if (rangeList != null && rangeList.size() > 0) {
                        IpResourceRange range = (IpResourceRange)rangeList.get(0);
                        serv.setIpResourceId(range.getIpResourceId());
                        serv.setAddressFrom(range.getAddressFrom());
                        break;
                    }
                    e.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c IP-\u0430\u0434\u0440\u0435\u0441 \u0441\u0435\u0440\u0432\u0438\u0441\u0443.");
                    return;
                }
            }
            ArrayList<InetServOption> servOptionList = new ArrayList<InetServOption>();
            for (Element servOptionEl : XMLUtils.selectElements((Node)addInetServEl, (String)"inetServOption")) {
                int optionId = Utils.parseInt((String)servOptionEl.getAttribute("optionId"), (int)0);
                if (optionId <= 0) continue;
                InetServOption option = new InetServOption();
                option.setDateFrom(e.getDateFrom());
                option.setOptionId(optionId);
                servOptionList.add(option);
            }
            if (!e.isCheck()) {
                long saWaitTimout = 0L;
                if (card != null) {
                    serv.setLogin(String.valueOf(card.getCardCode()));
                    serv.setPassword(card.getCardPinCode());
                    saWaitTimout = 10000L;
                }
                servService.inetServUpdate(serv, servOptionList, card == null, card == null, saWaitTimout);
            }
        }
    }

    private void contractDelete(ServerContext ctx, int moduleId, ContractDeleteEvent e) throws Exception {
        InetServService servService = (InetServService)ctx.getService(InetServService.class, moduleId);
        if (e.isCheck()) {
            try {
                List servList = servService.inetServList(e.getContractId(), null);
                for (InetServ serv : servList) {
                    servService.inetServIsActive(serv);
                }
            }
            catch (Exception ex) {
                e.setError(ModuleCache.getInstance().getModule(moduleId).getTitle() + ": " + ex.getMessage());
            }
        } else {
            List servList = servService.inetServList(e.getContractId(), null);
            for (InetServ serv : servList) {
                if (serv.getParentId() != 0) continue;
                servService.inetServDelete(serv.getId(), false);
            }
            new InetAccountingPeriodDao(ctx.getConnection(), moduleId, e.getUserId()).deleteForContract(e.getContractId());
        }
    }

    private void contractClose(ServerContext ctx, int moduleId, ContractCloseEvent e) throws Exception {
        InetServService inetService = (InetServService)ctx.getService(InetServService.class, moduleId);
        List list = inetService.inetServList(e.getContractId(), null);
        if (e.isCheck()) {
            for (InetServ serv : list) {
                if (serv.getDateTo() == null || TimeUtils.dateBeforeOrEq((Date)serv.getDateTo(), (Date)e.getDate())) continue;
                e.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u0441\u0435\u0440\u0432\u0438\u0441 \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u0443 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u043e\u0437\u0436\u0435 \u0434\u0430\u0442\u044b \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.");
            }
        } else {
            Date now = new Date();
            for (InetServ serv : list) {
                if (serv.getDateTo() != null && !TimeUtils.dateBefore((Date)now, (Date)serv.getDateTo())) continue;
                serv.setDateTo(e.getDate());
                inetService.inetServUpdate(serv, inetService.inetServOptionList(serv.getId()), false, false, 0L);
            }
        }
    }

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        String cidStr = String.valueOf(cid);
        String tableName = "inet_serv_" + mid;
        String typesTableName = "inet_serv_type_" + mid;
        String devicesTableName = "inet_device_tree_" + mid;
        String invDevicesTableName = "inv_device_" + mid;
        String query = "SELECT inet_serv.*, serv_type.title as _typeTitle, device.title as _deviceTitle, invDevice.comment as _deviceComment, CAST(INET_NTOA(CONV(HEX(inet_serv.addressFrom), 16, 10)) AS CHAR) AS _addressFrom, CAST(INET_NTOA(CONV(HEX(inet_serv.addressTo), 16, 10)) AS CHAR) AS _addressTo   FROM " + tableName + " as inet_serv LEFT JOIN " + typesTableName + " as serv_type ON serv_type.id=inet_serv.typeId  LEFT JOIN " + devicesTableName + " as device ON device.id=inet_serv.deviceId LEFT JOIN " + invDevicesTableName + " as invDevice ON device.invDeviceId=invDevice.id  WHERE contractId=" + cidStr + " ORDER BY IF(inet_serv.parentId>0, inet_serv.parentId, inet_serv.id), inet_serv.parentId";
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery(query);
        new XMLDatabaseSerializer(tables).addItemsFromRS(tableName, null, null, rs);
        st.close();
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("inet_accounting_period_" + mid), (String)"contractId", (String)cidStr, null, (boolean)false, null, null);
    }

    public List<ModuleEntity> getObjectEntities(Connection con, int moduleId, int objectId) throws Exception {
        ArrayList<ModuleEntity> result = new ArrayList<ModuleEntity>();
        try (ContractObjectDao objectDao = new ContractObjectDao(con, 0);
             InetServDao servDao = new InetServDao(con, moduleId);){
            ContractObject object = (ContractObject)objectDao.get(objectId);
            InetServ root = servDao.tree(object.getContractId());
            if (root.getChildren() == null) {
                ArrayList<ModuleEntity> arrayList = result;
                return arrayList;
            }
            for (InetServ inetServ : root.getChildren()) {
                if (inetServ.getContractObjectId() != objectId) continue;
                ModuleEntity entity = new ModuleEntity();
                entity.setName("\u0421\u0435\u0440\u0432\u0438\u0441");
                entity.setData(inetServ.getTitle());
                entity.setComment(inetServ.getComment());
                entity.setPeriod(TimeUtils.formatPeriod((Date)inetServ.getDateFrom(), (Date)inetServ.getDateTo()));
                result.add(entity);
            }
        }
        return result;
    }

    public void start(Connection con, BGModule module) throws Exception {
        boolean firstCall = this.moduleIds.size() == 0;
        this.moduleIds.add(module.getId());
        super.start(con, module);
        EventProcessor eventProcessor = EventProcessor.getInstance();
        if (firstCall) {
            eventProcessor.addListener((EventListener)this, ContractStatusChangedEvent.class);
        }
        InetDeviceDao.checkTables(con, module.getId(), new Date());
    }

    public void notify(Event _e, EventListenerContext ctx) throws BGException {
        if (_e instanceof ContractStatusChangedEvent) {
            ContractStatusChangedEvent e = (ContractStatusChangedEvent)_e;
            ConnectionSet connectionSet = ctx.getConnectionSet();
            StatusCache statusCache = StatusCache.getInstance();
            int contractId = e.getContractId();
            ConvergenceBalance balance = ConvergenceBalanceManager.getInstance().getBalance(connectionSet, Integer.valueOf(contractId), System.currentTimeMillis());
            boolean balanceOk = balance.isBalanceExceedsLimit();
            if (balanceOk) {
                return;
            }
            for (Integer moduleId : this.moduleIds) {
                if (!statusCache.isModuleActiveStatus(moduleId.intValue(), e.getStatus().getStatus())) continue;
                this.unlockService(connectionSet.getConnection(), moduleId, contractId, false, false);
            }
        }
    }
}

