/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.enaza.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.enaza.common.bean.EnazaTransaction;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaException;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaTransactionDao;
import ru.bitel.bgbilling.modules.enaza.server.bean.event.GetChargeTypeEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;

public class EnazaBalanceManager {
    private EnazaTransactionDao dao;
    private Connection con;
    private int mid;
    private ModuleSetup moduleSetup;

    public EnazaBalanceManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    private EnazaTransactionDao getDao() {
        return this.dao != null ? this.dao : (this.dao = new EnazaTransactionDao(this.con, this.mid));
    }

    private ModuleSetup getModuleSetup() {
        return this.moduleSetup != null ? this.moduleSetup : (this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.mid)));
    }

    public EnazaTransaction checkTransaction(Long orderId) throws Exception {
        return this.getDao().get(orderId);
    }

    public EnazaTransaction checkTransaction(EnazaTransaction transaction) throws Exception {
        EnazaTransaction oldTransaction = this.checkTransaction(transaction.getOrderId().longValue());
        return oldTransaction != null ? oldTransaction : transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnazaTransaction chargeTransaction2(EnazaTransaction transaction) throws Exception {
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            if (transaction.getChargeId() > 0) {
                EnazaTransaction enazaTransaction = transaction;
                return enazaTransaction;
            }
            this.moduleSetup = this.getModuleSetup();
            int chargeType = this.getEnazaChargeType((ParameterMap)this.moduleSetup);
            Date now = new Date();
            GetChargeTypeEvent event = (GetChargeTypeEvent)EventProcessor.getInstance().request((QueueEvent)new GetChargeTypeEvent(this.mid, transaction.getContractId(), 0, transaction.getProductType().intValue(), transaction.getAmount(), chargeType));
            if (!event.isLock()) {
                if (event.getChargeType() != -1) {
                    boolean useLimit = this.moduleSetup.getBoolean("enaza.use_limit", false);
                    if (!this.isChargeAcceptable(bu, now, transaction.getContractId(), event.getAmount(), useLimit)) {
                        throw new EnazaException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432!");
                    }
                    Charge charge = Charge.builder().setDate(new Date()).setContractId(transaction.getContractId()).setComment("\u041f\u043b\u0430\u0442\u0435\u0436 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 Enaza \u043f\u043e \u0437\u0430\u043a\u0430\u0437\u0443 \u2116" + String.valueOf(transaction.getOrderId())).setSum(event.getAmount()).setTypeId(chargeType).build();
                    new ChargeDao(this.con).update((Object)charge);
                    ServerUtils.commitConnection((Connection)this.con);
                    bu.updateBalance(now, transaction.getContractId());
                    EventProcessor.getInstance().publish((Event)new ChargeEvent(0, charge));
                    transaction.setChargeId(charge.getId());
                    bu.close();
                } else {
                    transaction.setChargeId(-1);
                }
                transaction.setDate(now);
                transaction.setStatus(EnazaTransaction.STATUS_OK);
            }
        }
        finally {
            this.getDao().update(transaction);
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnazaTransaction chargeTransaction3(EnazaTransaction transaction, Contract contract) throws Exception {
        if (transaction.getChargeId() > 0) {
            return transaction;
        }
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            if ("1".equals(transaction.getServiceId())) {
                this.moduleSetup = this.getModuleSetup();
                int chargeType = this.getEnazaChargeType((ParameterMap)this.moduleSetup);
                GetChargeTypeEvent event = (GetChargeTypeEvent)EventProcessor.getInstance().request((QueueEvent)new GetChargeTypeEvent(this.mid, transaction.getContractId(), 0, transaction.getProductType().intValue(), transaction.getAmount(), chargeType));
                if (!event.isLock()) {
                    if (event.getChargeType() != -1) {
                        boolean useLimit = this.moduleSetup.getBoolean("enaza.use_limit", false);
                        if (!this.isChargeAcceptable(bu, transaction.getDate(), contract, event.getAmount(), useLimit)) {
                            transaction.setStatus(-1);
                        } else {
                            Charge charge = Charge.builder().setDate(transaction.getDate()).setContractId(transaction.getContractId()).setComment("\u041f\u043b\u0430\u0442\u0435\u0436 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 Enaza \u043f\u043e \u0437\u0430\u043a\u0430\u0437\u0443 \u2116" + String.valueOf(transaction.getOrderId()) + " [" + String.valueOf(transaction) + "]").setSum(event.getAmount()).setTypeId(chargeType).build();
                            new ChargeDao(this.con).update((Object)charge);
                            ServerUtils.commitConnection((Connection)this.con);
                            bu.updateBalance(transaction.getDate(), transaction.getContractId());
                            EventProcessor.getInstance().publish((Event)new ChargeEvent(0, charge));
                            transaction.setChargeId(charge.getId());
                        }
                        bu.close();
                    } else {
                        transaction.setChargeId(-1);
                    }
                    transaction.setStatus(EnazaTransaction.STATUS_OK);
                }
            }
        }
        finally {
            this.getDao().update(transaction);
        }
        return transaction;
    }

    private boolean isChargeAcceptable(BalanceUtils bu, Date date, Contract contract, BigDecimal amount, boolean useLimit) throws EnazaException {
        BigDecimal limit;
        if (contract == null) {
            throw new EnazaException("contract is null!");
        }
        BigDecimal balance = bu.getBalance(date, contract);
        boolean enoughBalance = useLimit ? balance.subtract(limit = contract.getBalanceLimit()).compareTo(amount) >= 0 : balance.compareTo(amount) >= 0;
        return enoughBalance;
    }

    private boolean isChargeAcceptable(BalanceUtils bu, Date date, int contractId, BigDecimal amount, boolean useLimit) throws Exception {
        Contract contract = ContractDao.getContract((Connection)this.con, (int)contractId);
        if (contract == null) {
            throw new EnazaException("Contract with id=" + contractId + " NOT FOUND!");
        }
        return this.isChargeAcceptable(bu, date, contract, amount, useLimit);
    }

    private int getEnazaChargeType(ParameterMap moduleSetup) {
        return moduleSetup.getInt("enaza.charge.type", 1);
    }
}

