/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.enaza.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.modules.enaza.common.bean.EnazaTransaction;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaAccessTokenDao;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaBalanceManager;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaException;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaTransactionDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;

@WebServlet(name="EnazaApi", urlPatterns={"/enaza_api/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final Pattern slashPattern = Pattern.compile("/");

    public void init() {
        this.setup = Setup.getSetup();
        System.getProperties().setProperty("networkaddress.cache.ttl", "3600");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().write("POST expected!");
        response.getWriter().flush();
        response.getWriter().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block82: {
            con = null;
            try {
                moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
                if (moduleId <= 0) {
                    throw new BGException("Invalid URL: mid missing!");
                }
                con = this.setup.getDBConnectionFromPool();
                con.setAutoCommit(false);
                moduleSetup = this.setup.getModuleSetup(Integer.valueOf(moduleId));
                protocolVersion = moduleSetup.getInt("enaza.protocol.version", 2);
                if (protocolVersion == 3) {
                    type = this.getRequestType(request);
                    if (type == null) {
                        throw new BGException("Invalid request URL!");
                    }
                    responseType = null;
                    enazaResponse = null;
                    enazaError = new EnazaError(this);
                    enazaSecret = moduleSetup.get("enaza3.password", "123456");
                    scope = moduleSetup.get("enaza3.scope", "client_id service_id tariff_name email phone balance");
                    if ("login".equals(type)) {
                        enazaLoginRequest3 = new EnazaLoginRequest3(request);
                        responseType = enazaLoginRequest3.responseType;
                        enazaResponse = new EnazaResponse(this, "access");
                        enazaError = enazaLoginRequest3.checkHash(enazaSecret);
                        accessToken = "";
                        if (enazaError != null && "".equals(enazaError.error)) {
                            enazaError.error = "access_denied";
                            enazaError.errorDescription = "IP \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d";
                        }
                        enazaResponse.paramMap.put("access_token", accessToken);
                        enazaResponse.paramMap.put("scope", scope);
                    } else if ("access".equals(type)) {
                        enazaAccessRequest3 = new EnazaAccessRequest3(request);
                        responseType = enazaAccessRequest3.responseType;
                        enazaResponse = new EnazaResponse(this, "access");
                        enazaError = enazaAccessRequest3.checkHash(enazaSecret);
                        if (enazaError != null && "".equals(enazaError.error)) {
                            code = enazaAccessRequest3.code;
                            if (code != null) {
                                enazaAccessTokenDao = new EnazaAccessTokenDao(con, moduleId);
                                enazaAccessToken /* !! */  = enazaAccessTokenDao.getEnazaAccessTokenByCode(code);
                                if (enazaAccessToken /* !! */  != null) {
                                    enazaAccessToken /* !! */ .setAccessToken(enazaAccessToken /* !! */ .generate());
                                    enazaAccessToken /* !! */ .setAccessTokenCreate(new Date());
                                    enazaAccessToken /* !! */ .setCode(null);
                                    enazaAccessToken /* !! */ .setCodeExpire(null);
                                    enazaAccessTokenDao.update((Object)enazaAccessToken /* !! */ );
                                    enazaResponse.paramMap.put("access_token", enazaAccessToken /* !! */ .getAccessToken());
                                } else {
                                    enazaError.error = "invalid_grant";
                                    enazaError.errorDescription = "\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u043a\u043e\u0434 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u0438\u0441\u0442\u0435\u043a \u0441\u0440\u043e\u043a \u0435\u0433\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f";
                                }
                            } else {
                                enazaError.error = "invalid_request";
                                enazaError.errorDescription = "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 code";
                            }
                        }
                        enazaResponse.paramMap.put("scope", scope);
                    } else if ("client".equals(type)) {
                        enazaClientRequest3 = new EnazaClientRequest3(request);
                        responseType = enazaClientRequest3.responseType;
                        enazaResponse = new EnazaResponse(this, "client");
                        enazaError = enazaClientRequest3.checkHash(enazaSecret);
                        if (enazaError != null && "".equals(enazaError.error)) {
                            requestScopes = Utils.toSet((String)enazaClientRequest3.scope.replaceAll(" ", ","));
                            availableScope = Utils.toList((String)scope.replaceAll(" ", ","));
                            if (Utils.notEmptyCollection((Collection)requestScopes)) {
                                for (String requestScope : requestScopes) {
                                    if (availableScope.contains(requestScope)) continue;
                                    enazaError.error = "invalid_scope";
                                    enazaError.errorDescription = "Request scope '" + requestScope + "' not available!";
                                    break;
                                }
                            }
                            if ("".equals(enazaError.error)) {
                                accessToken = enazaClientRequest3.accessToken;
                                enazaAccessToken = new EnazaAccessTokenDao(con, moduleId).getEnazaAccessTokenByAccessToken(accessToken);
                                if (enazaAccessToken != null) {
                                    contractId = enazaAccessToken.getContractId();
                                    contractDao = new ContractDao(con, 0);
                                    try {
                                        contract = (Contract)contractDao.get(contractId);
                                        if (contract == null) ** GOTO lbl199
                                        contractStatus = new ContractStatusDao(con).getStatus(contractId, LocalDate.now());
                                        statusIds = Utils.toIntegerSet((String)moduleSetup.get("enaza3.contract.status.active.ids", null));
                                        if (contractStatus == null || statusIds.contains(contractStatus.getStatus())) {
                                            for (String paramName : availableScope) {
                                                if (Utils.notEmptyCollection((Collection)requestScopes) && !requestScopes.contains(paramName)) continue;
                                                if ("client_id".equals(paramName)) {
                                                    enazaResponse.paramMap.put("client_id", contract.getTitle());
                                                    continue;
                                                }
                                                if ("service_id".equals(paramName)) {
                                                    contractTariffDao = new ContractTariffDao(con);
                                                    str = new StringBuilder();
                                                    for (ContractTariff contractTariff : contractTariffDao.list(contractId, LocalDate.now())) {
                                                        serviceIds = moduleSetup.get("enaza3.tariff.service.ids." + contractTariff.getTariffPlanId(), null);
                                                        if (serviceIds == null) continue;
                                                        if (str.length() > 0) {
                                                            str.append(" ");
                                                        }
                                                        str.append(serviceIds);
                                                    }
                                                    if (str.length() <= 0) continue;
                                                    enazaResponse.paramMap.put("service_id", str.toString());
                                                    continue;
                                                }
                                                if ("tariff_name".equals(paramName)) {
                                                    tariffPlanDao = new TariffPlanDao(con);
                                                    try {
                                                        contractTariffDao = new ContractTariffDao(con);
                                                        tariffPlanMap = tariffPlanDao.getTariffPlanMap();
                                                        str = new StringBuilder();
                                                        for (ContractTariff contractTariff : contractTariffDao.list(contractId, LocalDate.now())) {
                                                            tariffPlan = (TariffPlan)tariffPlanMap.get(contractTariff.getTariffPlanId());
                                                            if (tariffPlan == null) continue;
                                                            if (str.length() > 0) {
                                                                str.append(" ");
                                                            }
                                                            str.append(tariffPlan.getTitle());
                                                        }
                                                        if (str.length() <= 0) continue;
                                                        enazaResponse.paramMap.put("tariff_name", str.toString());
                                                        continue;
                                                    }
                                                    finally {
                                                        tariffPlanDao.close();
                                                        continue;
                                                    }
                                                }
                                                if ("email".equals(paramName)) {
                                                    emailParamId = moduleSetup.getInt("enaza3.email.param.id", 0);
                                                    if (emailParamId <= 0 || (email = (String)contractDao.optContractParameterEmailFirst(contractId, emailParamId).orElse(null)) == null) continue;
                                                    enazaResponse.paramMap.put("email", email);
                                                    continue;
                                                }
                                                if ("phone".equals(paramName)) {
                                                    phoneParamId = moduleSetup.getInt("enaza3.phone.param.id", 0);
                                                    if (phoneParamId <= 0 || !(attrPhone = contractDao.getContractParameterPhone(contractId, phoneParamId)).isPresent()) continue;
                                                    enazaResponse.paramMap.put("phone", ((EntityAttrPhone)attrPhone.get()).getContactList().stream().map((Function<EntityAttrPhone.PhoneContact, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPhone(), (Lru/bitel/oss/kernel/entity/common/bean/EntityAttrPhone$PhoneContact;)Ljava/lang/String;)()).collect(Collectors.joining(" ")));
                                                    continue;
                                                }
                                                if (!"balance".equals(paramName)) continue;
                                                bu = new BalanceUtils(con);
                                                try {
                                                    enazaResponse.paramMap.put("balance", bu.getBalance(LocalDate.now(), contractId).toPlainString());
                                                }
                                                finally {
                                                    bu.close();
                                                }
                                            }
                                        }
                                        enazaError.error = "invalid_agreement";
                                        enazaError.errorDescription = "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430 \u0437\u0430\u043a\u0440\u044b\u0442/\u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430";
                                    }
                                    finally {
                                        contractDao.close();
                                    }
                                }
                            } else {
                                enazaError.error = "invalid_grant";
                                enazaError.errorDescription = "\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d";
                            }
                        }
                    } else if ("order".equals(type)) {
                        enazaOrderRequest3 = new EnazaOrderRequest3(request);
                        responseType = enazaOrderRequest3.responseType;
                        enazaResponse = new EnazaResponse(this, "order");
                        enazaError = enazaOrderRequest3.checkHash(enazaSecret);
                        if (enazaError != null && "".equals(enazaError.error)) {
                            date = new Date();
                            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            enazaResponse.paramMap.put("order_id", enazaOrderRequest3.orderId);
                            enazaResponse.paramMap.put("amount", enazaOrderRequest3.amount.toPlainString());
                            enazaResponse.paramMap.put("client_id", enazaOrderRequest3.clientId);
                            enazaResponse.paramMap.put("region_id", moduleSetup.getInt("enaza3.region.id", 0));
                            enazaResponse.paramMap.put("result", "-4");
                            enazaResponse.paramMap.put("date", dateFormat.format(date));
                            contractDao = new ContractDao(con, 0);
                            contract = contractDao.getByTitle(enazaOrderRequest3.clientId);
                            contractDao.close();
                            if (contract != null) {
                                manager = new EnazaBalanceManager(con, moduleId);
                                enazaTransaction = manager.checkTransaction(this.parseTransaction3(enazaOrderRequest3));
                                enazaTransaction.setContractId(contract.getId());
                                enazaTransaction = manager.chargeTransaction3(enazaTransaction, contract);
                                enazaResponse.paramMap.put("result", enazaTransaction.getStatus());
                                enazaResponse.paramMap.put("payment_id", enazaTransaction.getChargeId());
                            } else {
                                enazaResponse.paramMap.put("result", "-2");
                            }
                        }
                    } else {
                        throw new BGException("Invalid request: type '" + type + "' unknown!");
                    }
lbl199:
                    // 9 sources

                    enazaResponse.paramMap.put("error", enazaError.error);
                    enazaResponse.paramMap.put("error_description", enazaError.errorDescription);
                    con.commit();
                    if (responseType != null && "json".equals(responseType)) {
                        response.setContentType("application/json; charset=utf-8");
                        out = response.getWriter();
                        try {
                            dataMap = new HashMap<String, Map<String, Object>>();
                            dataMap.put(enazaResponse.name, enazaResponse.paramMap);
                            jsonObject = new JSONObject(dataMap);
                            out.print(jsonObject.toString());
                            break block82;
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                    }
                    response.setContentType("text/xml; charset=utf-8");
                    out = response.getOutputStream();
                    try {
                        doc = XMLUtils.newDocument();
                        rootElement = doc.createElement(enazaResponse.name);
                        doc.appendChild(rootElement);
                        for (Map.Entry<String, Object> entry : enazaResponse.paramMap.entrySet()) {
                            XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)rootElement, (String)entry.getKey()), (String)entry.getValue().toString());
                        }
                        XMLUtils.serialize((Node)doc, (OutputStream)out, (String)"utf-8");
                        break block82;
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                response.setContentType("text/plain");
                out = response.getOutputStream();
                try {
                    enazaRequest2 = new EnazaRequest2(this, request);
                    switch (this.parseRequestType(enazaRequest2).ordinal()) {
                        case 1: {
                            this.acceptPayment(response, (OutputStream)out, con, moduleId, moduleSetup, enazaRequest2);
                            ** break;
lbl242:
                            // 1 sources

                            break;
                        }
                        case 0: {
                            transaction = this.parseTransaction2(enazaRequest2, moduleSetup);
                            new EnazaTransactionDao(con, moduleId).update(transaction);
                            defaultUrl = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/bgbilling/webexecuter";
                            response.sendRedirect(moduleSetup.get("bgbilling.webexecuter.url", defaultUrl) + "?mid=" + moduleId + "&module=enaza&action=Enaza&operation=confirmation&orderId=" + String.valueOf(transaction.getOrderId()));
                            ** break;
lbl249:
                            // 1 sources

                            break;
                        }
                        ** default:
lbl251:
                        // 1 sources

                        break;
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
                con.commit();
            }
            catch (Exception ex) {
                try {
                    this.logError(ex);
                    try {
                        con.rollback();
                    }
                    catch (SQLException ex1) {
                        this.logError(ex1);
                    }
                }
                catch (Throwable var32_53) {
                    ServerUtils.closeConnection(con);
                    throw var32_53;
                }
                ServerUtils.closeConnection((Connection)con);
            }
        }
        ServerUtils.closeConnection((Connection)con);
    }

    private String getRequestType(HttpServletRequest request) {
        String type = null;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            String[] params = slashPattern.split(pathInfo);
            switch (params.length) {
                default: {
                    type = params[2];
                }
                case 0: 
                case 1: 
            }
        }
        return type;
    }

    private void acceptPayment(HttpServletResponse response, OutputStream out, Connection con, int mid, ModuleSetup moduleSetup, EnazaRequest2 enazaRequest2) throws Exception {
        EnazaBalanceManager manager = new EnazaBalanceManager(con, mid);
        EnazaTransaction transaction = manager.checkTransaction(this.parseTransaction2(enazaRequest2, moduleSetup));
        try {
            transaction = manager.chargeTransaction2(transaction);
        }
        catch (EnazaException ex) {
            this.logError((Exception)((Object)ex));
        }
        Document doc = XMLUtils.newDocument();
        Element order = XMLUtils.createElement((Document)doc, (String)"order");
        String orderIdVal = String.valueOf(transaction.getOrderId());
        XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)order, (String)"order_id"), (String)orderIdVal);
        String amountVal = Utils.formatBigDecimalSumm((BigDecimal)transaction.getAmount());
        XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)order, (String)"amount"), (String)amountVal);
        String payNumVal = String.valueOf(transaction.getChargeId());
        XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)order, (String)"pay_num"), (String)payNumVal);
        String clientPurseVal = String.valueOf(transaction.getContractId());
        XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)order, (String)"client_purse"), (String)clientPurseVal);
        XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)order, (String)"result"), (String)(transaction.getStatus() == EnazaTransaction.STATUS_OK ? "0" : "1"));
        XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)order, (String)"date"), (String)TimeUtils.format((Date)transaction.getDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)order, (String)"hash"), (String)Utils.getDigest((String)(orderIdVal + amountVal + payNumVal + clientPurseVal + moduleSetup.get("enaza.password", "123456")), (String)"utf-8"));
        response.setContentType("text/xml");
        XMLUtils.serialize((Node)doc, (OutputStream)out, (String)"utf-8");
    }

    private RequestType parseRequestType(EnazaRequest2 request2) {
        if (request2.orderId != null) {
            if (request2.clientPurse != null) {
                return RequestType.ACCEPT_FREE_PAYMENT;
            }
            return RequestType.NEW_PAYMENT;
        }
        return RequestType.CUSTOMER_INFO;
    }

    private EnazaTransaction parseTransaction2(EnazaRequest2 enazaRequest2, ModuleSetup moduleSetup) throws EnazaException {
        String valueForHash = enazaRequest2.orderId + (enazaRequest2.clientPurse != null ? enazaRequest2.clientPurse : "") + enazaRequest2.amount + enazaRequest2.from + moduleSetup.get("enaza.password", "123456");
        String calcHash = Utils.getDigest((String)valueForHash, (String)"utf-8");
        if (!enazaRequest2.hash.toLowerCase().equals(calcHash.toLowerCase())) {
            throw new EnazaException("[checkValidity] Hashes are not equal!");
        }
        EnazaTransaction enazaTransaction = new EnazaTransaction();
        enazaTransaction.setAmount(Utils.parseBigDecimal((String)enazaRequest2.amount, null));
        enazaTransaction.setDate(new Date());
        String desc = enazaRequest2.desc;
        if (Utils.notEmptyString((String)desc)) {
            String[] val = desc.split("=");
            if (val.length > 1) {
                enazaTransaction.setProductType(Utils.parseBigDecimal((String)val[0], (BigDecimal)new BigDecimal(-1)));
                enazaTransaction.setDescription(val[1]);
            } else {
                enazaTransaction.setDescription(enazaRequest2.desc);
            }
        } else {
            enazaTransaction.setDescription("");
        }
        enazaTransaction.setOrderId(Utils.parseBigDecimal((String)enazaRequest2.orderId, (BigDecimal)BigDecimal.ZERO));
        if (enazaRequest2.clientPurse != null) {
            enazaTransaction.setContractId(Utils.parseInt((String)enazaRequest2.clientPurse));
        }
        enazaTransaction.setStatus(EnazaTransaction.STATUS_NEW);
        return enazaTransaction;
    }

    private EnazaTransaction parseTransaction3(EnazaOrderRequest3 enazaOrderRequest3) throws EnazaException {
        EnazaTransaction enazaTransaction = new EnazaTransaction();
        enazaTransaction.setOrderId(enazaOrderRequest3.orderId);
        enazaTransaction.setClientId(enazaOrderRequest3.clientId);
        enazaTransaction.setAmount(enazaOrderRequest3.amount);
        enazaTransaction.setContractGroupId(enazaOrderRequest3.contractGroupId);
        enazaTransaction.setDescription(enazaOrderRequest3.desc);
        enazaTransaction.setServiceId(enazaOrderRequest3.serviceId);
        enazaTransaction.setVat(enazaOrderRequest3.vat);
        enazaTransaction.setProductType(enazaOrderRequest3.productType);
        enazaTransaction.setPriceCategory(enazaOrderRequest3.priceCategoty);
        enazaTransaction.setDate(new Date());
        return enazaTransaction;
    }

    public static String getEnazaBillingUrl(ParameterMap moduleSetup) {
        return moduleSetup.get("enaza.billing.url", "https://billing.enaza.ru/cgi-bin/ppo/halius/ps_payments_gate.result");
    }

    public static String getEnazaRedirectUrl(ParameterMap moduleSetup) {
        return moduleSetup.get("enaza.redirect.url", "https://billing.enaza.ru/cgi-bin/ppo/halius/ps_payments_gate.return");
    }

    private EnazaError checkHash(String str, String hash) {
        EnazaError enazaError = new EnazaError(this);
        if (hash == null || !hash.equals(Utils.getDigest((String)str, (String)"utf-8").toLowerCase())) {
            enazaError = new EnazaError(this, "invalid_request", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 hash");
        }
        return enazaError;
    }

    class EnazaError {
        String error;
        String errorDescription;

        private EnazaError(ModuleExecutor this$0) {
            this(this$0, "", "");
        }

        private EnazaError(ModuleExecutor this$0, String error, String errorDescription) {
            this.error = error;
            this.errorDescription = errorDescription;
        }
    }

    class EnazaLoginRequest3 {
        String ip;
        String shopId;
        String responseType;
        String hash;

        private EnazaLoginRequest3(HttpServletRequest request) {
            this.ip = request.getParameter("ip");
            this.shopId = request.getParameter("shop_id");
            this.responseType = request.getParameter("response_type");
            this.hash = request.getParameter("hash");
        }

        private EnazaError checkHash(String secret) {
            String str = this.ip + this.shopId + secret;
            return ModuleExecutor.this.checkHash(str, this.hash);
        }
    }

    class EnazaResponse {
        String name;
        Map<String, Object> paramMap = new HashMap<String, Object>();

        private EnazaResponse(ModuleExecutor this$0, String name) {
            this.name = name;
        }
    }

    class EnazaAccessRequest3 {
        String code;
        String shopId;
        String responseType;
        String hash;

        private EnazaAccessRequest3(HttpServletRequest request) {
            this.shopId = request.getParameter("shop_id");
            this.code = request.getParameter("code");
            this.responseType = request.getParameter("response_type");
            this.hash = request.getParameter("hash");
        }

        private EnazaError checkHash(String secret) {
            String str = this.shopId + this.code + secret;
            return ModuleExecutor.this.checkHash(str, this.hash);
        }
    }

    class EnazaClientRequest3 {
        String shopId;
        String accessToken;
        String scope;
        String responseType;
        String hash;

        private EnazaClientRequest3(HttpServletRequest request) {
            this.shopId = request.getParameter("shop_id");
            this.accessToken = request.getParameter("access_token");
            this.scope = request.getParameter("scope");
            this.responseType = request.getParameter("response_type");
            this.hash = request.getParameter("hash");
        }

        private EnazaError checkHash(String secret) {
            String str = this.shopId + this.accessToken + this.scope + secret;
            return ModuleExecutor.this.checkHash(str, this.hash);
        }
    }

    class EnazaOrderRequest3 {
        BigDecimal orderId;
        String clientId;
        BigDecimal amount;
        BigDecimal contractGroupId;
        String desc;
        String shopId;
        String serviceId;
        String responseType;
        int vat;
        BigDecimal productType;
        BigDecimal priceCategoty;
        String hash;

        private EnazaOrderRequest3(HttpServletRequest request) {
            this.orderId = new BigDecimal(request.getParameter("order_id"));
            this.clientId = request.getParameter("client_id");
            this.amount = new BigDecimal(request.getParameter("amount"));
            this.contractGroupId = new BigDecimal(request.getParameter("contract_group_id"));
            this.desc = request.getParameter("desc");
            this.shopId = request.getParameter("shop_id");
            this.serviceId = request.getParameter("service_id");
            this.responseType = request.getParameter("response_type");
            this.vat = Utils.parseInt((String)request.getParameter("vat"), (int)3);
            this.productType = Utils.parseBigDecimal((String)request.getParameter("product_type"), (BigDecimal)BigDecimal.ZERO);
            this.priceCategoty = Utils.parseBigDecimal((String)request.getParameter("price_categoty"), (BigDecimal)BigDecimal.ZERO);
            this.hash = request.getParameter("hash");
        }

        private EnazaError checkHash(String secret) {
            String str = this.orderId.toPlainString() + this.clientId + this.amount.toPlainString() + this.shopId + this.serviceId + secret;
            return ModuleExecutor.this.checkHash(str, this.hash);
        }
    }

    class EnazaRequest2 {
        String orderId;
        String clientPurse;
        String amount;
        String desc;
        String from;
        String hash;

        private EnazaRequest2(ModuleExecutor this$0, HttpServletRequest request) {
            this.orderId = request.getParameter("order_id");
            this.clientPurse = request.getParameter("client_purse");
            this.amount = request.getParameter("amount");
            this.desc = request.getParameter("desc");
            this.from = request.getParameter("from");
            this.hash = request.getParameter("hash");
        }
    }

    private static enum RequestType {
        NEW_PAYMENT,
        ACCEPT_FREE_PAYMENT,
        CUSTOMER_INFO;

    }
}

