/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server;

import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.modules.email.common.bean.AttributeValue;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.AttributeValueManager;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.bgbilling.modules.email.server.bean.Forward;
import ru.bitel.bgbilling.modules.email.server.bean.ForwardManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.email.server"};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void moduleAction(ServerContext ctx, int moduleId, Event event) throws Exception {
        block8: {
            ContractWrapEvent cwEvent;
            block9: {
                block6: {
                    AccountManager am;
                    DomainManager dm;
                    block7: {
                        if (!(event instanceof ContractDeleteEvent)) break block6;
                        ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
                        Connection con = ctx.getConnection();
                        dm = new DomainManager(con, moduleId);
                        am = new AccountManager(con, moduleId);
                        if (!cdEvent.isCheck()) break block7;
                        String error = this.existAccounts(cdEvent.getContractId(), moduleId, con, new Date());
                        if (!Utils.notBlankString((String)error)) break block8;
                        cdEvent.setError(error);
                        break block8;
                    }
                    for (Account account : am.getContractAccountList(event.getContractId())) {
                        Domain domain = dm.get(account.getDomainId());
                        if (domain == null) continue;
                        am.deleteAccount(account.getId());
                    }
                    break block8;
                }
                if (!(event instanceof ContractCloseEvent)) break block9;
                ContractCloseEvent ccEvent = (ContractCloseEvent)event;
                if (ccEvent.isCheck()) break block8;
                AccountManager am = new AccountManager(ctx.getConnection(), moduleId);
                for (Account account : am.getContractAccountList(ccEvent.getContractId())) {
                    if (account.getDate2() != null) continue;
                    this.closeAccount(account, ccEvent.getDate(), am);
                }
                break block8;
            }
            if (event instanceof ContractWrapEvent && !(cwEvent = (ContractWrapEvent)event).isCheck()) {
                AccountManager manager = new AccountManager(ctx.getConnection(), moduleId);
                AttributeValueManager attributeValueManager = new AttributeValueManager(ctx.getConnection(), moduleId);
                ForwardManager forwardManager = new ForwardManager(ctx.getConnection(), moduleId);
                for (Account account : manager.getContractAccountList(cwEvent.getContractId(), cwEvent.getDateOpen())) {
                    List<Forward> forwardList;
                    Account accountTransfer = new Account();
                    accountTransfer.setContractId(cwEvent.getToContractId());
                    accountTransfer.setAccount(account.getAccount());
                    accountTransfer.setDomainId(account.getDomainId());
                    accountTransfer.setQuota(account.getQuota());
                    accountTransfer.setStatus(account.getStatus());
                    accountTransfer.setComment(account.getComment());
                    accountTransfer.setPassword(account.getPassword());
                    accountTransfer.setDate1(cwEvent.getDateOpen());
                    accountTransfer.setDate2(account.getDate2());
                    accountTransfer.setNeedOpenAndNeedClose(new Date());
                    manager.updateAccount(accountTransfer);
                    List<AttributeValue> attrList = attributeValueManager.getValueList(account.getId());
                    if (!attrList.isEmpty()) {
                        attributeValueManager.updateValues(accountTransfer.getId(), attrList);
                    }
                    if (!(forwardList = forwardManager.getForwardList(account.getId())).isEmpty()) {
                        forwardManager.updateForwardList(accountTransfer.getId(), forwardList);
                    }
                    if (account.getDate2() != null && !TimeUtils.dateBefore((Date)cwEvent.getDateClose(), (Date)account.getDate2())) continue;
                    this.closeAccount(account, cwEvent.getDateClose(), manager);
                }
            }
        }
    }

    private void closeAccount(Account account, Date closeDate, AccountManager manager) {
        account.setDate2(closeDate);
        account.setNeedOpenAndNeedClose(new Date());
        manager.updateAccount(account);
    }

    private String existAccounts(int cid, int mid, Connection con, Date date) throws Exception {
        String result = null;
        if (new AccountManager(con, mid).getContractAccountsCount(cid, date) > 0) {
            result = "\u0412 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u0438\u043c\u0435\u044e\u0442\u0441\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u043f\u043e\u0447\u0442\u043e\u0432\u044b\u0435 \u0430\u043a\u043a\u0443\u043d\u0442\u044b, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0438\u0445!";
        }
        return result;
    }

    public void serializeContract(Connection con, int contractId, int moduleId, XMLStreamWriter module, boolean onlyCurrent) throws SQLException, XMLStreamException {
        if (onlyCurrent) {
            module.writeStartElement("email_domain_" + moduleId);
            DomainManager domainManager = new DomainManager(con, moduleId);
            for (Domain domain : domainManager.list(null)) {
                module.writeStartElement("domain");
                module.writeAttribute("id", String.valueOf(domain.getId()));
                module.writeAttribute("name", String.valueOf(domain.getName()));
                module.writeEndElement();
            }
            module.writeEndElement();
        }
        List accountList = ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)module, (String)("email_account_" + moduleId), (String)"cid", (String)String.valueOf(contractId), (String)"id", (boolean)false, null, null);
        for (String aid : accountList) {
            ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)module, (String)("email_forward_" + moduleId), (String)"aid", (String)aid, null, (boolean)false, null, null);
            ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)module, (String)("email_attribute_" + moduleId), (String)"aid", (String)aid, null, (boolean)false, null, null);
        }
    }

    public void lockService(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.changeStatus(con, mid, contractRuntime, 0, 2);
    }

    public void unlockService(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.changeStatus(con, mid, contractRuntime, 2, 0);
    }

    public void unlockServiceNow(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.unlockService(con, mid, contractRuntime, balance, limit, lightweight);
    }

    private void changeStatus(Connection con, int mid, ContractRuntime contractRuntime, int from, int to) {
        ModuleSetup moduleSetup = new ModuleSetup(con, mid);
        if (moduleSetup.getInt("change.by.status", 0) == 0) {
            return;
        }
        DomainManager domainManager = new DomainManager(con, mid);
        AccountManager accountManager = new AccountManager(con, mid);
        ForwardManager forwardManager = new ForwardManager(con, mid);
        AttributeValueManager attributeManager = new AttributeValueManager(con, mid);
        for (Account account : accountManager.getContractAccountList(contractRuntime.contractId)) {
            if (account.getStatus() != from) continue;
            try {
                Domain domain = domainManager.get(account.getDomainId());
                if (domain == null) continue;
                account.setStatus(to);
                account.setForwardList(forwardManager.getForwardList(account.getId()));
                account.setAttributes(attributeManager.getValueList(account.getId()));
                if (!TimeUtils.dateInRange((Date)new Date(), (Date)account.getDate1(), (Date)account.getDate2())) continue;
                domainManager.getServiceActivator(domain).modify(account);
                accountManager.updateAccount(account);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public List<MenuItem> getContractWebMenuItems(Connection con, String module, int moduleId, int contractId) throws Exception {
        return this.disableContractWebMenuItems(this.getWebMenuItems(con, module, moduleId), new HashSet());
    }
}

