/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGEditorDialogVPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.PeriodTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.drweb.common.bean.TariffAVD;
import ru.bitel.bgbilling.modules.drweb.common.service.DrWebService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class ServiceConfigTariffs
extends ServiceConfigTabbedPanel {
    private Map<Integer, Service> serviceMap = new HashMap<Integer, Service>();
    private TariffAVDTableModel model = new TariffAVDTableModel();
    private BGUTable table;
    private List<Service> serviceList;

    public ServiceConfigTariffs() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() {
        this.table = new BGUTable((TableModel)((Object)this.model));
        this.table.setSelectionMode(0);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServiceConfigTariffs.this.editItem();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void newItem() {
        new TariffEditorDialog("\u041d\u043e\u0432\u044b\u0439 \u0442\u0430\u0440\u0438\u0444", new TariffAVD()).open();
    }

    public void editItem() {
        this.model.optSelectedRow().ifPresentOrElse(tariffAVD -> new TariffEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430", (TariffAVD)tariffAVD).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f"));
    }

    public void deleteItem() {
        this.model.optSelectedRow().filter(a -> ClientUtils.confirmDelete((Object)a)).ifPresentOrElse(tariffAVD -> {
            try {
                ((DrWebService)this.getContext().getWebService(DrWebService.class, this.getModuleId())).tariffAVDDelete(tariffAVD.getId());
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }, () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444"));
    }

    public void setData() {
        try {
            Async serviceSupplier = Async.of(() -> ((ModuleService)this.getContext().getWebService(ModuleService.class, 0)).serviceList(this.getModuleId()));
            this.model.setData(((DrWebService)this.getContext().getWebService(DrWebService.class, this.getModuleId())).tariffAVDList(-1, false));
            this.serviceMap.clear();
            this.serviceList = (List)serviceSupplier.get();
            this.serviceList.forEach(a -> this.serviceMap.put(a.getId(), (Service)a));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    class TariffAVDTableModel
    extends BGTableModel<TariffAVD> {
        public TariffAVDTableModel() {
            super(TariffAVDTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 150, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", -1, 150, -1, "serviceTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", -1, 150, -1, "serviceTitleForNew", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b", -1, 150, -1, "groupTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c", -1, 150, -1, "dateView", true, (TableCellRenderer)new PeriodTableCellRenderer());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", -1, 150, -1, "dateWork", true, (TableCellRenderer)new PeriodTableCellRenderer());
        }

        public Object getValue(TariffAVD tariffAVD, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            Service service = null;
            switch (identifier) {
                case "serviceTitle": {
                    service = ServiceConfigTariffs.this.serviceMap.get(tariffAVD.getSid());
                    return service == null ? "??? [#" + tariffAVD.getSid() + "]" : service.getTitle();
                }
                case "serviceTitleForNew": {
                    service = ServiceConfigTariffs.this.serviceMap.get(tariffAVD.getSidForNew());
                    return service == null ? "??? [#" + tariffAVD.getSidForNew() + "]" : service.getTitle();
                }
                case "dateView": {
                    return new Period(tariffAVD.getDateFromView(), tariffAVD.getDateToView());
                }
                case "dateWork": {
                    return new Period(tariffAVD.getDateFromWork(), tariffAVD.getDateToWork());
                }
            }
            return super.getValue((Object)tariffAVD, column);
        }
    }

    class TariffEditorDialog
    extends BGEditorDialog<TariffAVD> {
        private IdTitle dummyItem;
        private List<IdTitle> serviceItems;
        private BGTextField title;
        private BGTextField groupTitle;
        private BGUComboBox<IdTitle> services;
        private BGUComboBox<IdTitle> servicesForNew;
        private BGUComboBox<IdTitle> nextTariff;
        private BGControlPanelPeriodNoB workPeriod;
        private BGControlPanelPeriodNoB viewPeriod;
        private BGTextField groupForView;
        private JCheckBox onlyForNew;

        public TariffEditorDialog(String title, TariffAVD data) {
            super(title, (Object)data);
            this.dummyItem = IdTitle.NO_SELECT;
            this.serviceItems = new ArrayList<IdTitle>();
            this.title = new BGTextField(40);
            this.groupTitle = new BGTextField(40);
            this.services = new BGUComboBox();
            this.servicesForNew = new BGUComboBox();
            this.nextTariff = new BGUComboBox();
            this.workPeriod = new BGControlPanelPeriodNoB(false);
            this.viewPeriod = new BGControlPanelPeriodNoB(false);
            this.groupForView = new BGTextField();
            this.onlyForNew = new JCheckBox("\u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u043d\u043e\u0432\u044b\u0445");
        }

        public void doDialogPanel() {
            this.serviceItems.add(this.dummyItem);
            ServiceConfigTariffs.this.serviceList.forEach(a -> this.serviceItems.add(new IdTitle(a.getId(), a.getTitle())));
            this.panel.add((Component)new BGEditorDialogVPanel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", (Component)this.title), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new BGEditorDialogVPanel("\u0413\u0440\u0443\u043f\u043f\u0430", (Component)this.groupTitle), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)new BGEditorDialogVPanel("\u0423\u0441\u043b\u0443\u0433\u0430", this.services), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)new BGEditorDialogVPanel("\u0423\u0441\u043b\u0443\u0433\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", this.servicesForNew), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)new BGEditorDialogVPanel("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0442\u0430\u0440\u0438\u0444", this.nextTariff), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)new BGEditorDialogVPanel("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442", (Component)this.workPeriod), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)new BGEditorDialogVPanel("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c", (Component)this.viewPeriod), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)new BGEditorDialogVPanel("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0441 \u043c\u0435\u0442\u043a\u0430\u043c\u0438 (IDs)", (Component)this.groupForView), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.onlyForNew, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 10, 0), 0, 0));
            this.services.setData(this.serviceItems);
            this.servicesForNew.setData(this.serviceItems);
            ArrayList<IdTitle> tariffs = new ArrayList<IdTitle>();
            tariffs.add(this.dummyItem);
            ServiceConfigTariffs.this.model.getRows().forEach(a -> tariffs.add(new IdTitle(a.getId(), a.getTitle())));
            this.nextTariff.setData(tariffs);
            this.title.setText(((TariffAVD)this.data).getTitle());
            this.groupTitle.setText(((TariffAVD)this.data).getGroupTitle());
            this.services.setSelectedItem((Object)this.serviceItems.stream().filter(a -> a.getId() == ((TariffAVD)this.data).getSid()).findFirst().orElse(this.dummyItem));
            this.servicesForNew.setSelectedItem((Object)this.serviceItems.stream().filter(a -> a.getId() == ((TariffAVD)this.data).getSidForNew()).findFirst().orElse(this.dummyItem));
            this.nextTariff.setSelectedItem((Object)tariffs.stream().filter(a -> a.getId() == ((TariffAVD)this.data).getNextTariff()).findFirst().orElse(this.dummyItem));
            this.viewPeriod.setDateCalendar1(TimeUtils.convertDateToCalendar((Date)((TariffAVD)this.data).getDateFromView()));
            this.viewPeriod.setDateCalendar2(TimeUtils.convertDateToCalendar((Date)((TariffAVD)this.data).getDateToView()));
            this.workPeriod.setDateCalendar1(TimeUtils.convertDateToCalendar((Date)((TariffAVD)this.data).getDateFromWork()));
            this.workPeriod.setDateCalendar2(TimeUtils.convertDateToCalendar((Date)((TariffAVD)this.data).getDateToWork()));
            this.groupForView.setText(((TariffAVD)this.data).getGroupForView());
            this.onlyForNew.setSelected(((TariffAVD)this.data).isOnlyForNew());
        }

        public boolean doApply() throws Exception {
            if (Utils.isBlankString((String)this.title.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            if (((IdTitle)this.services.getSelectedItem()).getId() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443");
                return false;
            }
            if (((IdTitle)this.services.getSelectedItem()).getId() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443");
                return false;
            }
            if (!TimeUtils.periodInRange((Date)this.viewPeriod.getDateFrom(), (Date)this.viewPeriod.getDateTo(), (Date)this.workPeriod.getDateFrom(), (Date)this.workPeriod.getDateTo())) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u0435\u0440\u0438\u043e\u0434 \u043f\u043e\u043a\u0430\u0437\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0440\u0430\u0431\u043e\u0442\u044b");
                return false;
            }
            ((TariffAVD)this.data).setTitle(this.title.getText());
            ((TariffAVD)this.data).setGroupTitle(this.groupTitle.getText());
            ((TariffAVD)this.data).setSid(((IdTitle)this.services.getSelectedItem()).getId());
            ((TariffAVD)this.data).setSidForNew(((IdTitle)this.servicesForNew.getSelectedItem()).getId());
            ((TariffAVD)this.data).setNextTariff(((IdTitle)this.nextTariff.getSelectedItem()).getId());
            ((TariffAVD)this.data).setDateFromView(this.viewPeriod.getDateFrom());
            ((TariffAVD)this.data).setDateToView(this.viewPeriod.getDateTo());
            ((TariffAVD)this.data).setDateFromWork(this.workPeriod.getDateFrom());
            ((TariffAVD)this.data).setDateToWork(this.workPeriod.getDateTo());
            ((TariffAVD)this.data).setGroupForView(this.groupForView.getText());
            ((TariffAVD)this.data).setOnlyForNew(this.onlyForNew.isSelected());
            ((DrWebService)ServiceConfigTariffs.this.getContext().getWebService(DrWebService.class, ServiceConfigTariffs.this.getModuleId())).tariffAVDUpdate((TariffAVD)this.data);
            ServiceConfigTariffs.this.setData();
            return true;
        }
    }
}

