/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.utils;

import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactTypeDao;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;

public final class DispatchUtils
extends AbstractService {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Contact> getContactsFromContractParameters(int contractId, Dispatch dispatch, Connection con) throws BGException {
        int contactTypeId = dispatch.getContactTypeId();
        int typeId = DispatchUtils.getContactTypeIdOfContact(dispatch, con);
        try (ContractDao contractDao = new ContractDao(con, 0);
             ContractParameterManager parameterManager = new ContractParameterManager(con);){
            Optional attrEmail;
            ContactTypeDao contactTypeDao = new ContactTypeDao(con);
            ContactType contactType = contactTypeDao.get(contactTypeId);
            ContractParameterPref paramPref = parameterManager.getParamPref(contactType.getPid());
            if (typeId == ContractParameterPrefType.TYPE_EMAIL.getId() && (attrEmail = contractDao.getContractParameterEmail(contractId, paramPref.getId())).isPresent()) {
                List<Contact> list = DispatchUtils.createContactForSend(((EntityAttrEmail)attrEmail.get()).toString(), contractId, contactTypeId, typeId);
                return list;
            }
            if (typeId != ContractParameterPrefType.TYPE_PHONE.getId()) return new ArrayList<Contact>();
            Optional attrPhone = contractDao.getContractParameterPhone(contractId, paramPref.getId());
            if (!attrPhone.isPresent()) return new ArrayList<Contact>();
            List<Contact> list = DispatchUtils.createContactForSend(((EntityAttrPhone)attrPhone.get()).toString(), contractId, contactTypeId, typeId);
            return list;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public static int getContactTypeIdOfContact(Dispatch dispatch, Connection con) throws BGException {
        int n;
        ContractParameterManager parameterManager = new ContractParameterManager(con);
        try {
            int pid = DispatchUtils.getContactTypePid(dispatch, con);
            n = pid > 0 ? parameterManager.getParamPref(pid).getType().getId() : -1;
        }
        catch (Throwable throwable) {
            try {
                try {
                    parameterManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        parameterManager.close();
        return n;
    }

    public static int getContactTypePid(Dispatch dispatch, Connection con) throws SQLException {
        ContactType contactType = new ContactTypeDao(con).get(dispatch.getContactTypeId());
        if (contactType != null) {
            return contactType.getPid();
        }
        return 0;
    }

    private static List<Contact> createContactForSend(String contactsFromParameters, int contractId, int contactTypeId, int typeId) {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        if (Utils.isBlankString((String)contactsFromParameters)) {
            return contacts;
        }
        DispatchUtils.getCorrectContacts(contactsFromParameters, typeId).forEach(value -> {
            Contact contact = new Contact();
            contact.setValue(value);
            contact.setDefaultValue(value);
            contact.setContractId(contractId);
            contact.setContactTypeId(contactTypeId);
            contact.setId(-1);
            contacts.add(contact);
        });
        return contacts;
    }

    private static List<String> getCorrectContacts(String value, int typeId) {
        String val;
        Matcher matcher;
        ArrayList<String> contacts = new ArrayList<String>();
        if (typeId == ContractParameterPrefType.TYPE_EMAIL.getId()) {
            matcher = Pattern.compile("[-a-z0-9~!$%^&*_=+}{\\'?]+(\\.[-a-z0-9~!$%^&*_=+}{\\'?]+)*@([a-z0-9_][-a-z0-9_]*(\\.[-a-z0-9_]+)*\\.(aero|arpa|biz|com|coop|edu|gov|info|int|mil|museum|name|net|org|pro|travel|mobi|[a-z]{2,5})|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))(:[0-9]{1,5})?", 2).matcher(value);
            while (matcher.find()) {
                val = matcher.group().trim();
                contacts.add(val);
            }
        }
        if (typeId == ContractParameterPrefType.TYPE_PHONE.getId()) {
            matcher = Pattern.compile("\\d\\s(\\d+|\\W\\d+\\W+\\d+)(\\d|\\s\\d+\\W\\d+\\W\\d+)").matcher(value);
            while (matcher.find()) {
                val = matcher.group().trim().replaceAll("\\D", "");
                if (val.length() <= 10) continue;
                contacts.add(val);
            }
        }
        return contacts;
    }
}

