/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.condition;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.plugins.dispatch.client.condition.base.AbstractDispatchConditionPanel;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.DispatchFrequencyCondition;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.common.Utils;

public class DispatchFrequencyConditionPanel
extends AbstractDispatchConditionPanel {
    public JCheckBox useCondition = new JCheckBox("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0443\u0441\u043b\u043e\u0432\u0438\u0435");
    public BGTextField daysDeltaToSend = new BGTextField(5);
    public JPanel dataPanel = new JPanel(new GridBagLayout());
    private ButtonGroup modeButtonGroup = new ButtonGroup();

    public DispatchFrequencyConditionPanel(ClientContext context) {
        super(context);
    }

    protected void jbInit() {
        this.dataPanel.add((Component)new JLabel("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u0435 \u0447\u0430\u0449\u0435, \u0447\u0435\u043c \u0440\u0430\u0437 \u0432"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.dataPanel.add((Component)this.getDayPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.dataPanel.add((Component)this.getMonthPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.setBorder(BorderFactory.createTitledBorder(" \u0427\u0430\u0441\u0442\u043e\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 "));
        this.setLayout(new GridBagLayout());
        this.add(this.useCondition, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.dataPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.useCondition.addActionListener(actionEvent -> this.setActive(this.useCondition.isSelected()));
    }

    private JPanel getDayPanel() {
        JRadioButton dayButton = new JRadioButton();
        dayButton.setActionCommand("day");
        dayButton.setSelected(true);
        this.modeButtonGroup.add(dayButton);
        this.daysDeltaToSend.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)dayButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.daysDeltaToSend, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u0434\u043d\u0435\u0439"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getMonthPanel() {
        JRadioButton monthButton = new JRadioButton();
        monthButton.setActionCommand("month");
        monthButton.setSelected(true);
        this.modeButtonGroup.add(monthButton);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)monthButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u043d\u044b\u0439 \u043c\u0435\u0441\u044f\u0446"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public void clearFields() {
        this.modeButtonGroup.getElements().nextElement().setSelected(true);
        this.daysDeltaToSend.setText("3");
    }

    @Override
    protected DispatchCondition readConditionFromPanel() {
        DispatchFrequencyCondition condition = new DispatchFrequencyCondition();
        condition.setDaysDelta(Utils.parseInt((String)this.daysDeltaToSend.getText()));
        condition.setMode(this.modeButtonGroup.getSelection().getActionCommand());
        return condition;
    }

    @Override
    protected void fillFromCondition(DispatchCondition condition) {
        DispatchFrequencyCondition fCondition = (DispatchFrequencyCondition)condition;
        this.daysDeltaToSend.setText(String.valueOf(fCondition.getDaysDelta()));
        String mode = fCondition.getMode();
        Enumeration<AbstractButton> enumeration = this.modeButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (!mode.equals(button.getActionCommand())) continue;
            this.modeButtonGroup.setSelected(button.getModel(), true);
            break;
        }
    }

    @Override
    public boolean isActive() {
        return this.useCondition.isSelected();
    }

    @Override
    public void setActive(boolean active) {
        this.useCondition.setSelected(active);
        this.dataPanel.setVisible(active);
    }

    @Override
    public String validateCondition() {
        String result = "";
        if ("day".equals(this.modeButtonGroup.getSelection().getActionCommand()) && Utils.parseInt((String)this.daysDeltaToSend.getText()) < 1) {
            result = "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 1 \u0434\u043d\u044f!";
        }
        return result;
    }
}

