/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ru.bitel.common.Utils;
import ru.bitel.common.model.ScheduleTime;

public class SchedulePane
extends JPanel {
    private JTextField minutesField = new JTextField();
    private JTextField hoursField = new JTextField();
    private JTextField daysField = new JTextField();
    protected JTextField daysOfWeekField = new JTextField();
    private JTextField monthsField = new JTextField();

    public SchedulePane() {
        this.setLayout(new GridBagLayout());
        this.init();
    }

    protected void init() {
        this.add((Component)new JLabel("\u041c\u0438\u043d\u0443\u0442\u044b"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.minutesField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("\u0427\u0430\u0441\u044b"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.hoursField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("\u0414\u043d\u0438"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.daysField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("\u0414\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.daysOfWeekField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446\u044b"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.monthsField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
    }

    public void setDefaultTime() {
        this.minutesField.setText("*");
        this.hoursField.setText("*");
        this.daysField.setText("*");
        this.daysOfWeekField.setText("*");
        this.monthsField.setText("*");
    }

    public void setTime(ScheduleTime st) {
        if (st != null) {
            this.minutesField.setText(Utils.unpackValues((long)st.getMin(), (int)0));
            this.hoursField.setText(Utils.unpackValues((long)st.getHour(), (int)0));
            this.daysField.setText(Utils.unpackValues((long)st.getDay(), (int)1));
            this.daysOfWeekField.setText(Utils.unpackValues((long)st.getDayOfWeek(), (int)1));
            this.monthsField.setText(Utils.unpackValues((long)st.getMonth(), (int)1));
        }
    }

    public ScheduleTime getTime() {
        return new ScheduleTime((int)Utils.packValues((Collection)Utils.toList((String)this.monthsField.getText()), (int)1), (int)Utils.packValues((Collection)Utils.toList((String)this.daysField.getText()), (int)1), (int)Utils.packValues((Collection)Utils.toList((String)this.hoursField.getText()), (int)0), (int)Utils.packValues((Collection)Utils.toList((String)this.daysOfWeekField.getText()), (int)1), Utils.packValues((Collection)Utils.toList((String)this.minutesField.getText()), (int)0));
    }

    public void setTimeMode(boolean timeMode) {
        this.monthsField.setEnabled(!timeMode);
        this.daysOfWeekField.setEnabled(!timeMode);
        this.daysField.setEnabled(!timeMode);
        if (timeMode) {
            this.setDefaultHoursAndMins("0", "0");
        } else {
            this.setDefaultHoursAndMins("*", "*");
        }
    }

    public void setDefaultHoursAndMins(String hour, String min) {
        this.hoursField.setText(hour);
        this.minutesField.setText(min);
    }
}

