/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.bean.condition;

import java.sql.Connection;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.DispatchFrequencyCondition;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.bgbilling.plugins.dispatch.server.bean.condition.base.DispatchConditionChecker;

public class DispatchFrequencyConditionChecker
implements DispatchConditionChecker {
    private final long MILLISECONDS_IN_DAYS = 86400000L;

    @Override
    public boolean check(Connection con, DispatchCondition condition, Dispatch dispatch, Subscription subscribe) {
        DispatchFrequencyCondition freqCondition = (DispatchFrequencyCondition)condition;
        long currentTime = System.currentTimeMillis();
        long lastSent = subscribe.getPreferences().getLong("last.time.sent", 0L);
        boolean result = false;
        if ("day".equals(freqCondition.getMode())) {
            result = (currentTime - lastSent) / 86400000L >= (long)freqCondition.getDaysDelta();
        } else {
            LocalDate last = Instant.ofEpochMilli(lastSent).atZone(ZoneId.systemDefault()).toLocalDate();
            boolean bl = result = !LocalDate.now().isBefore(last.plusMonths(1L));
        }
        if (result) {
            subscribe.getPreferences().set("last.time.sent", String.valueOf(currentTime));
            subscribe.setUpdate(true);
        }
        return result;
    }
}

