/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.condition;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.math.BigDecimal;
import javax.swing.JLabel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.plugins.dispatch.client.condition.base.DummyDispatchConditionPanel;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.DispatchSaldoCondition;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.common.Utils;

public class DispatchSaldoConditionPanel
extends DummyDispatchConditionPanel {
    private BGTextField saldoFromTextField = new BGTextField();
    private BGTextField saldoToTextField = new BGTextField();

    public DispatchSaldoConditionPanel(ClientContext context) {
        super(context);
    }

    @Override
    protected void jbInit() {
        super.jbInit();
        this.mainPanel.add((Component)new JLabel("\u041e\u0442:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.saldoFromTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)new JLabel("\u0434\u043e:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.saldoToTextField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    protected String getTitle() {
        return "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043f\u043e \u0441\u0430\u043b\u044c\u0434\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430";
    }

    @Override
    protected DispatchCondition readConditionFromPanel() {
        DispatchSaldoCondition result = new DispatchSaldoCondition();
        BigDecimal from = Utils.parseBigDecimal((String)this.saldoFromTextField.getText(), null);
        BigDecimal to = Utils.parseBigDecimal((String)this.saldoToTextField.getText(), null);
        result.setSaldoFrom(from);
        result.setSaldoTo(to);
        return result;
    }

    @Override
    protected void fillFromCondition(DispatchCondition condition) {
        DispatchSaldoCondition cond = (DispatchSaldoCondition)condition;
        this.saldoFromTextField.setText(cond.getSaldoFrom() == null ? "" : Utils.formatCost((BigDecimal)cond.getSaldoFrom()));
        this.saldoToTextField.setText(cond.getSaldoTo() == null ? "" : Utils.formatCost((BigDecimal)cond.getSaldoTo()));
    }

    @Override
    public void clearFields() {
        super.clearFields();
        this.saldoFromTextField.setText("");
        this.saldoToTextField.setText("");
    }

    @Override
    public String validateCondition() {
        String result = null;
        BigDecimal from = Utils.parseBigDecimal((String)this.saldoFromTextField.getText(), null);
        BigDecimal to = Utils.parseBigDecimal((String)this.saldoToTextField.getText(), null);
        if (from == null && to == null) {
            result = "\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!";
        }
        if (from != null && to != null && from.compareTo(to) > 0) {
            result = "\u0421\u0443\u043c\u043c\u0430 \u041e\u0422 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u0430 \u0441\u0443\u043c\u043c\u0435 \u0414\u041e!";
        }
        return result;
    }
}

