/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cloudpayments.server;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsAutopaymentEvent;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsCheckEvent;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.worker.CloudPaymentsAutopaymentEventWorker;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.worker.CloudPaymentsCheckEventWorker;
import ru.bitel.bgbilling.modules.cloudpayments.server.service.CloudPaymentsServiceImpl;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.jmx.MBeanPaymentModule;

@BGPaymentModule
public class Module
extends ModuleBase
implements MBeanPaymentModule {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.cloudpayments.server"};
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), CloudPaymentsServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void start(Connection con, BGModule module) throws BGException {
        this.registerMBean(module);
        if (Setup.getSetup().getModuleSetup(Integer.valueOf(module.getId())).getBoolean("cloudpayments.event.worker", true)) {
            new CloudPaymentsCheckEventWorker(Setup.getSetup(), module.getId());
            new CloudPaymentsAutopaymentEventWorker(Setup.getSetup(), module.getId());
        } else {
            this.addListeners(module);
        }
    }

    @Deprecated
    private void addListeners(final BGModule module) throws BGException {
        EventProcessor.getInstance().addListener((EventListener)new EventListener<CloudPaymentsCheckEvent>(){

            public void notify(CloudPaymentsCheckEvent event, EventListenerContext ctx) throws Exception {
                new TransactionManager(ctx.getConnection(), module.getId()).doCheckRequest(event.getContractId(), event.isAutopaymentTransaction());
            }
        }, CloudPaymentsCheckEvent.class, module.getId(), null);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<CloudPaymentsAutopaymentEvent>(){

            public void notify(CloudPaymentsAutopaymentEvent event, EventListenerContext ctx) throws Exception {
                Contract contract;
                int moduleId = module.getId();
                int contractId = event.getContractId();
                Connection con = ctx.getConnection();
                AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
                Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
                BigDecimal sum = event.getSum();
                if (sum == null) {
                    sum = autopayment.getSum();
                }
                if (autopayment == null || autopayment.getMode().getCode() != event.getMode() || (contract = ContractDao.getContract((Connection)con, (int)contractId)) != null) {
                    // empty if block
                }
            }
        }, CloudPaymentsAutopaymentEvent.class, module.getId(), null);
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        try {
            ContractDeleteEvent contractDeleteEvent;
            Connection con = serverContext.getConnection();
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (!contractCreateEvent.isCheck()) {
                    this.enableAutopayment(contractCreateEvent.getPattern().getData(), "cloudpayments", moduleId, contractId, con, serverContext.getUserId());
                }
            } else if (event instanceof ContractDeleteEvent && !(contractDeleteEvent = (ContractDeleteEvent)event).isCheck()) {
                this.removeAutopayment(moduleId, contractId, con);
            }
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        ArrayList<PaymentMethod> methods = new ArrayList<PaymentMethod>();
        methods.add(PaymentMethod.CARD);
        return methods;
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

