/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.action.web;

import bitel.billing.server.ActionBase;
import bitel.billing.server.contract.bean.ContractServiceManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Channel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.PacketChannel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.AddCheck;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.ChannelManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketChannelManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.TariffRequestManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.ClosePacketSubscriptionEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.GetClosePacketDatesEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.GetOpenPacketDatesEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.OpenPacketSubscriptionEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.SubscriptionChangedEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.task.Recalculator;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.CollectionMapConverter;
import ru.bitel.common.model.Pair;

public class ActionSubscription
extends ActionBase {
    private Map<Integer, List<PacketChannel>> channelPacketMap = null;

    public void doAction() throws Exception {
        GregorianCalendar now = new GregorianCalendar();
        XMLUtils.createElement((Element)this.rootNode, (String)"date").setAttribute("year", TimeUtils.format((Calendar)now, (String)"yyyy"));
        UserCardManager userCardManager = new UserCardManager(this.con, this.mid, -1);
        PacketManager pm = new PacketManager(this.con, this.mid);
        CardPacketManager cpm = new CardPacketManager(this.con, this.mid);
        TariffRequestManager trm = new TariffRequestManager(this.connectionSet, this.mid);
        int usercardId = this.getIntParameter("card", -1);
        UserCard userCard = (UserCard)userCardManager.get(usercardId);
        Set<Integer> packetGroup = null;
        if (userCard != null && userCard.getContractId() == this.cid) {
            packetGroup = trm.getPacketGroup((ParameterMap)this.moduleSetup, this.cid, now);
        }
        List<PacketChannel> pc = new PacketChannelManager(this.con, this.mid).getPacketChannelList(now);
        Map mapPacketChannelList = new CollectionMapConverter<PacketChannel, Integer, Integer>(this){

            protected Pair<Integer, Integer> convert(PacketChannel f) {
                return new Pair((Object)f.getPacketId(), (Object)f.getChannelId());
            }
        }.getMapOfList(pc);
        HashMap<Integer, Packet> packetMap = new HashMap<Integer, Packet>();
        Element packetList = this.createElement(this.rootNode, "packet_list");
        for (Packet packet : pm.getPacketList()) {
            packetMap.put(packet.getId(), packet);
            if (!packet.isCanWebOpen() && !packet.isCanWebClose() || this.isVirtualCinema() != packet.isVirtualCinema()) continue;
            Element item = this.addListItem(packetList, packet.getId(), packet.getTitle());
            if (packetGroup != null && packetGroup.contains(packet.getId())) {
                item.setAttribute("packetGroup", "1");
            }
            item.setAttribute("can_web_open", packet.isCanWebOpen() ? "1" : "0");
            item.setAttribute("can_web_close", packet.isCanWebClose() ? "1" : "0");
            List lpc = (List)mapPacketChannelList.get(packet.getId());
            item.setAttribute("channel_count", String.valueOf(lpc != null ? lpc.size() : 0));
        }
        if (userCard != null && userCard.getContractId() == this.cid) {
            int multiroomMaxSlavecard = this.moduleSetup.getInt("multiroom.max.slavecards", 0);
            if (multiroomMaxSlavecard > 0) {
                Element slavecardList = this.createElement(this.rootNode, "slavecard_list");
                for (UserCard card : userCardManager.getSlavecards(userCard)) {
                    Element item = this.createElement(slavecardList, "item");
                    item.setAttribute("id", String.valueOf(card.getId()));
                    item.setAttribute("number", card.getGuiTitle());
                    item.setAttribute("number2", String.valueOf(card.getNumber()));
                    item.setAttribute("basecardTitle", card.getBasecardTitle());
                }
            }
            this.processCommand(cpm, packetMap, userCard, usercardId, now);
            boolean isShowArchive = this.getBooleanParameter("showarchive", false);
            XMLUtils.setAttribute((Element)this.rootNode, (String)"showarchive", (String)(isShowArchive ? "1" : "0"));
            Element currentSubscription = this.createElement(this.rootNode, "current_subscription");
            List<CardPacket> cardPacketList = cpm.getCardPacketList(this.cid, userCard.getId(), isShowArchive ? null : new Date(), this.isVirtualCinema());
            for (CardPacket cardPacket : cardPacketList) {
                Packet packet = (Packet)packetMap.get(cardPacket.getPacketId());
                if (packet == null || this.isVirtualCinema() != packet.isVirtualCinema()) continue;
                Element item = this.createElement(currentSubscription, "item");
                item.setAttribute("packet", packet.getTitle());
                item.setAttribute("period", TimeUtils.formatPeriod((Date)cardPacket.getDateFrom(), (Date)cardPacket.getDateTo()));
                item.setAttribute("date1", TimeUtils.format((Date)cardPacket.getDateFrom(), (String)"dd.MM.yyyy HH:mm"));
                item.setAttribute("date2", TimeUtils.format((Date)cardPacket.getDateTo(), (String)"dd.MM.yyyy HH:mm"));
                item.setAttribute("status", cardPacket.getStringStatus());
                item.setAttribute("packet_id", String.valueOf(packet.getId()));
                boolean packetisactive = TimeUtils.checkDateIntervalsIntersection((Date)cardPacket.getDateFrom(), (Date)cardPacket.getDateTo(), (Date)now.getTime(), (Date)now.getTime());
                item.setAttribute("canclose", packetisactive ? "1" : "0");
                item.setAttribute("packetisactive", packetisactive ? "1" : "0");
                List lpc = (List)mapPacketChannelList.get(packet.getId());
                item.setAttribute("channel_count", String.valueOf(lpc != null ? lpc.size() : 0));
                if (!packet.isVirtualCinema()) continue;
                String cost = Utils.formatCost((float)trm.getSubscriptionCost(this.cid, cardPacket.getDateFrom(), packetMap, Collections.singletonList(cardPacket), false));
                item.setAttribute("cost", cost);
            }
            currentSubscription.setAttribute("cost", Utils.formatCost((float)trm.getSubscriptionCost(this.cid, now.getTime(), packetMap, cardPacketList, false)));
            HashMap<String, String> costMap = new HashMap<String, String>();
            Element futureSubscription = this.createElement(this.rootNode, "future_subscription");
            List<CardPacket> futureCardPacketList = cpm.getFutureCardPacketList(this.cid, userCard.getId(), now.getTime());
            for (CardPacket cardPacket : futureCardPacketList) {
                String cost;
                Packet packet = (Packet)packetMap.get(cardPacket.getPacketId());
                if (packet == null || this.isVirtualCinema() != packet.isVirtualCinema()) continue;
                Element item = this.createElement(futureSubscription, "item");
                item.setAttribute("id", String.valueOf(cardPacket.getId()));
                item.setAttribute("packet_id", String.valueOf(cardPacket.getPacketId()));
                item.setAttribute("packet", packet.getTitle());
                item.setAttribute("period", TimeUtils.formatPeriod((Date)cardPacket.getDateFrom(), (Date)cardPacket.getDateTo()));
                item.setAttribute("date1", TimeUtils.format((Date)cardPacket.getDateFrom(), (String)"dd.MM.yyyy HH:mm"));
                item.setAttribute("date2", TimeUtils.format((Date)cardPacket.getDateTo(), (String)"dd.MM.yyyy HH:mm"));
                Date date = cardPacket.getDateFrom();
                String dateString = TimeUtils.formatDate((Date)cardPacket.getDateFrom());
                if (this.isVirtualCinema()) {
                    cost = Utils.formatCost((float)trm.getSubscriptionCost(this.cid, date, packetMap, Collections.singletonList(cardPacket), false));
                    item.setAttribute("cost", cost);
                    continue;
                }
                cost = (String)costMap.get(dateString);
                if (cost == null) {
                    cost = Utils.formatCost((float)trm.getSubscriptionCost(this.cid, date, packetMap, cpm.getCardPacketList(this.cid, cardPacket.getUsercardId(), date, this.isVirtualCinema()), false));
                    costMap.put(dateString, cost);
                }
                item.setAttribute("cost", cost);
            }
            GetOpenPacketDatesEvent dateOpenListEvent = new GetOpenPacketDatesEvent(this.userId, this.mid, this.cid, userCard.getId(), new Date());
            dateOpenListEvent = (GetOpenPacketDatesEvent)EventProcessor.getInstance().request((QueueEvent)dateOpenListEvent);
            if (dateOpenListEvent.getDateList() != null) {
                Element dateListEl = this.createElement(this.rootNode, "date_list_open");
                for (Date date : dateOpenListEvent.getDateList()) {
                    Element item = this.createElement(dateListEl, "item");
                    item.setAttribute("value", TimeUtils.format((Date)date, (String)"dd.MM.yyyy"));
                }
            }
            GetClosePacketDatesEvent dateCloseListEvent = new GetClosePacketDatesEvent(this.userId, this.mid, this.cid, userCard.getId(), new Date());
            dateCloseListEvent = (GetClosePacketDatesEvent)EventProcessor.getInstance().request((QueueEvent)dateCloseListEvent);
            if (dateCloseListEvent.getDateList() != null) {
                Element dateListEl = this.createElement(this.rootNode, "date_list_close");
                for (Date date : dateCloseListEvent.getDateList()) {
                    Element item = this.createElement(dateListEl, "item");
                    item.setAttribute("value", TimeUtils.format((Date)date, (String)"dd.MM.yyyy"));
                }
            }
            Element date = this.createElement(this.rootNode, "date");
            date.setAttribute("year", String.valueOf(now.get(1)));
            date.setAttribute("month", String.valueOf(now.get(2) + 1));
            date.setAttribute("day", String.valueOf(now.get(5)));
        }
    }

    protected boolean isVirtualCinema() {
        return false;
    }

    protected void processCommand(CardPacketManager cpm, Map<Integer, Packet> packetMap, UserCard userCard, int usercardId, Calendar now) throws Exception {
        List<CardPacket> cardPacketList = Collections.unmodifiableList(cpm.getCardPacketList(this.cid, userCard.getId(), now.getTime(), this.isVirtualCinema()));
        List<CardPacket> futureCardPacketList = Collections.unmodifiableList(cpm.getFutureCardPacketList(this.cid, userCard.getId(), now.getTime()));
        TariffRequestManager trm = new TariffRequestManager(this.connectionSet, this.mid);
        HashMap<Integer, CardPacket> cardPacketMap = new HashMap<Integer, CardPacket>();
        for (CardPacket cardPacket : cardPacketList) {
            cardPacketMap.put(cardPacket.getPacketId(), cardPacket);
        }
        HashMap<Integer, CardPacket> futureCardPacketMap = new HashMap<Integer, CardPacket>();
        for (CardPacket cp : futureCardPacketList) {
            futureCardPacketMap.put(cp.getPacketId(), cp);
        }
        String string = this.getParameter("command", "");
        if (Utils.notBlankString((String)string)) {
            if (string.equals("delete")) {
                int id = this.getIntParameter("id", -1);
                CardPacket cardPacket = cpm.getCardPacketById(id);
                Packet packet = packetMap.get(cardPacket.getPacketId());
                if (cardPacket != null && cardPacket.getContractId() == this.cid && TimeUtils.dateBefore((Date)now.getTime(), (Date)cardPacket.getDateFrom())) {
                    if (!this.checkCanRemovePacketWeb(cpm, packetMap, this.cid, usercardId, packet, TimeUtils.convertDateToCalendar((Date)cardPacket.getDateFrom()), false)) {
                        return;
                    }
                    cpm.deleteCardPacket(id);
                    SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.userId, this.mid, this.cid, userCard.getId(), 2, 3, cardPacket.getPacketId(), null);
                    this.context.publishAfterCommit((Event)event);
                }
            } else if (string.equals("change")) {
                int packetId = this.getIntParameter("packet", -1);
                Packet packet = packetMap.get(packetId);
                if (packet == null || !packet.isCanWebOpen() && !packet.isCanWebClose()) {
                    throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u043c \u043f\u0430\u043a\u0435\u0442\u043e\u043c \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u0447\u0435\u0440\u0435\u0437 WEB");
                }
                String type = this.getParameter("type", "open");
                Calendar date = Calendar.getInstance();
                Date _fromDate = this.getDateParameter("from_date");
                if (_fromDate != null) {
                    date.setTime(_fromDate);
                } else {
                    int day = this.getIntParameter("day", 0);
                    int month = this.getIntParameter("month", 1) - 1;
                    int year = this.getIntParameter("year", 0);
                    date.set(year, month, day);
                }
                String comment = this.getParameter("comment");
                if (!this.isVirtualCinema()) {
                    boolean canSubscriptionChange;
                    if (packet.isVirtualCinema()) {
                        return;
                    }
                    boolean bl = canSubscriptionChange = userCard.getSubscrDate() != null && TimeUtils.dateBeforeOrEq((Date)userCard.getSubscrDate(), (Date)date.getTime());
                    if (!canSubscriptionChange) {
                        throw new BGMessageException("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u043e\u0439 \u043e\u0442 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e!");
                    }
                    if (type.equals("open")) {
                        Object[] pkt;
                        if (!packet.isCanWebOpen()) {
                            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0447\u0435\u0440\u0435\u0437 WEB");
                        }
                        if (TimeUtils.dateBefore((Calendar)date, (Calendar)now)) {
                            throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043a\u0440\u044b\u0442 \u0440\u0430\u043d\u0435\u0435 \u0447\u0435\u043c \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u043e\u0439!");
                        }
                        if (cpm.getCardPacket(usercardId, packetId, date.getTime()) != null) {
                            throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442 \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443!");
                        }
                        AtomicReference<Date> date2 = new AtomicReference<Date>();
                        try {
                            this.checkCanAddPacketWeb(cpm, packetMap, this.cid, usercardId, packet, date, date2);
                        }
                        catch (BGException ex) {
                            throw new BGMessageException(ex.getMessage());
                        }
                        Set<Integer> packetGroup = trm.getPacketGroup((ParameterMap)this.moduleSetup, this.cid, date);
                        if (this.moduleSetup.getInt("cerbercrypt.cardpacket.addcheck", AddCheck.OPEN.getCode()) >= AddCheck.WEBADD.getCode() && (pkt = this.hasChannelFromPacket(cpm, packetMap, this.cid, usercardId, packetId, date.getTime(), packetGroup)) != null) {
                            Packet pak = (Packet)pkt[0];
                            Channel c = (Channel)pkt[1];
                            throw new BGMessageException("\u041a\u0430\u043d\u0430\u043b " + (c != null ? c.getTitle() : "null") + " \u0432 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u043c \u043f\u0430\u043a\u0435\u0442\u0435 " + packet.getTitle() + " \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442 \u0432 \u043f\u0430\u043a\u0435\u0442\u0435 " + pak.getTitle());
                        }
                        OpenPacketSubscriptionEvent eventOpenPacket = new OpenPacketSubscriptionEvent(this.userId, this.mid, this.cid, userCard, packet, date.getTime());
                        eventOpenPacket = (OpenPacketSubscriptionEvent)EventProcessor.getInstance().request((QueueEvent)eventOpenPacket);
                        if (Utils.notBlankString((String)eventOpenPacket.getError())) {
                            throw new BGMessageException(eventOpenPacket.getError());
                        }
                        if (Utils.notBlankString((String)eventOpenPacket.getMessage())) {
                            this.setMsg(eventOpenPacket.getMessage());
                        }
                        if (!eventOpenPacket.isProcessed()) {
                            CardPacket cardPacket = new CardPacket();
                            cardPacket.setContractId(this.cid);
                            cardPacket.setUsercardId(usercardId);
                            cardPacket.setPacketId(packetId);
                            cardPacket.setDateFrom(TimeUtils.convertCalendarToDate((Calendar)date));
                            if (comment != null) {
                                cardPacket.setComment(comment);
                            }
                            if (cardPacket.getDateFrom() == null && userCard.getDate1() != null || cardPacket.getDateTo() == null && userCard.getDate2() != null || cardPacket.getDateFrom() != null && userCard.getDate1() != null && TimeUtils.dateBefore((Date)cardPacket.getDateFrom(), (Date)userCard.getDate1()) || cardPacket.getDateTo() != null && userCard.getDate2() != null && TimeUtils.dateBefore((Date)userCard.getDate2(), (Date)cardPacket.getDateTo())) {
                                throw new BGMessageException("\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043f\u0430\u043a\u0435\u0442\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043a\u0430\u0440\u0442\u044b");
                            }
                            try {
                                cpm.openCardPackets(this.connectionSet, (ParameterMap)this.moduleSetup, packetMap, this.cid, usercardId, Collections.singletonList(cardPacket), now, true);
                                SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.userId, this.mid, this.cid, userCard.getId(), 2, 1, cardPacket.getPacketId(), TimeUtils.convertCalendarToDate((Calendar)date));
                                this.context.publishAfterCommit((Event)event);
                                new UserCardManager(this.con, this.mid, -1).updateSubscribe(date.getTime(), cardPacket.getUsercardId(), true);
                            }
                            catch (BGMessageException e) {
                                throw new BGMessageException(e.getMessage());
                            }
                        }
                    } else if (type.equals("close")) {
                        CardPacket cardPacket;
                        if (!packet.isCanWebClose()) {
                            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0447\u0435\u0440\u0435\u0437 WEB");
                        }
                        if (TimeUtils.dateBefore((Calendar)date, (Calendar)now)) {
                            throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043a\u0440\u044b\u0442 \u043d\u0435 \u0440\u0430\u043d\u0435\u0435 \u0447\u0435\u043c \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u043e\u0439");
                        }
                        if (!this.checkCanRemovePacketWeb(cpm, packetMap, this.cid, usercardId, packet, date, false)) {
                            return;
                        }
                        ClosePacketSubscriptionEvent eventClosePacket = new ClosePacketSubscriptionEvent(this.userId, this.mid, this.cid, userCard, packet, date.getTime());
                        eventClosePacket = (ClosePacketSubscriptionEvent)EventProcessor.getInstance().request((QueueEvent)eventClosePacket);
                        if (Utils.notBlankString((String)eventClosePacket.getError())) {
                            throw new BGMessageException(eventClosePacket.getError());
                        }
                        if (Utils.notBlankString((String)eventClosePacket.getMessage())) {
                            this.setMsg(eventClosePacket.getMessage());
                        }
                        if (!eventClosePacket.isProcessed() && (cardPacket = cpm.getCardPacket(usercardId, packetId, date.getTime())) != null) {
                            cardPacket.setDateTo(TimeUtils.convertCalendarToDate((Calendar)date));
                            if (comment != null) {
                                cardPacket.setComment(comment);
                            }
                            cpm.updateCardPacket(cardPacket);
                            SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.userId, this.mid, this.cid, userCard.getId(), 2, 2, packetId, TimeUtils.convertCalendarToDate((Calendar)date));
                            this.context.publishAfterCommit((Event)event);
                        }
                    }
                } else if (packet.isVirtualCinema()) {
                    int virtualCinemaService = this.moduleSetup.getInt("cerbercrypt.virtual_cinema.serviceId", 0);
                    if (virtualCinemaService > 0) {
                        boolean can = false;
                        List serviceList = new ContractServiceManager(this.con).getContractServiceList(this.cid, (Calendar)new GregorianCalendar());
                        for (ContractService s : serviceList) {
                            if (s.getServiceId() != virtualCinemaService) continue;
                            can = true;
                            break;
                        }
                        if (!can) {
                            throw new BGMessageException("\u0423\u0441\u043b\u0443\u0433\u0430 \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0438\u043d\u043e\u0437\u0430\u043b \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430.");
                        }
                    }
                    if (type.equals("activate")) {
                        date = new GregorianCalendar();
                        if (cpm.getCardPacket(usercardId, packetId, date.getTime()) != null) {
                            throw new BGMessageException("\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0438\u043d\u043e\u0437\u0430\u043b \u0443\u0436\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d!");
                        }
                        Calendar date2 = (Calendar)date.clone();
                        date2.add(5, 1);
                        CardPacket cardPacket = new CardPacket();
                        cardPacket.setContractId(this.cid);
                        cardPacket.setUsercardId(usercardId);
                        cardPacket.setPacketId(packetId);
                        cardPacket.setDateFrom(TimeUtils.convertCalendarToDate((Calendar)date));
                        cardPacket.setDateTo(TimeUtils.convertCalendarToDate((Calendar)date2));
                        if (cardPacket.getDateFrom() == null && userCard.getDate1() != null || cardPacket.getDateTo() == null && userCard.getDate2() != null || cardPacket.getDateFrom() != null && userCard.getDate1() != null && TimeUtils.dateBefore((Date)cardPacket.getDateFrom(), (Date)userCard.getDate1()) || cardPacket.getDateTo() != null && userCard.getDate2() != null && TimeUtils.dateBefore((Date)userCard.getDate2(), (Date)cardPacket.getDateTo())) {
                            throw new BGMessageException("\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043f\u0430\u043a\u0435\u0442\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043a\u0430\u0440\u0442\u044b");
                        }
                        Object event = new SubscriptionChangedEvent(this.userId, this.mid, this.cid, userCard.getId(), 2, 1, cardPacket.getPacketId(), TimeUtils.convertCalendarToDate((Calendar)date));
                        this.context.publishAfterCommit(event);
                        float summ = trm.getSubscriptionCost(this.cid, date.getTime(), packetMap, Collections.singletonList(cardPacket), true);
                        BalanceUtils bu = new BalanceUtils(this.con);
                        ContractDao contractDao = new ContractDao(this.con, 0);
                        BigDecimal balance = bu.getBalance(date.getTime(), this.cid);
                        BigDecimal limit = ((Contract)contractDao.get(this.cid)).getBalanceLimit();
                        bu.close();
                        contractDao.close();
                        if (Float.isNaN(summ)) {
                            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043a\u0438\u043d\u043e\u0437\u0430\u043b\u0430.");
                        }
                        if (balance.floatValue() - summ < limit.floatValue()) {
                            throw new BGMessageException("\u041d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0447\u0435\u0442\u0435 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438!");
                        }
                        if (this.getIntParameter("activate", 0) != 1) {
                            Element act = this.createElement(this.rootNode, "activation");
                            act.setAttribute("summ", Utils.formatCost((float)summ));
                            act.setAttribute("virtual_cinema", packet.getTitle());
                            act.setAttribute("packet", String.valueOf(packet.getId()));
                            return;
                        }
                        if (cardPacket.getDateFrom() == null && userCard.getDate1() != null || cardPacket.getDateTo() == null && userCard.getDate2() != null || cardPacket.getDateFrom() != null && userCard.getDate1() != null && TimeUtils.dateBefore((Date)cardPacket.getDateFrom(), (Date)userCard.getDate1()) || cardPacket.getDateTo() != null && userCard.getDate2() != null && TimeUtils.dateBefore((Date)userCard.getDate2(), (Date)cardPacket.getDateTo())) {
                            throw new BGMessageException("\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043f\u0430\u043a\u0435\u0442\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043a\u0430\u0440\u0442\u044b");
                        }
                        cpm.updateCardPacket(cardPacket);
                        new RunTaskDataManager(this.con).addTask((RunTask)new Recalculator(this.mid, TimeUtils.convertDateToCalendar((Date)cardPacket.getDateFrom()), null, String.valueOf(this.cid), "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438"));
                    }
                }
            }
        }
    }

    private Map<Integer, List<PacketChannel>> getChannelPacketMap(Map<Integer, Packet> packetMap) throws BGException {
        Map<Integer, List<PacketChannel>> result = this.channelPacketMap;
        if (result == null) {
            result = new HashMap<Integer, List<PacketChannel>>();
            PacketChannelManager pcm = new PacketChannelManager(this.con, this.mid);
            for (Packet p : packetMap.values()) {
                List<PacketChannel> pcList = pcm.getPacketChannelList(p.getId());
                result.put(p.getId(), pcList);
            }
            this.channelPacketMap = result;
        }
        return result;
    }

    public Object[] hasChannelFromPacket(CardPacketManager cpm, Map<Integer, Packet> packetMap, int cid, int usercardId, int packetId, Date now, Set<Integer> withoutPackets) throws BGException {
        Map<Integer, List<PacketChannel>> channelPacketMap = this.getChannelPacketMap(packetMap);
        List<CardPacket> list = cpm.getCardPacketList(cid, usercardId, now, false);
        List<PacketChannel> addSet = channelPacketMap.get(packetId);
        for (CardPacket cp : list) {
            List<PacketChannel> set = channelPacketMap.get(cp.getPacketId());
            if (set == null || withoutPackets != null && withoutPackets.contains(cp.getPacketId())) continue;
            for (PacketChannel i : addSet) {
                for (PacketChannel s : set) {
                    if (i.getChannelId() != s.getChannelId() || !TimeUtils.dateInRange((Date)now, (Date)s.getDateFrom(), (Date)s.getDateTo()) || !TimeUtils.dateInRange((Date)now, (Date)i.getDateFrom(), (Date)i.getDateTo())) continue;
                    Channel c = new ChannelManager(this.con, this.mid).getChannelById(i.getChannelId());
                    return new Object[]{packetMap.get(cp.getPacketId()), c};
                }
            }
        }
        return null;
    }

    protected void checkCanAddPacketWeb(CardPacketManager cpm, Map<Integer, Packet> packetMap, int cid, int usercardId, Packet packet, Calendar date, AtomicReference<Date> date2Ref) throws BGException {
        if (packet.getDepends().size() > 0 || packet.getUnacceptable().size() > 0) {
            List<CardPacket> currentPacketList = cpm.getCardPacketList(cid, usercardId, date.getTime(), false);
            currentPacketList.addAll(cpm.getFutureCardPacketList(cid, usercardId, date.getTime()));
            currentPacketList = Collections.unmodifiableList(currentPacketList);
            HashSet<Integer> currentPackets = new HashSet<Integer>();
            Date date2 = null;
            for (CardPacket cardPacket : currentPacketList) {
                currentPackets.add(cardPacket.getPacketId());
                if (cardPacket.getDateTo() == null || date2 != null && !date2.after(cardPacket.getDateTo())) continue;
                date2 = cardPacket.getDateTo();
            }
            date2Ref.set(date2);
            if (packet.getDepends().size() > 0 && Collections.disjoint(currentPackets, packet.getDepends())) {
                StringBuilder packets = new StringBuilder();
                for (Integer id : packet.getDepends()) {
                    Packet p = packetMap.get(id);
                    if (p != null) {
                        packets.append(p.getTitle()).append(", ");
                        XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)this.rootNode, (String)"msgpacketid"), (String)String.valueOf(p.getId()));
                        continue;
                    }
                    this.getLogger().error("Depend packet id={} not found for packet id={}", (Object)id, (Object)packet.getId());
                }
                if (packets.length() > 0) {
                    packets.setLength(packets.length() - 2);
                }
                throw new BGMessageException("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0430 \u043e\u0434\u0438\u043d \u0438\u0437 \u043f\u0430\u043a\u0435\u0442\u043e\u0432: " + packets.toString());
            }
            ArrayList unacceptable = new ArrayList(packet.getUnacceptable());
            unacceptable.retainAll(currentPackets);
            if (unacceptable.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Integer id : unacceptable) {
                    Packet p = packetMap.get(id);
                    if (p != null) {
                        stringBuilder.append(p.getTitle()).append(", ");
                        XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)this.rootNode, (String)"msgpacketid"), (String)String.valueOf(p.getId()));
                        continue;
                    }
                    this.getLogger().error("Unacceptable packet not found={} for packet {}", (Object)id, (Object)packet.getId());
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.setLength(stringBuilder.length() - 2);
                }
                throw new BGMessageException("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442\u044b: " + stringBuilder.toString());
            }
        }
    }

    protected boolean checkCanRemovePacketWeb(CardPacketManager cpm, Map<Integer, Packet> packetMap, int cid, int usercardId, Packet packet, Calendar date, boolean groupReplace) throws BGException {
        Packet p;
        StringBuilder packets;
        List<CardPacket> currentPacketList = cpm.getCardPacketList(cid, usercardId, date.getTime(), false);
        currentPacketList.addAll(cpm.getFutureCardPacketList(cid, usercardId, date.getTime()));
        currentPacketList = Collections.unmodifiableList(currentPacketList);
        TariffRequestManager trm = new TariffRequestManager(this.connectionSet, this.mid);
        Set<Integer> packetGroup = trm.getPacketGroup((ParameterMap)this.moduleSetup, cid, date);
        boolean result = true;
        StringBuilder errors = new StringBuilder();
        if (!groupReplace && packetGroup != null && packetGroup.contains(packet.getId())) {
            packetGroup.remove(packet.getId());
            packets = new StringBuilder();
            for (Integer id : packetGroup) {
                p = packetMap.get(id);
                if (p != null) {
                    packets.append(p.getTitle()).append(", ");
                    XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)this.rootNode, (String)"msgpacketid"), (String)String.valueOf(p.getId()));
                    continue;
                }
                this.getLogger().error("Group packet not found={}", (Object)packet.getId());
            }
            if (packets.length() > 0) {
                packets.setLength(packets.length() - 2);
            }
            errors.append("\u0411\u0430\u0437\u043e\u0432\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0435\u0433\u043e \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430 \u043e\u0434\u0438\u043d \u0438\u0437: " + packets.toString()).append(".");
            result = false;
        }
        packets = new StringBuilder();
        for (CardPacket cp : currentPacketList) {
            p = packetMap.get(cp.getPacketId());
            if (p != null) {
                if (!p.getDepends().contains(packet.getId())) continue;
                packets.append(p.getTitle()).append(", ");
                XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)this.rootNode, (String)"msgpacketid"), (String)String.valueOf(p.getId()));
                continue;
            }
            this.getLogger().error("Packet not found={} for cardPacket {}", (Object)cp.getPacketId(), (Object)cp.getId());
        }
        if (packets.length() > 0) {
            packets.setLength(packets.length() - 2);
            if (errors.length() > 0) {
                errors.append(" ");
            }
            errors.append("\u041f\u0430\u043a\u0435\u0442 " + packet.getTitle() + " \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442\u044b: " + packets.toString() + ". \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0435 \u043f\u0430\u043a\u0435\u0442\u044b.");
            result = false;
        }
        if (errors.length() > 0) {
            throw new BGMessageException(errors.toString());
        }
        return result;
    }
}

