/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.fisc.komtet;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.json.JSONTokener;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.BGFiscConnectException;
import ru.bitel.bgbilling.plugins.cashcheck.server.CashCheckUtils;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckFiscalData;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckPrintResult;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.Fiscalizator;
import ru.bitel.common.Utils;
import ru.bitel.common.function.ThrowingConsumer;

public class KomtetFiscalizator
extends Fiscalizator {
    private String shopId = null;
    private String secret = null;
    private int queue = -1;
    private int timeout = -1;
    private int sno = 0;
    private String payment_address = null;
    private String supplier_info_phones = null;
    private String supplier_info_name = null;
    private String supplier_info_inn = null;
    private static Logger logger = LogManager.getLogger();

    public KomtetFiscalizator(Printer printer) throws BGException {
        super(printer);
        this.shopId = printer.getConfig().get("shopId", null);
        this.secret = printer.getConfig().get("secret", null);
        this.queue = printer.getConfig().getInt("queue", -1);
        if (this.shopId == null || this.secret == null || this.queue <= 0) {
            throw new BGException("\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b shopId, secret, queue \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b");
        }
        this.timeout = printer.getConfig().getInt("timeout", this.timeout);
        this.sno = printer.getConfig().getInt("sno", 0);
        this.payment_address = printer.getConfig().get("payment_address", null);
        this.supplier_info_phones = printer.getConfig().get("supplier_info.phones", null);
        this.supplier_info_name = printer.getConfig().get("supplier_info.name", null);
        this.supplier_info_inn = printer.getConfig().get("supplier_info.inn", null);
    }

    private String getSignature(String method, String url, String body) throws BGException {
        if (body == null) {
            body = "";
        }
        String msg = method + url + body;
        try {
            SecretKeySpec keySpec = new SecretKeySpec(this.secret.getBytes("utf-8"), "HmacMD5");
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(keySpec);
            byte[] rawHmac = mac.doFinal(msg.getBytes("utf-8"));
            return Utils.bytesToString((byte[])rawHmac, (boolean)false, (String)"");
        }
        catch (Exception e) {
            throw new BGException("error create HmacMD5-signature: " + e.getMessage(), (Throwable)e);
        }
    }

    private static String formatErrorText(JSONObject response, Integer httpCode) {
        Object _message;
        String title = response.has("title") ? response.getString("title") : null;
        String description = response.has("description") ? response.getString("description") : null;
        Object object = _message = Utils.notBlankString((String)title) ? title : "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430?";
        if (Utils.notBlankString((String)description)) {
            _message = (String)_message + "\n" + description;
        }
        String error_code = response.has("error_code") ? response.getString("error_code") : "?";
        String http = httpCode != null ? httpCode.toString() : "?";
        return String.format("\u041e\u0448\u0438\u0431\u043a\u0430 Komtet: %s\n\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e: error_code: %s, http: %s", _message, error_code, http);
    }

    private JSONObject doJsonRequest(String method, String url, JSONObject data) throws BGException, BGFiscConnectException {
        String body = null;
        if (data != null) {
            try {
                body = data.toString(0);
            }
            catch (Exception e) {
                throw new BGException("error dump json to request: " + e.getMessage(), (Throwable)e);
            }
        }
        final String signature = this.getSignature(method, url, body);
        HashMap<String, String> requestProperties = new HashMap<String, String>(){
            {
                this.put("Content-type", "application/json; charset=utf-8");
                this.put("Authorization", KomtetFiscalizator.this.shopId);
                this.put("X-HMAC-Signature", signature);
            }
        };
        CashCheckUtils.HttpReply reply = CashCheckUtils.doHttpRequest(method, url, body, (Map<String, String>)requestProperties, this.timeout, logger);
        JSONObject fullresponse = null;
        try {
            JSONTokener tokener = new JSONTokener(reply.body);
            fullresponse = (JSONObject)tokener.nextValue();
        }
        catch (Exception e) {
            throw new BGException("error parse json from response: " + e.getMessage());
        }
        if (fullresponse.has("error_code")) {
            throw new BGMessageException(KomtetFiscalizator.formatErrorText(fullresponse, reply.code));
        }
        return fullresponse;
    }

    private String payment_type_convert(Integer payment_type) {
        if (payment_type == null) {
            return null;
        }
        switch (payment_type) {
            default: {
                return "card";
            }
            case 1002: 
            case 1081: {
                return "card";
            }
            case 1001: 
            case 1031: {
                return "cash";
            }
            case 1003: 
            case 1215: {
                return "prepayment";
            }
            case 1004: 
            case 1216: {
                return "credit";
            }
            case 1005: 
            case 1217: 
        }
        return "counter_provisioning";
    }

    private String check_intent_convert(Check.Type checkType) {
        if (checkType == null) {
            return null;
        }
        switch (checkType) {
            case PAYMENT: {
                return "sell";
            }
            case PAYMENTREFUND: {
                return "sellReturn";
            }
            case PAYMENTCORRECTION: {
                return "sellCorrection";
            }
            case PAYMENTREFUNDCORRECTION: {
                return "sellReturnCorrection";
            }
        }
        throw new RuntimeException("unknown checkType enum value " + String.valueOf(checkType));
    }

    private static String vat_convert(Integer vat) {
        if (vat == null) {
            return "no";
        }
        switch (vat) {
            default: {
                return "no";
            }
            case 0: 
            case 1000000: {
                return "0";
            }
            case 10: 
            case 1000010: {
                return "10";
            }
            case 110: 
            case 1000110: {
                return "110";
            }
            case 20: 
            case 1000020: {
                return "20";
            }
            case 120: 
            case 1000120: {
                return "120";
            }
            case 1000005: {
                return "5";
            }
            case 1000105: {
                return "105";
            }
            case 1000007: {
                return "7";
            }
            case 1000107: 
        }
        return "107";
    }

    private static String payMethod_convert(Integer payMethod) {
        if (payMethod == null) {
            return null;
        }
        switch (payMethod) {
            default: {
                return null;
            }
            case 1: 
            case 1214001: {
                return "pre_payment_full";
            }
            case 2: 
            case 1214002: {
                return "pre_payment_part";
            }
            case 3: 
            case 1214003: {
                return "advance";
            }
            case 4: 
            case 1214004: {
                return "full_payment";
            }
            case 5: 
            case 1214005: {
                return "credit_part";
            }
            case 6: 
            case 1214006: {
                return "credit";
            }
            case 7: 
            case 1214007: 
        }
        return "credit_pay";
    }

    private static String payObject_convert(Integer payObject) {
        if (payObject == null) {
            return null;
        }
        switch (payObject) {
            default: {
                return null;
            }
            case 1: 
            case 1212001: {
                return "product";
            }
            case 3: 
            case 1212003: {
                return "work";
            }
            case 4: 
            case 1212004: {
                return "service";
            }
            case 10: 
            case 1212010: {
                return "payment";
            }
            case 11: 
            case 1212011: {
                return "commission";
            }
            case 13: 
            case 1212013: 
        }
        return "other";
    }

    private static String agent_info_type_convert(Object agent_info_type) {
        if (agent_info_type == null) {
            return null;
        }
        if (agent_info_type instanceof String) {
            return (String)agent_info_type;
        }
        if (agent_info_type instanceof Integer) {
            switch ((Integer)agent_info_type) {
                default: {
                    return "unknown#" + String.valueOf(agent_info_type);
                }
                case 0: {
                    return "bank_payment_agent";
                }
                case 1: {
                    return "bank_payment_subagent";
                }
                case 2: {
                    return "payment_agent";
                }
                case 3: {
                    return "payment_subagent";
                }
                case 4: {
                    return "solicitor";
                }
                case 5: {
                    return "commissionaire";
                }
                case 6: 
            }
            return "agent";
        }
        throw new RuntimeException("unknown agent_info_type tag type");
    }

    private CheckPrintResult addTask(String intent, final Check check) throws BGException {
        String _intent;
        logger.debug("add task " + intent + "...");
        String check_intent = this.check_intent_convert(check.getCheckType());
        if (check_intent != null && !check_intent.equals(intent)) {
            logger.debug("overwrite check type from " + intent + " to " + check_intent);
            _intent = check_intent;
        } else {
            _intent = intent;
        }
        final String external_id = check.getDocumentId();
        if (external_id == null) {
            throw new BGMessageException("\u0412 \u0441\u043a\u0440\u0438\u043f\u0442\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0447\u0435\u043a\u0430 documentId (\u0434\u043b\u044f external_id)");
        }
        final String customerAddr = check.getCustomerEmail();
        if (customerAddr == null) {
            throw new BGMessageException("\u0412 \u0441\u043a\u0440\u0438\u043f\u0442\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d customerEmail");
        }
        if (check.getCashierName() != null && check.getCashierINN() == null || check.getCashierName() == null && check.getCashierINN() != null) {
            throw new BGMessageException("\u0418\u043c\u044f+\u0438\u043d\u043d \u043a\u0430\u0441\u0441\u0438\u0440\u0430 (\u043d\u0435)\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0430\u0440\u043e\u0439");
        }
        final String vatTotal = KomtetFiscalizator.vat_convert(check.getTax());
        final String payMethodTotal = KomtetFiscalizator.payMethod_convert(check.getPayMethod());
        final String payObjectTotal = KomtetFiscalizator.payObject_convert(check.getPayObject());
        JSONObject data = new JSONObject((Map)new HashMap<String, Object>(){
            {
                Long attr_internet;
                this.put("intent", _intent);
                this.put("external_id", external_id);
                this.put("sno", KomtetFiscalizator.this.sno);
                this.put("print", !check.isOnlyElCheck());
                this.put("user", customerAddr);
                this.put("positions", new ArrayList<HashMap<String, Object>>(){
                    {
                        for (final Check.CheckLine line : check.getLines()) {
                            if (line.summa == null) continue;
                            final String payMethod = line.payMethod != null ? KomtetFiscalizator.payMethod_convert(line.payMethod) : payMethodTotal;
                            final String payObject = line.payObject != null ? KomtetFiscalizator.payObject_convert(line.payObject) : payObjectTotal;
                            final String vat = line.tax != null ? KomtetFiscalizator.vat_convert(line.tax) : vatTotal;
                            final String line_supplier_info_phones = line.customTags.getOrDefault(100001171, KomtetFiscalizator.this.supplier_info_phones);
                            final String line_supplier_info_name = line.customTags.getOrDefault(100001225, KomtetFiscalizator.this.supplier_info_name);
                            final String line_supplier_info_inn = line.customTags.getOrDefault(100001226, KomtetFiscalizator.this.supplier_info_inn);
                            final String line_agent_info_type = (String)line.customTags.get(100001222);
                            this.add(new HashMap<String, Object>(){
                                {
                                    this.put("name", line.text);
                                    this.put("price", line.summa);
                                    this.put("quantity", 1);
                                    this.put("total", line.summa);
                                    if (line_agent_info_type != null) {
                                        this.put("agent_info", new HashMap<String, Object>(){
                                            {
                                                this.put("type", KomtetFiscalizator.agent_info_type_convert(line_agent_info_type));
                                            }
                                        });
                                    }
                                    if (line_supplier_info_name != null && line_supplier_info_inn != null) {
                                        this.put("supplier_info", new HashMap<String, Object>(){
                                            {
                                                if (line_supplier_info_phones != null) {
                                                    this.put("phones", Utils.toList((String)line_supplier_info_phones));
                                                }
                                                this.put("name", line_supplier_info_name);
                                                this.put("inn", line_supplier_info_inn);
                                            }
                                        });
                                    }
                                    if (payMethod != null) {
                                        this.put("calculation_method", payMethod);
                                    }
                                    if (payObject != null) {
                                        this.put("calculation_subject", payObject);
                                    }
                                    this.put("vat", vat);
                                }
                            });
                        }
                    }
                });
                this.put("payments", new ArrayList<HashMap<String, Object>>(){
                    {
                        this.add(new HashMap<String, Object>(){
                            {
                                this.put("sum", check.getPaymentsum());
                                if (check.getPaymentType() != null) {
                                    this.put("type", KomtetFiscalizator.this.payment_type_convert(check.getPaymentType()));
                                }
                            }
                        });
                    }
                });
                if (check.getCashierName() != null && check.getCashierINN() != null) {
                    this.put("cashier", new HashMap<String, Object>(){
                        {
                            this.put("name", check.getCashierName());
                            this.put("inn", check.getCashierINN());
                        }
                    });
                }
                if (KomtetFiscalizator.this.payment_address != null) {
                    this.put("payment_address", KomtetFiscalizator.this.payment_address);
                }
                if ((attr_internet = (Long)check.getCustomTags().get(1125)) != null) {
                    this.put("internet", attr_internet == 1L);
                }
            }
        });
        String url = "https://kassa.komtet.ru/api/shop/v1/queues/" + this.queue + "/task";
        JSONObject reply = this.doJsonRequest("POST", url, data);
        if (!reply.has("id")) {
            throw new BGException("protocol error: no id field in response");
        }
        String taskId = String.valueOf(reply.getInt("id"));
        return CheckPrintResult.async(taskId);
    }

    @Override
    public CheckPrintResult check(String oppass, BigDecimal clientsumma, Check check) throws BGException {
        return this.addTask("sell", check);
    }

    @Override
    public CheckPrintResult checkreturn(String oppass, BigDecimal clientsumma, Check check) throws BGException {
        return this.addTask("sellReturn", check);
    }

    private String queueStatus() throws BGException {
        logger.debug("queue status...");
        String url = "https://kassa.komtet.ru/api/shop/v1/queues/" + this.queue;
        JSONObject reply = this.doJsonRequest("GET", url, null);
        int id = reply.getInt("id");
        String state = reply.getString("state");
        return String.format("id: %d, state: %s", id, state);
    }

    @Override
    public String status(String pass) throws BGException {
        return "ok, \u0441\u0442\u0430\u0442\u0443\u0441 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + this.queueStatus();
    }

    @Override
    public String name(String pass) throws BGException {
        return "\u041a\u043e\u043c\u0442\u0435\u0442 \u041a\u0430\u0441\u0441\u0430";
    }

    @Override
    public String getFiscalizatorStatus() throws BGException {
        return "shopId: " + this.shopId + "\nqueue: " + this.queue;
    }

    @Override
    public boolean isAsynchronous() {
        return true;
    }

    private Fiscalizator.CheckResult getTaskInfo(String taskId) throws BGException {
        String state;
        logger.debug("get task info " + taskId + "...");
        String url = "https://kassa.komtet.ru/api/shop/v1/tasks/" + taskId;
        JSONObject reply = this.doJsonRequest("GET", url, null);
        if (!reply.has("state")) {
            throw new BGException("protocol error: no \"state\" field in task-info-response");
        }
        switch (state = reply.getString("state")) {
            case "done": {
                if (!reply.has("fiscal_data") || reply.isNull("fiscal_data")) {
                    throw new BGException("protocol error: no \"fiscal_data\" field with \"state:done\" in task-info-response");
                }
                return Fiscalizator.CheckResult.ok(taskId, this.fiscalDataConvert(reply));
            }
            case "error": {
                if (!reply.has("error_description") || reply.isNull("error_description")) {
                    throw new BGException("protocol error: no \"error_description\" field with \"state:error\" in task-info-response");
                }
                String error_description = reply.getString("error_description");
                return Fiscalizator.CheckResult.error(taskId, error_description);
            }
            case "new": {
                return Fiscalizator.CheckResult.wait(taskId);
            }
        }
        throw new BGException("protocol error: error value \"state\" field in task-info-response: \"" + state + "\"");
    }

    private CheckFiscalData fiscalDataConvert(JSONObject reply) {
        JSONObject fiscal_dataJson = reply.getJSONObject("fiscal_data");
        CheckFiscalData cfd = new CheckFiscalData();
        cfd.time(fiscal_dataJson.optString("t", null), "yyyyMMdd'T'HHmm");
        cfd.total = fiscal_dataJson.optBigDecimal("s", null);
        cfd.fn = fiscal_dataJson.optString("fn", null);
        cfd.fd = fiscal_dataJson.optString("i", null);
        cfd.fp = fiscal_dataJson.optString("fp", null);
        cfd.ofd_receipt_url = reply.optString("receipt_url", null);
        int n = fiscal_dataJson.optInt("n", -1);
        if (n == 1) {
            cfd.type = Check.Type.PAYMENT;
        } else if (n == 2) {
            cfd.type = Check.Type.PAYMENTREFUND;
        }
        cfd.fillAttrs(fiscal_dataJson.toMap(), "t", "s", "fn", "i", "fp", "n");
        return cfd;
    }

    @Override
    public void checkPending(List<String> pendingIds, long timeout, ThrowingConsumer<Fiscalizator.CheckResult> eachResult) throws BGException {
        for (String pendingId : pendingIds) {
            eachResult.accept((Object)this.getTaskInfo(pendingId));
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException e) {
                throw new BGException("InterruptedException");
            }
        }
    }
}

