package ru.bitel.bgbilling.modules.botmanager.dyn.auth;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessing;

public class AuthProcessing
    implements DialogProcessing
{
    private static final Logger logger = LogManager.getLogger();

    /**
     * ID диалога с запросом пароля для авторизации
     */
    private final int REQUEST_PASS_DIALOG = 9;

    /**
     * ID диалога с ошибкой
     */
    private final int ERROR_DIALOG = 8;

    @Override
    public void preDialog( ServerContext serverContext, JSONObject botData )
    {
    }

    @Override
    public void processDialog( ServerContext serverContext, JSONObject botData, String inputTextOfUser )
    {
        int cid = findContract( serverContext.getConnection(), inputTextOfUser );
        if( cid > 0 )
        {
            //если договор найден, то указываем, что следующим надо показать диалог с запросом пароля от ЛК
            botData.put( CONTRACT_ID, cid );
            botData.put( NEXT_DIALOG_ID, REQUEST_PASS_DIALOG );
            if( logger.isDebugEnabled() )
            {
                logger.debug( "Substring for search contract=" + inputTextOfUser + " Contract was find" );
            }
        }
        else
        {
            botData.put( NEXT_DIALOG_ID, ERROR_DIALOG );
            if( logger.isDebugEnabled() )
            {
                logger.debug( "Cannot to find contract for substring: " + inputTextOfUser );
            }
        }
    }

    //поиск договора по названию договора
    private int findContract( Connection connection, String contractTitle )
    {
        int result = -1;
        String query = "select id from contract where title like '%" + contractTitle + "%'";
        try ( var statement = connection.createStatement();
            ResultSet rs = statement.executeQuery( query ))
        {
            if( rs.next() )
            {
                result = rs.getInt( "id" );
            }
        }
        catch( SQLException ex )
        {
            logger.error( ex );
        }

        return result;
    }

    @Override
    public String title()
    {
        return "Обработка авторизации";
    }
}
