/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.common.bean.AccountReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class AccountReportDao
extends AbstractDao<AccountReport> {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");

    public AccountReportDao(Connection con, int moduleId) {
        super(con, "", moduleId);
    }

    public void searchAccountReport(SearchResult<AccountReport> searchResult, List<Integer> contractIds, List<Integer> invoiceTypeIds, List<Integer> paymentTypeIds) throws BGException {
        if (searchResult != null && contractIds != null) {
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            try {
                AccountReport accountReport;
                StringBuilder sql = new StringBuilder().append("SELECT ").append("doc.id, cid, type, format_number, create_dt AS createDate, summ AS debetSum, 0 AS creditSum, '\u041f\u0440\u043e\u0434\u0430\u0436\u0430' AS operation, '\u0410\u043a\u0442' AS documentName").append(" FROM ").append("bill_invoice_data_").append(this.moduleId).append(" AS doc").append(" WHERE ").append(" cid IN (").append(contractIds.isEmpty() ? "0" : Utils.toString(contractIds)).append(")");
                if (invoiceTypeIds != null && !invoiceTypeIds.isEmpty()) {
                    sql.append("AND type IN (").append(Utils.toString(invoiceTypeIds)).append(")");
                }
                sql.append(period != null && period.getDateFrom() != null ? " AND create_dt >= ?" : "").append(period != null && period.getDateTo() != null ? " AND create_dt <= ?" : "").toString();
                int parameterIndex = 1;
                PreparedStatement psSelect = this.con.prepareStatement(sql.toString());
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        psSelect.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        psSelect.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                    }
                }
                ResultSet resultSet = psSelect.executeQuery();
                while (resultSet.next()) {
                    accountReport = this.getFromRS(resultSet);
                    accountReport.setType(resultSet.getInt("type"));
                    list.add(accountReport);
                }
                resultSet.close();
                psSelect.close();
                sql = new StringBuilder().append("SELECT ").append("doc.id, cid, pt, '\u0431/\u043d' AS format_number, dt AS createDate, summa AS creditSum, 0 AS debetSum, '\u041f\u0440\u0438\u0445\u043e\u0434' AS operation, doc.comment AS documentName").append(" FROM ").append("contract_payment").append(" AS doc").append(" WHERE ").append(" cid IN (").append(Utils.toString(contractIds)).append(")").append(period != null && period.getDateFrom() != null ? " AND dt >= ?" : "").append(period != null && period.getDateTo() != null ? " AND dt <= ?" : "");
                if (paymentTypeIds != null && !paymentTypeIds.isEmpty()) {
                    sql.append("AND pt IN (").append(Utils.toString(paymentTypeIds)).append(")");
                }
                parameterIndex = 1;
                psSelect = this.con.prepareStatement(sql.toString());
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        psSelect.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        psSelect.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                    }
                }
                resultSet = psSelect.executeQuery();
                while (resultSet.next()) {
                    accountReport = this.getFromRS(resultSet);
                    accountReport.setType(resultSet.getInt("pt"));
                    list.add(accountReport);
                }
                resultSet.close();
                psSelect.close();
                Collections.sort(list);
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    protected AccountReport getFromRS(ResultSet resultSet) throws SQLException, BGException {
        AccountReport accountReport = new AccountReport();
        accountReport.setId(resultSet.getInt("id"));
        accountReport.setCreateDate((Date)resultSet.getTimestamp("createDate"));
        accountReport.setContractId(resultSet.getInt("cid"));
        accountReport.setDebetSum(resultSet.getBigDecimal("debetSum"));
        accountReport.setCreditSum(resultSet.getBigDecimal("creditSum"));
        accountReport.setDocumentId(resultSet.getInt("doc.id"));
        accountReport.setDocumentNumber(resultSet.getString("format_number"));
        accountReport.setDocument(resultSet.getString("operation") + " (" + resultSet.getString("documentName") + " \u2116 " + accountReport.getDocumentNumber() + " \u043e\u0442 " + this.dateFormat.format(accountReport.getCreateDate()) + ")");
        return accountReport;
    }

    protected void updateImpl(AccountReport accountReport) throws SQLException {
    }
}

