/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.bill.client.BillDoc;
import ru.bitel.bgbilling.modules.bill.client.ServiceConfigBillGenerate;
import ru.bitel.bgbilling.modules.bill.client.ServiceConfigBillViewer;
import ru.bitel.bgbilling.modules.bill.client.bean.BillPositionsEditor;
import ru.bitel.bgbilling.modules.bill.client.bean.ConfirmPayBillDialog;
import ru.bitel.bgbilling.modules.bill.client.bean.GenerateInvoiceMenu;
import ru.bitel.bgbilling.modules.bill.client.bean.SelectDateDialog;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ServiceReportPanel
extends ServicePanel {
    private static final String VIEW_MODE_VIEW = "view";
    private static final String VIEW_MODE_BILL = "bill";
    private static final String VIEW_MODE_REPORT = "report";
    private static final String VIEW_MODE_INVOICE = "invoice";
    private static final String VIEW_MODE_GENERATE = "generate";
    private CardLayout mainCardLayout = new CardLayout();
    private ServiceConfigBillViewer viewer = new ServiceConfigBillViewer(true);
    private BGControlPanelPages page = new BGControlPanelPages();
    private JLabel recordCountLabel = new JLabel();
    private CardLayout tableCardLayout = new CardLayout();
    private JPanel tablePanel = new JPanel(this.tableCardLayout);
    private ServiceConfigBillGenerate generatePanel = new ServiceConfigBillGenerate(false);
    private BillPositionsEditor positionsEditorBill;
    private BillPositionsEditor positionsEditorInvoice;
    private BGUTable billTable = null;
    private BGUTable invoiceTable = null;
    private BGTableModel<Element> tableModel = null;
    private BillTableModel billTableModel = null;
    private InvoiceTableModel invoiceTableModel = null;
    private ActionListener editActionListener = null;
    private ActionListener showActionListener = null;
    private JPopupMenu billPopupMenu = null;
    private JPopupMenu invoicePopupMenu = null;
    private ButtonGroup buttonGroup = null;
    JPanel bottomPanel;
    private JLabel allSumLabel = new JLabel();
    private int pay = 0;
    private ReportToggleButton generateButton = null;
    private GenerateInvoiceMenu generateInvoiceMenu = null;
    private Directory<UserInfo> userDirectory;

    public ServiceReportPanel() {
        this.jbInit();
    }

    public void editItem() {
        String mode = this.buttonGroup.getSelection().getActionCommand();
        if (VIEW_MODE_BILL.equals(mode)) {
            this.positionsEditorBill.editItem();
        } else {
            this.positionsEditorInvoice.editItem();
        }
    }

    public void deleteItem() {
        String mode = this.buttonGroup.getSelection().getActionCommand();
        if (!VIEW_MODE_GENERATE.equals(mode)) {
            String message;
            List rows = this.tableModel.getSelectedRows();
            if (rows.isEmpty()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
                return;
            }
            switch (mode) {
                case "bill": {
                    String string = "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0447\u0435\u0442\u0430?";
                    break;
                }
                case "invoice": {
                    String string = "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0410\u043a\u0442\u044b, \u0423\u041f\u0414?";
                    break;
                }
                default: {
                    String string = message = "";
                }
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                List<Integer> ids = rows.stream().map(a -> Utils.parseInt((String)a.getAttribute("id"))).toList();
                this.tryCall(() -> {
                    if (VIEW_MODE_BILL.equals(mode)) {
                        ((BillService)this.getContext().getWebService(BillService.class)).billDelete(ids);
                    } else {
                        ((BillService)this.getContext().getWebService(BillService.class)).invoiceDelete(ids);
                    }
                    this.trySetData();
                });
            }
        }
    }

    private void jbInit() {
        this.showActionListener = e -> this.showDocs();
        this.editActionListener = e -> this.editItem();
        ActionListener whatShowActionListener = e -> this.showPanel(e.getActionCommand());
        ReportToggleButton billButton = new ReportToggleButton("\u0441\u0447\u0435\u0442\u0430", VIEW_MODE_BILL, whatShowActionListener, true);
        ReportToggleButton invoiceButton = new ReportToggleButton("\u0441\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0430\u043a\u0442\u044b, \u0423\u041f\u0414", VIEW_MODE_INVOICE, whatShowActionListener, false);
        this.generateButton = new ReportToggleButton("\u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432", VIEW_MODE_GENERATE, whatShowActionListener, false);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(billButton);
        this.buttonGroup.add(invoiceButton);
        this.buttonGroup.add(this.generateButton);
        this.buttonGroup.setSelected(billButton.getModel(), true);
        this.viewer.addPropertyChangeListener(e -> {
            if ("toList".equals(e.getPropertyName())) {
                this.mainCardLayout.show((Container)((Object)this), VIEW_MODE_REPORT);
            }
        });
        int index = 0;
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.add((Component)billButton, new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        headerPanel.add((Component)invoiceButton, new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        headerPanel.add((Component)this.generateButton, new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        headerPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(index++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        headerPanel.add((Component)this.recordCountLabel, new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 15), 0, 0));
        headerPanel.add((Component)this.page, new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.tablePanel.add((Component)this.getBillPanel(), VIEW_MODE_BILL);
        this.tablePanel.add((Component)this.getInvoicePanel(), VIEW_MODE_INVOICE);
        this.tablePanel.add((Component)((Object)this.generatePanel), VIEW_MODE_GENERATE);
        this.bottomPanel = new JPanel(new GridBagLayout());
        this.bottomPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.bottomPanel.add((Component)this.allSumLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 17), 0, 0));
        JPanel reportPanel = new JPanel(new GridBagLayout());
        reportPanel.add((Component)headerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        reportPanel.add((Component)this.tablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        reportPanel.add((Component)this.bottomPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        JPanel viewPanel = new JPanel(new GridBagLayout());
        viewPanel.add((Component)((Object)this.viewer), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.page.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.trySetData();
            }
        });
        this.setLayout(this.mainCardLayout);
        this.add(viewPanel, VIEW_MODE_VIEW);
        this.add(reportPanel, VIEW_MODE_REPORT);
        this.mainCardLayout.show((Container)((Object)this), VIEW_MODE_REPORT);
        this.tableCardLayout.show(this.tablePanel, VIEW_MODE_BILL);
    }

    private JPanel getBillPanel() {
        this.billTableModel = new BillTableModel(BillTableModel.class.getName());
        this.positionsEditorBill = new BillPositionsEditor((BGPanel)this, null, true, VIEW_MODE_BILL, this.billTableModel);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.getBillTable()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.positionsEditorBill.getPositionsPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getInvoicePanel() {
        this.invoiceTableModel = new InvoiceTableModel(InvoiceTableModel.class.getName());
        this.positionsEditorInvoice = new BillPositionsEditor((BGPanel)this, null, true, VIEW_MODE_INVOICE, this.invoiceTableModel);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.getInvoiceTable()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.positionsEditorInvoice.getPositionsPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private void showPanel(String name) {
        if (VIEW_MODE_INVOICE.equals(name)) {
            this.invoicePopupMenu = null;
        }
        this.tableCardLayout.show(this.tablePanel, name);
        boolean flag = VIEW_MODE_GENERATE.equals(name);
        this.recordCountLabel.setVisible(!flag);
        this.page.setVisible(!flag);
        this.bottomPanel.setVisible(!flag);
        if (flag) {
            this.generatePanel.setData();
        } else {
            this.trySetData();
        }
    }

    public void setData() throws Exception {
        this.tryCall(() -> {
            this.userDirectory = this.userDirectory == null ? this.getContext().getDirectory(UserInfo.class, 0) : this.userDirectory;
        });
        this.viewer.setContractId(this.getContractId());
        String mode = this.buttonGroup.getSelection().getActionCommand();
        String action = mode.equals(VIEW_MODE_BILL) ? "ContractBill" : "ContractInvoice";
        this.tableModel = mode.equals(VIEW_MODE_BILL) ? this.billTableModel : this.invoiceTableModel;
        Request request = new Request().setModule(this.module).setAction(action).setModuleId(this.getModuleId()).setContractId(this.getContractId()).setPage(this.page);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            Element tableElement = XMLUtils.getElement((Document)doc, (String)"table");
            ArrayList<Element> tableData = new ArrayList<Element>();
            BigDecimal totalSum = BigDecimal.ZERO;
            for (Element rowElement : XMLUtils.selectElements((Node)tableElement, (String)"data/row")) {
                totalSum = Utils.parseBigDecimal((String)rowElement.getAttribute("summ"), (BigDecimal)BigDecimal.ZERO).add(totalSum);
                rowElement.setAttribute("cid", String.valueOf(this.getContractId()));
                tableData.add(rowElement);
            }
            this.allSumLabel.setText("\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430: " + Utils.formatCostByGrouping((BigDecimal)totalSum, (int)3, (int)2));
            this.tableModel.setData(tableData);
            this.page.setPageInfo(tableElement);
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + tableElement.getAttribute("recordCount"));
            Element payElement = XMLUtils.selectElement((Node)doc, (String)"//pay");
            if (payElement != null) {
                this.pay = Utils.parseInt((String)XMLUtils.getAttribute((Element)payElement, (String)"pay"), (int)0);
            }
        }
        if (ClientUtils.checkStatus((Document)(doc = this.getDocument(request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("BillPositionList").setAttribute("parsed", "1"))))) {
            this.positionsEditorBill.setPositionList(XMLUtils.getNode((Document)doc, (String)"positions"));
        }
        if (ClientUtils.checkStatus((Document)(doc = this.getDocument(request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("InvoicePositionList").setAttribute("parsed", "1"))))) {
            this.positionsEditorInvoice.setPositionList(XMLUtils.getNode((Document)doc, (String)"positions"));
        }
        this.tableCardLayout.show(this.tablePanel, mode);
    }

    private void showDocs() {
        DocumentType mode = this.tableModel == this.invoiceTableModel ? DocumentType.INVOICE : DocumentType.BILL;
        ArrayList<BillDoc> docList = new ArrayList<BillDoc>();
        for (Element rowElement : this.tableModel.getSelectedRows()) {
            BillDoc doc = new BillDoc();
            doc.type = mode;
            doc.cid = this.getContractId();
            doc.docId = Utils.parseInt((String)rowElement.getAttribute("id"));
            doc.number = rowElement.getAttribute("number");
            docList.add(doc);
        }
        if (!docList.isEmpty()) {
            this.viewer.openDocuments(docList, false);
            this.mainCardLayout.show((Container)((Object)this), VIEW_MODE_VIEW);
        }
    }

    public void init(int contractId, int moduleId) {
        super.init(contractId, moduleId);
        this.viewer.init(this.module, moduleId);
        this.positionsEditorBill.init(this.module, moduleId);
        this.positionsEditorInvoice.init(this.module, moduleId);
        this.generatePanel.init(this.module, moduleId);
        this.generatePanel.setContractId(contractId);
    }

    private void setPayed(boolean payed, Date date, boolean checkWeekend) {
        Calendar calendar;
        List rows = this.billTableModel.getSelectedRows();
        if (rows.isEmpty()) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
            return;
        }
        if (checkWeekend && date != null && ((calendar = TimeUtils.convertDateToCalendar((Date)date)).get(7) == 1 || calendar.get(7) == 7) && !ClientUtils.confirm((String)"\u0414\u0430\u0442\u0430 \u043f\u043e\u043f\u0430\u0434\u0430\u0435\u0442 \u043d\u0430 \u0432\u044b\u0445\u043e\u0434\u043d\u043e\u0439 \u0434\u0435\u043d\u044c, \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?", (String)"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043e\u043f\u043b\u0430\u0442\u044b")) {
            return;
        }
        int result = 0;
        if (payed && this.pay == 2) {
            for (Element rowElement : rows) {
                StringBuilder sb = new StringBuilder().append(rowElement.getAttribute("id")).append(":").append(rowElement.getAttribute("cid")).append(";");
                Map<String, String> data = this.getMapData(rowElement);
                String summAndComment = ConfirmPayBillDialog.showConfirmDialog(JOptionPane.getRootFrame(), data);
                if (summAndComment == null) continue;
                result = this.doSetPayed(payed, date, summAndComment, sb.toString()) ? 1 : 0;
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (Element rowElement : rows) {
                sb.append(rowElement.getAttribute("id"));
                sb.append(":");
                sb.append(rowElement.getAttribute("cid"));
                sb.append(";");
            }
            int n = result = this.doSetPayed(payed, date, null, sb.toString()) ? 1 : 0;
        }
        if (result > 0) {
            this.trySetData();
        }
    }

    private boolean doSetPayed(boolean payed, Date date, String sumComment, String ids) {
        Document doc;
        boolean result = false;
        Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("SetPayed").setAttribute("value", String.valueOf(payed)).setAttribute("ids", ids);
        if (date != null) {
            request.setAttribute("date", TimeUtils.format((Date)date, (String)"dd.MM.yyyy"));
        }
        if (sumComment != null) {
            request.setAttribute("summComment", sumComment);
        }
        if (ClientUtils.checkStatus((Document)(doc = this.getDocument(request)))) {
            result = true;
        }
        return result;
    }

    private Map<String, String> getMapData(Element rowElement) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("contract", rowElement.getAttribute("contract"));
        data.put("number", rowElement.getAttribute("number"));
        data.put("create_dt", rowElement.getAttribute("create_dt"));
        data.put("summ", rowElement.getAttribute("summ"));
        return data;
    }

    private BGUTable getBillTable() {
        if (this.billTable == null) {
            this.billTable = new BGUTable((TableModel)((Object)this.billTableModel));
            this.billTable.setSelectionMode(2);
            this.billTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && ServiceReportPanel.this.valueInArray(ServiceReportPanel.this.billTable.rowAtPoint(mouseEvent.getPoint()), ServiceReportPanel.this.billTable.getSelectedRows())) {
                        ServiceReportPanel.this.getBillPopupMenu().show((Component)ServiceReportPanel.this.billTable, mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getClickCount() == 2 && mouseEvent.getClickCount() == 2) {
                        ServiceReportPanel.this.showDocs();
                    }
                    super.mouseClicked(mouseEvent);
                }
            });
        }
        return this.billTable;
    }

    private JPopupMenu getBillPopupMenu() {
        if (this.billPopupMenu == null) {
            ActionListener actionListener = e -> {
                int[] idArray = Utils.toIntArray((String)e.getActionCommand());
                if (idArray[2] > 0 && idArray[1] > 0 && idArray[0] > 0) {
                    this.tryCall(() -> {
                        this.buttonGroup.setSelected(this.generateButton.getModel(), true);
                        this.generatePanel.setDocumentTypeSelectedIndex(1);
                        this.generatePanel.getTemplateBillList(false, String.valueOf(idArray[1]), VIEW_MODE_INVOICE, idArray[2], String.valueOf(idArray[0]), VIEW_MODE_BILL);
                        this.generatePanel.setTableSelectedIndex(0);
                        this.generatePanel.setTableSelectionV();
                        this.showPanel(VIEW_MODE_GENERATE);
                    });
                }
            };
            this.generateInvoiceMenu = new GenerateInvoiceMenu("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0443, \u0410\u043a\u0442, \u0423\u041f\u0414", this.tableModel, actionListener, () -> this.getDocType());
            this.billPopupMenu = new JPopupMenu();
            this.billPopupMenu.add("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(this.editActionListener);
            this.billPopupMenu.addSeparator();
            this.billPopupMenu.add("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c").addActionListener(this.showActionListener);
            this.billPopupMenu.addSeparator();
            this.billPopupMenu.add("\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043e \u0441\u0435\u0433\u043e\u0434\u043d\u044f (" + TimeUtils.format((LocalDate)LocalDate.now(), (String)"dd.MM, EEE") + ")").addActionListener(e -> this.setPayed(true, new GregorianCalendar().getTime(), true));
            this.billPopupMenu.add("\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043e \u0432\u0447\u0435\u0440\u0430 (" + TimeUtils.format((LocalDate)LocalDate.now().minusDays(1L), (String)"dd.MM, EEE") + ")").addActionListener(e -> {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.set(5, calendar.get(5) - 1);
                this.setPayed(true, calendar.getTime(), true);
            });
            this.billPopupMenu.add("\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043e \u043d\u0430 \u0434\u0430\u0442\u0443").addActionListener(e -> {
                SelectDateDialog sdd = new SelectDateDialog();
                sdd.setVisible(true);
                Calendar calendar = sdd.getCalendar();
                if (calendar != null) {
                    this.setPayed(true, calendar.getTime(), false);
                }
            });
            this.billPopupMenu.addSeparator();
            this.billPopupMenu.add("\u041d\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043e").addActionListener(e -> this.setPayed(false, null, false));
            this.billPopupMenu.addSeparator();
            this.billPopupMenu.add(this.generateInvoiceMenu);
            this.billPopupMenu.addSeparator();
            this.billPopupMenu.add(this.getChangeDocTypeMenu(DocumentType.BILL));
        }
        return this.billPopupMenu;
    }

    private List<IdTitle> getDocType() {
        try {
            return ((BillService)this.getContext().getWebService(BillService.class, this.getModuleId())).docTypeTitles(this.getContractId(), DocumentType.INVOICE);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
            return Collections.emptyList();
        }
    }

    private BGUTable getInvoiceTable() {
        if (this.invoiceTable == null) {
            this.invoiceTable = new BGUTable((TableModel)((Object)this.invoiceTableModel));
            this.invoiceTable.setSelectionMode(2);
            this.invoiceTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && ServiceReportPanel.this.valueInArray(ServiceReportPanel.this.invoiceTable.rowAtPoint(mouseEvent.getPoint()), ServiceReportPanel.this.invoiceTable.getSelectedRows())) {
                        ServiceReportPanel.this.getInvoicePopupMenu().show((Component)ServiceReportPanel.this.invoiceTable, mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getClickCount() == 2 && mouseEvent.getClickCount() == 2) {
                        ServiceReportPanel.this.showDocs();
                    }
                    super.mouseClicked(mouseEvent);
                }
            });
        }
        return this.invoiceTable;
    }

    private JPopupMenu getInvoicePopupMenu() {
        if (this.invoicePopupMenu == null) {
            this.invoicePopupMenu = new JPopupMenu();
            this.invoicePopupMenu.add("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(this.editActionListener);
            this.invoicePopupMenu.addSeparator();
            this.invoicePopupMenu.add("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c").addActionListener(this.showActionListener);
            this.invoicePopupMenu.addSeparator();
            this.invoicePopupMenu.add("\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u043a \u043f\u043e\u043a\u0430\u0437\u0443").addActionListener(e -> this.setShowReady(true));
            this.invoicePopupMenu.add("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043a \u043f\u043e\u043a\u0430\u0437\u0443").addActionListener(e -> this.setShowReady(false));
            this.invoicePopupMenu.addSeparator();
            this.invoicePopupMenu.add(this.getChangeDocTypeMenu(DocumentType.INVOICE));
        }
        return this.invoicePopupMenu;
    }

    private JMenu getChangeDocTypeMenu(DocumentType documentType) {
        JMenu changeDocTypeMenu = new JMenu("\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0430 ...");
        try {
            ActionListener actionListener = e -> {
                StringBuilder sb = new StringBuilder();
                for (Element rowElement : this.tableModel.getSelectedRows()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(rowElement.getAttribute("id"));
                }
                Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("ContractDocumentDocTypeUpdate").setAttribute("documentType", documentType.getCode()).setAttribute("documentTypeId", Utils.parseInt((String)e.getActionCommand(), (int)0)).setAttribute("documentIds", sb.toString());
                if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                    this.trySetData();
                }
            };
            for (DocType docType : ((BillService)this.getContext().getPort(BillService.class)).docTypeListForContract(this.getContractId(), documentType)) {
                JMenuItem docTypeMenuItem = new JMenuItem(docType.getTitle());
                docTypeMenuItem.setActionCommand(String.valueOf(docType.getId()));
                docTypeMenuItem.addActionListener(actionListener);
                changeDocTypeMenu.add(docTypeMenuItem);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        return changeDocTypeMenu;
    }

    private boolean valueInArray(int value, int[] array) {
        boolean result = false;
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                boolean bl = result = value == array[i];
                if (result) break;
            }
        }
        return result;
    }

    private void setShowReady(boolean ready) {
        ArrayList<Integer> ids1 = new ArrayList<Integer>();
        for (Element rowElement : this.tableModel.getSelectedRows()) {
            ids1.add(Utils.parseInt((String)rowElement.getAttribute("id")));
        }
        String ids = Utils.toString(ids1);
        if (Utils.isBlankString((String)ids)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0438");
        } else {
            Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("SetShowReady").setAttribute("ids", ids).setAttribute("ready", ready ? "1" : "0");
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.trySetData();
            }
        }
    }

    class BillTableModel
    extends BGTableModel<Element> {
        public BillTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("type", 0, 0, 0, "type", false);
            this.addColumnId();
            this.addColumn("\u0413\u043e\u0434.\u041c\u0435\u0441\u044f\u0446", 100, 100, 100, "month", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u043e\u043c\u0435\u0440", 100, 100, 100, "number", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", Date.class, 120, 120, 120, "create_dt", true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 100, 100, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f", 100, 100, -1, "type_title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043b", 180, 180, 180, "who_created", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u043e\u043f\u043b\u0430\u0442\u044b", Date.class, 120, 120, 120, "pay_dt", true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u041e\u0442\u043c\u0435\u0442\u0438\u043b \u043e\u043f\u043b\u0430\u0442\u0443", 180, 180, 180, "who_payed", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", BigDecimal.class, 120, 120, 120, "summ", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }

        public Object getValue(Element value, int column) throws Exception {
            switch (this.getIdentifier(column)) {
                case "create_dt": {
                    return TimeUtils.parseDate((String)value.getAttribute("create_dt"), (String)"dd.MM.yyyy");
                }
                case "pay_dt": {
                    return TimeUtils.parseDate((String)value.getAttribute("pay_dt"), (String)"dd.MM.yyyy");
                }
                case "summ": {
                    return new BigDecimal(value.getAttribute("summ"));
                }
            }
            return super.getValue((Object)value, column);
        }
    }

    class InvoiceTableModel
    extends BGTableModel<Element> {
        public InvoiceTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("type", 0, 0, 0, "type", false);
            this.addColumnId();
            this.addColumn("\u0413\u043e\u0434.\u041c\u0435\u0441\u044f\u0446", 100, 100, 100, "month", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u043e\u043c\u0435\u0440", 100, 100, 100, "number", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", Date.class, 120, 120, 120, "create_dt", true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0422\u0438\u043f", 100, 100, -1, "type_title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043b", -1, 200, 300, "userId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432 \u041b\u041a", Boolean.class, 120, 120, 120, "show_ready", true);
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", BigDecimal.class, 120, 120, 120, "summ", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }

        public Object getValue(Element value, int column) throws Exception {
            switch (this.getIdentifier(column)) {
                case "create_dt": {
                    return TimeUtils.parseDate((String)value.getAttribute("create_dt"), (String)"dd.MM.yyyy");
                }
                case "show_ready": {
                    return Boolean.valueOf(value.getAttribute("show_ready"));
                }
                case "userId": {
                    UserInfo userInfo = (UserInfo)ServiceReportPanel.this.userDirectory.get(Utils.parseInt((String)value.getAttribute("userId"), (int)-5));
                    return userInfo == null ? "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : userInfo.getName();
                }
                case "summ": {
                    return new BigDecimal(value.getAttribute("summ"));
                }
            }
            return super.getValue((Object)value, column);
        }
    }

    class ReportToggleButton
    extends JToggleButton {
        public ReportToggleButton(String text, String actionCommand, ActionListener actionListener, boolean selected) {
            super(text, selected);
            this.setActionCommand(actionCommand);
            this.addActionListener(actionListener);
        }
    }
}

