/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import bitel.billing.server.ActionConType;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.bill.common.bean.BillListFilter;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.SortMode;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.Invoice;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@ActionConType(value=2)
public class ActionInvoice
extends ActionBase {
    public void doAction() throws Exception {
        boolean forRegister;
        List<Invoice> payInvoiceList;
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        BillListFilter billListFilter = new BillListFilter().setContractTitle(this.getParameter("contract", "")).setBillNumber(this.getParameter("billNumber", "")).setYear(this.getIntParameter("y", 0)).setMonth(this.getIntParameter("m", -1)).setPackageId(this.getIntParameter("package", -1)).setUnloadType(this.getIntParameter("unload_type", 0)).setTypeIds(Utils.toIntegerList((String)this.getParameter("type", ""))).setContractLabelIds(Utils.toIntegerList((String)this.getParameter("gr", ""))).setContractLabelMode(this.getParameter("gr_mode", "or")).setPackageParamId(this.getPackageParamId()).setNameSortParam(this.getNameSortParamId()).setAddressSortParamId(this.getAddressSortParamId()).setPrimarySortMode(this.getIntParameter("sort_mode", SortMode.CONTRACT.getCode())).setSecondarySortMode(this.getIntParameter("secondary_sort_mode", -1)).setPage(this.getPage());
        String sFrom = this.getParameter("from", "");
        String sUntil = this.getParameter("until", "");
        boolean getXml = Utils.notBlankString((String)this.getParameter("get_xml"));
        Calendar from = null;
        Calendar until = null;
        if (!Utils.isEmptyString((String)sFrom)) {
            from = TimeUtils.convertStringToCalendar((String)sFrom);
        }
        if (!Utils.isEmptyString((String)sUntil)) {
            until = TimeUtils.convertStringToCalendar((String)sUntil);
        }
        if ((payInvoiceList = new InvoiceManager(this.conSlave, this.mid).getInvoiceList(billListFilter, from, until, getXml, forRegister = this.getIntParameter("forRegister", 0) == 1)) == null) {
            return;
        }
        Document doc = this.rootNode.getOwnerDocument();
        BigDecimal sum = BigDecimal.ZERO;
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        this.setPageAttribute(table, billListFilter.getPage());
        StringBuilder contractAndComment = new StringBuilder();
        for (Invoice payInvoice : payInvoiceList) {
            Element row = this.createElement(data, "row");
            sum = sum.add(payInvoice.getSumm());
            contractAndComment.setLength(0);
            contractAndComment.append(payInvoice.getContractTitle());
            if (payInvoice.getContractComment() != null) {
                contractAndComment.append(" [ ").append(payInvoice.getContractComment()).append(" ]");
            }
            row.setAttribute("id", String.valueOf(payInvoice.getId()));
            row.setAttribute("cid", String.valueOf(payInvoice.getContractId()));
            row.setAttribute("contract", payInvoice.getContractTitle());
            row.setAttribute("contract_and_comment", contractAndComment.toString());
            row.setAttribute("number", String.valueOf(payInvoice.getFormatNumber()));
            row.setAttribute("create_dt", TimeUtils.formatDate((Date)payInvoice.getCreateDate()));
            row.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)payInvoice.getSumm()));
            row.setAttribute("sum", Utils.formatBigDecimalSumm((BigDecimal)payInvoice.getSumm()));
            row.setAttribute("unload_status", payInvoice.getUnloadStatus() == 0 ? "\u043d\u0435 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d" : "\u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d");
            row.setAttribute("show_ready", String.valueOf(payInvoice.isShowReady()));
            row.setAttribute("type", String.valueOf(payInvoice.getTypeId()));
            row.setAttribute("type_title", Utils.maskNull((String)payInvoice.getTypeTitle()));
            row.setAttribute("userId", String.valueOf(payInvoice.getUserId()));
            if (forRegister) {
                row.setAttribute("address", Utils.maskNull((String)payInvoice.getAddress()));
                row.setAttribute("recipient", Utils.maskNull((String)payInvoice.getRecipient()));
            }
            if (!getXml) continue;
            row.appendChild(doc.importNode(payInvoice.getDocument().getDocumentElement(), true));
        }
        table.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)sum));
        table.setAttribute("number", String.valueOf(payInvoiceList.size()));
        this.createElement(this.rootNode, "separator").setAttribute("separator", this.moduleSetup.get("csv.separator", ","));
    }
}

