/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.bill.common.bean.NumerationPool;
import ru.bitel.common.model.LoggingAbstractManager;
import ru.bitel.common.model.Pair;

public class NumerationPoolManager
extends LoggingAbstractManager<NumerationPool> {
    private Connection con;
    private int moduleId;
    private static Map<Pair<Integer, Integer>, NumerationPool> poolMap = new ConcurrentHashMap<Pair<Integer, Integer>, NumerationPool>();

    public NumerationPoolManager(Connection con, int moduleId, int userId) {
        super(con, "bill_numeration_pool", moduleId, userId);
        this.con = con;
        this.moduleId = moduleId;
    }

    public List<NumerationPool> list() throws BGException {
        return this.list("", "id", new Object[0]);
    }

    protected NumerationPool getFromRS(ResultSet rs) throws SQLException {
        NumerationPool np = new NumerationPool();
        np.setId(rs.getInt("id"));
        np.setTitle(rs.getString("title"));
        np.setPattern(rs.getString("pattern"));
        return np;
    }

    protected NumerationPool getImpl(int id) throws BGException, SQLException {
        NumerationPool np = (NumerationPool)super.getImpl(id);
        poolMap.put((Pair<Integer, Integer>)new Pair((Object)this.moduleId, (Object)id), np);
        return np;
    }

    protected void updateImpl(NumerationPool b) throws BGException, SQLException {
        Object query = "";
        query = b.getId() < 0 ? "INSERT INTO " + this.tableName + "(title, pattern) VALUES(?,?)" : "UPDATE " + this.tableName + " SET title=?, pattern=? WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement((String)query, 1);
        String titleValue = null;
        switch (b.getId()) {
            case 1: {
                titleValue = "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e (\u0441\u0447\u0435\u0442\u0430)";
                break;
            }
            case 2: {
                titleValue = "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e (\u0441\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0430\u043a\u0442\u044b, \u0423\u041f\u0414)";
                break;
            }
            default: {
                titleValue = b.getTitle();
            }
        }
        ps.setString(1, titleValue);
        ps.setString(2, b.getPattern());
        if (b.getId() >= 0) {
            ps.setInt(3, b.getId());
        }
        ps.executeUpdate();
        if (b.getId() < 0) {
            ResultSet rs = ps.getGeneratedKeys();
            if (rs.next()) {
                b.setId(rs.getInt(1));
            }
            rs.close();
            ps.close();
        }
        poolMap.put((Pair<Integer, Integer>)new Pair((Object)this.moduleId, (Object)b.getId()), b);
        ps.close();
    }

    protected int deleteImpl(int id) throws BGException, SQLException {
        if (id == 1 || id == 2) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0443\u043b \"\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e\"");
        }
        String query = "SELECT title FROM bill_doc_type_" + this.moduleId + " WHERE npid = ?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        int count = 0;
        StringBuilder sb = null;
        while (rs.next()) {
            if (sb == null) {
                sb = new StringBuilder(100);
                sb.append("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0443\u043b, \u0442.\u043a. \u043e\u043d \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u043a \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u043c \u0442\u0438\u043f\u0430\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432:\n");
            }
            if (count < 3) {
                sb.append(rs.getString(1));
                sb.append("\n");
            }
            ++count;
        }
        rs.close();
        ps.close();
        if (sb != null) {
            if (count >= 3) {
                sb.append("...\n");
            }
            sb.append("\u0412\u0441\u0435\u0433\u043e: ");
            sb.append(count);
            throw new BGMessageException(sb.toString());
        }
        poolMap.remove(new Pair((Object)this.moduleId, (Object)id));
        return super.deleteImpl(id);
    }

    public static String formatNumber(int poolId, int yy, int mm, int num, int num_in_month, int num_in_year, Connection con, int mid) throws Exception {
        return NumerationPoolManager.formatNumber(poolId, yy, mm, num, num_in_month, num_in_year, con, mid, 0);
    }

    public static String formatNumber(int poolId, int yy, int mm, int num, int num_in_month, int num_in_year, Connection con, int moduleId, int contractId) throws Exception {
        NumerationPool curPool = poolMap.get(new Pair((Object)moduleId, (Object)poolId));
        if (curPool == null) {
            try (NumerationPoolManager numerationPoolManager = new NumerationPoolManager(con, moduleId, 0);){
                curPool = (NumerationPool)numerationPoolManager.get(poolId);
            }
        }
        String matching = curPool.getPattern();
        Pattern p = Pattern.compile("\\$number_in_month\\{(\\d+)\\}");
        Matcher m = p.matcher(matching);
        if (m.find()) {
            matching = m.replaceAll(String.format("%1$0" + m.group(1) + "d", num_in_month));
        }
        if ((m = (p = Pattern.compile("\\$number_in_year\\{(\\d+)\\}")).matcher(matching)).find()) {
            matching = m.replaceAll(String.format("%1$0" + m.group(1) + "d", num_in_year));
        }
        if ((m = (p = Pattern.compile("\\$number\\{(\\d+)\\}")).matcher(matching)).find()) {
            matching = m.replaceAll(String.format("%1$0" + m.group(1) + "d", num));
        }
        if ((m = (p = Pattern.compile("\\$number\\{(\\d+)[;,\\,](\\d+)\\}")).matcher(matching)).find()) {
            matching = m.replaceAll(String.format("%1$0" + m.group(2) + "d", Integer.valueOf(m.group(1)) + num));
        }
        p = Pattern.compile("\\$month");
        m = p.matcher(matching);
        matching = m.replaceAll(String.format("%1$02d", mm + 1));
        p = Pattern.compile("\\$year");
        m = p.matcher(matching);
        matching = m.replaceAll(String.valueOf(yy));
        if (contractId > 0 && (m = (p = Pattern.compile("\\$contract_title")).matcher(matching)).find()) {
            String replacement = "";
            Contract contract = new ContractManager(con).getContractById(contractId);
            if (contract != null) {
                replacement = contract.getTitle();
            }
            matching = m.replaceAll(replacement);
        }
        return matching;
    }
}

