/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.action.pub;

import bitel.billing.server.util.captcha.Captcha;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCreateData;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractCreatedEvent;
import ru.bitel.bgbilling.modules.voiceip.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLogin;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLoginManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

public class ActionCreateContract
extends ActionBase {
    private static final Object mutex = new Object();
    private static final Random random = new Random();
    private static final Pattern patEmail = Pattern.compile("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction() throws SQLException, BGException {
        block39: {
            boolean find;
            boolean acceptInReference;
            String alias;
            String email;
            String fio;
            block38: {
                this.session = this.request.getSession(true);
                this.rootNode.setAttribute("xslt", "voiceip_create_contract.xsl");
                this.rootNode.setAttribute("action", "CreateContract");
                this.rootNode.setAttribute("module", "voiceip");
                this.rootNode.setAttribute("mid", String.valueOf(this.mid));
                if (this.mid <= 0) {
                    return;
                }
                int contractPatternId = this.moduleSetup.getInt("web.register.contract.pattern", -1);
                int paramFio = this.moduleSetup.getInt("web.register.fio.param", -1);
                int paramAcceptInRef = this.moduleSetup.getInt("web.register.refbook.param", -1);
                int paramEmail = this.moduleSetup.getInt("web.register.email.param", -1);
                if (contractPatternId <= 0 || paramFio <= 0 || paramAcceptInRef <= 0 || paramEmail <= 0) {
                    log.warn("VoiceIp ActionCreateContract is off or invalid $mid in xls");
                    return;
                }
                if (this.getParameter("getcaptcha") != null) {
                    Captcha.captcha((HttpServletRequest)this.request, (HttpServletResponse)this.response, (HttpSession)this.session, (boolean)false);
                    return;
                }
                String captcha = this.getParameter("captcha");
                fio = this.getParameter("fio");
                email = this.getParameter("email", "").trim();
                alias = this.getParameter("alias", "").trim();
                String passw1 = this.getParameter("passw1", "").trim();
                String passw2 = this.getParameter("passw2", "").trim();
                acceptInReference = "1".equals(this.getParameter("ref"));
                find = false;
                String range = this.moduleSetup.get("web.register.alias.range", null);
                Contract contract = null;
                String aliasOld = (String)this.session.getAttribute("ru.bitel.bgbilling.server.voiceip.Pub_ActionCreateContract.alias");
                if (alias.equals(aliasOld)) {
                    contract = (Contract)this.session.getAttribute("ru.bitel.bgbilling.server.voiceip.Pub_ActionCreateContract.contract");
                }
                try {
                    if (contract == null) {
                        VoiceIpLoginManager loginManager = new VoiceIpLoginManager(this.con, this.mid);
                        if (!(Utils.isBlankString((String)fio) && Utils.isBlankString((String)email) && Utils.isBlankString((String)alias) && Utils.isBlankString((String)captcha))) {
                            if (Utils.isBlankString((String)fio)) {
                                throw new BGMessageException("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0444\u0430\u043c\u0438\u043b\u0438\u044e, \u0438\u043c\u044f, \u043e\u0442\u0447\u0435\u0441\u0442\u0432\u043e.");
                            }
                            Pattern pat = patEmail;
                            String _pat = this.moduleSetup.get("web.register.email.param.pattern", null);
                            if (_pat != null) {
                                pat = Pattern.compile(_pat);
                            }
                            if (Utils.isBlankString((String)email) || !pat.matcher(email).matches()) {
                                throw new BGMessageException("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 email.");
                            }
                            if (Utils.isBlankString((String)alias)) {
                                throw new BGMessageException("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0436\u0435\u043b\u0430\u0435\u043c\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430.");
                            }
                            int size = this.moduleSetup.getInt("web.register.alias.size", -1);
                            if (!this.checkRange(alias, size, this.getRanges(range))) {
                                if (size > 0) {
                                    throw new BGMessageException("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 " + size + " \u0446\u0438\u0444\u0440 \u0438 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 " + range);
                                }
                                throw new BGMessageException("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 " + range);
                            }
                            Object object = mutex;
                            synchronized (object) {
                                if (!loginManager.checkAlias(alias)) {
                                    List<Long> aliases = loginManager.getFirstAliases(this.getRanges(range), 4);
                                    if (aliases != null && aliases.size() > 0) {
                                        Element free = this.createElement(this.rootNode, "free");
                                        for (int i = 0; i < 3 && i < aliases.size(); ++i) {
                                            Element aliasEl = this.createElement(free, "alias");
                                            aliasEl.setAttribute("alias", String.valueOf(aliases.get(i)));
                                        }
                                    }
                                    throw new BGMessageException("\u0418\u0437\u0432\u0438\u043d\u0438\u0442\u0435, \u043d\u043e \u0442\u0430\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 \u0443\u0436\u0435 \u0437\u0430\u043d\u044f\u0442.");
                                }
                                find = true;
                                String error = ContractUtils.checkPassword((ParameterMap)this.setup, (String)passw1, (String)passw2);
                                if (error != null) {
                                    throw new BGException(error);
                                }
                                if (!Captcha.validate((String)captcha, (HttpSession)this.session)) {
                                    throw new BGMessageException("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0442\u0435\u043a\u0441\u0442 \u0441 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
                                }
                                try (ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());){
                                    ContractCreateData data = ContractCreateData.builder().setPatternId(contractPatternId).setDateFrom(new Date()).setPassword(passw1).build();
                                    contract = contractDao.createFromPattern(data, false);
                                    int contractId = contract.getId();
                                    contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrBoolean(contractId, paramAcceptInRef, acceptInReference));
                                    contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrText(contractId, paramFio, fio));
                                    EntityAttrEmail attrEmail = new EntityAttrEmail(contractId, paramEmail);
                                    attrEmail.setData(email);
                                    contractDao.updateContractParameter(contractId, (EntityAttr)attrEmail);
                                }
                                catch (Exception e) {
                                    throw new BGException(e.getMessage());
                                }
                                int type = this.moduleSetup.getInt("web.register.login.type", 0);
                                VoiceIpLogin login = new VoiceIpLogin();
                                login.setContractId(contract.getId());
                                login.setDate1(new Date());
                                login.setComment("\u0421\u043e\u0437\u0434\u0430\u043d \u0447\u0435\u0440\u0435\u0437 web");
                                login.setObjectId(0);
                                login.setType(type);
                                login.setStatus(true);
                                error = loginManager.checkLoginAvailable((Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(this.mid)));
                                if (error != null) {
                                    throw new BGException(error);
                                }
                                login = loginManager.addLogin(login, (Preferences)this.moduleSetup);
                                try {
                                    String query = "UPDATE contract SET comment=? WHERE id=?";
                                    PreparedStatement ps = this.con.prepareStatement(query);
                                    ps.setString(1, fio);
                                    ps.setInt(2, contract.getId());
                                    ps.executeUpdate();
                                    ps.close();
                                    HashSet<String> aliases = new HashSet<String>(1);
                                    aliases.add(alias);
                                    loginManager.updateAliases(login.getId(), aliases);
                                    loginManager.updatePassword(login.getId(), passw1, -1);
                                }
                                catch (SQLException ex) {
                                    ex.printStackTrace();
                                }
                                EventProcessor.getInstance().request((QueueEvent)new ContractCreatedEvent(contract, -1));
                            }
                        }
                        List<Long> aliases = loginManager.getFirstAliases(this.getRanges(range), 1);
                        if (aliases != null && aliases.size() > 0) {
                            alias = String.valueOf(aliases.get(0));
                        }
                    }
                    if (contract == null) break block38;
                }
                catch (Throwable throwable) {
                    if (contract != null) {
                        Element contractEl = this.createElement(this.rootNode, "contract");
                        contractEl.setAttribute("title", contract.getTitle());
                        this.session.setAttribute("ru.bitel.bgbilling.server.voiceip.Pub_ActionCreateContract.alias", (Object)alias);
                        this.session.setAttribute("ru.bitel.bgbilling.server.voiceip.Pub_ActionCreateContract.contract", (Object)contract);
                    } else {
                        Element params = this.createElement(this.rootNode, "params");
                        params.setAttribute("fio", fio);
                        params.setAttribute("email", email);
                        params.setAttribute("alias", alias);
                        params.setAttribute("ref", acceptInReference ? "1" : "0");
                        if (find) {
                            params.setAttribute("find", "1");
                        }
                        params.setAttribute("random", String.valueOf(random.nextInt()));
                    }
                    throw throwable;
                }
                Element contractEl = this.createElement(this.rootNode, "contract");
                contractEl.setAttribute("title", contract.getTitle());
                this.session.setAttribute("ru.bitel.bgbilling.server.voiceip.Pub_ActionCreateContract.alias", (Object)alias);
                this.session.setAttribute("ru.bitel.bgbilling.server.voiceip.Pub_ActionCreateContract.contract", (Object)contract);
                break block39;
            }
            Element params = this.createElement(this.rootNode, "params");
            params.setAttribute("fio", fio);
            params.setAttribute("email", email);
            params.setAttribute("alias", alias);
            params.setAttribute("ref", acceptInReference ? "1" : "0");
            if (find) {
                params.setAttribute("find", "1");
            }
            params.setAttribute("random", String.valueOf(random.nextInt()));
        }
    }

    private List<long[]> getRanges(String range) {
        ArrayList<long[]> result = null;
        if (range != null) {
            String[] ranges = Utils.patternSemicolon.split(range);
            result = new ArrayList<long[]>(ranges.length);
            for (int i = 0; i < ranges.length; ++i) {
                String[] r = ranges[i].split("\\s*-\\s*");
                if (r.length == 2) {
                    result.add(new long[]{Utils.parseLong((String)r[0], (long)Long.MIN_VALUE), Utils.parseLong((String)r[1], (long)Long.MAX_VALUE)});
                    continue;
                }
                result.add(new long[]{Utils.parseLong((String)r[0], (long)Long.MIN_VALUE), Utils.parseLong((String)r[0], (long)Long.MAX_VALUE)});
            }
        }
        return result;
    }

    private boolean checkRange(String alias, int size, List<long[]> ranges) {
        boolean result;
        block2: {
            long[] r;
            result = false;
            if (size > 0 && alias.length() != size) {
                return result;
            }
            long a = Utils.parseLong((String)alias, (long)-1L);
            if (a <= 0L || ranges == null) break block2;
            Iterator<long[]> iterator = ranges.iterator();
            while (iterator.hasNext() && !(result = (r = iterator.next())[0] <= a && r[1] >= a)) {
            }
        }
        return result;
    }
}

