/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffWorkerContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.server.runtime.geocode.GeoCodeCache;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.common.ParameterMap;

public class SetDestinationTariffTreeNode
extends TariffTreeNode<VoiceTariffRequest, VoiceTariffContext, TreeContext, TariffWorkerContext> {
    private final int destId;
    private final String dest_source;

    public SetDestinationTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.destId = parameterMap.getInt("dest", 0);
        this.dest_source = parameterMap.get("dest_source");
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, VoiceTariffRequest req, VoiceTariffContext context, TreeContext treeContext, TariffWorkerContext workerContext) {
        if (this.dest_source.equals("=")) {
            req.setDestId(this.destId);
        } else {
            String phone = req.phoneTo;
            VoiceGeographicCode code = null;
            try {
                code = GeoCodeCache.findCode(phone, workerContext.getModuleId(), req.getOperatorId(), workerContext.getConnection());
            }
            catch (BGException e) {
                this.logger.error("", (Throwable)e);
            }
            if (code != null && code.getDestinationId() > 0) {
                req.setDestId(code.getDestinationId());
            } else {
                this.logger.warn("Destination from " + phone + " not found.");
            }
        }
        return 0;
    }
}

