/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime.geocode;

import java.sql.Connection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.server.bean.code.GeoCodeManager;
import ru.bitel.bgbilling.modules.voice.server.event.GeoCodeUpdateEvent;
import ru.bitel.bgbilling.modules.voice.server.runtime.geocode.GeoNode;

public class GeoCodeCache
implements EventListener<GeoCodeUpdateEvent> {
    private static final ConcurrentHashMap<String, GeoCodeCache> cache = new ConcurrentHashMap();
    private final int moduleId;
    private final int operatorId;
    private GeoNode<Object> root;

    public static synchronized GeoCodeCache getInstance(Connection con, int moduleId, int operatorId) throws BGException {
        String key = moduleId + "_" + operatorId;
        GeoCodeCache geoCodeCache = cache.get(key);
        if (geoCodeCache == null) {
            geoCodeCache = new GeoCodeCache(moduleId, operatorId);
            geoCodeCache.load(con);
            cache.put(key, geoCodeCache);
        }
        return geoCodeCache;
    }

    private GeoCodeCache(int moduleId, int operatorId) throws BGException {
        this.moduleId = moduleId;
        this.operatorId = operatorId;
        EventProcessor.getInstance().addListener((EventListener)this, GeoCodeUpdateEvent.class, moduleId, null);
    }

    public synchronized void load(Connection con) throws BGException {
        try (GeoCodeManager codeManager = new GeoCodeManager(con, this.moduleId, -1);){
            this.root = this.getCodeTree(codeManager);
        }
    }

    private <I> GeoNode<I> getCodeTree(GeoCodeManager codeManager) throws BGException {
        List<VoiceGeographicCode> codeList = codeManager.list(-1, this.operatorId);
        VoiceGeographicCode root = new VoiceGeographicCode();
        root.setCode("");
        root.setLevel(0);
        VoiceGeographicCode[] path = new VoiceGeographicCode[20];
        String lastCode = root.getCode();
        int level = 0;
        path[level] = root;
        GeoNode rootNode = new GeoNode();
        for (VoiceGeographicCode currentCode : codeList) {
            String currCode = currentCode.getCode();
            if (!currCode.startsWith(lastCode)) {
                while (--level >= 0 && !currCode.startsWith(path[level].getCode())) {
                }
            }
            path[++level] = currentCode;
            currentCode.setLevel(level);
            lastCode = currCode;
            rootNode.addCode(currentCode);
        }
        return rootNode;
    }

    public VoiceGeographicCode findCode(String number) {
        return this.root.findCode(number);
    }

    public static VoiceGeographicCode findCode(String number, int moduleId, int operatorId, Connection con) throws BGException {
        GeoCodeCache cashe = GeoCodeCache.getInstance(con, moduleId, operatorId);
        return cashe.findCode(number);
    }

    public void notify(GeoCodeUpdateEvent e, EventListenerContext ctx) throws BGException {
        this.load(ctx.getConnection());
    }
}

