/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.device;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.swing.DropMode;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolBar;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.mediation.VoiceNumberApplyTo;
import ru.bitel.common.Preferences;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.TableRowReorderable;
import ru.bitel.common.client.table.TableRowTransferHandler;

public class VoiceDeviceCdrPanel
extends BGUPanel {
    protected final AtomicReference<VoiceDevice> currentRef;
    private BGToolBar toolBar = new BGToolBar(true, true);
    private CdrTableModel tableModel = new CdrTableModel();
    private BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));

    public VoiceDeviceCdrPanel(AtomicReference<VoiceDevice> currentRef) {
        super((LayoutManager)new GridBagLayout());
        this.currentRef = currentRef;
        this.table.setDragEnabled(true);
        this.table.setDropMode(DropMode.INSERT_ROWS);
        this.table.setTransferHandler((TransferHandler)new TableRowTransferHandler((JTable)this.table));
        this.table.setSelectionMode(0);
    }

    protected void jbInit() throws Exception {
        this.toolBar.setOrientation(0);
        this.toolBar.add(this.getActionMap().get("item.add"));
        this.toolBar.add(this.getActionMap().get("item.edit"));
        this.toolBar.add(this.getActionMap().get("item.delete"));
        this.add((Component)this.toolBar, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit((JTable)this.table, (BGUPanel)this, (String)"item.edit");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {});
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.tableModel.setData(new ArrayList()));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            String cdrConverterRules = new Preferences(this.currentRef.get().getConfig(), "\n").get("cdr.converter.rules", "[]");
            JSONArray jsonArray = new JSONArray(cdrConverterRules);
            ArrayList<CdrRuleData> cdrRuleDatas = new ArrayList<CdrRuleData>();
            for (int index = 0; index < jsonArray.length(); ++index) {
                JSONObject json = jsonArray.getJSONObject(index);
                CdrRuleData cdrRuleData = new CdrRuleData();
                cdrRuleData.setApplyTo(VoiceNumberApplyTo.valueOf((String)json.optString("applyTo", VoiceNumberApplyTo.ALL.name())));
                cdrRuleData.setOperation(Operation.valueOf(json.optString("operation", Operation.REPLACE.name())));
                cdrRuleData.setRule(json.optString("rule", ""));
                cdrRuleData.setValue(json.optString("value", ""));
                cdrRuleDatas.add(cdrRuleData);
            }
            this.tableModel.setData(cdrRuleDatas);
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {});
        new AbstractBGUPanel.BGActionItemAdd((AbstractBGUPanel)this, e -> new RuleEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u0430\u0432\u0438\u043b\u0430", null).open());
        new AbstractBGUPanel.BGActionItemEdit((AbstractBGUPanel)this, e -> this.tableModel.optSelectedRow().ifPresentOrElse(data -> new RuleEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u0430\u0432\u0438\u043b\u0430", (CdrRuleData)data).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
        new AbstractBGUPanel.BGActionItemDelete((AbstractBGUPanel)this, e -> this.tableModel.optSelectedRow().ifPresentOrElse(data -> {
            if (ClientUtils.confirmDelete((Object)data.getRule())) {
                this.tableModel.deleteRow(data);
            }
        }, () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f")));
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                JSONArray jsonArray = new JSONArray();
                for (CdrRuleData cdrRuleData : VoiceDeviceCdrPanel.this.tableModel.getRows()) {
                    JSONObject json = new JSONObject();
                    json.put("applyTo", (Object)cdrRuleData.getApplyTo().name());
                    json.put("operation", (Object)cdrRuleData.getOperation().name());
                    json.put("rule", (Object)cdrRuleData.getRule());
                    json.put("value", (Object)cdrRuleData.getValue());
                    jsonArray.put((Object)json);
                }
                StringBuffer outConfig = new StringBuffer();
                int start = 0;
                int pos = 0;
                boolean add = true;
                String inConfig = VoiceDeviceCdrPanel.this.currentRef.get().getConfig();
                while ((pos = inConfig.indexOf("\n", start)) > -1) {
                    String key;
                    boolean replace = false;
                    String param = inConfig.substring(start, pos);
                    int keyEndPos = param.indexOf(61);
                    if (keyEndPos > -1 && (key = param.substring(0, keyEndPos)).equals("cdr.converter.rules")) {
                        outConfig.append(key).append("=").append(jsonArray.toString()).append("\n");
                        replace = true;
                        add = false;
                    }
                    if (!replace) {
                        outConfig.append(param).append("\n");
                    }
                    start = pos + 1;
                }
                if (start < inConfig.length()) {
                    outConfig.append(inConfig.substring(start));
                }
                if (add) {
                    outConfig.append("cdr.converter.rules").append("=").append(jsonArray.toString()).append("\n");
                }
                VoiceDeviceCdrPanel.this.currentRef.get().setConfig(outConfig.toString());
            }
        };
    }

    class CdrTableModel
    extends BGTableModel<CdrRuleData>
    implements TableRowReorderable {
        public CdrTableModel() {
            super(CdrTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u043a", 300, 300, 300, "applyTo", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f", 200, 200, 200, "operation", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0423\u0441\u043b\u043e\u0432\u043d\u0438\u0435", 100, 100, -1, "rule", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442", 100, 100, -1, "value", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(CdrRuleData val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("applyTo".equals(identifier)) {
                return val.getApplyTo().getTitle();
            }
            if ("operation".equals(identifier)) {
                return val.getOperation().getTitle();
            }
            return super.getValueAt((Object)val, column);
        }

        public void reorder(int fromIndex, int toIndex) {
            int from = this.table.convertRowIndexToModel(fromIndex);
            int to = this.table.convertRowIndexToModel(toIndex);
            CdrRuleData data = (CdrRuleData)this.getRows().get(from);
            if (from > to) {
                this.getRows().remove(from);
                this.getRows().add(to, data);
            } else {
                this.getRows().add(to, data);
                this.getRows().remove(from);
            }
        }
    }

    public class CdrRuleData {
        private VoiceNumberApplyTo applyTo;
        private Operation operation;
        private String rule;
        private String value;

        public VoiceNumberApplyTo getApplyTo() {
            return this.applyTo;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String getRule() {
            return this.rule;
        }

        public String getValue() {
            return this.value;
        }

        public void setApplyTo(VoiceNumberApplyTo applyTo) {
            this.applyTo = applyTo;
        }

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    class RuleEditorDialog
    extends BGEditorDialog<CdrRuleData> {
        private BGUComboBox<KeyValue> applyTo;
        private BGUComboBox<KeyValue> operation;
        private JTextField whatField;
        private JTextField toField;

        public RuleEditorDialog(String title, CdrRuleData data) {
            super(title, (Object)data);
            this.applyTo = new BGUComboBox();
            this.operation = new BGUComboBox();
            this.whatField = new JTextField(40);
            this.toField = new JTextField(40);
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u043a:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.applyTo, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.operation, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0423\u0441\u043b\u043e\u0432\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.whatField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.toField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            List<KeyValue> applyToItems = Stream.of(VoiceNumberApplyTo.values()).map(a -> new KeyValue(a.name(), a.getTitle())).toList();
            this.applyTo.setData(applyToItems);
            this.operation.setData(Stream.of(Operation.values()).map(a -> new KeyValue(a.name(), a.getTitle())).toList());
            if (this.data != null) {
                this.applyTo.setSelectedItem((Object)applyToItems.stream().filter(a -> a.getKey().equals(((CdrRuleData)this.data).getApplyTo().name())).findFirst().orElse(applyToItems.get(0)));
                this.whatField.setText(((CdrRuleData)this.data).getRule());
                this.toField.setText(((CdrRuleData)this.data).getValue());
            }
        }

        public boolean doApply() throws Exception {
            if (this.data == null) {
                CdrRuleData data = new CdrRuleData();
                this.data = data;
                VoiceDeviceCdrPanel.this.tableModel.addRow(data);
            }
            ((CdrRuleData)this.data).setApplyTo(VoiceNumberApplyTo.valueOf((String)((KeyValue)this.applyTo.getSelectedItem()).getKey()));
            ((CdrRuleData)this.data).setOperation(Operation.valueOf(((KeyValue)this.operation.getSelectedItem()).getKey()));
            ((CdrRuleData)this.data).setRule(this.whatField.getText());
            ((CdrRuleData)this.data).setValue(this.toField.getText());
            int row = VoiceDeviceCdrPanel.this.tableModel.getSelectedRowIndex();
            VoiceDeviceCdrPanel.this.tableModel.fireTableCellUpdated(row, 2);
            VoiceDeviceCdrPanel.this.tableModel.fireTableCellUpdated(row, 3);
            return true;
        }
    }

    static enum Operation {
        REPLACE("\u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c");

        private String title;

        private Operation(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

