/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageContract;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class SmartHousePackageContractDao
extends AbstractIdDao<SmartHousePackageContract> {
    private Logger logger = LogManager.getLogger();

    public SmartHousePackageContractDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_package_contract");
    }

    public void searchContractPackages(SearchResult<SmartHousePackageContract> searchResult, int contractId) throws BGException {
        List list = searchResult.getList();
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE contract_id=? " + (page == null ? "" : page.sqlLimit());
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            psSelect.setInt(parameterIndex++, contractId);
            ResultSet resultSet = psSelect.executeQuery();
            while (resultSet.next()) {
                list.add(this.getFromRS(resultSet));
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    protected SmartHousePackageContract getFromRS(ResultSet rs) throws SQLException, BGException {
        SmartHousePackageContract contractPackage = new SmartHousePackageContract();
        contractPackage.setId(rs.getInt("id"));
        contractPackage.setContractId(rs.getInt("contract_id"));
        contractPackage.setObjectId(rs.getInt("object_id"));
        contractPackage.setPackageId(rs.getInt("package_id"));
        contractPackage.setPeriod(new PeriodWithTime((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to")));
        contractPackage.setCalcPeriod(new PeriodWithTime((Date)rs.getTimestamp("calc_date_from"), (Date)rs.getTimestamp("calc_date_to")));
        contractPackage.setPackageCost(rs.getBigDecimal("package_cost"));
        contractPackage.setPackageCostDate(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("package_cost_date")));
        contractPackage.setReserveId(rs.getInt("reserve_id"));
        String data = rs.getString("data");
        contractPackage.setData(data.isEmpty() ? "{}" : data);
        return contractPackage;
    }

    public void update(SmartHousePackageContract contractPackage) throws BGException {
        super.update((Object)contractPackage);
    }

    public int[] getNavigationIds(int contractId, int packageContractId) throws BGException, BGMessageException {
        int[] result;
        block19: {
            ArrayList<LocalDateTime[]> dates;
            ArrayList<Integer> ids;
            block21: {
                block20: {
                    ids = new ArrayList<Integer>();
                    dates = new ArrayList<LocalDateTime[]>();
                    String query = "SELECT `id`, `date_from`, `date_to` FROM " + this.tableName + " WHERE `contract_id`=? ORDER BY `date_from`";
                    try (PreparedStatement psSelect = this.con.prepareStatement(query);){
                        psSelect.setInt(1, contractId);
                        try (ResultSet rs = psSelect.executeQuery();){
                            while (rs.next()) {
                                ids.add(rs.getInt(1));
                                dates.add(new LocalDateTime[]{TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp(2)), TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp(3))});
                            }
                        }
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)e);
                        throw new BGException((Throwable)e);
                    }
                    result = new int[3];
                    if (packageContractId <= 0) break block20;
                    result[1] = packageContractId;
                    int len = ids.size();
                    for (int index = 0; index < len; ++index) {
                        if ((Integer)ids.get(index) != packageContractId) continue;
                        this.setIDResult(index, len, result, ids);
                        break block19;
                    }
                    break block19;
                }
                if (ids.size() != 1) break block21;
                result[1] = (Integer)ids.get(0);
                break block19;
            }
            if (ids.size() <= 1) break block19;
            int len = dates.size();
            LocalDateTime now = LocalDateTime.now();
            for (int index = 0; index < len; ++index) {
                this.setIDResult(index, len, result, ids);
                LocalDateTime[] dateTimes = (LocalDateTime[])dates.get(index);
                if (dateTimes[1] != null && dateTimes[1].compareTo(now) < 0) {
                    continue;
                }
                break;
            }
        }
        return result;
    }

    private void setIDResult(int index, int len, int[] result, List<Integer> ids) {
        result[1] = ids.get(index);
        if (index > 0) {
            result[0] = ids.get(index - 1);
            result[2] = 0;
        }
        if (index < len - 1) {
            result[2] = ids.get(index + 1);
        }
    }

    protected void updateImpl(SmartHousePackageContract contractPackage) throws BGException, SQLException {
        if (contractPackage == null) {
            throw new BGException("contractPackage is null");
        }
        boolean update = contractPackage.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET package_id=?, data=?, contract_id=?, date_from=?, date_to=? " + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            ps.setInt(parameterIndex++, contractPackage.getPackageId());
            ps.setString(parameterIndex++, contractPackage.getData());
            ps.setInt(parameterIndex++, contractPackage.getContractId());
            PeriodWithTime period = contractPackage.getPeriod();
            ps.setTimestamp(parameterIndex++, period == null ? null : TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
            ps.setTimestamp(parameterIndex++, period == null ? null : TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
            if (update) {
                ps.setInt(parameterIndex++, contractPackage.getId());
            }
            ps.executeUpdate();
        }
    }
}

