/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.server.task;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelContractTariff;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelTariff;
import ru.bitel.bgbilling.modules.runtel.server.bean.RunTelContract;
import ru.bitel.bgbilling.modules.runtel.server.bean.RunTelContractTariffDao;
import ru.bitel.bgbilling.modules.runtel.server.bean.RunTelDao;
import ru.bitel.bgbilling.modules.runtel.server.bean.RunTelTariffDao;
import ru.bitel.bgbilling.modules.runtel.server.bean.RuntelManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

public class RunTelSync
extends TaskBase {
    private static final Logger logger = LogManager.getLogger();

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        RunTelSync.syncData(this.setup.getDBConnectionFromPool(), this.moduleId);
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c RunTel. \u0417\u0430\u0434\u0430\u0447\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0438 \u0422\u041f. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }

    private static void syncData(Connection con, int moduleId) {
        try (RunTelDao runTelDao = new RunTelDao(con, moduleId);
             ContractDao contractDao = new ContractDao(con, 0);
             RunTelTariffDao runTelTariffDao = new RunTelTariffDao(con, moduleId);
             RunTelContractTariffDao runTelContractTariffDao = new RunTelContractTariffDao(con, moduleId);){
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            List activeContractStatus = moduleSetup.getIntegerList("runtel.active.status.ids", Utils.toIntegerList((String)"0"));
            SearchResult searchResultContracts = new SearchResult();
            runTelDao.searchContracts((SearchResult<RunTelContract>)searchResultContracts, moduleSetup.getInt("runtel.email.parameter.id", 0));
            Map<Integer, RunTelContractTariff> runTelContractTariffs = runTelContractTariffDao.getLastRunTelContractTariffs();
            for (RunTelContract runTelContract : searchResultContracts.getList()) {
                runTelContract.setTariff(runTelContractTariffs.get(runTelContract.getContractId()));
                runTelContract.setStatus(activeContractStatus.contains(runTelContract.getStatus()) ? 1 : 0);
            }
            SearchResult searchResultTariffs = new SearchResult();
            runTelTariffDao.searchRunTelTariffList((SearchResult<RunTelTariff>)searchResultTariffs);
            HashMap<Integer, RunTelTariff> runTelTariffs = new HashMap<Integer, RunTelTariff>();
            searchResultTariffs.getList().forEach(item -> runTelTariffs.put(item.getId(), (RunTelTariff)item));
            RuntelManager runtelManager = new RuntelManager(moduleId);
            String token = runtelManager.getToken();
            if (token != null) {
                runtelManager.syncData(searchResultContracts.getList(), runTelTariffs, token);
            }
        }
        catch (BGException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
    }

    public static void main(String[] args) {
        Setup.setSetup((Setup)new Setup("data.data"));
        Setup setup = Setup.getSetup();
        RunTelSync.syncData(setup.getDBConnectionFromPool(), 247);
        System.exit(0);
    }
}

