/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.bgsecure.client.RoleTreeTablePanel;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.modules.reports.client.AllModuleReportsComboBox;
import ru.bitel.bgbilling.modules.reports.client.modules.Report;
import ru.bitel.bgbilling.modules.reports.common.bean.ReportAccessRule;
import ru.bitel.bgbilling.modules.reports.common.service.ReportService;
import ru.bitel.common.client.BGSwingUtilites;

public class ReportAccessSettingsPanel
extends ServiceConfigTabbedPanel {
    private AllModuleReportsComboBox allModuleReportsPanel;
    private RoleTreeTablePanel rolesTable;
    private BGControlPanelListSelect usersList;
    private JButton save = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
    private boolean inited = false;
    private ReportService reportService;

    public ReportAccessSettingsPanel() {
        super("ReportAccessSettingsPanel");
        this.setLayout(new GridBagLayout());
    }

    public void setData() {
        if (this.inited) {
            return;
        }
        BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0438 \u0440\u043e\u043b\u0435\u0439");
        try {
            this.allModuleReportsPanel = new AllModuleReportsComboBox(e -> this.changeReport((Report)e));
            this.initRolesPanel();
            this.initUsersPanel();
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)((Object)this.allModuleReportsPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.save, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(3, 0, 0, 0), 0, 0);
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)this.rolesTable, constraints);
        rightPanel.add((Component)this.usersList, constraints);
        this.save.addActionListener(e -> this.updateReportAccessRule());
        this.setEnabledComponents(false);
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)leftPanel, (Component)rightPanel, 400L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.revalidate();
        this.repaint();
        this.allModuleReportsPanel.setData();
        this.inited = true;
    }

    private void initRolesPanel() throws BGException {
        this.rolesTable = new RoleTreeTablePanel(true, false);
        this.rolesTable.setRoles(((RoleService)this.getContext().getPort(RoleService.class, 0)).getRoleItems(false, true));
    }

    private void initUsersPanel() throws BGException {
        this.usersList = new BGControlPanelListSelect();
        BGSwingUtilites.wrapBorder((JPanel)this.usersList, (String)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438");
        this.usersList.getListModel().addAll(((UserService)this.getContext().getPort(UserService.class, 0)).listUsers().stream().map(user -> new BGUListItem(user.getId(), user.getTitle())).collect(Collectors.toList()));
    }

    private void changeReport(Report report) {
        if (report != null) {
            try {
                ReportAccessRule reportAccessRule = this.getReportService().getAccessRulesByReportId(report.id);
                this.rolesTable.setCheckedRoles(reportAccessRule.getAllowedRoleIds());
                this.usersList.setSelectedElements(reportAccessRule.getAllowedUserIds());
                this.setEnabledComponents(true);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
    }

    private void setEnabledComponents(boolean enabled) {
        this.usersList.setEnabled(enabled);
        this.rolesTable.setEnabled(enabled);
    }

    private void updateReportAccessRule() {
        Report report = this.allModuleReportsPanel.getReport();
        if (report != null) {
            try {
                ReportAccessRule reportAccessRule = new ReportAccessRule(report.id);
                reportAccessRule.addAllowedRolesIds(this.rolesTable.getCheckedRoleIds());
                reportAccessRule.addAllowedUserIds(Arrays.stream(this.usersList.getSelectedIds()).boxed().toList());
                this.getReportService().updateAccessRulesByReport(reportAccessRule);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = (ReportService)this.getContext().getPort(ReportService.class, this.getContext().getModuleId());
        }
        return this.reportService;
    }
}

