/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rentsoft.client;

import bitel.billing.module.common.BGControlPanelMonth;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.rentsoft.common.RentsoftService;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.RentsoftPayment;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.RentsoftProduct;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.SubscribtionStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Pair;

public class ContractSubscribePanel
extends BGUPanel {
    private static final Class<RentsoftService> clazz = RentsoftService.class;
    private BGUTable table;
    private BGEditor editor;
    private RentsoftSubscribeTableModel model;
    private BGControlPanelMonth month = new BGControlPanelMonth();
    private RentsoftPaymentTableModel rentsoftPaymentModel;

    protected void jbInit() {
        this.rentsoftPaymentModel = new RentsoftPaymentTableModel(RentsoftPaymentTableModel.class.getName());
        JPanel editorPanel = new JPanel(new GridBagLayout());
        editorPanel.add((Component)new JScrollPane((Component)new BGUTable((TableModel)((Object)this.rentsoftPaymentModel))), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.model = new RentsoftSubscribeTableModel(RentsoftSubscribeTableModel.class.getName());
        this.table = new BGUTable((TableModel)((Object)this.model));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() >= 2) {
                    ContractSubscribePanel.this.performAction("edit");
                }
            }
        });
        this.editor = new BGEditor();
        this.editor.addForm((JComponent)editorPanel);
        this.editor.setVisible(false);
        Dimension size = new Dimension(100, 300);
        this.editor.setPreferredSize(size);
        this.editor.setMinimumSize(size);
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getTopPanel() {
        BGButton button = new BGButton("OK");
        button.addActionListener(e -> this.performAction("recalculate"));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)new JLabel("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0437\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        topPanel.add((Component)this.month, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)button, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return topPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(((RentsoftService)((ClientContext)this.getContext()).getPort(clazz)).getSubscribtionStatuses(((ClientContext)this.getContext()).getContractId()))));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            RentsoftProduct product = (RentsoftProduct)((Pair)this.model.getSelectedRow()).getFirst();
            List data = ((RentsoftService)((ClientContext)this.getContext()).getPort(clazz)).getPaymentsByProduct(product.getId(), ((ClientContext)this.getContext()).getContractId());
            this.rentsoftPaymentModel.setData(data);
            this.editor.performActionOpen();
        });
        new AbstractBGUPanel.DefaultAction("recalculate", "\u041f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ((RentsoftService)((ClientContext)ContractSubscribePanel.this.getContext()).getPort(clazz)).recalculate(((ClientContext)ContractSubscribePanel.this.getContext()).getContractId(), TimeUtils.convertLocalDateToDate((LocalDate)ContractSubscribePanel.this.month.getLocalDate()));
            }
        };
    }

    class RentsoftPaymentTableModel
    extends BGTableModel<RentsoftPayment> {
        public RentsoftPaymentTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430", 160, 160, 200, "date", true).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041a\u043e\u0434 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438", 180, 200, 220, "txid", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", "comment", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 60, 80, 100, "status", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", 100, 100, 100, "amount", true).setTableCellRenderer(DecimalTableCellRenderer.DEFAULT);
        }

        public Object getValue(RentsoftPayment rentsoftPayment, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("status".equals(identifier)) {
                return rentsoftPayment.getStatus() == 0 ? "\u043e\u043f\u043b\u0430\u0447\u0435\u043d" : "\u043e\u0442\u043c\u0435\u043d\u0435\u043d";
            }
            return super.getValue((Object)rentsoftPayment, column);
        }
    }

    class RentsoftSubscribeTableModel
    extends BGTableModel<Pair<RentsoftProduct, SubscribtionStatus>> {
        public RentsoftSubscribeTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", "product", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", "status", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
        }

        public Object getValue(Pair<RentsoftProduct, SubscribtionStatus> val, int column) {
            String value = null;
            switch (column) {
                case 0: {
                    value = ((RentsoftProduct)val.getFirst()).getServiceName();
                    break;
                }
                case 1: {
                    value = SubscribtionStatus.Status.byCode((int)((SubscribtionStatus)val.getSecond()).getStatus()).getTitle();
                }
            }
            return value;
        }
    }
}

